/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.content.Context;
import bolts.Continuation;
import bolts.Task;
import com.parse.ManifestInfo;
import com.parse.PLog;
import com.parse.Parse;
import com.parse.ParseException;
import com.parse.ParseInstallation;
import com.parse.ParseObject;
import com.parse.ParseQuery;
import com.parse.ParseRESTCommand;
import com.parse.ParseRESTPushCommand;
import com.parse.ParseTaskUtils;
import com.parse.ParseUser;
import com.parse.PushRouter;
import com.parse.PushService;
import com.parse.SaveCallback;
import com.parse.SendCallback;
import com.parse.gdata.Preconditions;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class ParsePush {
    private static final String TAG = "com.parse.ParsePush";
    private Set<String> channelSet = null;
    private ParseQuery<ParseInstallation> query = null;
    private Long expirationTime = null;
    private Long expirationTimeInterval = null;
    private Boolean pushToIOS = null;
    private Boolean pushToAndroid = null;
    private JSONObject data;
    static final String V2_PUSH_NOT_CONFIGURED = "In order to use the ParsePush.subscribe or ParsePush.unsubscribe methods you must add the following to your AndroidManifest.xml: \n<receiver android:name=\"com.parse.ParsePushBroadcastReceiver\"\n  android:exported=\"false\">\n  <intent-filter>\n    <action android:name=\"com.parse.push.intent.RECEIVE\" />\n    <action android:name=\"com.parse.push.intent.OPEN\" />\n    <action android:name=\"com.parse.push.intent.DELETE\" />\n  </intent-filter>\n</receiver>\n(Replace \"com.parse.ParsePushBroadcastReceiver\" with your own implementation if you choose to extend ParsePushBroadcastReceiver)";

    static void setEnabled(final boolean enabled) {
        ParsePush.checkForManifestAndThrowExceptionIfNeeded();
        PushRouter.setForceEnabledAsync(enabled).onSuccess((Continuation)new Continuation<Void, Void>(){

            public Void then(Task<Void> task) throws Exception {
                Context context = Parse.getApplicationContext();
                if (!enabled) {
                    PushService.stopPpnsService(context);
                } else {
                    PushService.startServiceIfRequired(context);
                }
                return null;
            }
        });
    }

    public static Task<Void> subscribeInBackground(String channel) {
        if (channel == null) {
            throw new IllegalArgumentException("Can't subscribe to null channel.");
        }
        ParsePush.checkForManifestAndThrowExceptionIfNeeded();
        ParseInstallation installation = ParseInstallation.getCurrentInstallation();
        List channels = installation.getList("channels");
        if (channels == null || installation.isDirty("channels") || !channels.contains(channel)) {
            installation.addUnique("channels", channel);
            return installation.saveInBackground();
        }
        return Task.forResult(null);
    }

    public static void subscribeInBackground(String channel, SaveCallback callback) {
        ParseTaskUtils.callbackOnMainThreadAsync(ParsePush.subscribeInBackground(channel), callback);
    }

    public static Task<Void> unsubscribeInBackground(String channel) {
        if (channel == null) {
            throw new IllegalArgumentException("Can't unsubscribe from null channel.");
        }
        ParsePush.checkForManifestAndThrowExceptionIfNeeded();
        ParseInstallation installation = ParseInstallation.getCurrentInstallation();
        List channels = installation.getList("channels");
        if (channels != null && channels.contains(channel)) {
            installation.removeAll("channels", Arrays.asList(channel));
            return installation.saveInBackground();
        }
        return Task.forResult(null);
    }

    public static void unsubscribeInBackground(String channel, SaveCallback callback) {
        ParseTaskUtils.callbackOnMainThreadAsync(ParsePush.unsubscribeInBackground(channel), callback);
    }

    private static void checkForManifestAndThrowExceptionIfNeeded() {
        if (!ManifestInfo.getPushUsesBroadcastReceivers()) {
            throw new IllegalStateException(V2_PUSH_NOT_CONFIGURED);
        }
    }

    public static Task<Void> sendMessageInBackground(String message, ParseQuery<ParseInstallation> query) {
        ParsePush push = new ParsePush();
        push.setQuery(query);
        push.setMessage(message);
        return push.sendInBackground();
    }

    public static void sendMessageInBackground(String message, ParseQuery<ParseInstallation> query, SendCallback callback) {
        ParseTaskUtils.callbackOnMainThreadAsync(ParsePush.sendMessageInBackground(message, query), callback);
    }

    public static Task<Void> sendDataInBackground(JSONObject data, ParseQuery<ParseInstallation> query) {
        ParsePush push = new ParsePush();
        push.setQuery(query);
        push.setData(data);
        return push.sendInBackground();
    }

    public static void sendDataInBackground(JSONObject data, ParseQuery<ParseInstallation> query, SendCallback callback) {
        ParseTaskUtils.callbackOnMainThreadAsync(ParsePush.sendDataInBackground(data, query), callback);
    }

    public void setChannel(String channel) {
        Preconditions.checkArgument(channel != null, "channel cannot be null");
        this.channelSet = new HashSet<String>();
        this.channelSet.add(channel);
        this.query = null;
    }

    public void setChannels(Collection<String> channels) {
        Preconditions.checkArgument(channels != null, "channels collection cannot be null");
        for (String channel : channels) {
            Preconditions.checkArgument(channel != null, "channel cannot be null");
        }
        this.channelSet = new HashSet<String>();
        this.channelSet.addAll(channels);
        this.query = null;
    }

    public void setQuery(ParseQuery<ParseInstallation> query) {
        Preconditions.checkArgument(query != null, "Cannot target a null query");
        Preconditions.checkArgument(this.pushToIOS == null && this.pushToAndroid == null, "Cannot set push targets (i.e. setPushToAndroid or setPushToIOS) when pushing to a query");
        Preconditions.checkArgument(query.getClassName().equals(ParseObject.getClassName(ParseInstallation.class)), "Can only push to a query for Installations");
        this.channelSet = null;
        this.query = query;
    }

    public void setExpirationTime(long time) {
        this.expirationTime = time;
        this.expirationTimeInterval = null;
    }

    public void setExpirationTimeInterval(long timeInterval) {
        this.expirationTime = null;
        this.expirationTimeInterval = timeInterval;
    }

    public void clearExpiration() {
        this.expirationTime = null;
        this.expirationTimeInterval = null;
    }

    @Deprecated
    public void setPushToIOS(boolean pushToIOS) {
        Preconditions.checkArgument(this.query == null, "Cannot set push targets (i.e. setPushToAndroid or setPushToIOS) when pushing to a query");
        this.pushToIOS = pushToIOS;
    }

    @Deprecated
    public void setPushToAndroid(boolean pushToAndroid) {
        Preconditions.checkArgument(this.query == null, "Cannot set push targets (i.e. setPushToAndroid or setPushToIOS) when pushing to a query");
        this.pushToAndroid = pushToAndroid;
    }

    public void setData(JSONObject data) {
        this.data = data;
    }

    public void setMessage(String message) {
        JSONObject data = new JSONObject();
        try {
            data.put("alert", (Object)message);
        }
        catch (JSONException e) {
            PLog.e(TAG, "JSONException in setMessage", e);
        }
        this.setData(data);
    }

    public Task<Void> sendInBackground() {
        return ParseUser.getCurrentSessionTokenAsync().onSuccessTask((Continuation)new Continuation<String, Task<Void>>(){

            public Task<Void> then(Task<String> task) throws Exception {
                String sessionToken = (String)task.getResult();
                ParseQuery.State state = ParsePush.this.query != null ? ParsePush.this.query.getBuilder().build() : null;
                return ParsePush.this.currentSendCommand(state, sessionToken).executeAsync().makeVoid();
            }
        });
    }

    public void send() throws ParseException {
        ParseTaskUtils.wait(this.sendInBackground());
    }

    public void sendInBackground(SendCallback callback) {
        ParseTaskUtils.callbackOnMainThreadAsync(this.sendInBackground(), callback);
    }

    ParseRESTCommand currentSendCommand(String sessionToken) {
        ParseQuery.State<ParseInstallation> state = this.query != null ? this.query.getBuilder().build() : null;
        return this.currentSendCommand(state, sessionToken);
    }

    private ParseRESTCommand currentSendCommand(ParseQuery.State<ParseInstallation> query, String sessionToken) {
        if (this.data == null) {
            throw new IllegalArgumentException("Cannot send a push without calling either setMessage or setData");
        }
        String deviceType = null;
        if (query == null) {
            boolean willPushToIOS;
            boolean willPushToAndroid = this.pushToAndroid != null && this.pushToAndroid != false;
            boolean bl = willPushToIOS = this.pushToIOS != null && this.pushToIOS != false;
            if (!willPushToIOS || !willPushToAndroid) {
                if (willPushToIOS) {
                    deviceType = "ios";
                } else if (willPushToAndroid) {
                    deviceType = "android";
                }
            }
        }
        return ParseRESTPushCommand.sendPushCommand(query, this.channelSet, deviceType, this.expirationTime, this.expirationTimeInterval, this.data, sessionToken);
    }
}

