/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.content.Context;
import android.content.Intent;
import bolts.Continuation;
import bolts.Task;
import com.parse.ConnectivityNotifier;
import com.parse.EventuallyPin;
import com.parse.PLog;
import com.parse.Parse;
import com.parse.ParseEventuallyQueue;
import com.parse.ParseException;
import com.parse.ParseNetworkCommand;
import com.parse.ParseObject;
import com.parse.ParseOperationSet;
import com.parse.ParseTaskUtils;
import com.parse.TaskQueue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.json.JSONObject;

class ParsePinningEventuallyQueue
extends ParseEventuallyQueue {
    private static final String TAG = "ParsePinningEventuallyQueue";
    private HashMap<String, Task.TaskCompletionSource> pendingOperationSetUUIDTasks = new HashMap();
    private TaskQueue taskQueue = new TaskQueue();
    private TaskQueue operationSetTaskQueue = new TaskQueue();
    private ArrayList<String> eventuallyPinUUIDQueue = new ArrayList();
    private Task.TaskCompletionSource connectionTaskCompletionSource = Task.create();
    private final Object connectionLock = new Object();
    private ConnectivityNotifier notifier;
    private ConnectivityNotifier.ConnectivityListener listener = new ConnectivityNotifier.ConnectivityListener(){

        @Override
        public void networkConnectivityStatusChanged(Context context, Intent intent) {
            boolean connectionLost = intent.getBooleanExtra("noConnectivity", false);
            if (connectionLost) {
                ParsePinningEventuallyQueue.this.setConnected(false);
            } else {
                ParsePinningEventuallyQueue.this.setConnected(ConnectivityNotifier.isConnected(context));
            }
        }
    };
    private final Object taskQueueSyncLock = new Object();
    private HashMap<String, Task.TaskCompletionSource> pendingEventuallyTasks = new HashMap();
    private HashMap<String, ParseOperationSet> uuidToOperationSet = new HashMap();
    private HashMap<String, EventuallyPin> uuidToEventuallyPin = new HashMap();

    public ParsePinningEventuallyQueue(Context context) {
        this.setConnected(ConnectivityNotifier.isConnected(context));
        this.notifier = ConnectivityNotifier.getNotifier(context);
        this.notifier.addListener(this.listener);
        this.resume();
    }

    @Override
    public void onDestroy() {
        this.notifier.removeListener(this.listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setConnected(boolean connected) {
        Object object = this.connectionLock;
        synchronized (object) {
            if (this.isConnected() != connected) {
                super.setConnected(connected);
                if (connected) {
                    this.connectionTaskCompletionSource.trySetResult(null);
                    this.connectionTaskCompletionSource = Task.create();
                    this.connectionTaskCompletionSource.trySetResult(null);
                } else {
                    this.connectionTaskCompletionSource = Task.create();
                }
            }
        }
    }

    @Override
    public int pendingCount() {
        try {
            return ParseTaskUtils.wait(this.pendingCountAsync());
        }
        catch (ParseException e) {
            throw new IllegalStateException(e);
        }
    }

    public Task<Integer> pendingCountAsync() {
        final Task.TaskCompletionSource tcs = Task.create();
        this.taskQueue.enqueue(new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> toAwait) throws Exception {
                return ParsePinningEventuallyQueue.this.pendingCountAsync(toAwait).continueWithTask((Continuation)new Continuation<Integer, Task<Void>>(){

                    public Task<Void> then(Task<Integer> task) throws Exception {
                        int count = (Integer)task.getResult();
                        tcs.setResult((Object)count);
                        return Task.forResult(null);
                    }
                });
            }
        });
        return tcs.getTask();
    }

    public Task<Integer> pendingCountAsync(Task<Void> toAwait) {
        return toAwait.continueWithTask((Continuation)new Continuation<Void, Task<Integer>>(){

            public Task<Integer> then(Task<Void> task) throws Exception {
                return EventuallyPin.findAllPinned().continueWithTask((Continuation)new Continuation<List<EventuallyPin>, Task<Integer>>(){

                    public Task<Integer> then(Task<List<EventuallyPin>> task) throws Exception {
                        List pins = (List)task.getResult();
                        return Task.forResult((Object)pins.size());
                    }
                });
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause() {
        Object object = this.connectionLock;
        synchronized (object) {
            this.connectionTaskCompletionSource.trySetError((Exception)new PauseException());
            this.connectionTaskCompletionSource = Task.create();
            this.connectionTaskCompletionSource.trySetError((Exception)new PauseException());
        }
        object = this.taskQueueSyncLock;
        synchronized (object) {
            for (String key : this.pendingEventuallyTasks.keySet()) {
                this.pendingEventuallyTasks.get(key).trySetError((Exception)new PauseException());
            }
            this.pendingEventuallyTasks.clear();
            this.uuidToOperationSet.clear();
            this.uuidToEventuallyPin.clear();
        }
        try {
            ParseTaskUtils.wait(this.whenAll(Arrays.asList(this.taskQueue, this.operationSetTaskQueue)));
        }
        catch (ParseException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void resume() {
        if (this.isConnected()) {
            this.connectionTaskCompletionSource.trySetResult(null);
            this.connectionTaskCompletionSource = Task.create();
            this.connectionTaskCompletionSource.trySetResult(null);
        } else {
            this.connectionTaskCompletionSource = Task.create();
        }
        this.populateQueueAsync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Task<Void> waitForConnectionAsync() {
        Object object = this.connectionLock;
        synchronized (object) {
            return this.connectionTaskCompletionSource.getTask();
        }
    }

    @Override
    public Task<Object> enqueueEventuallyAsync(final ParseNetworkCommand command, final ParseObject object) {
        Parse.requirePermission("android.permission.ACCESS_NETWORK_STATE");
        final Task.TaskCompletionSource tcs = Task.create();
        this.taskQueue.enqueue(new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> toAwait) throws Exception {
                return ParsePinningEventuallyQueue.this.enqueueEventuallyAsync(command, object, (Task<Void>)toAwait, tcs);
            }
        });
        return tcs.getTask();
    }

    private Task<Void> enqueueEventuallyAsync(final ParseNetworkCommand command, final ParseObject object, Task<Void> toAwait, final Task.TaskCompletionSource tcs) {
        return toAwait.continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> toAwait) throws Exception {
                Task<EventuallyPin> pinTask = EventuallyPin.pinEventuallyCommand(object, command);
                return pinTask.continueWithTask((Continuation)new Continuation<EventuallyPin, Task<Void>>(){

                    public Task<Void> then(Task<EventuallyPin> task) throws Exception {
                        EventuallyPin pin = (EventuallyPin)task.getResult();
                        Exception error = task.getError();
                        if (error != null) {
                            if (5 >= Parse.getLogLevel()) {
                                PLog.w(ParsePinningEventuallyQueue.TAG, "Unable to save command for later.", error);
                            }
                            ParsePinningEventuallyQueue.this.notifyTestHelper(4);
                            return Task.forResult(null);
                        }
                        ParsePinningEventuallyQueue.this.pendingOperationSetUUIDTasks.put(pin.getUUID(), tcs);
                        ParsePinningEventuallyQueue.this.populateQueueAsync().continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

                            public Task<Void> then(Task<Void> task) throws Exception {
                                ParsePinningEventuallyQueue.this.notifyTestHelper(3);
                                return task;
                            }
                        });
                        return task.makeVoid();
                    }
                });
            }
        });
    }

    private Task<Void> populateQueueAsync() {
        return this.taskQueue.enqueue(new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> toAwait) throws Exception {
                return ParsePinningEventuallyQueue.this.populateQueueAsync((Task<Void>)toAwait);
            }
        });
    }

    private Task<Void> populateQueueAsync(Task<Void> toAwait) {
        return toAwait.continueWithTask((Continuation)new Continuation<Void, Task<List<EventuallyPin>>>(){

            public Task<List<EventuallyPin>> then(Task<Void> task) throws Exception {
                return EventuallyPin.findAllPinned(ParsePinningEventuallyQueue.this.eventuallyPinUUIDQueue);
            }
        }).onSuccessTask((Continuation)new Continuation<List<EventuallyPin>, Task<Void>>(){

            public Task<Void> then(Task<List<EventuallyPin>> task) throws Exception {
                List pins = (List)task.getResult();
                for (EventuallyPin pin : pins) {
                    ParsePinningEventuallyQueue.this.runEventuallyAsync(pin);
                }
                return task.makeVoid();
            }
        });
    }

    private Task<Void> runEventuallyAsync(final EventuallyPin eventuallyPin) {
        final String uuid = eventuallyPin.getUUID();
        if (this.eventuallyPinUUIDQueue.contains(uuid)) {
            return Task.forResult(null);
        }
        this.eventuallyPinUUIDQueue.add(uuid);
        this.operationSetTaskQueue.enqueue(new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> toAwait) throws Exception {
                return ParsePinningEventuallyQueue.this.runEventuallyAsync(eventuallyPin, (Task<Void>)toAwait).continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

                    public Task<Void> then(Task<Void> task) throws Exception {
                        ParsePinningEventuallyQueue.this.eventuallyPinUUIDQueue.remove(uuid);
                        return task;
                    }
                });
            }
        });
        return Task.forResult(null);
    }

    private Task<Void> runEventuallyAsync(final EventuallyPin eventuallyPin, Task<Void> toAwait) {
        return toAwait.continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> task) throws Exception {
                return ParsePinningEventuallyQueue.this.waitForConnectionAsync();
            }
        }).onSuccessTask((Continuation)new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> task) throws Exception {
                return ParsePinningEventuallyQueue.this.waitForOperationSetAndEventuallyPin(null, eventuallyPin).continueWithTask((Continuation)new Continuation<Object, Task<Void>>(){

                    public Task<Void> then(Task<Object> task) throws Exception {
                        Exception error = task.getError();
                        if (error != null) {
                            if (error instanceof PauseException) {
                                return task.makeVoid();
                            }
                            if (6 >= Parse.getLogLevel()) {
                                PLog.e(ParsePinningEventuallyQueue.TAG, "Failed to run command.", error);
                            }
                            ParsePinningEventuallyQueue.this.notifyTestHelper(2, error);
                        } else {
                            ParsePinningEventuallyQueue.this.notifyTestHelper(1);
                        }
                        Task.TaskCompletionSource tcs = (Task.TaskCompletionSource)ParsePinningEventuallyQueue.this.pendingOperationSetUUIDTasks.remove(eventuallyPin.getUUID());
                        if (tcs != null) {
                            if (error != null) {
                                tcs.setError(error);
                            } else {
                                tcs.setResult(task.getResult());
                            }
                        }
                        return task.makeVoid();
                    }
                });
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Task<Object> waitForOperationSetAndEventuallyPin(ParseOperationSet operationSet, EventuallyPin eventuallyPin) {
        Task.TaskCompletionSource tcs;
        String uuid;
        if (eventuallyPin != null && eventuallyPin.getType() != 1) {
            return this.process(eventuallyPin, null);
        }
        Object object = this.taskQueueSyncLock;
        synchronized (object) {
            if (operationSet != null && eventuallyPin == null) {
                uuid = operationSet.getUUID();
                this.uuidToOperationSet.put(uuid, operationSet);
            } else if (operationSet == null && eventuallyPin != null) {
                uuid = eventuallyPin.getOperationSetUUID();
                this.uuidToEventuallyPin.put(uuid, eventuallyPin);
            } else {
                throw new IllegalStateException("Either operationSet or eventuallyPin must be set.");
            }
            eventuallyPin = this.uuidToEventuallyPin.get(uuid);
            operationSet = this.uuidToOperationSet.get(uuid);
            if (eventuallyPin == null || operationSet == null) {
                Task.TaskCompletionSource tcs2;
                if (this.pendingEventuallyTasks.containsKey(uuid)) {
                    tcs2 = this.pendingEventuallyTasks.get(uuid);
                } else {
                    tcs2 = Task.create();
                    this.pendingEventuallyTasks.put(uuid, tcs2);
                }
                return tcs2.getTask();
            }
            tcs = this.pendingEventuallyTasks.get(uuid);
        }
        return this.process(eventuallyPin, operationSet).continueWithTask((Continuation)new Continuation<Object, Task<Object>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Task<Object> then(Task<Object> task) throws Exception {
                Object object = ParsePinningEventuallyQueue.this.taskQueueSyncLock;
                synchronized (object) {
                    ParsePinningEventuallyQueue.this.pendingEventuallyTasks.remove(uuid);
                    ParsePinningEventuallyQueue.this.uuidToOperationSet.remove(uuid);
                    ParsePinningEventuallyQueue.this.uuidToEventuallyPin.remove(uuid);
                }
                Exception error = task.getError();
                if (error != null) {
                    tcs.trySetError(error);
                } else if (task.isCancelled()) {
                    tcs.trySetCancelled();
                } else {
                    tcs.trySetResult(task.getResult());
                }
                return tcs.getTask();
            }
        });
    }

    private Task<Object> process(final EventuallyPin eventuallyPin, final ParseOperationSet operationSet) {
        return this.waitForConnectionAsync().onSuccessTask((Continuation)new Continuation<Void, Task<Object>>(){

            public Task<Object> then(Task<Void> task) throws Exception {
                Object executeTask;
                final int type = eventuallyPin.getType();
                final ParseObject object = eventuallyPin.getObject();
                String sessionToken = eventuallyPin.getSessionToken();
                if (type == 1) {
                    executeTask = object.saveAsync(operationSet, sessionToken);
                } else if (type == 2) {
                    executeTask = object.deleteAsync(sessionToken);
                } else {
                    ParseNetworkCommand command = eventuallyPin.getCommand();
                    executeTask = command.executeAsync();
                }
                return executeTask.continueWithTask((Continuation)new Continuation<Object, Task<Object>>(){

                    public Task<Object> then(final Task<Object> saveTask) throws Exception {
                        Exception error = saveTask.getError();
                        if (error != null && error instanceof ParseException && ((ParseException)error).getCode() == 100) {
                            ParsePinningEventuallyQueue.this.setConnected(false);
                            ParsePinningEventuallyQueue.this.notifyTestHelper(7);
                            return ParsePinningEventuallyQueue.this.process(eventuallyPin, operationSet);
                        }
                        return eventuallyPin.unpinInBackground("_eventuallyPin").continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

                            public Task<Void> then(Task<Void> task) throws Exception {
                                Object result = saveTask.getResult();
                                if (type == 1) {
                                    return object.handleSaveEventuallyResultAsync((JSONObject)result, operationSet);
                                }
                                if (type == 2) {
                                    return object.handleDeleteEventuallyResultAsync(result);
                                }
                                return task;
                            }
                        }).continueWithTask((Continuation)new Continuation<Void, Task<Object>>(){

                            public Task<Object> then(Task<Void> task) throws Exception {
                                return saveTask;
                            }
                        });
                    }
                });
            }
        });
    }

    @Override
    void simulateReboot() {
        this.pause();
        this.pendingOperationSetUUIDTasks.clear();
        this.pendingEventuallyTasks.clear();
        this.uuidToOperationSet.clear();
        this.uuidToEventuallyPin.clear();
        this.resume();
    }

    @Override
    public void clear() {
        this.pause();
        Task<Void> task = this.taskQueue.enqueue(new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> toAwait) throws Exception {
                return toAwait.continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

                    public Task<Void> then(Task<Void> task) throws Exception {
                        return EventuallyPin.findAllPinned().onSuccessTask((Continuation)new Continuation<List<EventuallyPin>, Task<Void>>(){

                            public Task<Void> then(Task<List<EventuallyPin>> task) throws Exception {
                                List pins = (List)task.getResult();
                                ArrayList<Task<Void>> tasks = new ArrayList<Task<Void>>();
                                for (EventuallyPin pin : pins) {
                                    tasks.add(pin.unpinInBackground("_eventuallyPin"));
                                }
                                return Task.whenAll(tasks);
                            }
                        });
                    }
                });
            }
        });
        try {
            ParseTaskUtils.wait(task);
        }
        catch (ParseException e) {
            throw new IllegalStateException(e);
        }
        this.simulateReboot();
        this.resume();
    }

    private Task<Void> whenAll(Collection<TaskQueue> taskQueues) {
        ArrayList<Task<Void>> tasks = new ArrayList<Task<Void>>();
        for (TaskQueue taskQueue : taskQueues) {
            Task<Void> task = taskQueue.enqueue(new Continuation<Void, Task<Void>>(){

                public Task<Void> then(Task<Void> toAwait) throws Exception {
                    return toAwait;
                }
            });
            tasks.add(task);
        }
        return Task.whenAll(tasks);
    }

    private static class PauseException
    extends Exception {
        private PauseException() {
        }
    }
}

