/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import bolts.Continuation;
import bolts.Task;
import com.parse.ManifestInfo;
import com.parse.PLog;
import com.parse.Parse;
import com.parse.ParseClassName;
import com.parse.ParseException;
import com.parse.ParseFileUtils;
import com.parse.ParseObject;
import com.parse.ParseOperationSet;
import com.parse.ParseQuery;
import com.parse.ParseTaskUtils;
import com.parse.PushRouter;
import com.parse.PushService;
import com.parse.PushType;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import org.json.JSONObject;

@ParseClassName(value="_Installation")
public class ParseInstallation
extends ParseObject {
    private static final String TAG = "com.parse.ParseInstallation";
    private static final Object MUTEX_CURRENT_INSTALLATION = new Object();
    private static final String INSTALLATION_ID_LOCATION = "installationId";
    static final String FILENAME_CURRENT_INSTALLATION = "currentInstallation";
    private static final String PIN_CURRENT_INSTALLATION = "_currentInstallation";
    private static final String KEY_INSTALLATION_ID = "installationId";
    private static final String KEY_DEVICE_TYPE = "deviceType";
    private static final String KEY_APP_NAME = "appName";
    private static final String KEY_APP_IDENTIFIER = "appIdentifier";
    private static final String KEY_PARSE_VERSION = "parseVersion";
    private static final String KEY_DEVICE_TOKEN = "deviceToken";
    private static final String KEY_DEVICE_TOKEN_LAST_MODIFIED = "deviceTokenLastModified";
    private static final String KEY_PUSH_TYPE = "pushType";
    private static final String KEY_TIME_ZONE = "timeZone";
    private static final String KEY_APP_VERSION = "appVersion";
    private static final List<String> READ_ONLY_FIELDS = Collections.unmodifiableList(Arrays.asList("deviceType", "installationId", "deviceToken", "pushType", "timeZone", "appVersion", "appName", "parseVersion", "deviceTokenLastModified", "appIdentifier"));
    static ParseInstallation currentInstallation = null;
    static String installationId = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Task<Boolean> hasCurrentInstallationAsync() {
        Object object = MUTEX_CURRENT_INSTALLATION;
        synchronized (object) {
            if (currentInstallation != null) {
                return Task.forResult((Object)true);
            }
        }
        if (Parse.isLocalDatastoreEnabled()) {
            ParseQuery<ParseInstallation> query = ParseQuery.getQuery(ParseInstallation.class).fromPin(PIN_CURRENT_INSTALLATION).ignoreACLs();
            return query.countInBackground().onSuccess((Continuation)new Continuation<Integer, Boolean>(){

                public Boolean then(Task<Integer> task) throws Exception {
                    return (Integer)task.getResult() == 1;
                }
            });
        }
        return Task.call((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return new File(Parse.getParseDir(), ParseInstallation.FILENAME_CURRENT_INSTALLATION).exists();
            }
        }, (Executor)Task.BACKGROUND_EXECUTOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ParseInstallation getCurrentInstallation() {
        ParseInstallation current;
        boolean deserializedInstallationFromDisk = false;
        Object object = MUTEX_CURRENT_INSTALLATION;
        synchronized (object) {
            current = currentInstallation;
        }
        if (current != null) {
            return current;
        }
        if (Parse.isLocalDatastoreEnabled()) {
            try {
                ParseQuery<ParseInstallation> query = ParseQuery.getQuery(ParseInstallation.class).fromPin(PIN_CURRENT_INSTALLATION).ignoreACLs();
                Task task = query.findInBackground().onSuccessTask((Continuation)new Continuation<List<ParseInstallation>, Task<ParseInstallation>>(){

                    public Task<ParseInstallation> then(Task<List<ParseInstallation>> task) throws Exception {
                        List results = (List)task.getResult();
                        if (results != null) {
                            if (results.size() == 1) {
                                return Task.forResult(results.get(0));
                            }
                            return ParseObject.unpinAllInBackground(ParseInstallation.PIN_CURRENT_INSTALLATION).cast();
                        }
                        return Task.forResult(null);
                    }
                }).onSuccessTask((Continuation)new Continuation<ParseInstallation, Task<ParseInstallation>>(){

                    public Task<ParseInstallation> then(Task<ParseInstallation> task) throws Exception {
                        ParseInstallation ldsInstallation = (ParseInstallation)task.getResult();
                        if (ldsInstallation != null) {
                            return task;
                        }
                        return ParseObject.migrateFromDiskToLDS(ParseInstallation.FILENAME_CURRENT_INSTALLATION, ParseInstallation.PIN_CURRENT_INSTALLATION).cast();
                    }
                });
                current = (ParseInstallation)ParseTaskUtils.wait(task);
            }
            catch (ParseException parseException) {}
        } else {
            current = (ParseInstallation)ParseInstallation.getFromDisk(FILENAME_CURRENT_INSTALLATION);
        }
        if (current == null) {
            current = ParseObject.create(ParseInstallation.class);
            current.updateDeviceInfo();
        } else {
            deserializedInstallationFromDisk = true;
            PLog.v(TAG, "Successfully deserialized Installation object");
        }
        if (deserializedInstallationFromDisk) {
            current.maybeUpdateInstallationIdOnDisk();
        }
        object = MUTEX_CURRENT_INSTALLATION;
        synchronized (object) {
            currentInstallation = current;
        }
        return current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getOrCreateCurrentInstallationId() {
        Object object = MUTEX_CURRENT_INSTALLATION;
        synchronized (object) {
            if (installationId == null) {
                try {
                    File installationIdFile = new File(Parse.getParseDir(), "installationId");
                    installationId = ParseFileUtils.readFileToString(installationIdFile, "UTF-8");
                }
                catch (FileNotFoundException e) {
                    PLog.i(TAG, "Couldn't find existing installationId file. Creating one instead.");
                }
                catch (IOException e) {
                    PLog.e(TAG, "Unexpected exception reading installation id from disk", e);
                }
            }
            if (installationId == null) {
                installationId = UUID.randomUUID().toString();
                ParseInstallation.setCurrentInstallationId(installationId);
            }
        }
        return installationId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setCurrentInstallationId(String newInstallationId) {
        Object object = MUTEX_CURRENT_INSTALLATION;
        synchronized (object) {
            File installationIdFile = new File(Parse.getParseDir(), "installationId");
            try {
                ParseFileUtils.writeStringToFile(installationIdFile, newInstallationId, "UTF-8");
            }
            catch (IOException e) {
                PLog.e(TAG, "Unexpected exception writing installation id to disk", e);
            }
            installationId = newInstallationId;
        }
    }

    public static ParseQuery<ParseInstallation> getQuery() {
        return ParseQuery.getQuery(ParseInstallation.class);
    }

    public String getInstallationId() {
        return this.getString("installationId");
    }

    @Override
    boolean needsDefaultACL() {
        return false;
    }

    @Override
    boolean isKeyMutable(String key) {
        return !READ_ONLY_FIELDS.contains(key);
    }

    @Override
    void updateBeforeSave() {
        super.updateBeforeSave();
        if (this.isCurrentInstallation()) {
            this.updateTimezone();
            this.updateVersionInfo();
            this.updateDeviceInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    <T extends ParseObject> Task<T> fetchAsync(final Task<Void> toAwait, final String sessionToken) {
        Object object = this.mutex;
        synchronized (object) {
            Task<Void> result = this.getObjectId() == null ? this.saveAsync(toAwait, sessionToken) : Task.forResult(null);
            return result.onSuccessTask(new Continuation<Void, Task<T>>(){

                public Task<T> then(Task<Void> task) throws Exception {
                    return ParseInstallation.access$001(ParseInstallation.this, toAwait, sessionToken);
                }
            });
        }
    }

    @Override
    Task<Void> handleSaveResultAsync(JSONObject result, ParseOperationSet operationsBeforeSave) {
        Task task = super.handleSaveResultAsync(result, operationsBeforeSave);
        if (ManifestInfo.getPushUsesBroadcastReceivers()) {
            task = task.onSuccessTask((Continuation)new Continuation<Void, Task<Boolean>>(){

                public Task<Boolean> then(Task<Void> task) throws Exception {
                    return PushRouter.getForceEnabledStateAsync();
                }
            }).onSuccess((Continuation)new Continuation<Boolean, Void>(){

                public Void then(Task<Boolean> task) throws Exception {
                    Boolean forceEnabled = (Boolean)task.getResult();
                    if (forceEnabled == null || forceEnabled.booleanValue()) {
                        PushService.startServiceIfRequired(Parse.applicationContext);
                    }
                    return null;
                }
            });
        }
        return task.onSuccessTask((Continuation)new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> task) throws Exception {
                return ParseInstallation.maybeFlushToDiskAsync(ParseInstallation.this);
            }
        });
    }

    @Override
    Task<Void> handleFetchResultAsync(JSONObject result) {
        return super.handleFetchResultAsync(result).onSuccessTask((Continuation)new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> task) throws Exception {
                return ParseInstallation.maybeFlushToDiskAsync(ParseInstallation.this);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isCurrentInstallation() {
        Object object = MUTEX_CURRENT_INSTALLATION;
        synchronized (object) {
            return this == currentInstallation;
        }
    }

    private void maybeUpdateInstallationIdOnDisk() {
        boolean installationIdIsEmpty;
        String installationIdInObject = this.getInstallationId();
        String installationIdOnDisk = ParseInstallation.getOrCreateCurrentInstallationId();
        boolean bl = installationIdIsEmpty = installationIdInObject == null || installationIdInObject.length() == 0;
        if (!installationIdIsEmpty && !installationIdInObject.equals(installationIdOnDisk)) {
            PLog.w(TAG, "Will update installation id on disk: " + installationIdOnDisk + " because it does not match installation id in ParseInstallation: " + installationIdInObject);
            ParseInstallation.setCurrentInstallationId(installationIdInObject);
        }
    }

    private void updateTimezone() {
        String zone = TimeZone.getDefault().getID();
        if ((zone.indexOf(47) > 0 || zone.equals("GMT")) && !zone.equals(this.get(KEY_TIME_ZONE))) {
            this.performPut(KEY_TIME_ZONE, zone);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateVersionInfo() {
        Object object = this.mutex;
        synchronized (object) {
            try {
                Context context = Parse.getApplicationContext();
                String packageName = context.getPackageName();
                PackageManager pm = context.getPackageManager();
                PackageInfo pkgInfo = pm.getPackageInfo(packageName, 0);
                String appVersion = pkgInfo.versionName;
                String appName = pm.getApplicationLabel(pm.getApplicationInfo(packageName, 0)).toString();
                if (packageName != null && !packageName.equals(this.get(KEY_APP_IDENTIFIER))) {
                    this.performPut(KEY_APP_IDENTIFIER, packageName);
                }
                if (appName != null && !appName.equals(this.get(KEY_APP_NAME))) {
                    this.performPut(KEY_APP_NAME, appName);
                }
                if (appVersion != null && !appVersion.equals(this.get(KEY_APP_VERSION))) {
                    this.performPut(KEY_APP_VERSION, appVersion);
                }
            }
            catch (PackageManager.NameNotFoundException e) {
                PLog.w(TAG, "Cannot load package info; will not be saved to installation");
            }
            if (!"1.9.2".equals(this.get(KEY_PARSE_VERSION))) {
                this.performPut(KEY_PARSE_VERSION, "1.9.2");
            }
        }
    }

    private void updateDeviceInfo() {
        String deviceType;
        if (!this.has("installationId")) {
            this.performPut("installationId", ParseInstallation.getOrCreateCurrentInstallationId());
        }
        if (!(deviceType = "android").equals(this.get(KEY_DEVICE_TYPE))) {
            this.performPut(KEY_DEVICE_TYPE, deviceType);
        }
    }

    PushType getPushType() {
        return PushType.fromString(super.getString(KEY_PUSH_TYPE));
    }

    void setPushType(PushType pushType) {
        if (pushType != null) {
            this.performPut(KEY_PUSH_TYPE, pushType.toString());
        }
    }

    void removePushType() {
        this.performRemove(KEY_PUSH_TYPE);
    }

    String getDeviceToken() {
        return super.getString(KEY_DEVICE_TOKEN);
    }

    boolean isDeviceTokenStale() {
        return super.getLong(KEY_DEVICE_TOKEN_LAST_MODIFIED) != ManifestInfo.getLastModified();
    }

    void setDeviceTokenLastModified(long lastModified) {
        this.performPut(KEY_DEVICE_TOKEN_LAST_MODIFIED, lastModified);
    }

    void setDeviceToken(String deviceToken) {
        if (deviceToken != null && deviceToken.length() > 0) {
            this.performPut(KEY_DEVICE_TOKEN, deviceToken);
            this.performPut(KEY_DEVICE_TOKEN_LAST_MODIFIED, ManifestInfo.getLastModified());
        }
    }

    void removeDeviceToken() {
        this.performRemove(KEY_DEVICE_TOKEN);
        this.performRemove(KEY_DEVICE_TOKEN_LAST_MODIFIED);
    }

    private static Task<Void> maybeFlushToDiskAsync(final ParseInstallation installation) {
        if (!installation.isCurrentInstallation()) {
            return Task.forResult(null);
        }
        Task task = Parse.isLocalDatastoreEnabled() ? ParseObject.unpinAllInBackground(PIN_CURRENT_INSTALLATION).continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> task) throws Exception {
                return installation.pinInBackground(ParseInstallation.PIN_CURRENT_INSTALLATION, false);
            }
        }) : Task.forResult(null).continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> task) throws Exception {
                installation.saveToDisk(ParseInstallation.FILENAME_CURRENT_INSTALLATION);
                return task;
            }
        });
        task = task.continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> task) throws Exception {
                installation.maybeUpdateInstallationIdOnDisk();
                return task;
            }
        });
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearCurrentInstallationFromMemory() {
        Object object = MUTEX_CURRENT_INSTALLATION;
        synchronized (object) {
            currentInstallation = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearCurrentInstallationFromDisk(Context context) {
        Object object = MUTEX_CURRENT_INSTALLATION;
        synchronized (object) {
            currentInstallation = null;
            installationId = null;
            if (Parse.isLocalDatastoreEnabled()) {
                ParseObject.unpinAllInBackground(PIN_CURRENT_INSTALLATION);
            }
            ParseFileUtils.deleteQuietly(new File(Parse.getParseDir(), FILENAME_CURRENT_INSTALLATION));
            ParseFileUtils.deleteQuietly(new File(Parse.getParseDir(), "installationId"));
        }
    }

    static /* synthetic */ Task access$001(ParseInstallation x0, Task x1, String x2) {
        return super.fetchAsync((Task<Void>)x1, x2);
    }
}

