/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import com.parse.ParseHttpBody;
import com.parse.ParseRequest;
import java.util.HashMap;
import java.util.Map;

class ParseHttpRequest {
    private final String url;
    private final ParseRequest.Method method;
    private final Map<String, String> headers;
    private final ParseHttpBody body;
    private final Object lock = new Object();
    private Runnable cancelRunnable;
    private boolean isCancelled;

    protected ParseHttpRequest(Builder builder) {
        this.url = builder.url;
        this.method = builder.method;
        this.headers = builder.headers;
        this.body = builder.body;
        this.isCancelled = builder.isCancelled;
    }

    public String getUrl() {
        return this.url;
    }

    public ParseRequest.Method getMethod() {
        return this.method;
    }

    public Map<String, String> getAllHeaders() {
        return this.headers;
    }

    public String getHeader(String name) {
        return this.headers.get(name);
    }

    public ParseHttpBody getBody() {
        return this.body;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isCancelled) {
                return;
            }
            this.isCancelled = true;
            if (this.cancelRunnable != null) {
                this.cancelRunnable.run();
            }
        }
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public void setCancelRunnable(Runnable cancelRunnable) {
        this.cancelRunnable = cancelRunnable;
    }

    public static class Builder {
        protected String url;
        protected ParseRequest.Method method;
        protected Map<String, String> headers;
        protected ParseHttpBody body;
        protected boolean isCancelled;

        public Builder() {
            this.headers = new HashMap<String, String>();
        }

        public Builder(ParseHttpRequest request) {
            this.url = request.url;
            this.method = request.method;
            this.headers = new HashMap<String, String>(request.headers);
            this.body = request.body;
            this.isCancelled = request.isCancelled;
        }

        public Builder setUrl(String url) {
            this.url = url;
            return this;
        }

        public Builder setMethod(ParseRequest.Method method) {
            this.method = method;
            return this;
        }

        public Builder setBody(ParseHttpBody body) {
            this.body = body;
            return this;
        }

        public Builder addHeader(String name, String value) {
            this.headers.put(name, value);
            return this;
        }

        public Builder setHeaders(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public ParseHttpRequest build() {
            return new ParseHttpRequest(this);
        }
    }
}

