/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import bolts.Continuation;
import bolts.Task;
import com.parse.AbstractParseQueryController;
import com.parse.OfflineStore;
import com.parse.PLog;
import com.parse.Parse;
import com.parse.ParseException;
import com.parse.ParseKeyValueCache;
import com.parse.ParseObject;
import com.parse.ParsePin;
import com.parse.ParseQuery;
import com.parse.ParseRESTQueryCommand;
import com.parse.ParseUser;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class ParseDefaultQueryController
extends AbstractParseQueryController {
    private static final String TAG = "ParseDefaultQueryController";

    ParseDefaultQueryController() {
    }

    @Override
    public <T extends ParseObject> Task<List<T>> findAsync(ParseQuery.State<T> state, ParseUser user, Task<Void> cancellationToken) {
        String sessionToken;
        String string = sessionToken = user != null ? user.getSessionToken() : null;
        if (state.isFromLocalDatastore()) {
            return ParseDefaultQueryController.findFromLocalDatastoreAsync(state.pinName(), state, user);
        }
        return ParseDefaultQueryController.findWithCachePolicyAsync(state.cachePolicy(), state, sessionToken, cancellationToken);
    }

    @Override
    public <T extends ParseObject> Task<Integer> countAsync(ParseQuery.State<T> state, ParseUser user, Task<Void> cancellationToken) {
        String sessionToken;
        String string = sessionToken = user != null ? user.getSessionToken() : null;
        if (state.isFromLocalDatastore()) {
            return ParseDefaultQueryController.countFromLocalDatastoreAsync(state.pinName(), state, user);
        }
        return ParseDefaultQueryController.countWithCachePolicyAsync(state.cachePolicy(), state, sessionToken, cancellationToken);
    }

    private static <T extends ParseObject> Task<List<T>> findFromNetworkAsync(final ParseQuery.State<T> state, String sessionToken, boolean shouldRetry, Task<Void> ct) {
        final long queryStart = System.nanoTime();
        final ParseRESTQueryCommand command = ParseRESTQueryCommand.findCommand(state, sessionToken);
        if (shouldRetry) {
            command.enableRetrying();
        }
        if (ct != null) {
            ct.continueWith((Continuation)new Continuation<Void, Void>(){

                public Void then(Task<Void> task) throws Exception {
                    if (task.isCancelled()) {
                        command.cancel();
                    }
                    return null;
                }
            });
        }
        final long querySent = System.nanoTime();
        return command.executeAsync().cast().onSuccess(new Continuation<JSONObject, List<T>>(){

            public List<T> then(Task<JSONObject> task) throws Exception {
                JSONObject json = (JSONObject)task.getResult();
                ParseQuery.CachePolicy policy = state.cachePolicy();
                if (policy != null && policy != ParseQuery.CachePolicy.IGNORE_CACHE) {
                    ParseKeyValueCache.saveToKeyValueCache(command.getCacheKey(), json.toString());
                }
                long queryReceived = System.nanoTime();
                List response = ParseDefaultQueryController.convertFindResponse(state, (JSONObject)task.getResult());
                long objectsParsed = System.nanoTime();
                if (json.has("trace")) {
                    Object serverTrace = json.get("trace");
                    PLog.d("ParseQuery", String.format("Query pre-processing took %f seconds\n%s\nClient side parsing took %f seconds\n", Float.valueOf((float)(querySent - queryStart) / 1000000.0f), serverTrace, Float.valueOf((float)(objectsParsed - queryReceived) / 1000000.0f)));
                }
                return response;
            }
        }, (Executor)Task.BACKGROUND_EXECUTOR);
    }

    private static <T extends ParseObject> Task<Integer> countFromNetworkAsync(final ParseQuery.State<T> state, String sessionToken, boolean shouldRetry, Task<Void> ct) {
        final ParseRESTQueryCommand command = ParseRESTQueryCommand.countCommand(state, sessionToken);
        if (shouldRetry) {
            command.enableRetrying();
        }
        if (ct != null) {
            ct.continueWith((Continuation)new Continuation<Void, Void>(){

                public Void then(Task<Void> task) throws Exception {
                    if (task.isCancelled()) {
                        command.cancel();
                    }
                    return null;
                }
            });
        }
        return command.executeAsync().onSuccessTask((Continuation)new Continuation<Object, Task<Object>>(){

            public Task<Object> then(Task<Object> task) throws Exception {
                ParseQuery.CachePolicy policy = state.cachePolicy();
                if (policy != null && policy != ParseQuery.CachePolicy.IGNORE_CACHE) {
                    Object result = task.getResult();
                    ParseKeyValueCache.saveToKeyValueCache(command.getCacheKey(), result.toString());
                }
                return task;
            }
        }, (Executor)Task.BACKGROUND_EXECUTOR).onSuccess((Continuation)new Continuation<Object, Integer>(){

            public Integer then(Task<Object> task) throws Exception {
                return ((JSONObject)task.getResult()).optInt("count");
            }
        });
    }

    private static <T extends ParseObject> List<T> convertFindResponse(ParseQuery.State<T> state, JSONObject response) throws JSONException {
        ArrayList answer = new ArrayList();
        JSONArray results = response.getJSONArray("results");
        if (results == null) {
            PLog.d(TAG, "null results in find response");
        } else {
            String resultClassName = response.optString("className", null);
            if (resultClassName == null) {
                resultClassName = state.className();
            }
            for (int i = 0; i < results.length(); ++i) {
                JSONObject data = results.getJSONObject(i);
                Object object = ParseObject.fromJSON(data, resultClassName, state.selectedKeys() == null);
                answer.add(object);
                ParseQuery.RelationConstraint relation = (ParseQuery.RelationConstraint)state.constraints().get("$relatedTo");
                if (relation == null) continue;
                relation.getRelation().addKnownObject((ParseObject)object);
            }
        }
        return answer;
    }

    private static <T extends ParseObject> Task<List<T>> findWithCachePolicyAsync(ParseQuery.CachePolicy policy, final ParseQuery.State<T> state, final String sessionToken, final Task<Void> ct) {
        CommandDelegate callbacks = new CommandDelegate<List<T>>(){

            @Override
            public Task<List<T>> runOnNetworkAsync(boolean retry) {
                return ParseDefaultQueryController.findFromNetworkAsync(state, sessionToken, retry, (Task<Void>)ct);
            }

            @Override
            public Task<List<T>> runFromCacheAsync() {
                return ParseDefaultQueryController.findFromCacheAsync(state, sessionToken);
            }
        };
        return ParseDefaultQueryController.runCommandWithPolicyAsync(callbacks, policy);
    }

    private static <T extends ParseObject> Task<Integer> countWithCachePolicyAsync(ParseQuery.CachePolicy policy, final ParseQuery.State<T> state, final String sessionToken, final Task<Void> ct) {
        CommandDelegate<Integer> callbacks = new CommandDelegate<Integer>(){

            @Override
            public Task<Integer> runOnNetworkAsync(boolean retry) {
                return ParseDefaultQueryController.countFromNetworkAsync(state, sessionToken, retry, (Task<Void>)ct);
            }

            @Override
            public Task<Integer> runFromCacheAsync() {
                return ParseDefaultQueryController.countFromCacheAsync(state, sessionToken);
            }
        };
        return ParseDefaultQueryController.runCommandWithPolicyAsync(callbacks, policy);
    }

    private static <T extends ParseObject> Task<List<T>> findFromCacheAsync(final ParseQuery.State<T> state, String sessionToken) {
        final String cacheKey = ParseRESTQueryCommand.findCommand(state, sessionToken).getCacheKey();
        return Task.call((Callable)new Callable<List<T>>(){

            @Override
            public List<T> call() throws Exception {
                Object cached = ParseKeyValueCache.jsonFromKeyValueCache(cacheKey, state.maxCacheAge());
                if (cached == null) {
                    throw new ParseException(120, "results not cached");
                }
                if (!(cached instanceof JSONObject)) {
                    throw new ParseException(120, "the cache contains the wrong datatype");
                }
                JSONObject object = (JSONObject)cached;
                try {
                    return ParseDefaultQueryController.convertFindResponse(state, object);
                }
                catch (JSONException e) {
                    throw new ParseException(120, "the cache contains corrupted json");
                }
            }
        }, (Executor)Task.BACKGROUND_EXECUTOR);
    }

    private static <T extends ParseObject> Task<Integer> countFromCacheAsync(final ParseQuery.State<T> state, String sessionToken) {
        final String cacheKey = ParseRESTQueryCommand.countCommand(state, sessionToken).getCacheKey();
        return Task.call((Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                Object cached = ParseKeyValueCache.jsonFromKeyValueCache(cacheKey, state.maxCacheAge());
                if (cached == null) {
                    throw new ParseException(120, "results not cached");
                }
                if (!(cached instanceof JSONObject)) {
                    throw new ParseException(120, "the cache contains the wrong datatype");
                }
                JSONObject object = (JSONObject)cached;
                try {
                    return object.getInt("count");
                }
                catch (JSONException e) {
                    throw new ParseException(120, "the cache contains corrupted json");
                }
            }
        }, (Executor)Task.BACKGROUND_EXECUTOR);
    }

    private static <TResult> Task<TResult> runCommandWithPolicyAsync(final CommandDelegate<TResult> c, ParseQuery.CachePolicy policy) {
        switch (policy) {
            case IGNORE_CACHE: 
            case NETWORK_ONLY: {
                return c.runOnNetworkAsync(true);
            }
            case CACHE_ONLY: {
                return c.runFromCacheAsync();
            }
            case CACHE_ELSE_NETWORK: {
                return c.runFromCacheAsync().continueWithTask(new Continuation<TResult, Task<TResult>>(){

                    public Task<TResult> then(Task<TResult> task) throws Exception {
                        if (task.getError() instanceof ParseException) {
                            return c.runOnNetworkAsync(true);
                        }
                        return task;
                    }
                });
            }
            case NETWORK_ELSE_CACHE: {
                return c.runOnNetworkAsync(false).continueWithTask(new Continuation<TResult, Task<TResult>>(){

                    public Task<TResult> then(Task<TResult> task) throws Exception {
                        Exception error = task.getError();
                        if (error instanceof ParseException && ((ParseException)error).getCode() == 100) {
                            return c.runFromCacheAsync();
                        }
                        return task;
                    }
                });
            }
            case CACHE_THEN_NETWORK: {
                throw new RuntimeException("You cannot use the cache policy CACHE_THEN_NETWORK with find()");
            }
        }
        throw new RuntimeException("Unknown cache policy: " + (Object)((Object)policy));
    }

    private static <T extends ParseObject> Task<List<T>> findFromLocalDatastoreAsync(String pinName, final ParseQuery.State<T> state, final ParseUser user) {
        final OfflineStore store = Parse.getLocalDatastore();
        Task task = pinName != null ? ParsePin.getParsePin(pinName) : Task.forResult(null);
        return task.onSuccessTask(new Continuation<ParsePin, Task<List<T>>>(){

            public Task<List<T>> then(Task<ParsePin> task) throws Exception {
                ParsePin pin = (ParsePin)task.getResult();
                return store.findAsync(state, user, pin);
            }
        });
    }

    private static <T extends ParseObject> Task<Integer> countFromLocalDatastoreAsync(String pinName, final ParseQuery.State<T> state, final ParseUser user) {
        final OfflineStore store = Parse.getLocalDatastore();
        Task task = pinName != null ? ParsePin.getParsePin(pinName) : Task.forResult(null);
        return task.onSuccessTask((Continuation)new Continuation<ParsePin, Task<Integer>>(){

            public Task<Integer> then(Task<ParsePin> task) throws Exception {
                ParsePin pin = (ParsePin)task.getResult();
                return store.countAsync(state, user, pin);
            }
        });
    }

    private static interface CommandDelegate<T> {
        public Task<T> runOnNetworkAsync(boolean var1);

        public Task<T> runFromCacheAsync();
    }
}

