/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import bolts.Task;
import com.parse.ParseByteArrayHttpBody;
import com.parse.ParseCallback2;
import com.parse.ParseException;
import com.parse.ParseTaskUtils;
import java.io.IOException;
import java.io.OutputStream;

class ParseCountingByteArrayHttpBody
extends ParseByteArrayHttpBody {
    private static final int DEFAULT_CHUNK_SIZE = 4096;
    private final ParseCallback2<Integer, ParseException> progressCallback;

    public ParseCountingByteArrayHttpBody(byte[] content, String contentType, ParseCallback2<Integer, ParseException> progressCallback) {
        super(content, contentType);
        this.progressCallback = progressCallback;
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException("Output stream may not be null");
        }
        int position = 0;
        int totalLength = this.content.length;
        while (position < totalLength) {
            int length = Math.min(totalLength - position, 4096);
            out.write(this.content, position, length);
            out.flush();
            int progress = 100 * (position += length) / totalLength;
            ParseTaskUtils.callbackOnMainThreadAsync(Task.forResult((Object)progress), this.progressCallback);
        }
    }
}

