/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import bolts.Continuation;
import bolts.Task;
import com.parse.ConfigCallback;
import com.parse.NoObjectsEncoder;
import com.parse.Parse;
import com.parse.ParseDecoder;
import com.parse.ParseException;
import com.parse.ParseFile;
import com.parse.ParseFileUtils;
import com.parse.ParseGeoPoint;
import com.parse.ParseRESTConfigCommand;
import com.parse.ParseTaskUtils;
import com.parse.ParseUser;
import com.parse.PointerEncoder;
import com.parse.TaskQueue;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ParseConfig {
    static final String CURRENT_CONFIG_FILENAME = "currentConfig";
    private static final TaskQueue taskQueue = new TaskQueue();
    private static final Object currentConfigMutex = new Object();
    private static ParseConfig currentConfig;
    private final Map<String, Object> params;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ParseConfig getCurrentConfig() {
        Object object = currentConfigMutex;
        synchronized (object) {
            if (currentConfig == null) {
                ParseConfig config = ParseConfig.getFromDisk(CURRENT_CONFIG_FILENAME);
                currentConfig = config != null ? config : new ParseConfig();
            }
            return currentConfig;
        }
    }

    public static ParseConfig get() throws ParseException {
        return ParseTaskUtils.wait(ParseConfig.getInBackground());
    }

    public static void getInBackground(ConfigCallback callback) {
        ParseTaskUtils.callbackOnMainThreadAsync(ParseConfig.getInBackground(), callback);
    }

    public static Task<ParseConfig> getInBackground() {
        return taskQueue.enqueue(new Continuation<Void, Task<ParseConfig>>(){

            public Task<ParseConfig> then(Task<Void> toAwait) throws Exception {
                return ParseConfig.getAsync((Task<Void>)toAwait);
            }
        });
    }

    private static Task<ParseConfig> getAsync(final Task<Void> toAwait) {
        return ParseUser.getCurrentSessionTokenAsync().onSuccessTask((Continuation)new Continuation<String, Task<JSONObject>>(){

            public Task<JSONObject> then(Task<String> task) throws Exception {
                String sessionToken = (String)task.getResult();
                final ParseRESTConfigCommand command = ParseRESTConfigCommand.fetchConfigCommand(sessionToken);
                command.enableRetrying();
                return toAwait.continueWithTask((Continuation)new Continuation<Void, Task<JSONObject>>(){

                    public Task<JSONObject> then(Task<Void> task) throws Exception {
                        return command.executeAsync().cast();
                    }
                });
            }
        }).onSuccess((Continuation)new Continuation<JSONObject, ParseConfig>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public ParseConfig then(Task<JSONObject> task) throws Exception {
                JSONObject result = (JSONObject)task.getResult();
                ParseConfig config = new ParseConfig(result, ParseDecoder.get());
                config.saveToDisk(ParseConfig.CURRENT_CONFIG_FILENAME);
                Object object = currentConfigMutex;
                synchronized (object) {
                    currentConfig = config;
                    return currentConfig;
                }
            }
        }, (Executor)Task.BACKGROUND_EXECUTOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearCurrentConfigForTesting() {
        Object object = currentConfigMutex;
        synchronized (object) {
            currentConfig = null;
        }
    }

    private static ParseConfig getFromDisk(String filename) {
        JSONObject json;
        try {
            json = ParseFileUtils.readFileToJSONObject(new File(Parse.getParseDir(), filename));
        }
        catch (IOException | JSONException e) {
            return null;
        }
        try {
            return new ParseConfig(json, ParseDecoder.get());
        }
        catch (JSONException e) {
            return null;
        }
    }

    ParseConfig(JSONObject object, ParseDecoder decoder) throws JSONException {
        Map decodedObject = (Map)decoder.decode(object);
        Map decodedParams = (Map)decodedObject.get("params");
        if (decodedParams == null) {
            throw new RuntimeException("Object did not contain the 'params' key.");
        }
        this.params = Collections.unmodifiableMap(decodedParams);
    }

    ParseConfig() {
        this.params = Collections.unmodifiableMap(new HashMap());
    }

    public Object get(String key) {
        return this.get(key, null);
    }

    public Object get(String key, Object defaultValue) {
        if (!this.params.containsKey(key)) {
            return defaultValue;
        }
        Object value = this.params.get(key);
        if (value == JSONObject.NULL) {
            return null;
        }
        return this.params.get(key);
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        if (!this.params.containsKey(key)) {
            return defaultValue;
        }
        Object value = this.params.get(key);
        return value instanceof Boolean ? (Boolean)value : defaultValue;
    }

    public Date getDate(String key) {
        return this.getDate(key, null);
    }

    public Date getDate(String key, Date defaultValue) {
        if (!this.params.containsKey(key)) {
            return defaultValue;
        }
        Object value = this.params.get(key);
        if (value == null || value == JSONObject.NULL) {
            return null;
        }
        return value instanceof Date ? (Date)value : defaultValue;
    }

    public double getDouble(String key) {
        return this.getDouble(key, 0.0);
    }

    public double getDouble(String key, double defaultValue) {
        Number number = this.getNumber(key);
        return number != null ? number.doubleValue() : defaultValue;
    }

    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    public int getInt(String key, int defaultValue) {
        Number number = this.getNumber(key);
        return number != null ? number.intValue() : defaultValue;
    }

    public JSONArray getJSONArray(String key) {
        return this.getJSONArray(key, null);
    }

    public JSONArray getJSONArray(String key, JSONArray defaultValue) {
        List list = this.getList(key);
        Object encoded = list != null ? PointerEncoder.get().encode(list) : null;
        return encoded == null || encoded instanceof JSONArray ? (JSONArray)encoded : defaultValue;
    }

    public JSONObject getJSONObject(String key) {
        return this.getJSONObject(key, null);
    }

    public JSONObject getJSONObject(String key, JSONObject defaultValue) {
        Map map = this.getMap(key);
        Object encoded = map != null ? PointerEncoder.get().encode(map) : null;
        return encoded == null || encoded instanceof JSONObject ? (JSONObject)encoded : defaultValue;
    }

    public <T> List<T> getList(String key) {
        return this.getList(key, null);
    }

    public <T> List<T> getList(String key, List<T> defaultValue) {
        if (!this.params.containsKey(key)) {
            return defaultValue;
        }
        Object value = this.params.get(key);
        if (value == null || value == JSONObject.NULL) {
            return null;
        }
        List returnValue = value instanceof List ? (List)value : defaultValue;
        return returnValue;
    }

    public long getLong(String key) {
        return this.getLong(key, 0L);
    }

    public long getLong(String key, long defaultValue) {
        Number number = this.getNumber(key);
        return number != null ? number.longValue() : defaultValue;
    }

    public <V> Map<String, V> getMap(String key) {
        return this.getMap(key, null);
    }

    public <V> Map<String, V> getMap(String key, Map<String, V> defaultValue) {
        if (!this.params.containsKey(key)) {
            return defaultValue;
        }
        Object value = this.params.get(key);
        if (value == null || value == JSONObject.NULL) {
            return null;
        }
        Map returnValue = value instanceof Map ? (Map)value : defaultValue;
        return returnValue;
    }

    public Number getNumber(String key) {
        return this.getNumber(key, null);
    }

    public Number getNumber(String key, Number defaultValue) {
        if (!this.params.containsKey(key)) {
            return defaultValue;
        }
        Object value = this.params.get(key);
        if (value == null || value == JSONObject.NULL) {
            return null;
        }
        return value instanceof Number ? (Number)((Number)value) : (Number)defaultValue;
    }

    public ParseFile getParseFile(String key) {
        return this.getParseFile(key, null);
    }

    public ParseFile getParseFile(String key, ParseFile defaultValue) {
        if (!this.params.containsKey(key)) {
            return defaultValue;
        }
        Object value = this.params.get(key);
        if (value == null || value == JSONObject.NULL) {
            return null;
        }
        return value instanceof ParseFile ? (ParseFile)value : defaultValue;
    }

    public ParseGeoPoint getParseGeoPoint(String key) {
        return this.getParseGeoPoint(key, null);
    }

    public ParseGeoPoint getParseGeoPoint(String key, ParseGeoPoint defaultValue) {
        if (!this.params.containsKey(key)) {
            return defaultValue;
        }
        Object value = this.params.get(key);
        if (value == null || value == JSONObject.NULL) {
            return null;
        }
        return value instanceof ParseGeoPoint ? (ParseGeoPoint)value : defaultValue;
    }

    public String getString(String key) {
        return this.getString(key, null);
    }

    public String getString(String key, String defaultValue) {
        if (!this.params.containsKey(key)) {
            return defaultValue;
        }
        Object value = this.params.get(key);
        if (value == null || value == JSONObject.NULL) {
            return null;
        }
        return value instanceof String ? (String)value : defaultValue;
    }

    private void saveToDisk(String filename) {
        JSONObject object = new JSONObject();
        try {
            JSONObject jsonParams = (JSONObject)NoObjectsEncoder.get().encode(this.params);
            object.put("params", (Object)jsonParams);
        }
        catch (JSONException e) {
            throw new RuntimeException("could not serialize config to JSON");
        }
        try {
            ParseFileUtils.writeJSONObjectToFile(new File(Parse.getParseDir(), filename), object);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String toString() {
        return "ParseConfig[" + this.params.toString() + "]";
    }
}

