/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import java.util.AbstractList;
import java.util.List;

class Lists {
    Lists() {
    }

    static <T> List<List<T>> partition(List<T> list, int size) {
        return new Partition<T>(list, size);
    }

    private static class Partition<T>
    extends AbstractList<List<T>> {
        private final List<T> list;
        private final int size;

        public Partition(List<T> list, int size) {
            this.list = list;
            this.size = size;
        }

        @Override
        public List<T> get(int location) {
            int start = location * this.size;
            int end = Math.min(start + this.size, this.list.size());
            return this.list.subList(start, end);
        }

        @Override
        public int size() {
            return (int)Math.ceil((double)this.list.size() / (double)this.size);
        }
    }
}

