/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.StrictMode;
import bolts.Task;
import com.parse.Parse;
import com.parse.ParseCommand;
import com.parse.ParseEventuallyQueue;
import com.parse.ParseException;
import com.parse.ParseInstallation;
import com.parse.ParseObject;
import com.parse.ParseUser;
import com.parse.PushConnection;
import com.parse.PushRouter;
import com.parse.PushService;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.URL;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONObject;

class ParseTestUtils {
    private static final String TAG = "com.parse.ParseTestUtils";
    private static final Object TEST_SERVER_LOCK = new Object();
    private static String testServer;
    private static final AtomicBoolean strictModeEnabled;

    ParseTestUtils() {
    }

    public static String useServer(String theServer) {
        String oldServer = ParseObject.server;
        ParseObject.server = theServer;
        return oldServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setTestServer(String server) {
        Object object = TEST_SERVER_LOCK;
        synchronized (object) {
            testServer = server;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getTestServer(Context context) {
        if (testServer == null) {
            Object object = TEST_SERVER_LOCK;
            synchronized (object) {
                if (testServer == null) {
                    try {
                        BufferedReader br = new BufferedReader(new InputStreamReader(context.getAssets().open("server.config")));
                        testServer = br.readLine();
                    }
                    catch (Exception e) {
                        testServer = Build.PRODUCT.contains("vbox") ? "http://192.168.56.1:3000" : (Build.PRODUCT.contains("sdk") || Build.PRODUCT.contains("full_x86") ? "http://10.0.2.2:3000" : "http://localhost:3000");
                    }
                }
            }
        }
        return testServer;
    }

    public static String useTestServer(Context context) {
        return ParseTestUtils.useServer(ParseTestUtils.getTestServer(context));
    }

    public static String useBadServerPort() {
        return ParseTestUtils.useBadServerPort(ParseObject.server);
    }

    public static String useInvalidServer() {
        return ParseTestUtils.useServer("http://invalid.server:3000");
    }

    public static String useBadServerPort(String baseUrl) {
        String newUrl = "http://10.0.2.2:6000";
        try {
            URL base = new URL(baseUrl);
            newUrl = base.getProtocol() + "://" + base.getHost() + ":" + (base.getPort() + 999);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return ParseTestUtils.useServer(newUrl);
    }

    public static void clearApp() {
        ParseCommand command = new ParseCommand("clear_app", null);
        try {
            Parse.waitForTask(command.executeAsync());
        }
        catch (ParseException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static void mockV8Client() {
        ParseCommand command = new ParseCommand("mock_v8_client", null);
        try {
            Parse.waitForTask(command.executeAsync());
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static void unmockV8Client() {
        ParseCommand command = new ParseCommand("unmock_v8_client", null);
        try {
            Parse.waitForTask(command.executeAsync());
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static void saveObjectToDisk(ParseObject object, Context context, String filename) {
        object.saveToDisk(context, filename);
    }

    public static ParseObject getObjectFromDisk(Context context, String filename) {
        return ParseObject.getFromDisk(context, filename);
    }

    public static ParseUser getUserObjectFromDisk(Context context, String filename) {
        return (ParseUser)ParseObject.getFromDisk(context, filename);
    }

    public static void saveStringToDisk(String string, Context context, String filename) {
        File file = new File(ParseTestUtils.getParseDir(context), filename);
        try {
            FileOutputStream out = new FileOutputStream(file);
            out.write(string.getBytes("UTF-8"));
            out.close();
        }
        catch (UnsupportedEncodingException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private static File getParseDir(Context context) {
        return context.getDir("Parse", 0);
    }

    public static Set<String> keySet(ParseObject object) {
        return object.keySet();
    }

    public static void setCommandInitialDelay(long milliSeconds) {
        ParseCommand.setDefaultInitialRetryDelay(milliSeconds);
    }

    public static void clearCurrentInstallationFromMemory() {
        ParseInstallation.currentInstallation = null;
    }

    public static Set<String> pushRoutes(Context context) {
        Task<Set<String>> subscriptionsTask = PushRouter.getSubscriptionsAsync(false);
        try {
            subscriptionsTask.waitForCompletion();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return (Set)subscriptionsTask.getResult();
    }

    public static String getInstallationId(Context context) {
        return ParseInstallation.getCurrentInstallation().getInstallationId();
    }

    public static JSONObject getSerializedPushStateJSON() {
        return Parse.getDiskObject(Parse.applicationContext, "pushState");
    }

    public static void startServiceIfRequired(Context context) {
        PushService.startServiceIfRequired(context);
    }

    public static void setRetryDelayEnabled(boolean enable) {
        PushConnection.ENABLE_RETRY_DELAY = enable;
    }

    public static ServerSocket mockPushServer() {
        ServerSocket socket;
        try {
            socket = new ServerSocket(0);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
        InetSocketAddress address = (InetSocketAddress)socket.getLocalSocketAddress();
        PushService.useServer(address.getHostName(), address.getPort());
        Parse.logI(TAG, "running mockPushServer on " + address);
        return socket;
    }

    public static void resetCommandCache() {
        ParseEventuallyQueue cache = Parse.getEventuallyQueue();
        ParseEventuallyQueue.TestHelper helper = cache.getTestHelper();
        cache.clear();
        helper.clear();
    }

    public static void disconnectCommandCache() {
        Parse.eventuallyQueue.setConnected(false);
    }

    public static void reconnectCommandCache() {
        Parse.eventuallyQueue.setConnected(true);
    }

    public static boolean waitForCommandCacheEnqueue() {
        return Parse.eventuallyQueue.getTestHelper().waitFor(3);
    }

    public static boolean waitForCommandCacheSuccess() {
        return Parse.eventuallyQueue.getTestHelper().waitFor(1) && Parse.eventuallyQueue.getTestHelper().waitFor(5);
    }

    public static boolean waitForCommandCacheFailure() {
        return Parse.eventuallyQueue.getTestHelper().waitFor(2);
    }

    public static int commandCacheUnexpectedEvents() {
        return Parse.eventuallyQueue.getTestHelper().unexpectedEvents();
    }

    public static int setPushHistoryLength(int length) {
        int oldLength = PushRouter.MAX_HISTORY_LENGTH;
        PushRouter.MAX_HISTORY_LENGTH = length;
        return oldLength;
    }

    public static void setStrictModeEnabledForMainThread(final boolean enabled) {
        if (strictModeEnabled.compareAndSet(!enabled, enabled)) {
            final Semaphore done = new Semaphore(0);
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    ParseTestUtils.setStrictModeEnabledForThisThread(enabled);
                    done.release();
                }
            });
            done.acquireUninterruptibly();
        }
    }

    public static void setStrictModeEnabledForThisThread(boolean enabled) {
        if (enabled) {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)new StrictMode.ThreadPolicy.Builder().detectAll().penaltyLog().penaltyDeath().build());
        } else {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)new StrictMode.ThreadPolicy.Builder().detectAll().penaltyLog().build());
        }
    }

    static {
        strictModeEnabled = new AtomicBoolean(false);
    }
}

