/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.net.Uri;
import com.parse.Parse;
import com.parse.ParseRESTCommand;
import com.parse.ParseRequest;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

class ParseRESTAnalyticsCommand
extends ParseRESTCommand {
    private static final String EVENT_APP_OPENED = "AppOpened";

    public ParseRESTAnalyticsCommand(String httpPath, ParseRequest.Method httpMethod, Map<String, ?> parameters, String sessionToken) {
        super(httpPath, httpMethod, parameters, sessionToken);
    }

    public static ParseRESTAnalyticsCommand trackAppOpenedCommand(String pushHash, String sessionToken) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (pushHash != null) {
            parameters.put("push_hash", pushHash);
        }
        return ParseRESTAnalyticsCommand.trackEventCommand(EVENT_APP_OPENED, parameters, sessionToken);
    }

    public static ParseRESTAnalyticsCommand trackEventCommand(String eventName, JSONObject dimensions, String sessionToken) {
        HashMap<String, JSONObject> parameters = null;
        if (dimensions != null) {
            parameters = new HashMap<String, JSONObject>();
            parameters.put("dimensions", dimensions);
        }
        return ParseRESTAnalyticsCommand.trackEventCommand(eventName, parameters, sessionToken);
    }

    static ParseRESTAnalyticsCommand trackEventCommand(String eventName, Map<String, ?> parameters, String sessionToken) {
        String httpPath = String.format("events/%s", Uri.encode((String)eventName));
        HashMap<String, Object> commandParameters = new HashMap<String, Object>();
        if (parameters != null) {
            commandParameters.putAll(parameters);
        }
        commandParameters.put("at", Parse.encodeDate(new Date()));
        return new ParseRESTAnalyticsCommand(httpPath, ParseRequest.Method.POST, commandParameters, sessionToken);
    }
}

