/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import com.parse.Parse;
import com.parse.ParseDeleteOperation;
import com.parse.ParseFieldOperation;
import com.parse.ParseObject;
import com.parse.ParseObjectEncodingStrategy;
import com.parse.ParseSetOperation;
import org.json.JSONException;
import org.json.JSONObject;

class ParseIncrementOperation
implements ParseFieldOperation {
    private Number amount;

    public ParseIncrementOperation(Number amount) {
        this.amount = amount;
    }

    public JSONObject encode(ParseObjectEncodingStrategy objectEncoder) throws JSONException {
        JSONObject output = new JSONObject();
        output.put("__op", (Object)"Increment");
        output.put("amount", (Object)this.amount);
        return output;
    }

    @Override
    public ParseFieldOperation mergeWithPrevious(ParseFieldOperation previous) {
        if (previous == null) {
            return this;
        }
        if (previous instanceof ParseDeleteOperation) {
            return new ParseSetOperation(this.amount);
        }
        if (previous instanceof ParseSetOperation) {
            Object oldValue = ((ParseSetOperation)previous).getValue();
            if (oldValue instanceof Number) {
                return new ParseSetOperation(Parse.addNumbers((Number)oldValue, this.amount));
            }
            throw new IllegalArgumentException("You cannot increment a non-number.");
        }
        if (previous instanceof ParseIncrementOperation) {
            Number oldAmount = ((ParseIncrementOperation)previous).amount;
            return new ParseIncrementOperation(Parse.addNumbers(oldAmount, this.amount));
        }
        throw new IllegalArgumentException("Operation is invalid after previous operation.");
    }

    @Override
    public Object apply(Object oldValue, ParseObject object, String key) {
        if (oldValue == null) {
            return this.amount;
        }
        if (oldValue instanceof Number) {
            return Parse.addNumbers((Number)oldValue, this.amount);
        }
        throw new IllegalArgumentException("You cannot increment a non-number.");
    }
}

