/*
 * Decompiled with CFR 0.152.
 */
package com.parse.signpost;

import com.parse.signpost.OAuth;
import com.parse.signpost.OAuthConsumer;
import com.parse.signpost.basic.UrlStringRequestAdapter;
import com.parse.signpost.exception.OAuthCommunicationException;
import com.parse.signpost.exception.OAuthExpectationFailedException;
import com.parse.signpost.exception.OAuthMessageSignerException;
import com.parse.signpost.http.HttpParameters;
import com.parse.signpost.http.HttpRequest;
import com.parse.signpost.signature.AuthorizationHeaderSigningStrategy;
import com.parse.signpost.signature.HmacSha1MessageSigner;
import com.parse.signpost.signature.OAuthMessageSigner;
import com.parse.signpost.signature.QueryStringSigningStrategy;
import com.parse.signpost.signature.SigningStrategy;
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;

public abstract class AbstractOAuthConsumer
implements OAuthConsumer {
    private static final long serialVersionUID = 1L;
    private String consumerKey;
    private String consumerSecret;
    private String token;
    private OAuthMessageSigner messageSigner;
    private SigningStrategy signingStrategy;
    private HttpParameters additionalParameters;
    private HttpParameters requestParameters;
    private boolean sendEmptyTokens;

    public AbstractOAuthConsumer(String consumerKey, String consumerSecret) {
        this.consumerKey = consumerKey;
        this.consumerSecret = consumerSecret;
        this.setMessageSigner(new HmacSha1MessageSigner());
        this.setSigningStrategy(new AuthorizationHeaderSigningStrategy());
    }

    @Override
    public void setMessageSigner(OAuthMessageSigner messageSigner) {
        this.messageSigner = messageSigner;
        messageSigner.setConsumerSecret(this.consumerSecret);
    }

    @Override
    public void setSigningStrategy(SigningStrategy signingStrategy) {
        this.signingStrategy = signingStrategy;
    }

    @Override
    public void setAdditionalParameters(HttpParameters additionalParameters) {
        this.additionalParameters = additionalParameters;
    }

    @Override
    public HttpRequest sign(HttpRequest request) throws OAuthMessageSignerException, OAuthExpectationFailedException, OAuthCommunicationException {
        if (this.consumerKey == null) {
            throw new OAuthExpectationFailedException("consumer key not set");
        }
        if (this.consumerSecret == null) {
            throw new OAuthExpectationFailedException("consumer secret not set");
        }
        this.requestParameters = new HttpParameters();
        try {
            if (this.additionalParameters != null) {
                this.requestParameters.putAll(this.additionalParameters, false);
            }
            this.collectHeaderParameters(request, this.requestParameters);
            this.collectQueryParameters(request, this.requestParameters);
            this.collectBodyParameters(request, this.requestParameters);
            this.completeOAuthParameters(this.requestParameters);
            this.requestParameters.remove("oauth_signature");
        }
        catch (IOException e) {
            throw new OAuthCommunicationException(e);
        }
        String signature = this.messageSigner.sign(request, this.requestParameters);
        OAuth.debugOut("signature", signature);
        this.signingStrategy.writeSignature(signature, request, this.requestParameters);
        OAuth.debugOut("Auth header", request.getHeader("Authorization"));
        OAuth.debugOut("Request URL", request.getRequestUrl());
        return request;
    }

    @Override
    public HttpRequest sign(Object request) throws OAuthMessageSignerException, OAuthExpectationFailedException, OAuthCommunicationException {
        return this.sign(this.wrap(request));
    }

    @Override
    public String sign(String url) throws OAuthMessageSignerException, OAuthExpectationFailedException, OAuthCommunicationException {
        UrlStringRequestAdapter request = new UrlStringRequestAdapter(url);
        SigningStrategy oldStrategy = this.signingStrategy;
        this.signingStrategy = new QueryStringSigningStrategy();
        this.sign(request);
        this.signingStrategy = oldStrategy;
        return request.getRequestUrl();
    }

    protected abstract HttpRequest wrap(Object var1);

    @Override
    public void setTokenWithSecret(String token, String tokenSecret) {
        this.token = token;
        this.messageSigner.setTokenSecret(tokenSecret);
    }

    @Override
    public String getToken() {
        return this.token;
    }

    @Override
    public String getTokenSecret() {
        return this.messageSigner.getTokenSecret();
    }

    @Override
    public String getConsumerKey() {
        return this.consumerKey;
    }

    @Override
    public String getConsumerSecret() {
        return this.consumerSecret;
    }

    protected void completeOAuthParameters(HttpParameters out) {
        if (!out.containsKey("oauth_consumer_key")) {
            out.put("oauth_consumer_key", this.consumerKey, true);
        }
        if (!out.containsKey("oauth_signature_method")) {
            out.put("oauth_signature_method", this.messageSigner.getSignatureMethod(), true);
        }
        if (!out.containsKey("oauth_timestamp")) {
            out.put("oauth_timestamp", this.generateTimestamp(), true);
        }
        if (!out.containsKey("oauth_nonce")) {
            out.put("oauth_nonce", this.generateNonce(), true);
        }
        if (!out.containsKey("oauth_version")) {
            out.put("oauth_version", "1.0", true);
        }
        if (!out.containsKey("oauth_token") && (this.token != null && !this.token.equals("") || this.sendEmptyTokens)) {
            out.put("oauth_token", this.token, true);
        }
    }

    @Override
    public HttpParameters getRequestParameters() {
        return this.requestParameters;
    }

    @Override
    public void setSendEmptyTokens(boolean enable) {
        this.sendEmptyTokens = enable;
    }

    protected void collectHeaderParameters(HttpRequest request, HttpParameters out) {
        HttpParameters headerParams = OAuth.oauthHeaderToParamsMap(request.getHeader("Authorization"));
        out.putAll(headerParams, false);
    }

    protected void collectBodyParameters(HttpRequest request, HttpParameters out) throws IOException {
        String contentType = request.getContentType();
        if (contentType != null && contentType.startsWith("application/x-www-form-urlencoded")) {
            InputStream payload = request.getMessagePayload();
            out.putAll(OAuth.decodeForm(payload), true);
        }
    }

    protected void collectQueryParameters(HttpRequest request, HttpParameters out) {
        String url = request.getRequestUrl();
        int q = url.indexOf(63);
        if (q >= 0) {
            out.putAll(OAuth.decodeForm(url.substring(q + 1)), true);
        }
    }

    protected String generateTimestamp() {
        return Long.toString(System.currentTimeMillis() / 1000L);
    }

    protected String generateNonce() {
        return Long.toString(new Random().nextLong());
    }
}

