/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import com.parse.Parse;
import com.parse.ParseInstallation;
import com.parse.ParseQuery;
import com.parse.ParseRESTCommand;
import com.parse.ParseRequest;
import com.parse.PointerEncodingStrategy;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class ParseRESTPushCommand
extends ParseRESTCommand {
    public ParseRESTPushCommand(String httpPath, ParseRequest.Method httpMethod, Map<String, ?> parameters, String sessionToken) {
        super(httpPath, httpMethod, parameters, sessionToken);
    }

    public static ParseRESTPushCommand sendPushCommand(ParseQuery<ParseInstallation> query, Set<String> targetChannels, String targetDeviceType, Long expirationTime, Long expirationInterval, JSONObject payload, String sessionToken) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (query != null) {
            ParseQuery.QueryConstraints where = query.getConstraints();
            JSONObject whereJSON = (JSONObject)Parse.encode(where, PointerEncodingStrategy.get());
            parameters.put("where", whereJSON);
        } else if (targetChannels != null) {
            parameters.put("channels", new JSONArray(targetChannels));
        }
        if (targetDeviceType != null) {
            JSONObject deviceTypeCondition = new JSONObject();
            try {
                deviceTypeCondition.put("deviceType", (Object)targetDeviceType);
            }
            catch (JSONException e) {
                throw new RuntimeException(e.getMessage());
            }
            parameters.put("where", deviceTypeCondition);
        }
        if (parameters.size() == 0) {
            parameters.put("where", new JSONObject());
        }
        if (expirationTime != null) {
            parameters.put("expiration_time", expirationTime);
        } else if (expirationInterval != null) {
            parameters.put("expiration_interval", expirationInterval);
        }
        if (payload != null) {
            parameters.put("data", payload);
        }
        return new ParseRESTPushCommand("push", ParseRequest.Method.POST, parameters, sessionToken);
    }
}

