/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.util.SparseArray;
import bolts.Task;
import com.parse.EventuallyPin;
import com.parse.ParseCommand;
import com.parse.ParseNetworkCommand;
import com.parse.ParseObject;
import com.parse.ParseOperationSet;
import com.parse.ParseRESTCommand;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.json.JSONException;
import org.json.JSONObject;

abstract class ParseEventuallyQueue {
    private boolean isConnected;
    private TestHelper testHelper;

    ParseEventuallyQueue() {
    }

    public abstract void onDestroy();

    public void setConnected(boolean connected) {
        this.isConnected = connected;
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public abstract int pendingCount();

    public void setTimeoutRetryWaitSeconds(double seconds) {
    }

    public void setMaxCacheSizeBytes(int bytes) {
    }

    public TestHelper getTestHelper() {
        if (this.testHelper == null) {
            this.testHelper = new TestHelper();
        }
        return this.testHelper;
    }

    protected void notifyTestHelper(int event) {
        this.notifyTestHelper(event, null);
    }

    protected void notifyTestHelper(int event, Throwable t) {
        if (this.testHelper != null) {
            this.testHelper.notify(event, t);
        }
    }

    public abstract void pause();

    public abstract void resume();

    public abstract Task<Object> enqueueEventuallyAsync(ParseNetworkCommand var1, ParseObject var2);

    protected ParseNetworkCommand<JSONObject, Object> commandFromJSON(JSONObject json) throws JSONException {
        ParseNetworkCommand command;
        if (ParseRESTCommand.isValidCommandJSONObject(json)) {
            command = ParseRESTCommand.fromJSONObject(json);
        } else if (ParseCommand.isValidCommandJSONObject(json)) {
            command = new ParseCommand(json);
        } else {
            throw new JSONException("Failed to load command from JSON.");
        }
        return command;
    }

    Task<Object> waitForOperationSetAndEventuallyPin(ParseOperationSet operationSet, EventuallyPin eventuallyPin) {
        return Task.forResult(null);
    }

    abstract void simulateReboot();

    public abstract void clear();

    void fakeObjectUpdate() {
        if (this.testHelper != null) {
            this.testHelper.notify(3);
            this.testHelper.notify(1);
            this.testHelper.notify(5);
        }
    }

    public static class TestHelper {
        private static final int MAX_EVENTS = 1000;
        public static final int COMMAND_SUCCESSFUL = 1;
        public static final int COMMAND_FAILED = 2;
        public static final int COMMAND_ENQUEUED = 3;
        public static final int COMMAND_NOT_ENQUEUED = 4;
        public static final int OBJECT_UPDATED = 5;
        public static final int OBJECT_REMOVED = 6;
        public static final int NETWORK_DOWN = 7;
        private SparseArray<Semaphore> events = new SparseArray();

        public static String getEventString(int event) {
            switch (event) {
                case 1: {
                    return "COMMAND_SUCCESSFUL";
                }
                case 2: {
                    return "COMMAND_FAILED";
                }
                case 3: {
                    return "COMMAND_ENQUEUED";
                }
                case 4: {
                    return "COMMAND_NOT_ENQUEUED";
                }
                case 5: {
                    return "OBJECT_UPDATED";
                }
                case 6: {
                    return "OBJECT_REMOVED";
                }
                case 7: {
                    return "NETWORK_DOWN";
                }
            }
            throw new IllegalStateException("Encountered unknown event: " + event);
        }

        private TestHelper() {
            this.clear();
        }

        public void clear() {
            this.events.clear();
            this.events.put(1, (Object)new Semaphore(1000));
            this.events.put(2, (Object)new Semaphore(1000));
            this.events.put(3, (Object)new Semaphore(1000));
            this.events.put(4, (Object)new Semaphore(1000));
            this.events.put(5, (Object)new Semaphore(1000));
            this.events.put(6, (Object)new Semaphore(1000));
            this.events.put(7, (Object)new Semaphore(1000));
            for (int i = 0; i < this.events.size(); ++i) {
                int event = this.events.keyAt(i);
                ((Semaphore)this.events.get(event)).acquireUninterruptibly(1000);
            }
        }

        public int unexpectedEvents() {
            int sum = 0;
            for (int i = 0; i < this.events.size(); ++i) {
                int event = this.events.keyAt(i);
                sum += ((Semaphore)this.events.get(event)).availablePermits();
            }
            return sum;
        }

        public List<String> getUnexpectedEvents() {
            ArrayList<String> unexpectedEvents = new ArrayList<String>();
            for (int i = 0; i < this.events.size(); ++i) {
                int event = this.events.keyAt(i);
                if (((Semaphore)this.events.get(event)).availablePermits() <= 0) continue;
                unexpectedEvents.add(TestHelper.getEventString(event));
            }
            return unexpectedEvents;
        }

        public void notify(int event) {
            this.notify(event, null);
        }

        public void notify(int event, Throwable t) {
            ((Semaphore)this.events.get(event)).release();
        }

        public boolean waitFor(int event) {
            return this.waitFor(event, 1);
        }

        public boolean waitFor(int event, int permits) {
            try {
                return ((Semaphore)this.events.get(event)).tryAcquire(permits, 120L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return false;
            }
        }
    }
}

