/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import com.parse.ParseException;
import com.parse.ParseRESTCommand;
import com.parse.ParseRequest;
import com.parse.ProgressCallback;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpResponse;
import org.json.JSONException;
import org.json.JSONObject;

class ParseRESTUserCommand
extends ParseRESTCommand {
    private int statusCode;

    private ParseRESTUserCommand(String httpPath, ParseRequest.Method httpMethod, Map<String, ?> parameters, String sessionToken) {
        super(httpPath, httpMethod, parameters, sessionToken);
    }

    private ParseRESTUserCommand(String httpPath, ParseRequest.Method httpMethod, JSONObject parameters, String sessionToken) {
        super(httpPath, httpMethod, parameters, sessionToken);
    }

    public static ParseRESTUserCommand getCurrentUserCommand(String sessionToken) {
        return new ParseRESTUserCommand("users/me", ParseRequest.Method.GET, (Map)null, sessionToken);
    }

    public static ParseRESTUserCommand logInUserCommand(String username, String password) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("username", username);
        parameters.put("password", password);
        return new ParseRESTUserCommand("login", ParseRequest.Method.GET, parameters, null);
    }

    public static ParseRESTUserCommand serviceLogInUserCommand(String authType, JSONObject authData) throws JSONException {
        JSONObject authenticationData = new JSONObject();
        authenticationData.put(authType, (Object)authData);
        JSONObject parameters = new JSONObject();
        parameters.put("authData", (Object)authenticationData);
        return ParseRESTUserCommand.serviceLogInUserCommand(parameters, null);
    }

    public static ParseRESTUserCommand serviceLogInUserCommand(JSONObject parameters, String sessionToken) {
        return new ParseRESTUserCommand("users", ParseRequest.Method.POST, parameters, sessionToken);
    }

    public static ParseRESTUserCommand resetUserPasswordCommand(String email) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("email", email);
        return new ParseRESTUserCommand("requestPasswordReset", ParseRequest.Method.POST, parameters, null);
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    protected JSONObject onResponse(HttpResponse response, ProgressCallback progressCallback) throws IOException, ParseException {
        this.statusCode = response.getStatusLine().getStatusCode();
        return super.onResponse(response, progressCallback);
    }
}

