/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.net.http.AndroidHttpClient;
import android.os.Build;
import bolts.Continuation;
import bolts.Task;
import com.parse.LocalIdManager;
import com.parse.ManifestInfo;
import com.parse.NoObjectsEncodingStrategy;
import com.parse.Parse;
import com.parse.ParseException;
import com.parse.ParseIOUtils;
import com.parse.ParseInstallation;
import com.parse.ParseNetworkCommand;
import com.parse.ParseObject;
import com.parse.ParseRequest;
import com.parse.ProgressCallback;
import com.parse.codec.digest.DigestUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONStringer;

class ParseRESTCommand
extends ParseNetworkCommand<JSONObject, Object> {
    private static final String HEADER_APPLICATION_ID = "X-Parse-Application-Id";
    private static final String HEADER_CLIENT_KEY = "X-Parse-Client-Key";
    private static final String HEADER_CLIENT_VERSION = "X-Parse-Client-Version";
    private static final String HEADER_INSTALLATION_ID = "X-Parse-Installation-Id";
    private static final String HEADER_APP_BUILD_VERSION = "X-Parse-App-Build-Version";
    private static final String HEADER_APP_DISPLAY_VERSION = "X-Parse-App-Display-Version";
    private static final String HEADER_OS_VERSION = "X-Parse-OS-Version";
    private static final String HEADER_SESSION_TOKEN = "X-Parse-Session-Token";
    private static final String HEADER_MASTER_KEY = "X-Parse-Master-Key";
    private static final String PARAMETER_METHOD_OVERRIDE = "_method";
    protected String httpPath;
    protected final JSONObject jsonParameters;
    protected final String sessionToken;
    private String installationId;
    private String operationSetUUID;
    private String localId;
    public String masterKey;

    public ParseRESTCommand(String httpPath, ParseRequest.Method httpMethod, Map<String, ?> parameters, String sessionToken) {
        super(httpMethod, ParseRESTCommand.createUrl(httpPath));
        this.httpPath = httpPath;
        this.jsonParameters = parameters != null ? (JSONObject)Parse.encode(parameters, NoObjectsEncodingStrategy.get()) : null;
        this.sessionToken = sessionToken;
    }

    protected ParseRESTCommand(String httpPath, ParseRequest.Method httpMethod, JSONObject jsonParameters, String sessionToken) {
        this(httpPath, httpMethod, jsonParameters, null, sessionToken);
    }

    private ParseRESTCommand(String httpPath, ParseRequest.Method httpMethod, JSONObject jsonParameters, String localId, String sessionToken) {
        super(httpMethod, ParseRESTCommand.createUrl(httpPath));
        this.httpPath = httpPath;
        this.jsonParameters = jsonParameters;
        this.localId = localId;
        this.sessionToken = sessionToken;
    }

    public static ParseRESTCommand fromJSONObject(JSONObject jsonObject) {
        String httpPath = jsonObject.optString("httpPath");
        ParseRequest.Method httpMethod = ParseRequest.Method.fromString(jsonObject.optString("httpMethod"));
        String sessionToken = jsonObject.optString("sessionToken", null);
        String localId = jsonObject.optString("localId", null);
        JSONObject jsonParameters = jsonObject.optJSONObject("parameters");
        return new ParseRESTCommand(httpPath, httpMethod, jsonParameters, localId, sessionToken);
    }

    void enableRetrying() {
        this.maxRetries = 4;
    }

    private static String createUrl(String httpPath) {
        return String.format("%s/1/%s", ParseObject.server, httpPath);
    }

    private static void addDefaultHeaders(HttpUriRequest request) {
        request.addHeader(HEADER_APPLICATION_ID, Parse.applicationId);
        request.addHeader(HEADER_CLIENT_KEY, Parse.clientKey);
        request.addHeader(HEADER_CLIENT_VERSION, "a1.8.3");
        request.addHeader(HEADER_APP_BUILD_VERSION, String.valueOf(ManifestInfo.getVersionCode()));
        request.addHeader(HEADER_APP_DISPLAY_VERSION, ManifestInfo.getVersionName());
        request.addHeader(HEADER_OS_VERSION, Build.VERSION.RELEASE);
    }

    @Override
    protected HttpUriRequest newRequest(ParseRequest.Method method, ProgressCallback uploadProgressCallback) throws ParseException {
        HttpUriRequest request = this.jsonParameters != null && method != ParseRequest.Method.POST && method != ParseRequest.Method.PUT ? super.newRequest(ParseRequest.Method.POST, uploadProgressCallback) : super.newRequest(method, uploadProgressCallback);
        ParseRESTCommand.addDefaultHeaders(request);
        request.addHeader(HEADER_INSTALLATION_ID, this.installationId);
        if (this.sessionToken != null) {
            request.addHeader(HEADER_SESSION_TOKEN, this.sessionToken);
        }
        if (this.masterKey != null) {
            request.addHeader(HEADER_MASTER_KEY, this.masterKey);
        }
        return request;
    }

    @Override
    protected HttpEntity newEntity(ProgressCallback uploadProgressCallback) {
        if (this.jsonParameters == null) {
            String message = String.format("Trying to execute a %s command without body parameters.", this.method.toString());
            throw new IllegalArgumentException(message);
        }
        try {
            JSONObject parameters = this.jsonParameters;
            if (this.method == ParseRequest.Method.GET || this.method == ParseRequest.Method.DELETE) {
                parameters = new JSONObject(this.jsonParameters.toString());
                parameters.put(PARAMETER_METHOD_OVERRIDE, (Object)this.method.toString());
            }
            StringEntity entity = new StringEntity(parameters.toString(), "UTF8");
            entity.setContentType("application/json");
            return entity;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    protected Task<Void> onPreExecute(Task<Void> task) {
        Parse.checkInit();
        this.resolveLocalIds();
        return task.onSuccessTask((Continuation)new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> task) throws Exception {
                ParseRESTCommand.this.installationId = ParseInstallation.getOrCreateCurrentInstallationId();
                return task;
            }
        }, (Executor)Task.BACKGROUND_EXECUTOR);
    }

    @Override
    protected JSONObject onResponse(HttpResponse response, ProgressCallback downloadProgressCallback) throws IOException, ParseException {
        JSONObject json;
        InputStream inputStream = null;
        try {
            inputStream = AndroidHttpClient.getUngzippedContent((HttpEntity)response.getEntity());
            String content = new String(ParseIOUtils.toByteArray(inputStream));
            json = new JSONObject(content);
        }
        catch (JSONException e) {
            throw this.connectionFailed("bad json response", (Exception)((Object)e));
        }
        finally {
            ParseIOUtils.closeQuietly(inputStream);
        }
        return json;
    }

    @Override
    protected Task<Object> onPostExecute(Task<JSONObject> task) {
        JSONObject result;
        JSONObject json = (JSONObject)task.getResult();
        try {
            if (json.has("error")) {
                return Task.forError((Exception)new ParseException(json.getInt("code"), json.getString("error")));
            }
            result = json;
        }
        catch (JSONException e) {
            return Task.forError((Exception)this.connectionFailed("corrupted json", (Exception)((Object)e)));
        }
        return Task.forResult((Object)result);
    }

    public String getCacheKey() {
        String json;
        if (this.jsonParameters != null) {
            try {
                json = ParseRESTCommand.toDeterministicString(this.jsonParameters);
            }
            catch (JSONException e) {
                throw new RuntimeException(e.getMessage());
            }
        } else {
            json = "";
        }
        if (this.sessionToken != null) {
            json = json + this.sessionToken;
        }
        return String.format("ParseRESTCommand.%s.%s.%s", this.method.toString(), DigestUtils.md5Hex(this.httpPath), DigestUtils.md5Hex(json));
    }

    private static String toDeterministicString(Object o) throws JSONException {
        JSONStringer stringer = new JSONStringer();
        ParseRESTCommand.addToStringer(stringer, o);
        return stringer.toString();
    }

    private static void addToStringer(JSONStringer stringer, Object o) throws JSONException {
        if (o instanceof JSONObject) {
            stringer.object();
            JSONObject object = (JSONObject)o;
            Iterator keyIterator = object.keys();
            ArrayList keys = new ArrayList();
            while (keyIterator.hasNext()) {
                keys.add(keyIterator.next());
            }
            Collections.sort(keys);
            for (String key : keys) {
                stringer.key(key);
                ParseRESTCommand.addToStringer(stringer, object.opt(key));
            }
            stringer.endObject();
            return;
        }
        if (o instanceof JSONArray) {
            JSONArray array = (JSONArray)o;
            stringer.array();
            for (int i = 0; i < array.length(); ++i) {
                ParseRESTCommand.addToStringer(stringer, array.get(i));
            }
            stringer.endArray();
            return;
        }
        stringer.value(o);
    }

    static boolean isValidCommandJSONObject(JSONObject jsonObject) {
        return jsonObject.has("httpPath");
    }

    @Override
    public JSONObject toJSONObject() {
        JSONObject jsonObject = new JSONObject();
        try {
            if (this.httpPath != null) {
                jsonObject.put("httpPath", (Object)this.httpPath);
            }
            jsonObject.put("httpMethod", (Object)this.method.toString());
            if (this.jsonParameters != null) {
                jsonObject.put("parameters", (Object)this.jsonParameters);
            }
            if (this.sessionToken != null) {
                jsonObject.put("sessionToken", (Object)this.sessionToken);
            }
            if (this.localId != null) {
                jsonObject.put("localId", (Object)this.localId);
            }
        }
        catch (JSONException e) {
            throw new RuntimeException(e.getMessage());
        }
        return jsonObject;
    }

    @Override
    public String getSessionToken() {
        return this.sessionToken;
    }

    @Override
    public String getOperationSetUUID() {
        return this.operationSetUUID;
    }

    @Override
    void setOperationSetUUID(String operationSetUUID) {
        this.operationSetUUID = operationSetUUID;
    }

    @Override
    public void setLocalId(String localId) {
        this.localId = localId;
    }

    @Override
    public String getLocalId() {
        return this.localId;
    }

    private void maybeChangeServerOperation() throws JSONException {
        String objectId;
        if (this.localId != null && (objectId = LocalIdManager.getDefaultInstance().getObjectId(this.localId)) != null) {
            this.localId = null;
            this.httpPath = this.httpPath + String.format("/%s", objectId);
            this.url = ParseRESTCommand.createUrl(this.httpPath);
            if (this.httpPath.startsWith("classes") && this.method == ParseRequest.Method.POST) {
                this.method = ParseRequest.Method.PUT;
            }
        }
    }

    public void resolveLocalIds() {
        try {
            ArrayList<JSONObject> localPointers = new ArrayList<JSONObject>();
            ParseRESTCommand.getLocalPointersIn(this.jsonParameters, localPointers);
            for (JSONObject pointer : localPointers) {
                String localId = (String)pointer.get("localId");
                String objectId = LocalIdManager.getDefaultInstance().getObjectId(localId);
                if (objectId == null) {
                    throw new IllegalStateException("Tried to serialize a command referencing a new, unsaved object.");
                }
                pointer.put("objectId", (Object)objectId);
                pointer.remove("localId");
            }
            this.maybeChangeServerOperation();
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    @Override
    public void retainLocalIds() {
        if (this.localId != null) {
            LocalIdManager.getDefaultInstance().retainLocalIdOnDisk(this.localId);
        }
        try {
            ArrayList<JSONObject> localPointers = new ArrayList<JSONObject>();
            ParseRESTCommand.getLocalPointersIn(this.jsonParameters, localPointers);
            for (JSONObject pointer : localPointers) {
                String localId = (String)pointer.get("localId");
                LocalIdManager.getDefaultInstance().retainLocalIdOnDisk(localId);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    @Override
    public void releaseLocalIds() {
        if (this.localId != null) {
            LocalIdManager.getDefaultInstance().releaseLocalIdOnDisk(this.localId);
        }
        try {
            ArrayList<JSONObject> localPointers = new ArrayList<JSONObject>();
            ParseRESTCommand.getLocalPointersIn(this.jsonParameters, localPointers);
            for (JSONObject pointer : localPointers) {
                String localId = (String)pointer.get("localId");
                LocalIdManager.getDefaultInstance().releaseLocalIdOnDisk(localId);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }
}

