/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.net.http.AndroidHttpClient;
import bolts.Task;
import com.parse.CountingMultipartEntity;
import com.parse.Parse;
import com.parse.ParseCallback2;
import com.parse.ParseException;
import com.parse.ParseRequest;
import com.parse.ProgressCallback;
import com.parse.entity.mime.HttpMultipartMode;
import com.parse.entity.mime.content.ByteArrayBody;
import com.parse.entity.mime.content.StringBody;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.json.JSONException;
import org.json.JSONObject;

class ParseAWSRequest
extends ParseRequest<byte[], byte[]> {
    private String mimeType;
    private JSONObject postParams;
    private byte[] data;

    public ParseAWSRequest(String url) {
        super(url);
    }

    public ParseAWSRequest(ParseRequest.Method method, String url) {
        super(method, url);
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public void setPostParams(JSONObject postParams) {
        this.postParams = postParams;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    @Override
    protected HttpEntity newEntity(ProgressCallback uploadProgressCallback) {
        CountingMultipartEntity entity = new CountingMultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE, uploadProgressCallback);
        try {
            entity.addPart("Content-Type", new StringBody(this.mimeType));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage());
        }
        Iterator keys = this.postParams.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            try {
                entity.addPart(key, new StringBody(this.postParams.getString(key)));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e.getMessage());
            }
            catch (JSONException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        entity.addPart("file", new ByteArrayBody(this.data, this.mimeType, "file"));
        return entity;
    }

    @Override
    protected byte[] onResponse(HttpResponse response, final ProgressCallback downloadProgressCallback) throws IOException, ParseException {
        int statusCode = response.getStatusLine().getStatusCode();
        if ((statusCode < 200 || statusCode >= 300) && statusCode != 304) {
            String action = this.method == ParseRequest.Method.GET ? "Download from" : "Upload to";
            throw new ParseException(100, String.format("%s S3 failed. %s", action, response.getStatusLine().getReasonPhrase()));
        }
        if (this.method == ParseRequest.Method.GET) {
            int nRead;
            int totalSize = -1;
            Header[] contentLengthHeader = response.getHeaders("Content-Length");
            if (contentLengthHeader.length > 0) {
                totalSize = Integer.parseInt(contentLengthHeader[0].getValue());
            }
            int downloadedSize = 0;
            InputStream responseStream = AndroidHttpClient.getUngzippedContent((HttpEntity)response.getEntity());
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[32768];
            ParseCallback2<Integer, ParseException> c = null;
            if (downloadProgressCallback != null) {
                c = new ParseCallback2<Integer, ParseException>(){
                    Integer maxProgressSoFar = 0;

                    @Override
                    public void done(Integer percentDone, ParseException e) {
                        if (percentDone > this.maxProgressSoFar) {
                            this.maxProgressSoFar = percentDone;
                            downloadProgressCallback.done(percentDone);
                        }
                    }
                };
            }
            while ((nRead = responseStream.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
                downloadedSize += nRead;
                if (c == null || totalSize == -1) continue;
                int progressToReport = Math.round((float)downloadedSize / (float)totalSize * 100.0f);
                Parse.callbackOnMainThreadAsync(Task.forResult((Object)progressToReport), c);
            }
            return buffer.toByteArray();
        }
        return null;
    }
}

