/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.widget.ImageView;
import bolts.Continuation;
import bolts.Task;
import com.parse.GetDataCallback;
import com.parse.Parse;
import com.parse.ParseFile;

public class ParseImageView
extends ImageView {
    private ParseFile file;
    private Drawable placeholder;
    private boolean isLoaded = false;

    public ParseImageView(Context context) {
        super(context);
    }

    public ParseImageView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    public ParseImageView(Context context, AttributeSet attributeSet, int defStyle) {
        super(context, attributeSet, defStyle);
    }

    protected void onDetachedFromWindow() {
        if (this.file != null) {
            this.file.cancel();
        }
    }

    public void setImageBitmap(Bitmap bitmap) {
        super.setImageBitmap(bitmap);
        this.isLoaded = true;
    }

    public void setPlaceholder(Drawable placeholder) {
        this.placeholder = placeholder;
        if (!this.isLoaded) {
            this.setImageDrawable(this.placeholder);
        }
    }

    public void setParseFile(ParseFile file) {
        if (this.file != null) {
            this.file.cancel();
        }
        this.isLoaded = false;
        this.file = file;
        this.setImageDrawable(this.placeholder);
    }

    public Task<byte[]> loadInBackground() {
        if (this.file == null) {
            return Task.forResult(null);
        }
        final ParseFile loadingFile = this.file;
        return this.file.getDataInBackground().onSuccessTask((Continuation)new Continuation<byte[], Task<byte[]>>(){

            public Task<byte[]> then(Task<byte[]> task) throws Exception {
                Bitmap bitmap;
                byte[] data = (byte[])task.getResult();
                if (ParseImageView.this.file != loadingFile) {
                    return Task.cancelled();
                }
                if (data != null && (bitmap = BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length)) != null) {
                    ParseImageView.this.setImageBitmap(bitmap);
                }
                return task;
            }
        }, Task.UI_THREAD_EXECUTOR);
    }

    public void loadInBackground(GetDataCallback completionCallback) {
        Parse.callbackOnMainThreadAsync(this.loadInBackground(), completionCallback, true);
    }
}

