/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import bolts.Task;
import com.parse.Parse;
import com.parse.ProgressCallback;
import com.parse.entity.mime.HttpMultipartMode;
import com.parse.entity.mime.MultipartEntity;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;

class CountingMultipartEntity
extends MultipartEntity {
    private final ProgressCallback progressCallback;

    public CountingMultipartEntity(ProgressCallback progressCallback) {
        this.progressCallback = progressCallback;
    }

    public CountingMultipartEntity(HttpMultipartMode mode, ProgressCallback progressCallback) {
        super(mode);
        this.progressCallback = progressCallback;
    }

    public CountingMultipartEntity(HttpMultipartMode mode, String boundary, Charset charset, ProgressCallback progressCallback) {
        super(mode, boundary, charset);
        this.progressCallback = progressCallback;
    }

    @Override
    public void writeTo(OutputStream outstream) throws IOException {
        super.writeTo(new CountingOutputStream(outstream, this.progressCallback, this.getContentLength()));
    }

    public static class CountingOutputStream
    extends FilterOutputStream {
        private final ProgressCallback progressCallback;
        private long uploadedSize;
        private long totalSize;
        private boolean hasReportedDone = false;

        public CountingOutputStream(OutputStream out, ProgressCallback progressCallback, long totalSize) {
            super(out);
            this.progressCallback = progressCallback;
            this.totalSize = totalSize;
            this.uploadedSize = 0L;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
            this.uploadedSize += (long)len;
            this.notifyCallback();
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
            ++this.uploadedSize;
            this.notifyCallback();
        }

        private void notifyCallback() {
            if (this.hasReportedDone) {
                return;
            }
            int progressToReport = Math.round((float)this.uploadedSize / (float)this.totalSize * 100.0f);
            Parse.callbackOnMainThreadAsync(Task.forResult((Object)progressToReport), this.progressCallback);
            if (progressToReport == 100) {
                this.hasReportedDone = true;
            }
        }
    }
}

