/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.content.Intent;
import bolts.Task;
import com.parse.NoObjectsEncodingStrategy;
import com.parse.Parse;
import com.parse.ParseCommand;
import com.parse.ParseUser;
import com.parse.SaveCallback;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class ParseAnalytics {
    private static final String TAG = "com.parse.ParseAnalytics";
    private static final String OP = "client_events";
    private static final String APP_OPENED = "AppOpened";
    static Map<String, Boolean> lruSeenPushes = new LinkedHashMap<String, Boolean>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Boolean> eldest) {
            return this.size() > 10;
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Task<Void> trackAppOpenedInBackground(Intent intent) {
        ParseCommand command;
        block8: {
            String pushData = null;
            if (intent != null && intent.getExtras() != null) {
                pushData = intent.getExtras().getString("com.parse.Data");
            }
            command = ParseAnalytics.createCommand(APP_OPENED);
            if (pushData != null) {
                try {
                    JSONObject payload = new JSONObject(pushData);
                    String pushHash = payload.optString("push_hash");
                    if (pushHash.length() <= 0) break block8;
                    Map<String, Boolean> map = lruSeenPushes;
                    synchronized (map) {
                        if (lruSeenPushes.containsKey(pushHash)) {
                            return Task.forResult(null);
                        }
                        lruSeenPushes.put(pushHash, true);
                        command.put("push_hash", pushHash);
                    }
                }
                catch (JSONException e) {
                    Parse.logE(TAG, "Failed to parse push data: " + e.getMessage());
                }
            }
        }
        Task<Object> eventuallyTask = Parse.getEventuallyQueue().enqueueEventuallyAsync(command, null);
        return eventuallyTask.makeVoid();
    }

    @Deprecated
    public static void trackAppOpened(Intent intent) {
        ParseAnalytics.trackAppOpenedInBackground(intent);
    }

    public static void trackAppOpenedInBackground(Intent intent, SaveCallback callback) {
        Parse.callbackOnMainThreadAsync(ParseAnalytics.trackAppOpenedInBackground(intent), callback);
    }

    @Deprecated
    public static void trackEvent(String name) {
        ParseAnalytics.trackEventInBackground(name);
    }

    public static void trackEventInBackground(String name, SaveCallback callback) {
        Parse.callbackOnMainThreadAsync(ParseAnalytics.trackEventInBackground(name), callback);
    }

    @Deprecated
    public static void trackEvent(String name, Map<String, String> dimensions) {
        ParseAnalytics.trackEventInBackground(name, dimensions);
    }

    public static void trackEventInBackground(String name, Map<String, String> dimensions, SaveCallback callback) {
        Parse.callbackOnMainThreadAsync(ParseAnalytics.trackEventInBackground(name, dimensions), callback);
    }

    public static Task<Void> trackEventInBackground(String name) {
        return ParseAnalytics.trackEventInBackground(name, (Map<String, String>)null);
    }

    public static Task<Void> trackEventInBackground(String name, Map<String, String> dimensions) {
        if (name == null || name.trim().length() == 0) {
            throw new RuntimeException("A name for the custom event must be provided.");
        }
        ParseCommand command = ParseAnalytics.createCommand(name);
        if (dimensions != null) {
            JSONObject jsonDimensions = (JSONObject)Parse.encode(dimensions, NoObjectsEncodingStrategy.get());
            command.put("dimensions", jsonDimensions);
        }
        Task<Object> eventuallyTask = Parse.getEventuallyQueue().enqueueEventuallyAsync(command, null);
        return eventuallyTask.makeVoid();
    }

    static ParseCommand createCommand(String eventName) {
        ParseCommand command = new ParseCommand(OP, ParseUser.getCurrentSessionToken());
        command.put("at", Parse.encodeDate(new Date()));
        command.put("name", eventName);
        return command;
    }
}

