/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import bolts.Task;
import com.facebook.Session;
import com.facebook.android.Facebook;
import com.parse.FacebookAuthenticationProvider;
import com.parse.LogInCallback;
import com.parse.ManifestInfo;
import com.parse.Parse;
import com.parse.ParseAuthenticationProvider;
import com.parse.ParseException;
import com.parse.ParseUser;
import com.parse.SaveCallback;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import org.json.JSONException;
import org.json.JSONObject;

public final class ParseFacebookUtils {
    protected static FacebookAuthenticationProvider provider;
    private static boolean isInitialized;

    @Deprecated
    public static Facebook getFacebook() {
        if (provider == null) {
            throw new IllegalStateException("You must initialize ParseFacebookUtils before calling getFacebook()");
        }
        return provider.getFacebook();
    }

    public static Session getSession() {
        if (provider == null) {
            throw new IllegalStateException("You must initialize ParseFacebookUtils before calling getSession()");
        }
        return provider.getSession();
    }

    public static boolean isLinked(ParseUser user) {
        return user.getLinkedServiceNames().contains("facebook");
    }

    protected static void initialize() {
        String applicationId = null;
        Bundle metaData = ManifestInfo.getApplicationMetadata();
        if (metaData != null) {
            applicationId = metaData.getString("com.facebook.sdk.ApplicationId");
        }
        ParseFacebookUtils.initialize(applicationId);
    }

    public static void initialize(String appId) {
        if (Parse.applicationContext == null) {
            throw new IllegalStateException("You must call Parse.initialize() before using ParseFacebookUtils");
        }
        provider = new FacebookAuthenticationProvider(Parse.applicationContext, appId);
        ParseUser.registerAuthenticationProvider(provider);
        isInitialized = true;
    }

    private static void checkInitialization() {
        if (!isInitialized) {
            ParseFacebookUtils.initialize();
        }
    }

    public static void unlink(ParseUser user) throws ParseException {
        Parse.waitForTask(ParseFacebookUtils.unlinkInBackground(user));
    }

    public static Task<Void> unlinkInBackground(ParseUser user) {
        ParseFacebookUtils.checkInitialization();
        return user.unlinkFromAsync("facebook");
    }

    public static void unlinkInBackground(ParseUser user, SaveCallback callback) {
        Parse.callbackOnMainThreadAsync(ParseFacebookUtils.unlinkInBackground(user), callback);
    }

    public static Task<Void> linkInBackground(ParseUser user, String facebookId, String accessToken, Date expirationDate) {
        ParseFacebookUtils.checkInitialization();
        try {
            return user.linkWithAsync(provider.getAuthType(), provider.getAuthData(facebookId, accessToken, expirationDate));
        }
        catch (JSONException e) {
            return Task.forError((Exception)new ParseException(e));
        }
    }

    @Deprecated
    public static void link(ParseUser user, String facebookId, String accessToken, Date expirationDate) {
        ParseFacebookUtils.linkInBackground(user, facebookId, accessToken, expirationDate);
    }

    public static void link(ParseUser user, String facebookId, String accessToken, Date expirationDate, SaveCallback callback) {
        Parse.callbackOnMainThreadAsync(ParseFacebookUtils.linkInBackground(user, facebookId, accessToken, expirationDate), callback);
    }

    public static Task<Void> linkInBackground(ParseUser user, Collection<String> permissions, Activity activity, int activityCode) {
        ParseFacebookUtils.checkInitialization();
        provider.setActivity(activity);
        provider.setActivityCode(activityCode);
        if (permissions == null) {
            permissions = Collections.emptyList();
        }
        provider.setPermissions(permissions);
        return user.linkWithAsync(provider.getAuthType());
    }

    public static Task<Void> linkInBackground(ParseUser user, Collection<String> permissions, Activity activity) {
        return ParseFacebookUtils.linkInBackground(user, permissions, activity, 32665);
    }

    public static Task<Void> linkInBackground(ParseUser user, Activity activity, int activityCode) {
        return ParseFacebookUtils.linkInBackground(user, Collections.<String>emptyList(), activity, activityCode);
    }

    public static Task<Void> linkInBackground(ParseUser user, Activity activity) {
        return ParseFacebookUtils.linkInBackground(user, Collections.<String>emptyList(), activity, 32665);
    }

    public static void link(ParseUser user, Collection<String> permissions, Activity activity, int activityCode, SaveCallback callback) {
        Parse.callbackOnMainThreadAsync(ParseFacebookUtils.linkInBackground(user, permissions, activity, activityCode), callback, true);
    }

    public static void link(ParseUser user, Collection<String> permissions, Activity activity, SaveCallback callback) {
        ParseFacebookUtils.link(user, permissions, activity, 32665, callback);
    }

    @Deprecated
    public static void link(ParseUser user, Collection<String> permissions, Activity activity, int activityCode) {
        ParseFacebookUtils.linkInBackground(user, permissions, activity, activityCode);
    }

    @Deprecated
    public static void link(ParseUser user, Collection<String> permissions, Activity activity) {
        ParseFacebookUtils.linkInBackground(user, permissions, activity);
    }

    public static void link(ParseUser user, Activity activity, int activityCode, SaveCallback callback) {
        ParseFacebookUtils.link(user, Collections.<String>emptyList(), activity, activityCode, callback);
    }

    public static void link(ParseUser user, Activity activity, SaveCallback callback) {
        ParseFacebookUtils.link(user, Collections.<String>emptyList(), activity, 32665, callback);
    }

    @Deprecated
    public static void link(ParseUser user, Activity activity, int activityCode) {
        ParseFacebookUtils.linkInBackground(user, activity, activityCode);
    }

    @Deprecated
    public static void link(ParseUser user, Activity activity) {
        ParseFacebookUtils.linkInBackground(user, activity);
    }

    public static Task<ParseUser> logInInBackground(String facebookId, String accessToken, Date expirationDate) {
        ParseFacebookUtils.checkInitialization();
        try {
            return ParseUser.logInWithAsync(provider.getAuthType(), provider.getAuthData(facebookId, accessToken, expirationDate));
        }
        catch (JSONException e) {
            return Task.forError((Exception)new ParseException(e));
        }
    }

    public static void logIn(String facebookId, String accessToken, Date expirationDate, LogInCallback callback) {
        Parse.callbackOnMainThreadAsync(ParseFacebookUtils.logInInBackground(facebookId, accessToken, expirationDate), callback);
    }

    public static Task<ParseUser> logInInBackground(Collection<String> permissions, Activity activity, int activityCode) {
        ParseFacebookUtils.checkInitialization();
        provider.setActivity(activity);
        provider.setActivityCode(activityCode);
        if (permissions == null) {
            permissions = Collections.emptyList();
        }
        provider.setPermissions(permissions);
        return ParseUser.logInWithAsync(provider.getAuthType());
    }

    public static void logIn(Collection<String> permissions, Activity activity, int activityCode, LogInCallback callback) {
        Parse.callbackOnMainThreadAsync(ParseFacebookUtils.logInInBackground(permissions, activity, activityCode), callback, true);
    }

    public static void logIn(Activity activity, int activityCode, LogInCallback callback) {
        Parse.callbackOnMainThreadAsync(ParseFacebookUtils.logInInBackground(Collections.<String>emptyList(), activity, activityCode), callback, true);
    }

    public static void logIn(Collection<String> permissions, Activity activity, LogInCallback callback) {
        Parse.callbackOnMainThreadAsync(ParseFacebookUtils.logInInBackground(permissions, activity, 32665), callback, true);
    }

    public static void logIn(Activity activity, LogInCallback callback) {
        Parse.callbackOnMainThreadAsync(ParseFacebookUtils.logInInBackground(Collections.<String>emptyList(), activity, 32665), callback, true);
    }

    public static void finishAuthentication(int requestCode, int resultCode, Intent data) {
        if (provider != null) {
            provider.onActivityResult(requestCode, resultCode, data);
        }
    }

    public static Task<Void> saveLatestSessionDataInBackground(ParseUser user) {
        ParseFacebookUtils.checkInitialization();
        if (!ParseFacebookUtils.isLinked(user)) {
            throw new IllegalStateException("The user must already be linked to Facebook.");
        }
        Session session = ParseFacebookUtils.getSession();
        return ParseFacebookUtils.linkInBackground(user, provider.getUserId(), session.getAccessToken(), session.getExpirationDate());
    }

    public static void saveLatestSessionData(ParseUser user, SaveCallback callback) {
        Parse.callbackOnMainThreadAsync(ParseFacebookUtils.saveLatestSessionDataInBackground(user), callback);
    }

    @Deprecated
    public static void saveLatestSessionData(ParseUser user) {
        ParseFacebookUtils.saveLatestSessionDataInBackground(user);
    }

    @Deprecated
    public static boolean shouldExtendAccessToken(ParseUser user) {
        return user != null && ParseFacebookUtils.isLinked(user) && ParseFacebookUtils.getFacebook().shouldExtendAccessToken();
    }

    @Deprecated
    public static void extendAccessToken(final ParseUser user, Context context, final SaveCallback callback) {
        ParseFacebookUtils.checkInitialization();
        provider.extendAccessToken(context, new ParseAuthenticationProvider.ParseAuthenticationCallback(){

            @Override
            public void onSuccess(JSONObject authData) {
                Parse.callbackOnMainThreadAsync(user.linkWithAsync(provider.getAuthType(), authData), callback, true);
            }

            @Override
            public void onError(Throwable error) {
                if (callback != null) {
                    callback.internalDone(null, new ParseException(error));
                }
            }

            @Override
            public void onCancel() {
                if (callback != null) {
                    callback.internalDone(null, null);
                }
            }
        });
    }

    @Deprecated
    public static boolean extendAccessTokenIfNeeded(ParseUser user, Context context, SaveCallback callback) {
        if (ParseFacebookUtils.shouldExtendAccessToken(user)) {
            ParseFacebookUtils.extendAccessToken(user, context, callback);
            return true;
        }
        return false;
    }

    private ParseFacebookUtils() {
    }

    public static final class Permissions {
        private Permissions() {
        }

        public static final class Page {
            public static final String MANAGE_PAGES = "manage_pages";

            private Page() {
            }
        }

        public static final class Extended {
            public static final String READ_FRIEND_LISTS = "read_friendlists";
            public static final String READ_INSIGHTS = "read_insights";
            public static final String READ_MAILBOX = "read_mailbox";
            public static final String READ_REQUESTS = "read_requests";
            public static final String READ_STREAM = "read_stream";
            public static final String XMPP_LOGIN = "xmpp_login";
            public static final String ADS_MANAGEMENT = "ads_management";
            public static final String CREATE_EVENT = "create_event";
            public static final String MANAGE_FRIEND_LISTS = "manage_friendlists";
            public static final String MANAGE_NOTIFICATIONS = "manage_notifications";
            public static final String OFFLINE_ACCESS = "offline_access";
            public static final String PUBLISH_CHECKINS = "publish_checkins";
            public static final String PUBLISH_STREAM = "publish_stream";
            public static final String RSVP_EVENT = "rsvp_event";
            public static final String PUBLISH_ACTIONS = "publish_actions";

            private Extended() {
            }
        }

        public static final class Friends {
            public static final String ABOUT_ME = "friends_about_me";
            public static final String ACTIVITIES = "friends_activities";
            public static final String BIRTHDAY = "friends_birthday";
            public static final String CHECKINS = "friends_checkins";
            public static final String EDUCATION_HISTORY = "friends_education_history";
            public static final String EVENTS = "friends_events";
            public static final String GROUPS = "friends_groups";
            public static final String HOMETOWN = "friends_hometown";
            public static final String INTERESTS = "friends_interests";
            public static final String LIKES = "friends_likes";
            public static final String LOCATION = "friends_location";
            public static final String NOTES = "friends_notes";
            public static final String ONLINE_PRESENCE = "friends_online_presence";
            public static final String PHOTOS = "friends_photos";
            public static final String QUESTIONS = "friends_questions";
            public static final String RELATIONSHIPS = "friends_relationships";
            public static final String RELATIONSHIP_DETAILS = "friends_relationship_details";
            public static final String RELIGION_POLITICS = "friends_religion_politics";
            public static final String STATUS = "friends_status";
            public static final String VIDEOS = "friends_videos";
            public static final String WEBSITE = "friends_website";
            public static final String WORK_HISTORY = "friends_work_history";

            private Friends() {
            }
        }

        public static final class User {
            public static final String ABOUT_ME = "user_about_me";
            public static final String ACTIVITIES = "user_activities";
            public static final String BIRTHDAY = "user_birthday";
            public static final String CHECKINS = "user_checkins";
            public static final String EDUCATION_HISTORY = "user_education_history";
            public static final String EVENTS = "user_events";
            public static final String GROUPS = "user_groups";
            public static final String HOMETOWN = "user_hometown";
            public static final String INTERESTS = "user_interests";
            public static final String LIKES = "user_likes";
            public static final String LOCATION = "user_location";
            public static final String NOTES = "user_notes";
            public static final String ONLINE_PRESENCE = "user_online_presence";
            public static final String PHOTOS = "user_photos";
            public static final String QUESTIONS = "user_questions";
            public static final String RELATIONSHIPS = "user_relationships";
            public static final String RELATIONSHIP_DETAILS = "user_relationship_details";
            public static final String RELIGION_POLITICS = "user_religion_politics";
            public static final String STATUS = "user_status";
            public static final String VIDEOS = "user_videos";
            public static final String WEBSITE = "user_website";
            public static final String WORK_HISTORY = "user_work_history";
            public static final String EMAIL = "email";

            private User() {
            }
        }
    }
}

