/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import com.parse.Parse;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.PriorityQueue;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PushHistory {
    private static final String TAG = "com.parse.PushHistory";
    private final int maxHistoryLength;
    private final PriorityQueue<Entry> entries;
    private final HashSet<String> pushIds;
    private String cutoff;
    private String lastTime;

    public PushHistory(int maxHistoryLength, JSONObject json) {
        this.maxHistoryLength = maxHistoryLength;
        this.entries = new PriorityQueue(maxHistoryLength + 1);
        this.pushIds = new HashSet(maxHistoryLength + 1);
        this.cutoff = null;
        this.lastTime = null;
        if (json != null) {
            this.setCutoffTimestamp(json.optString("ignoreAfter", null));
            this.setLastReceivedTimestamp(json.optString("lastTime", null));
            JSONObject jsonHistory = json.optJSONObject("history");
            if (jsonHistory != null) {
                Iterator it = jsonHistory.keys();
                while (it.hasNext()) {
                    String pushId = (String)it.next();
                    String timestamp = jsonHistory.optString(pushId, null);
                    if (pushId == null || timestamp == null) continue;
                    this.tryInsertPush(pushId, timestamp);
                }
            }
        }
    }

    public JSONObject toJSON() throws JSONException {
        JSONObject json = new JSONObject();
        if (this.entries.size() > 0) {
            JSONObject history = new JSONObject();
            for (Entry e : this.entries) {
                history.put(e.pushId, (Object)e.timestamp);
            }
            json.put("history", (Object)history);
        }
        json.putOpt("ignoreAfter", (Object)this.cutoff);
        json.putOpt("lastTime", (Object)this.lastTime);
        return json;
    }

    public String getCutoffTimestamp() {
        return this.cutoff;
    }

    private void setCutoffTimestamp(String cutoff) {
        this.cutoff = cutoff;
    }

    public String getLastReceivedTimestamp() {
        return this.lastTime;
    }

    private void setLastReceivedTimestamp(String lastTime) {
        this.lastTime = lastTime;
    }

    public Set<String> getPushIds() {
        return Collections.unmodifiableSet(this.pushIds);
    }

    public boolean tryInsertPush(String pushId, String timestamp) {
        if (timestamp == null) {
            throw new IllegalArgumentException("Can't insert null pushId or timestamp into history");
        }
        if (this.lastTime == null || timestamp.compareTo(this.lastTime) > 0) {
            this.lastTime = timestamp;
        }
        if (this.cutoff != null && timestamp.compareTo(this.cutoff) <= 0) {
            Parse.logE(TAG, "Ignored old push " + pushId + " at " + timestamp + " before cutoff " + this.cutoff);
            return false;
        }
        if (pushId != null) {
            if (this.pushIds.contains(pushId)) {
                Parse.logE(TAG, "Ignored duplicate push " + pushId);
                return false;
            }
            this.entries.add(new Entry(pushId, timestamp));
            this.pushIds.add(pushId);
            while (this.entries.size() > this.maxHistoryLength) {
                Entry head = (Entry)this.entries.remove();
                this.pushIds.remove(head.pushId);
                this.cutoff = head.timestamp;
            }
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry
    implements Comparable<Entry> {
        public String pushId;
        public String timestamp;

        public Entry(String pushId, String timestamp) {
            this.pushId = pushId;
            this.timestamp = timestamp;
        }

        @Override
        public int compareTo(Entry other) {
            return this.timestamp.compareTo(other.timestamp);
        }
    }
}

