/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.content.Context;
import com.parse.LogInCallback;
import com.parse.Parse;
import com.parse.ParseException;
import com.parse.ParseUser;
import com.parse.SaveCallback;
import com.parse.TwitterAuthenticationProvider;
import com.parse.twitter.Twitter;
import org.json.JSONException;

public final class ParseTwitterUtils {
    private static Twitter twitter;
    private static TwitterAuthenticationProvider provider;
    private static boolean isInitialized;

    private static TwitterAuthenticationProvider getAuthenticationProvider() {
        if (provider == null) {
            provider = new TwitterAuthenticationProvider(ParseTwitterUtils.getTwitter());
        }
        return provider;
    }

    public static Twitter getTwitter() {
        if (twitter == null) {
            twitter = new Twitter("", "");
        }
        return twitter;
    }

    public static void initialize(String consumerKey, String consumerSecret) {
        ParseTwitterUtils.getTwitter().setConsumerKey(consumerKey);
        ParseTwitterUtils.getTwitter().setConsumerSecret(consumerSecret);
        ParseUser.registerAuthenticationProvider(ParseTwitterUtils.getAuthenticationProvider());
        isInitialized = true;
    }

    private static void checkInitialization() {
        if (!isInitialized) {
            throw new IllegalStateException("You must call ParseTwitterUtils.initialize() before using ParseTwitterUtils");
        }
    }

    public static boolean isLinked(ParseUser user) {
        return user.getLinkedServiceNames().contains(ParseTwitterUtils.getAuthenticationProvider().getAuthType());
    }

    public static void link(ParseUser user, Context context) {
        ParseTwitterUtils.link(user, context, null);
    }

    public static void link(ParseUser user, Context context, SaveCallback callback) {
        ParseTwitterUtils.checkInitialization();
        ParseTwitterUtils.getAuthenticationProvider().setContext(context);
        Parse.callbackOnMainThreadAsync(user.linkWithAsync(ParseTwitterUtils.getAuthenticationProvider().getAuthType()), callback, true);
    }

    public static void link(ParseUser user, String twitterId, String screenName, String authToken, String authTokenSecret) {
        ParseTwitterUtils.link(user, twitterId, screenName, authToken, authTokenSecret, null);
    }

    public static void link(ParseUser user, String twitterId, String screenName, String authToken, String authTokenSecret, SaveCallback callback) {
        block2: {
            ParseTwitterUtils.checkInitialization();
            try {
                Parse.callbackOnMainThreadAsync(user.linkWithAsync(ParseTwitterUtils.getAuthenticationProvider().getAuthType(), ParseTwitterUtils.getAuthenticationProvider().getAuthData(twitterId, screenName, authToken, authTokenSecret)), callback);
            }
            catch (JSONException e) {
                if (callback == null) break block2;
                callback.internalDone(null, new ParseException(e));
            }
        }
    }

    public static void logIn(String twitterId, String screenName, String authToken, String authTokenSecret, LogInCallback callback) {
        block2: {
            ParseTwitterUtils.checkInitialization();
            try {
                Parse.callbackOnMainThreadAsync(ParseUser.logInWithAsync(ParseTwitterUtils.getAuthenticationProvider().getAuthType(), ParseTwitterUtils.getAuthenticationProvider().getAuthData(twitterId, screenName, authToken, authTokenSecret)), callback);
            }
            catch (JSONException e) {
                if (callback == null) break block2;
                callback.internalDone(null, new ParseException(e));
            }
        }
    }

    public static void logIn(Context context, LogInCallback callback) {
        ParseTwitterUtils.checkInitialization();
        ParseTwitterUtils.getAuthenticationProvider().setContext(context);
        Parse.callbackOnMainThreadAsync(ParseUser.logInWithAsync(ParseTwitterUtils.getAuthenticationProvider().getAuthType()), callback, true);
    }

    public static void unlink(ParseUser user) throws ParseException {
        ParseTwitterUtils.checkInitialization();
        Parse.waitForTask(user.unlinkFromAsync(ParseTwitterUtils.getAuthenticationProvider().getAuthType()));
    }

    public static void unlinkInBackground(ParseUser user) {
        ParseTwitterUtils.unlinkInBackground(user, null);
    }

    public static void unlinkInBackground(ParseUser user, SaveCallback callback) {
        ParseTwitterUtils.checkInitialization();
        Parse.callbackOnMainThreadAsync(user.unlinkFromAsync(ParseTwitterUtils.getAuthenticationProvider().getAuthType()), callback);
    }

    private ParseTwitterUtils() {
    }
}

