/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.content.Context;
import com.parse.ParseAuthenticationProvider;
import com.parse.internal.AsyncCallback;
import com.parse.twitter.Twitter;
import java.lang.ref.WeakReference;
import org.json.JSONException;
import org.json.JSONObject;

class TwitterAuthenticationProvider
implements ParseAuthenticationProvider {
    private static final String SCREEN_NAME_KEY = "screen_name";
    private static final String ID_KEY = "id";
    private static final String AUTH_TOKEN_SECRET_KEY = "auth_token_secret";
    private static final String AUTH_TOKEN_KEY = "auth_token";
    private static final String CONSUMER_KEY_KEY = "consumer_key";
    private static final String CONSUMER_SECRET_KEY = "consumer_secret";
    private WeakReference<Context> baseContext;
    private final Twitter twitter;
    private ParseAuthenticationProvider.ParseAuthenticationCallback currentOperationCallback;

    public TwitterAuthenticationProvider(Twitter twitter) {
        this.twitter = twitter;
    }

    public void authenticate(final ParseAuthenticationProvider.ParseAuthenticationCallback callback) {
        Context context;
        if (this.currentOperationCallback != null) {
            this.cancel();
        }
        this.currentOperationCallback = callback;
        Context context2 = context = this.baseContext == null ? null : (Context)this.baseContext.get();
        if (context == null) {
            throw new IllegalStateException("Context must be non-null for Twitter authentication to proceed.");
        }
        this.twitter.authorize(context, new AsyncCallback(){

            public void onCancel() {
                TwitterAuthenticationProvider.this.handleCancel(callback);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onFailure(Throwable error) {
                if (TwitterAuthenticationProvider.this.currentOperationCallback != callback) {
                    return;
                }
                try {
                    callback.onError(error);
                }
                finally {
                    TwitterAuthenticationProvider.this.currentOperationCallback = null;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onSuccess(Object result) {
                if (TwitterAuthenticationProvider.this.currentOperationCallback != callback) {
                    return;
                }
                try {
                    JSONObject authData;
                    try {
                        authData = TwitterAuthenticationProvider.this.getAuthData(TwitterAuthenticationProvider.this.twitter.getUserId(), TwitterAuthenticationProvider.this.twitter.getScreenName(), TwitterAuthenticationProvider.this.twitter.getAuthToken(), TwitterAuthenticationProvider.this.twitter.getAuthTokenSecret());
                    }
                    catch (JSONException e) {
                        callback.onError(e);
                        TwitterAuthenticationProvider.this.currentOperationCallback = null;
                        return;
                    }
                    callback.onSuccess(authData);
                }
                finally {
                    TwitterAuthenticationProvider.this.currentOperationCallback = null;
                }
            }
        });
    }

    public JSONObject getAuthData(String userId, String screenName, String authToken, String authTokenSecret) throws JSONException {
        JSONObject authData = new JSONObject();
        authData.put(AUTH_TOKEN_KEY, (Object)authToken);
        authData.put(AUTH_TOKEN_SECRET_KEY, (Object)authTokenSecret);
        authData.put(ID_KEY, (Object)userId);
        authData.put(SCREEN_NAME_KEY, (Object)screenName);
        authData.put(CONSUMER_KEY_KEY, (Object)this.twitter.getConsumerKey());
        authData.put(CONSUMER_SECRET_KEY, (Object)this.twitter.getConsumerSecret());
        return authData;
    }

    public void cancel() {
        this.handleCancel(this.currentOperationCallback);
    }

    public void deauthenticate() {
        this.twitter.setAuthToken(null);
        this.twitter.setAuthTokenSecret(null);
        this.twitter.setScreenName(null);
        this.twitter.setUserId(null);
    }

    public String getAuthType() {
        return "twitter";
    }

    public Twitter getTwitter() {
        return this.twitter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCancel(ParseAuthenticationProvider.ParseAuthenticationCallback callback) {
        if (this.currentOperationCallback != callback || callback == null) {
            return;
        }
        try {
            callback.onCancel();
        }
        finally {
            this.currentOperationCallback = null;
        }
    }

    public boolean restoreAuthentication(JSONObject authData) {
        if (authData == null) {
            this.twitter.setAuthToken(null);
            this.twitter.setAuthTokenSecret(null);
            this.twitter.setScreenName(null);
            this.twitter.setUserId(null);
            return true;
        }
        try {
            this.twitter.setAuthToken(authData.getString(AUTH_TOKEN_KEY));
            this.twitter.setAuthTokenSecret(authData.getString(AUTH_TOKEN_SECRET_KEY));
            this.twitter.setUserId(authData.getString(ID_KEY));
            this.twitter.setScreenName(authData.getString(SCREEN_NAME_KEY));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setContext(Context context) {
        this.baseContext = new WeakReference<Context>(context);
    }
}

