/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import com.parse.Continuation;
import com.parse.OfflineStore;
import com.parse.ParseClassName;
import com.parse.ParseObject;
import com.parse.ParseQuery;
import com.parse.Task;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ParseClassName(value="_Pin")
class ParsePin
extends ParseObject {
    private static final String KEY_NAME = "_name";
    private static final String KEY_OBJECTS = "_objects";

    static Task<ParsePin> getParsePin(final String name) {
        ParseQuery<ParsePin> query = ParseQuery.getQuery(ParsePin.class).whereEqualTo(KEY_NAME, name);
        return OfflineStore.getCurrent().findAsync(query, null, null, false).onSuccess(new Continuation<List<ParsePin>, ParsePin>(){

            @Override
            public ParsePin then(Task<List<ParsePin>> task) throws Exception {
                ParsePin pin = null;
                if (task.getResult() != null && task.getResult().size() > 0) {
                    pin = task.getResult().get(0);
                }
                if (pin == null) {
                    pin = ParseObject.create(ParsePin.class);
                    pin.setName(name);
                }
                return pin;
            }
        });
    }

    static Task<Void> pinAllAsync(String name, final List<ParseObject> objects) {
        if (objects == null || objects.size() == 0) {
            return Task.forResult(null);
        }
        return ParsePin.getParsePin(name).onSuccessTask(new Continuation<ParsePin, Task<Void>>(){

            @Override
            public Task<Void> then(Task<ParsePin> task) throws Exception {
                ParsePin pin = task.getResult();
                OfflineStore store = OfflineStore.getCurrent();
                List<ParseObject> modified = pin.getObjects();
                if (modified == null) {
                    modified = new ArrayList<ParseObject>(objects);
                } else {
                    for (ParseObject object : objects) {
                        if (modified.contains(object)) continue;
                        modified.add(object);
                    }
                }
                pin.setObjects(modified);
                return store.saveLocallyAsync(pin, true);
            }
        });
    }

    static Task<Void> unpinAllAsync(String name, final List<ParseObject> objects) {
        if (objects == null || objects.size() == 0) {
            return Task.forResult(null);
        }
        return ParsePin.getParsePin(name).onSuccessTask(new Continuation<ParsePin, Task<Void>>(){

            @Override
            public Task<Void> then(Task<ParsePin> task) throws Exception {
                ParsePin pin = task.getResult();
                OfflineStore store = OfflineStore.getCurrent();
                List<ParseObject> modified = pin.getObjects();
                if (modified != null) {
                    modified.removeAll(objects);
                    if (modified.size() == 0) {
                        return store.unpinAsync(pin);
                    }
                }
                pin.setObjects(modified);
                return store.saveLocallyAsync(pin, true);
            }
        });
    }

    static Task<Void> unpinAllAsync(String name) {
        return ParsePin.getParsePin(name).continueWithTask(new Continuation<ParsePin, Task<Void>>(){

            @Override
            public Task<Void> then(Task<ParsePin> task) throws Exception {
                if (task.isFaulted()) {
                    return task.makeVoid();
                }
                ParsePin pin = task.getResult();
                return OfflineStore.getCurrent().unpinAsync(pin);
            }
        });
    }

    @Override
    boolean needsDefaultACL() {
        return false;
    }

    public String getName() {
        return this.getString(KEY_NAME);
    }

    public void setName(String name) {
        this.put(KEY_NAME, name);
    }

    public List<ParseObject> getObjects() {
        return this.getList(KEY_OBJECTS);
    }

    public void setObjects(List<ParseObject> objects) {
        this.put(KEY_OBJECTS, objects);
    }
}

