/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import com.parse.ParseACL;
import com.parse.ParseDecoder;
import com.parse.ParseFieldOperation;
import com.parse.ParseObjectEncodingStrategy;
import com.parse.ParseSetOperation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ParseOperationSet
extends HashMap<String, ParseFieldOperation> {
    private static final long serialVersionUID = 1L;
    private static final String REST_KEY_IS_SAVE_EVENTUALLY = "__isSaveEventually";
    private static final String REST_KEY_UUID = "__uuid";
    private String uuid;
    private boolean isSaveEventually = false;

    public ParseOperationSet() {
        this.uuid = UUID.randomUUID().toString();
    }

    private ParseOperationSet(String uuid) {
        this.uuid = uuid;
    }

    public String getUUID() {
        return this.uuid;
    }

    public void setIsSaveEventually(boolean value) {
        this.isSaveEventually = value;
    }

    public boolean isSaveEventually() {
        return this.isSaveEventually;
    }

    public void mergeFrom(ParseOperationSet other) {
        for (String key : other.keySet()) {
            ParseFieldOperation operation1 = (ParseFieldOperation)other.get(key);
            ParseFieldOperation operation2 = (ParseFieldOperation)this.get(key);
            operation2 = operation2 != null ? operation2.mergeWithPrevious(operation1) : operation1;
            this.put(key, operation2);
        }
    }

    public JSONObject toRest(ParseObjectEncodingStrategy objectEncoder, ArrayList<String> operationSetUUIDs) throws JSONException {
        JSONObject operationSetJSON = new JSONObject();
        for (String key : this.keySet()) {
            ParseFieldOperation op = (ParseFieldOperation)this.get(key);
            operationSetJSON.put(key, op.encode(objectEncoder));
        }
        operationSetJSON.put(REST_KEY_UUID, (Object)this.uuid);
        if (this.isSaveEventually) {
            operationSetJSON.put(REST_KEY_IS_SAVE_EVENTUALLY, true);
        }
        if (operationSetUUIDs != null) {
            operationSetUUIDs.add(this.uuid);
        }
        return operationSetJSON;
    }

    public static ParseOperationSet fromRest(JSONObject json, ParseDecoder decoder) throws JSONException {
        String uuid = (String)json.remove(REST_KEY_UUID);
        ParseOperationSet operationSet = uuid == null ? new ParseOperationSet() : new ParseOperationSet(uuid);
        boolean isSaveEventually = json.optBoolean(REST_KEY_IS_SAVE_EVENTUALLY);
        json.remove(REST_KEY_IS_SAVE_EVENTUALLY);
        operationSet.setIsSaveEventually(isSaveEventually);
        Iterator opKeys = json.keys();
        while (opKeys.hasNext()) {
            String opKey = (String)opKeys.next();
            Object value = decoder.decode(json.get(opKey));
            if (opKey.equals("ACL")) {
                value = ParseACL.createACLFromJSONObject(json.getJSONObject(opKey), decoder);
            }
            ParseFieldOperation fieldOp = value instanceof ParseFieldOperation ? (ParseFieldOperation)value : new ParseSetOperation(value);
            operationSet.put(opKey, fieldOp);
        }
        return operationSet;
    }
}

