/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.app.Activity;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.util.SparseIntArray;
import com.parse.ManifestInfo;
import com.parse.Parse;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ParseNotificationManager {
    public static final String TAG = "com.parse.ParseNotificationManager";
    private final Object lock = new Object();
    private final AtomicInteger notificationCount = new AtomicInteger(0);
    private volatile boolean shouldShowNotifications = true;
    private SparseIntArray iconIds = new SparseIntArray();

    ParseNotificationManager() {
    }

    public static ParseNotificationManager getInstance() {
        return Singleton.INSTANCE;
    }

    public boolean getShouldShowNotifications() {
        return this.shouldShowNotifications;
    }

    public void setShouldShowNotifications(boolean show) {
        this.shouldShowNotifications = show;
    }

    public int getNotificationCount() {
        return this.notificationCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValidIconId(Context context, int iconId) {
        int valid = 0;
        Object object = this.lock;
        synchronized (object) {
            valid = this.iconIds.get(iconId, -1);
        }
        if (valid == -1) {
            Resources resources = context.getResources();
            Drawable drawable2 = null;
            try {
                drawable2 = resources.getDrawable(iconId);
            }
            catch (Resources.NotFoundException e) {
                // empty catch block
            }
            Object object2 = this.lock;
            synchronized (object2) {
                valid = drawable2 == null ? 0 : 1;
                this.iconIds.put(iconId, valid);
            }
        }
        return valid == 1;
    }

    public Notification createNotification(Context context, String title, String body, Class<? extends Activity> clazz, int iconId, Bundle extras) {
        Notification notification = null;
        if (!this.isValidIconId(context, iconId)) {
            Parse.logE(TAG, "Icon id " + iconId + " is not a valid drawable. Trying to fall back to default app icon.");
            iconId = ManifestInfo.getIconId();
        }
        if (iconId == 0) {
            Parse.logE(TAG, "Could not find a valid icon id for this app. This is required to create a Notification object to show in the status bar. Make sure that the <application> in in your Manifest.xml has a valid android:icon attribute.");
        } else if (context == null || title == null || body == null || clazz == null || iconId == 0) {
            Parse.logE(TAG, "Must specify non-null context, title, body, and activity class to show notification.");
        } else {
            long when = System.currentTimeMillis();
            ComponentName name = new ComponentName(context, clazz);
            Intent intent = new Intent();
            intent.setComponent(name);
            intent.setFlags(0x10000000);
            if (extras != null) {
                intent.putExtras(extras);
            }
            PendingIntent contentIntent = PendingIntent.getActivity((Context)context, (int)((int)when), (Intent)intent, (int)0);
            notification = new Notification(iconId, (CharSequence)body, when);
            notification.flags |= 0x10;
            notification.defaults |= 0xFFFFFFFF;
            notification.setLatestEventInfo(context, (CharSequence)title, (CharSequence)body, contentIntent);
        }
        return notification;
    }

    public void showNotification(Context context, Notification notification) {
        if (context != null && notification != null) {
            this.notificationCount.incrementAndGet();
            if (this.shouldShowNotifications && context != null && notification != null) {
                NotificationManager nm = (NotificationManager)context.getSystemService("notification");
                int notificationId = (int)System.currentTimeMillis();
                try {
                    nm.notify(notificationId, notification);
                }
                catch (SecurityException e) {
                    notification.defaults = 5;
                    nm.notify(notificationId, notification);
                }
            }
        }
    }

    public void showNotification(Context context, String title, String body, Class<? extends Activity> cls, int iconId, Bundle extras) {
        this.showNotification(context, this.createNotification(context, title, body, cls, iconId, extras));
    }

    public static class Singleton {
        private static final ParseNotificationManager INSTANCE = new ParseNotificationManager();
    }
}

