/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.webkit.MimeTypeMap;
import com.parse.Continuation;
import com.parse.GetDataCallback;
import com.parse.Parse;
import com.parse.ParseAWSRequest;
import com.parse.ParseCallback;
import com.parse.ParseCommand;
import com.parse.ParseDecoder;
import com.parse.ParseException;
import com.parse.ParseFileUtils;
import com.parse.ParseUser;
import com.parse.ProgressCallback;
import com.parse.SaveCallback;
import com.parse.Task;
import com.parse.TaskQueue;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParseFile {
    private boolean dirty = false;
    private String name = null;
    private String url = null;
    private String contentType = null;
    byte[] data;
    private ParseAWSRequest request;
    final TaskQueue taskQueue = new TaskQueue();
    private Set<Task.TaskCompletionSource> currentTasks = Collections.synchronizedSet(new HashSet());

    static File getCacheDir() {
        return Parse.getParseCacheDir("files");
    }

    static File getFilesDir() {
        return Parse.getParseFilesDir("files");
    }

    static void clearCache() {
        for (File file : ParseFile.getCacheDir().listFiles()) {
            ParseFileUtils.deleteQuietly(file);
        }
    }

    public ParseFile(String name, byte[] data, String contentType) {
        if (data.length > Parse.maxParseFileSize) {
            throw new IllegalArgumentException(String.format("ParseFile must be less than %d bytes", Parse.maxParseFileSize));
        }
        this.name = name;
        this.data = data;
        this.contentType = contentType;
        this.dirty = true;
    }

    public ParseFile(byte[] data) {
        this(null, data, null);
    }

    public ParseFile(String name, byte[] data) {
        this(name, data, null);
    }

    public ParseFile(byte[] data, String contentType) {
        this(null, data, contentType);
    }

    ParseFile(String name, String url) {
        this.name = name;
        this.url = url;
    }

    private String getFilename() {
        return this.name;
    }

    File getCacheFile() {
        String filename = this.getFilename();
        return filename != null ? new File(ParseFile.getCacheDir(), filename) : null;
    }

    File getFilesFile() {
        String filename = this.getFilename();
        return filename != null ? new File(ParseFile.getFilesDir(), filename) : null;
    }

    public String getName() {
        return this.name;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isDataAvailable() {
        return this.data != null || (!this.isPinned() ? this.getCacheFile().exists() : this.getFilesFile().exists());
    }

    public String getUrl() {
        return this.url;
    }

    private byte[] getCachedData() {
        File file;
        if (this.data != null) {
            return this.data;
        }
        try {
            file = this.getCacheFile();
            if (file != null) {
                return ParseFileUtils.readFileToByteArray(file);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            file = this.getFilesFile();
            if (file != null) {
                return ParseFileUtils.readFileToByteArray(file);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    boolean isPinned() {
        File file = this.getFilesFile();
        return file != null && file.exists();
    }

    void pin() throws ParseException {
        this.setPinned(true);
    }

    void unpin() throws ParseException {
        this.setPinned(false);
    }

    void pinInBackground() {
        this.pinInBackground(null);
    }

    void unpinInBackground() {
        this.unpinInBackground(null);
    }

    void pinInBackground(ParseCallback<Void> callback) {
        this.setPinnedInBackground(true, callback);
    }

    void unpinInBackground(ParseCallback<Void> callback) {
        this.setPinnedInBackground(false, callback);
    }

    private void setPinned(boolean pinned) throws ParseException {
        Parse.waitForTask(this.setPinnedAsync(pinned));
    }

    private void setPinnedInBackground(boolean pinned, ParseCallback<Void> callback) {
        Parse.callbackOnMainThreadAsync(this.setPinnedAsync(pinned), callback);
    }

    private Task<Void> setPinnedAsync(final boolean pinned) {
        return this.taskQueue.enqueue(new Continuation<Void, Task<Void>>(){

            @Override
            public Task<Void> then(Task<Void> task) throws Exception {
                return task;
            }
        }).continueWith(new Continuation<Void, Void>(){

            @Override
            public Void then(Task<Void> task) throws Exception {
                File dest;
                File src;
                if (pinned && ParseFile.this.isPinned() || !pinned && !ParseFile.this.isPinned()) {
                    return null;
                }
                if (pinned) {
                    src = ParseFile.this.getCacheFile();
                    dest = ParseFile.this.getFilesFile();
                } else {
                    src = ParseFile.this.getFilesFile();
                    dest = ParseFile.this.getCacheFile();
                }
                if (dest == null) {
                    throw new IllegalStateException("Unable to pin file before saving");
                }
                if (dest.exists()) {
                    ParseFileUtils.deleteQuietly(dest);
                }
                if (pinned && ParseFile.this.data != null) {
                    ParseFileUtils.writeByteArrayToFile(dest, ParseFile.this.data);
                    if (src.exists()) {
                        ParseFileUtils.deleteQuietly(src);
                    }
                    return null;
                }
                if (src == null || !src.exists()) {
                    throw new IllegalStateException("Unable to pin file before retrieving");
                }
                ParseFileUtils.moveFile(src, dest);
                return null;
            }
        }, Task.BACKGROUND_EXECUTOR);
    }

    private ParseCommand constructFileUploadCommand(String sessionToken) {
        ParseCommand currentCommand = new ParseCommand("upload_file", sessionToken);
        currentCommand.enableRetrying();
        if (this.name != null) {
            currentCommand.put("name", this.name);
        }
        return currentCommand;
    }

    private void prepareFileUploadPost(JSONObject result, ProgressCallback progressCallback) {
        JSONObject postParams;
        String mimeType = null;
        try {
            this.name = result.getString("name");
            this.url = result.getString("url");
            postParams = result.getJSONObject("post_params");
        }
        catch (JSONException e) {
            throw new RuntimeException(e.getMessage());
        }
        if (this.contentType != null) {
            mimeType = this.contentType;
        } else if (this.name.lastIndexOf(".") != -1) {
            String extension = this.name.substring(this.name.lastIndexOf(".") + 1);
            mimeType = MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension);
        }
        if (mimeType == null) {
            mimeType = "application/octet-stream";
        }
        try {
            String url = result.getString("post_url");
            this.request = new ParseAWSRequest(1, url);
            this.request.setProgressCallback(progressCallback);
            this.request.setMimeType(mimeType);
            this.request.setPostParams(postParams);
            this.request.setData(this.getCachedData());
        }
        catch (JSONException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private Task<Void> handleFileUploadResultAsync(JSONObject result, ProgressCallback progressCallback) {
        if (this.request == null) {
            this.prepareFileUploadPost(result, progressCallback);
        }
        return this.request.executeAsync().makeVoid();
    }

    public void save() throws ParseException {
        this.save(null);
    }

    private void save(ProgressCallback progressCallback) throws ParseException {
        Parse.waitForTask(this.saveAsync(progressCallback));
    }

    Task<Void> saveAsync(final ProgressCallback progressCallback, Task<Void> toAwait) {
        if (!this.isDirty()) {
            return Task.forResult(null);
        }
        final Task.TaskCompletionSource tcs = Task.create();
        this.currentTasks.add(tcs);
        toAwait.continueWith(new Continuation<Void, Void>(){

            @Override
            public Void then(Task<Void> task) throws Exception {
                if (!ParseFile.this.isDirty()) {
                    tcs.trySetResult(null);
                    return null;
                }
                final String sessionToken = ParseUser.getCurrentSessionToken();
                Task.call(new Callable<ParseCommand>(){

                    @Override
                    public ParseCommand call() throws Exception {
                        final ParseCommand command = ParseFile.this.constructFileUploadCommand(sessionToken);
                        tcs.getTask().continueWith(new Continuation<Void, Void>(){

                            @Override
                            public Void then(Task<Void> task) throws Exception {
                                if (task.isCancelled()) {
                                    command.cancel();
                                }
                                return null;
                            }
                        });
                        return command;
                    }
                }).onSuccessTask(new Continuation<ParseCommand, Task<Object>>(){

                    @Override
                    public Task<Object> then(Task<ParseCommand> task) throws Exception {
                        return task.getResult().executeAsync();
                    }
                }).onSuccessTask(new Continuation<Object, Task<Void>>(){

                    @Override
                    public Task<Void> then(Task<Object> task) throws Exception {
                        return ParseFile.this.handleFileUploadResultAsync((JSONObject)task.getResult(), progressCallback);
                    }
                }).continueWithTask(new Continuation<Void, Task<Void>>(){

                    @Override
                    public Task<Void> then(Task<Void> task) throws Exception {
                        if (!task.isFaulted()) {
                            try {
                                ParseFileUtils.writeByteArrayToFile(ParseFile.this.getCacheFile(), ParseFile.this.data);
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            ParseFile.this.dirty = false;
                        }
                        return task;
                    }
                }).continueWith(new Continuation<Void, Void>(){

                    @Override
                    public Void then(Task<Void> task) throws Exception {
                        ParseFile.this.currentTasks.remove(tcs);
                        if (task.isCancelled()) {
                            tcs.trySetCancelled();
                        } else if (task.isFaulted()) {
                            tcs.trySetError(task.getError());
                        } else {
                            tcs.trySetResult(task.getResult());
                        }
                        return null;
                    }
                });
                return null;
            }
        });
        return tcs.getTask();
    }

    Task<Void> saveAsync(final ProgressCallback progressCallback) {
        return this.taskQueue.enqueue(new Continuation<Void, Task<Void>>(){

            @Override
            public Task<Void> then(Task<Void> task) throws Exception {
                return ParseFile.this.saveAsync(progressCallback, task);
            }
        });
    }

    public synchronized void saveInBackground(SaveCallback saveCallback, ProgressCallback progressCallback) {
        Parse.callbackOnMainThreadAsync(this.saveAsync(progressCallback), saveCallback);
    }

    public void saveInBackground(SaveCallback callback) {
        this.saveInBackground(callback, null);
    }

    public void saveInBackground() {
        this.saveInBackground(null);
    }

    public byte[] getData() throws ParseException {
        return Parse.waitForTask(this.getDataAsync(null));
    }

    private Task<byte[]> getDataAsync(final ProgressCallback progressCallback, Task<Void> toAwait) {
        if (this.data != null) {
            return Task.forResult(this.data);
        }
        final Task.TaskCompletionSource tcs = Task.create();
        this.currentTasks.add(tcs);
        toAwait.continueWith(new Continuation<Void, byte[]>(){

            @Override
            public byte[] then(Task<Void> task) throws Exception {
                return ParseFile.this.getCachedData();
            }
        }, Task.BACKGROUND_EXECUTOR).continueWith(new Continuation<byte[], Void>(){

            @Override
            public Void then(Task<byte[]> task) throws Exception {
                byte[] result = task.getResult();
                if (result != null) {
                    tcs.trySetResult(result);
                    return null;
                }
                ParseAWSRequest request = new ParseAWSRequest(ParseFile.this.url);
                request.executeAsync(progressCallback).continueWithTask(new Continuation<byte[], Task<byte[]>>(){

                    @Override
                    public Task<byte[]> then(Task<byte[]> task) throws Exception {
                        if (task.isFaulted() && task.getError() instanceof IllegalStateException) {
                            return Task.forError(new ParseException(100, task.getError().getMessage()));
                        }
                        if (tcs.getTask().isCancelled()) {
                            return tcs.getTask();
                        }
                        ParseFile.this.data = task.getResult();
                        if (ParseFile.this.data != null) {
                            ParseFileUtils.writeByteArrayToFile(ParseFile.this.getCacheFile(), ParseFile.this.data);
                        }
                        return task;
                    }
                }).continueWith(new Continuation<byte[], Void>(){

                    @Override
                    public Void then(Task<byte[]> task) throws Exception {
                        ParseFile.this.currentTasks.remove(tcs);
                        if (task.isCancelled()) {
                            tcs.trySetCancelled();
                        } else if (task.isFaulted()) {
                            tcs.trySetError(task.getError());
                        } else {
                            tcs.trySetResult(task.getResult());
                        }
                        return null;
                    }
                });
                return null;
            }
        });
        return tcs.getTask();
    }

    Task<byte[]> getDataAsync(final ProgressCallback progressCallback) {
        return this.taskQueue.enqueue(new Continuation<Void, Task<byte[]>>(){

            @Override
            public Task<byte[]> then(Task<Void> task) throws Exception {
                return ParseFile.this.getDataAsync(progressCallback, task);
            }
        });
    }

    public void getDataInBackground(GetDataCallback dataCallback, ProgressCallback progressCallback) {
        Parse.callbackOnMainThreadAsync(this.getDataAsync(progressCallback), dataCallback);
    }

    public void getDataInBackground(GetDataCallback dataCallback) {
        this.getDataInBackground(dataCallback, null);
    }

    public void cancel() {
        HashSet<Task.TaskCompletionSource> tasks = new HashSet<Task.TaskCompletionSource>(this.currentTasks);
        for (Task.TaskCompletionSource tcs : tasks) {
            tcs.trySetCancelled();
        }
        this.currentTasks.removeAll(tasks);
    }

    ParseFile(JSONObject json, ParseDecoder decoder) {
        this(json.optString("name"), json.optString("url"));
    }

    JSONObject encode() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("__type", (Object)"File");
        json.put("name", (Object)this.getName());
        String url = this.getUrl();
        if (url == null) {
            throw new IllegalStateException("Unable to encode an unsaved ParseFile.");
        }
        json.put("url", (Object)this.getUrl());
        return json;
    }
}

