/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.concurrent.locks.Lock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LockSet {
    private static WeakHashMap<Lock, Long> stableIds = new WeakHashMap();
    private static long nextStableId = 0L;
    private final Set<Lock> locks = new TreeSet<Lock>(new Comparator<Lock>(){

        @Override
        public int compare(Lock lhs, Lock rhs) {
            Long lhsId = LockSet.getStableId(lhs);
            Long rhsId = LockSet.getStableId(rhs);
            return lhsId.compareTo(rhsId);
        }
    });

    public LockSet(Collection<Lock> locks) {
        this.locks.addAll(locks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Long getStableId(Lock lock) {
        WeakHashMap<Lock, Long> weakHashMap = stableIds;
        synchronized (weakHashMap) {
            if (stableIds.containsKey(lock)) {
                return stableIds.get(lock);
            }
            long id2 = nextStableId++;
            stableIds.put(lock, id2);
            return id2;
        }
    }

    public void lock() {
        for (Lock l : this.locks) {
            l.lock();
        }
    }

    public void unlock() {
        for (Lock l : this.locks) {
            l.unlock();
        }
    }
}

