/*
 * Decompiled with CFR 0.152.
 */
package com.parse.twitter;

import android.app.ProgressDialog;
import android.content.Context;
import android.net.Uri;
import android.os.AsyncTask;
import android.webkit.CookieSyncManager;
import com.parse.internal.AsyncCallback;
import com.parse.oauth.OAuth1FlowDialog;
import com.parse.oauth.OAuth1FlowException;
import com.parse.signpost.OAuthProvider;
import com.parse.signpost.commonshttp.CommonsHttpOAuthConsumer;
import com.parse.signpost.commonshttp.CommonsHttpOAuthProvider;
import com.parse.signpost.http.HttpParameters;
import org.apache.http.client.methods.HttpUriRequest;

public class Twitter {
    static final String REQUEST_TOKEN_URL = "https://api.twitter.com/oauth/request_token";
    static final String AUTHORIZE_URL = "https://api.twitter.com/oauth/authorize";
    static final String ACCESS_TOKEN_URL = "https://api.twitter.com/oauth/access_token";
    private static final String VERIFIER_PARAM = "oauth_verifier";
    private static final String USER_ID_PARAM = "user_id";
    private static final String SCREEN_NAME_PARAM = "screen_name";
    private static final OAuthProvider PROVIDER = new CommonsHttpOAuthProvider("https://api.twitter.com/oauth/request_token", "https://api.twitter.com/oauth/access_token", "https://api.twitter.com/oauth/authorize");
    private static final String CALLBACK_URL = "twitter-oauth://complete";
    private String consumerKey;
    private String consumerSecret;
    private String authToken;
    private String authTokenSecret;
    private String userId;
    private String screenName;

    public Twitter(String consumerKey, String consumerSecret) {
        this.consumerKey = consumerKey;
        this.consumerSecret = consumerSecret;
    }

    public String getConsumerKey() {
        return this.consumerKey;
    }

    public void setConsumerKey(String consumerKey) {
        this.consumerKey = consumerKey;
    }

    public String getConsumerSecret() {
        return this.consumerSecret;
    }

    public void setConsumerSecret(String consumerSecret) {
        this.consumerSecret = consumerSecret;
    }

    public String getAuthToken() {
        return this.authToken;
    }

    public void setAuthToken(String authToken) {
        this.authToken = authToken;
    }

    public String getAuthTokenSecret() {
        return this.authTokenSecret;
    }

    public void setAuthTokenSecret(String authTokenSecret) {
        this.authTokenSecret = authTokenSecret;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getScreenName() {
        return this.screenName;
    }

    public void setScreenName(String screenName) {
        this.screenName = screenName;
    }

    public void signRequest(HttpUriRequest request) {
        CommonsHttpOAuthConsumer consumer = new CommonsHttpOAuthConsumer(this.getConsumerKey(), this.getConsumerSecret());
        consumer.setTokenWithSecret(this.getAuthToken(), this.getAuthTokenSecret());
        try {
            consumer.sign(request);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void authorize(final Context context, final AsyncCallback callback) {
        if (this.getConsumerKey() == null || this.getConsumerKey().length() == 0 || this.getConsumerSecret() == null || this.getConsumerSecret().length() == 0) {
            throw new IllegalStateException("Twitter must be initialized with a consumer key and secret before authorization.");
        }
        final CommonsHttpOAuthConsumer consumer = new CommonsHttpOAuthConsumer(this.getConsumerKey(), this.getConsumerSecret());
        final ProgressDialog progress = new ProgressDialog(context);
        progress.setMessage((CharSequence)"Loading...");
        AsyncTask<Void, Void, String> task = new AsyncTask<Void, Void, String>(){
            private Throwable error;

            protected void onPostExecute(String result) {
                super.onPostExecute((Object)result);
                try {
                    if (this.error != null) {
                        callback.onFailure(this.error);
                        return;
                    }
                    CookieSyncManager.createInstance((Context)context);
                    OAuth1FlowDialog dialog = new OAuth1FlowDialog(context, result, Twitter.CALLBACK_URL, "api.twitter", new OAuth1FlowDialog.FlowResultHandler(){

                        @Override
                        public void onError(int errorCode, String description, String failingUrl) {
                            callback.onFailure(new OAuth1FlowException(errorCode, description, failingUrl));
                        }

                        @Override
                        public void onComplete(String callbackUrl) {
                            CookieSyncManager.getInstance().sync();
                            Uri uri = Uri.parse((String)callbackUrl);
                            final String verifier = uri.getQueryParameter(Twitter.VERIFIER_PARAM);
                            if (verifier == null) {
                                callback.onCancel();
                                return;
                            }
                            AsyncTask<Void, Void, HttpParameters> getTokenTask = new AsyncTask<Void, Void, HttpParameters>(){
                                private Throwable error;

                                protected HttpParameters doInBackground(Void ... params) {
                                    try {
                                        PROVIDER.retrieveAccessToken(consumer, verifier);
                                    }
                                    catch (Throwable e) {
                                        this.error = e;
                                    }
                                    return PROVIDER.getResponseParameters();
                                }

                                protected void onPreExecute() {
                                    super.onPreExecute();
                                    progress.show();
                                }

                                protected void onPostExecute(HttpParameters result) {
                                    super.onPostExecute((Object)result);
                                    try {
                                        if (this.error != null) {
                                            callback.onFailure(this.error);
                                            return;
                                        }
                                        try {
                                            Twitter.this.setAuthToken(consumer.getToken());
                                            Twitter.this.setAuthTokenSecret(consumer.getTokenSecret());
                                            Twitter.this.setScreenName(result.getFirst(Twitter.SCREEN_NAME_PARAM));
                                            Twitter.this.setUserId(result.getFirst(Twitter.USER_ID_PARAM));
                                        }
                                        catch (Throwable e) {
                                            callback.onFailure(e);
                                            progress.dismiss();
                                            return;
                                        }
                                        callback.onSuccess(Twitter.this);
                                    }
                                    finally {
                                        progress.dismiss();
                                    }
                                }
                            };
                            getTokenTask.execute((Object[])new Void[0]);
                        }

                        @Override
                        public void onCancel() {
                            callback.onCancel();
                        }
                    });
                    dialog.show();
                }
                finally {
                    progress.dismiss();
                }
            }

            protected void onPreExecute() {
                super.onPreExecute();
                progress.show();
            }

            protected String doInBackground(Void ... params) {
                try {
                    return PROVIDER.retrieveRequestToken(consumer, Twitter.CALLBACK_URL);
                }
                catch (Throwable e) {
                    this.error = e;
                    return null;
                }
            }
        };
        task.execute((Object[])new Void[0]);
    }
}

