/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.parse.Continuation;
import com.parse.ManifestInfo;
import com.parse.Parse;
import com.parse.ParseDecoder;
import com.parse.ParseInstallation;
import com.parse.ParseNotificationManager;
import com.parse.ParseObject;
import com.parse.PointerOrLocalIdEncodingStrategy;
import com.parse.PushHistory;
import com.parse.PushRoutes;
import com.parse.Task;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class PushRouter {
    private static final String TAG = "com.parse.ParsePushRouter";
    private static final String LEGACY_ROUTE_LOCATION = "persistentCallbacks";
    private static final String STATE_LOCATION = "pushState";
    private static final ExecutorService EXECUTOR = Executors.newSingleThreadExecutor();
    public static final String GCM_RECEIVE_ACTION = "com.google.android.c2dm.intent.RECEIVE";
    static int MAX_HISTORY_LENGTH = 10;
    private static Task<Void> lastTask;
    private static PushListener pushListener;
    private static PushRouter instance;
    private final String stateLocation;
    private final PushRoutes routes;
    private final PushHistory history;
    private final AtomicBoolean isRefreshingInstallation = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Task<Void> subscribeAsync(final String channel, final Class<? extends Activity> cls, final int iconId) {
        if (channel != null && !PushRoutes.isValidChannelName(channel)) {
            throw new IllegalArgumentException("Invalid channel name: + " + channel + " (must be empty " + "string or a letter followed by alphanumerics or hyphen)");
        }
        if (cls == null) {
            throw new IllegalArgumentException("Can't subscribe to channel with null activity class.");
        }
        if (iconId == 0) {
            throw new IllegalArgumentException("Must subscribe to channel with a valid icon identifier.");
        }
        Task<Void> subscribeTask = null;
        Class<PushRouter> clazz = PushRouter.class;
        synchronized (PushRouter.class) {
            subscribeTask = PushRouter.getLastTask().onSuccess(new Continuation<Void, Void>(){

                @Override
                public Void then(Task<Void> task) {
                    PushRouter.getInstance().subscribe(channel, cls, iconId);
                    return null;
                }
            }, EXECUTOR);
            lastTask = PushRouter.makeUnhandledExceptionsFatal(subscribeTask);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return subscribeTask;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Task<Void> unsubscribeAsync(final String channel) {
        Task<Void> unsubscribeTask = null;
        Class<PushRouter> clazz = PushRouter.class;
        synchronized (PushRouter.class) {
            unsubscribeTask = PushRouter.getLastTask().onSuccess(new Continuation<Void, Void>(){

                @Override
                public Void then(Task<Void> task) {
                    PushRouter.getInstance().unsubscribe(channel);
                    return null;
                }
            }, EXECUTOR);
            lastTask = PushRouter.makeUnhandledExceptionsFatal(unsubscribeTask);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return unsubscribeTask;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Task<Set<String>> getSubscriptionsAsync(final boolean includeDefaultRoute) {
        Task<Set<String>> getSubscriptionsTask = null;
        Class<PushRouter> clazz = PushRouter.class;
        synchronized (PushRouter.class) {
            getSubscriptionsTask = PushRouter.getLastTask().onSuccess(new Continuation<Void, Set<String>>(){

                @Override
                public Set<String> then(Task<Void> task) {
                    return PushRouter.getInstance().getSubscriptions(includeDefaultRoute);
                }
            }, EXECUTOR);
            lastTask = PushRouter.makeUnhandledExceptionsFatal(getSubscriptionsTask.makeVoid());
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return getSubscriptionsTask;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Task<JSONObject> getPushRequestJSONAsync() {
        Task<JSONObject> getPushRequestTask = null;
        Class<PushRouter> clazz = PushRouter.class;
        synchronized (PushRouter.class) {
            getPushRequestTask = PushRouter.getLastTask().onSuccess(new Continuation<Void, JSONObject>(){

                @Override
                public JSONObject then(Task<Void> task) {
                    return PushRouter.getInstance().getPushRequestJSON();
                }
            }, EXECUTOR);
            lastTask = PushRouter.makeUnhandledExceptionsFatal(getPushRequestTask.makeVoid());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return getPushRequestTask;
        }
    }

    public static boolean isGcmPushIntent(Intent intent) {
        return intent != null && GCM_RECEIVE_ACTION.equals(intent.getAction());
    }

    public static void handleGcmPushIntent(final Intent intent) {
        final Semaphore done = new Semaphore(0);
        EXECUTOR.submit(new Runnable(){

            @Override
            public void run() {
                PushRouter.getInstance().handleGcmPush(intent);
                done.release();
            }
        });
        done.acquireUninterruptibly();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Task<Void> handlePpnsPushAsync(final JSONObject pushPayload) {
        Task<Void> receivedPushTask = null;
        Class<PushRouter> clazz = PushRouter.class;
        synchronized (PushRouter.class) {
            receivedPushTask = PushRouter.getLastTask().onSuccess(new Continuation<Void, Void>(){

                @Override
                public Void then(Task<Void> task) {
                    if (pushPayload != null) {
                        PushRouter.getInstance().handlePpnsPush(pushPayload);
                    }
                    return null;
                }
            }, EXECUTOR);
            lastTask = PushRouter.makeUnhandledExceptionsFatal(receivedPushTask);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return receivedPushTask;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Task<Void> reloadFromDiskAsync(final boolean removeExistingState) {
        Task<Void> reloadTask = null;
        Class<PushRouter> clazz = PushRouter.class;
        synchronized (PushRouter.class) {
            reloadTask = PushRouter.getLastTask().onSuccess(new Continuation<Void, Void>(){

                @Override
                public Void then(Task<Void> task) {
                    PushRouter.reloadInstance(removeExistingState);
                    return null;
                }
            }, EXECUTOR);
            lastTask = PushRouter.makeUnhandledExceptionsFatal(reloadTask);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return reloadTask;
        }
    }

    private static synchronized Task<Void> getLastTask() {
        if (lastTask == null) {
            lastTask = Task.forResult(null).makeVoid();
        }
        return lastTask;
    }

    private static Task<Void> makeUnhandledExceptionsFatal(Task<Void> lastTask) {
        return lastTask.continueWith(new Continuation<Void, Void>(){

            @Override
            public Void then(final Task<Void> task) {
                if (task.isFaulted()) {
                    Parse.uiThreadExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            throw new RuntimeException(task.getError());
                        }
                    });
                }
                return null;
            }
        }, EXECUTOR);
    }

    private static JSONArray getChannelsArrayFromInstallation(ParseInstallation installation) {
        JSONArray array = null;
        List list = installation.getList("channels");
        if (list != null) {
            array = (JSONArray)Parse.encode(list, PointerOrLocalIdEncodingStrategy.get());
        }
        return array != null ? array : new JSONArray();
    }

    static synchronized void setGlobalPushListener(PushListener listener) {
        pushListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void noteHandlePushResult(final JSONObject pushData, final HandlePushResult result) {
        PushListener listener = null;
        Class<PushRouter> clazz = PushRouter.class;
        synchronized (PushRouter.class) {
            listener = pushListener;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (listener != null) {
                final PushListener finalListener = listener;
                PushRouter.getLastTask().continueWith(new Continuation<Void, Void>(){

                    @Override
                    public Void then(Task<Void> task) {
                        finalListener.onPushHandled(pushData, result);
                        return null;
                    }
                }, EXECUTOR);
            }
            return;
        }
    }

    private static PushRouter getInstance() {
        if (instance == null) {
            JSONObject json = PushRouter.migrateV1toV3(LEGACY_ROUTE_LOCATION, STATE_LOCATION);
            if (json == null) {
                json = PushRouter.migrateV2toV3(STATE_LOCATION, STATE_LOCATION);
            }
            if (json == null) {
                json = ParseObject.getDiskObject(Parse.applicationContext, STATE_LOCATION);
            }
            PushRoutes routes = new PushRoutes(json);
            PushHistory history = new PushHistory(MAX_HISTORY_LENGTH, json);
            instance = new PushRouter(STATE_LOCATION, routes, history);
        }
        return instance;
    }

    private static PushRouter reloadInstance(boolean removeExistingState) {
        if (removeExistingState) {
            ParseObject.deleteDiskObject(Parse.applicationContext, LEGACY_ROUTE_LOCATION);
            ParseObject.deleteDiskObject(Parse.applicationContext, STATE_LOCATION);
        }
        instance = null;
        return PushRouter.getInstance();
    }

    static JSONObject migrateV1toV3(String location, String migratedLocation) {
        ParseInstallation installation = ParseInstallation.getCurrentInstallation();
        JSONObject legacyJSON = ParseObject.getDiskObject(Parse.applicationContext, location);
        JSONObject migratedJSON = null;
        if (legacyJSON != null) {
            Parse.logD(TAG, "Migrating push state from V1 to V3: " + legacyJSON);
            ArrayList<String> channels = new ArrayList<String>();
            Iterator keys = legacyJSON.keys();
            while (keys.hasNext()) {
                channels.add((String)keys.next());
            }
            installation.addAllUnique("channels", channels);
            installation.saveEventually();
            try {
                JSONObject json = new JSONObject();
                json.put("version", 3);
                json.put("routes", (Object)legacyJSON);
                json.put("channels", (Object)PushRouter.getChannelsArrayFromInstallation(installation));
                ParseObject.saveDiskObject(Parse.applicationContext, migratedLocation, json);
                migratedJSON = json;
            }
            catch (JSONException e) {
                Parse.logE(TAG, "Unexpected JSONException when serializing upgraded v1 push state: ", e);
            }
            if (!location.equals(migratedLocation)) {
                ParseObject.deleteDiskObject(Parse.applicationContext, location);
            }
        }
        return migratedJSON;
    }

    static JSONObject migrateV2toV3(String location, String migratedLocation) {
        ParseInstallation installation = ParseInstallation.getCurrentInstallation();
        JSONObject json = ParseObject.getDiskObject(Parse.applicationContext, location);
        JSONObject migratedJSON = null;
        if (json != null) {
            if (json.optInt("version") == 2) {
                JSONArray removeChannels;
                Parse.logD(TAG, "Migrating push state from V2 to V3: " + json);
                JSONArray addChannels = json.optJSONArray("addChannels");
                if (addChannels != null) {
                    ArrayList<String> toAdd = new ArrayList<String>();
                    int i = 0;
                    while (i < addChannels.length()) {
                        toAdd.add(addChannels.optString(i));
                        ++i;
                    }
                    installation.addAllUnique("channels", toAdd);
                    installation.saveEventually();
                }
                if ((removeChannels = json.optJSONArray("removeChannels")) != null) {
                    ArrayList<String> toRemove = new ArrayList<String>();
                    int i = 0;
                    while (i < removeChannels.length()) {
                        toRemove.add(removeChannels.optString(i));
                        ++i;
                    }
                    installation.removeAll("channels", toRemove);
                    installation.saveEventually();
                }
                if (json.has("installation")) {
                    ParseDecoder decoder = new ParseDecoder();
                    installation.mergeAfterFetch(json.optJSONObject("installation"), decoder, true);
                    installation.saveEventually();
                }
                try {
                    json.put("version", 3);
                    json.remove("addChannels");
                    json.remove("removeChannels");
                    json.remove("installation");
                    json.put("channels", (Object)PushRouter.getChannelsArrayFromInstallation(installation));
                    ParseObject.saveDiskObject(Parse.applicationContext, migratedLocation, json);
                    migratedJSON = json;
                }
                catch (JSONException e) {
                    Parse.logE(TAG, "Unexpected JSONException when serializing upgraded v2 push state: ", e);
                }
                if (!location.equals(migratedLocation)) {
                    ParseObject.deleteDiskObject(Parse.applicationContext, location);
                }
            } else if (json.optInt("version") == 3) {
                migratedJSON = json;
            }
        }
        return migratedJSON;
    }

    public PushRouter(String stateLocation, PushRoutes routes, PushHistory history) {
        this.stateLocation = stateLocation;
        this.routes = routes;
        this.history = history;
    }

    public JSONObject toJSON() throws JSONException {
        JSONObject json = PushRouter.merge(this.routes.toJSON(), this.history.toJSON());
        json.put("version", 3);
        json.put("channels", (Object)PushRouter.getChannelsArrayFromInstallation(ParseInstallation.getCurrentInstallation()));
        return json;
    }

    private static JSONObject merge(JSONObject ... objects) throws JSONException {
        JSONObject merged = new JSONObject();
        JSONObject[] jSONObjectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            JSONObject object = jSONObjectArray[n2];
            Iterator it = object.keys();
            while (it.hasNext()) {
                String key = (String)it.next();
                Object value = object.get(key);
                merged.put(key, value);
            }
            ++n2;
        }
        return merged;
    }

    public boolean saveStateToDisk() {
        boolean success = false;
        try {
            JSONObject json = this.toJSON();
            ParseObject.saveDiskObject(Parse.applicationContext, this.stateLocation, json);
            success = true;
        }
        catch (JSONException e) {
            Parse.logE(TAG, "Error serializing push state to json", e);
        }
        return success;
    }

    public JSONObject getPushRequestJSON() {
        JSONObject request = new JSONObject();
        ParseInstallation installation = ParseInstallation.getCurrentInstallation();
        try {
            request.put("installation_id", (Object)installation.getInstallationId());
            request.put("oauth_key", (Object)ParseObject.getApplicationId());
            request.put("v", (Object)"a1.4.0");
            String lastReceivedTimestamp = this.history.getLastReceivedTimestamp();
            request.put("last", lastReceivedTimestamp != null ? lastReceivedTimestamp : JSONObject.NULL);
            Set<String> pushIds = this.history.getPushIds();
            if (pushIds.size() > 0) {
                request.put("last_seen", (Object)new JSONArray(pushIds));
            }
            request.putOpt("ignore_after", (Object)this.history.getCutoffTimestamp());
        }
        catch (JSONException e) {
            Parse.logE(TAG, "Unexpected JSONException serializing push handshake", e);
            return null;
        }
        return request;
    }

    public void subscribe(String channel, Class<? extends Activity> cls, int icon) {
        PushRoutes.Route oldRoute;
        ParseInstallation installation = ParseInstallation.getCurrentInstallation();
        PushRoutes.Route route = new PushRoutes.Route(cls.getName(), icon);
        if (!route.equals(oldRoute = this.routes.put(channel, route))) {
            this.saveStateToDisk();
        }
        if (oldRoute == null && channel != null) {
            installation.addUnique("channels", channel);
        }
        installation.saveEventually();
    }

    public void unsubscribe(String channel) {
        PushRoutes.Route oldRoute = this.routes.remove(channel);
        if (oldRoute != null) {
            this.saveStateToDisk();
            if (channel != null) {
                ParseInstallation installation = ParseInstallation.getCurrentInstallation();
                installation.removeAll("channels", Arrays.asList(channel));
                installation.saveEventually();
            }
        }
    }

    public Set<String> getSubscriptions(boolean includeDefaultRoute) {
        HashSet<Object> subscriptions = new HashSet<Object>();
        List channels = ParseInstallation.getCurrentInstallation().getList("channels");
        if (channels != null) {
            subscriptions.addAll(channels);
        }
        subscriptions.addAll(this.routes.getChannels());
        if (!includeDefaultRoute) {
            subscriptions.remove(null);
        }
        return Collections.unmodifiableSet(subscriptions);
    }

    private Date serverInstallationUpdatedAt(JSONObject pushData) {
        Date updatedAt = null;
        String updatedAtString = pushData.optString("installation_updated_at", null);
        if (updatedAtString != null) {
            updatedAt = Parse.stringToDate(updatedAtString);
        }
        return updatedAt;
    }

    private void maybeRefreshInstallation(Date serverUpdatedAt) {
        Date updatedAt = ParseInstallation.getCurrentInstallation().getUpdatedAt();
        if (updatedAt != null && serverUpdatedAt != null && updatedAt.compareTo(serverUpdatedAt) < 0 && this.isRefreshingInstallation.compareAndSet(false, true)) {
            ParseInstallation installation = ParseInstallation.getCurrentInstallation();
            installation.fetchAsync().continueWith(new Continuation<ParseObject, Void>(){

                @Override
                public Void then(Task<ParseObject> task) {
                    PushRouter.this.isRefreshingInstallation.set(false);
                    return null;
                }
            });
        }
    }

    JSONObject convertGcmIntentToJSONObject(Intent intent) {
        JSONObject pushPayload = null;
        if (intent != null) {
            String messageType = intent.getStringExtra("message_type");
            if (messageType != null) {
                Parse.logI(TAG, "Ignored special message type " + messageType + " from GCM via intent" + intent);
            } else {
                String pushDataString = intent.getStringExtra("data");
                String channel = intent.getStringExtra("channel");
                String installationUpdatedAt = intent.getStringExtra("installation_updated_at");
                JSONObject pushData = null;
                boolean ignore = false;
                if (pushDataString != null) {
                    try {
                        pushData = new JSONObject(pushDataString);
                    }
                    catch (JSONException e) {
                        Parse.logE(TAG, "Ignoring push because of JSON exception while processing: " + pushDataString, e);
                        ignore = true;
                    }
                }
                if (!ignore) {
                    try {
                        pushPayload = new JSONObject();
                        pushPayload.putOpt("data", (Object)pushData);
                        pushPayload.putOpt("channel", (Object)channel);
                        pushPayload.putOpt("installation_updated_at", (Object)installationUpdatedAt);
                    }
                    catch (JSONException e) {
                        Parse.logE(TAG, "Ignoring push because of JSON exception while building payload", e);
                        pushPayload = null;
                    }
                }
            }
        }
        return pushPayload;
    }

    public HandlePushResult handleGcmPush(Intent intent) {
        JSONObject pushPayload = this.convertGcmIntentToJSONObject(intent);
        return pushPayload != null ? this.handlePush(pushPayload) : HandlePushResult.INVALID_DATA;
    }

    public HandlePushResult handlePpnsPush(JSONObject pushPayload) {
        HandlePushResult result = HandlePushResult.FAILED_HISTORY_TEST;
        String pushId = pushPayload.optString("push_id", null);
        String timestamp = pushPayload.optString("time", null);
        if (timestamp == null) {
            Parse.logE(TAG, "Ignoring PPNS push missing timestamp");
        } else if (this.history.tryInsertPush(pushId, timestamp)) {
            result = this.handlePush(pushPayload);
            this.saveStateToDisk();
        }
        return result;
    }

    public HandlePushResult handlePush(JSONObject pushPayload) {
        HandlePushResult result = this.handlePushInternal(pushPayload);
        this.maybeRefreshInstallation(this.serverInstallationUpdatedAt(pushPayload));
        PushRouter.noteHandlePushResult(pushPayload, result);
        return result;
    }

    private HandlePushResult handlePushInternal(JSONObject pushPayload) {
        PushRoutes.Route route;
        JSONObject pushData = pushPayload.optJSONObject("data");
        if (pushData == null) {
            pushData = new JSONObject();
        }
        String channel = pushPayload.optString("channel", null);
        String action = pushData.optString("action", null);
        Bundle extras = new Bundle();
        extras.putString("com.parse.Data", pushData.toString());
        extras.putString("com.parse.Channel", channel);
        if (action != null) {
            Intent broadcastIntent = new Intent();
            broadcastIntent.putExtras(extras);
            broadcastIntent.setAction(action);
            Parse.applicationContext.sendBroadcast(broadcastIntent);
            if (!pushData.has("alert") && !pushData.has("title")) {
                return HandlePushResult.BROADCAST_INTENT;
            }
        }
        if ((route = this.routes.get(channel)) == null && channel != null) {
            route = this.routes.get(null);
        }
        if (route == null) {
            Parse.logW(TAG, "Received push that has no handler. Did you call PushService.setDefaultPushCallback or PushService.subscribe? Push payload: " + pushPayload);
            return action != null ? HandlePushResult.BROADCAST_INTENT : HandlePushResult.NO_ROUTE_FOUND;
        }
        Class<? extends Activity> cls = route.getActivityClass();
        int iconId = route.getIconId();
        String title = pushData.optString("title", ManifestInfo.getDisplayName());
        String body = pushData.optString("alert", "Notification received.");
        if (iconId == 0) {
            Parse.logE(TAG, "Ignoring push associated with route " + route + " because iconId is invalid.");
            return HandlePushResult.INVALID_ROUTE;
        }
        if (title == null) {
            Parse.logE(TAG, "Ignoring push " + pushPayload + " because no title could be found.");
            return HandlePushResult.INVALID_ROUTE;
        }
        Context context = Parse.applicationContext;
        ParseNotificationManager.getInstance().showNotification(context, title, body, cls, iconId, extras);
        return action != null ? HandlePushResult.SHOW_NOTIFICATION_AND_BROADCAST_INTENT : HandlePushResult.SHOW_NOTIFICATION;
    }

    static enum HandlePushResult {
        INVALID_DATA,
        FAILED_HISTORY_TEST,
        NO_ROUTE_FOUND,
        INVALID_ROUTE,
        BROADCAST_INTENT,
        SHOW_NOTIFICATION,
        SHOW_NOTIFICATION_AND_BROADCAST_INTENT;

    }

    static interface PushListener {
        public void onPushHandled(JSONObject var1, HandlePushResult var2);
    }
}

