/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import com.parse.Capture;
import com.parse.Continuation;
import com.parse.LogInCallback;
import com.parse.Parse;
import com.parse.ParseAnonymousUtils;
import com.parse.ParseClassName;
import com.parse.ParseCommand;
import com.parse.ParseDecoder;
import com.parse.ParseException;
import com.parse.ParseFieldOperation;
import com.parse.ParseObject;
import com.parse.ParseObjectEncodingStrategy;
import com.parse.ParseQuery;
import com.parse.PointerEncodingStrategy;
import com.parse.RequestPasswordResetCallback;
import com.parse.SignUpCallback;
import com.parse.Task;
import com.parse.TaskQueue;
import com.parse.auth.ParseAuthenticationProvider;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@ParseClassName(value="_User")
public class ParseUser
extends ParseObject {
    private String password;
    private String sessionToken;
    private final JSONObject authData = new JSONObject();
    private final Set<String> linkedServiceNames = new HashSet<String>();
    private final Set<String> readOnlyLinkedServiceNames = Collections.unmodifiableSet(this.linkedServiceNames);
    private boolean isNew;
    private boolean isLazy = false;
    private static ParseUser currentUser;
    private static Map<String, ParseAuthenticationProvider> authenticationProviders;
    private static boolean autoUserEnabled;
    private static final Object currentUserMutex;
    private static boolean currentUserMatchesDisk;
    private static final String CURRENT_USER_FILENAME = "currentUser";
    private boolean isCurrentUser = false;

    static {
        authenticationProviders = new HashMap<String, ParseAuthenticationProvider>();
        currentUserMutex = new Object();
        currentUserMatchesDisk = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ParseUser logInLazyUser(String authType, JSONObject authData) {
        Object object = currentUserMutex;
        synchronized (object) {
            ParseUser user = ParseObject.create(ParseUser.class);
            user.isCurrentUser = true;
            user.isLazy = true;
            try {
                user.authData.put(authType, (Object)authData);
                user.linkedServiceNames.add(authType);
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
            currentUser = user;
            currentUserMatchesDisk = false;
            return user;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isLazy() {
        Object object = this.mutex;
        synchronized (object) {
            return this.isLazy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAuthenticated() {
        Object object = this.mutex;
        synchronized (object) {
            return this.isLazy() || this.sessionToken != null && ParseUser.getCurrentUser() != null && this.getObjectId().equals(ParseUser.getCurrentUser().getObjectId());
        }
    }

    @Override
    public void remove(String key) {
        if ("username".equals(key)) {
            throw new IllegalArgumentException("Can't remove the username key.");
        }
        super.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    JSONObject toJSONObjectForSaving(Map<String, ParseFieldOperation> operations, ParseObjectEncodingStrategy objectEncoder) {
        Object object = this.mutex;
        synchronized (object) {
            JSONObject objectJSON = super.toJSONObjectForSaving(operations, objectEncoder);
            if (this.sessionToken != null) {
                try {
                    objectJSON.put("session_token", (Object)this.sessionToken);
                }
                catch (JSONException e) {
                    throw new RuntimeException("could not encode value for key: sessionToken");
                }
            }
            if (this.authData.length() > 0) {
                try {
                    objectJSON.put("auth_data", (Object)this.authData);
                }
                catch (JSONException e) {
                    throw new RuntimeException("could not attach key: auth_data");
                }
            }
            return objectJSON;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    JSONObject toJSONObjectForDataFile(boolean includeOperations, ParseObjectEncodingStrategy objectEncoder) {
        Object object = this.mutex;
        synchronized (object) {
            JSONObject objectJSON = super.toJSONObjectForDataFile(includeOperations, objectEncoder);
            if (this.sessionToken != null) {
                try {
                    objectJSON.put("session_token", (Object)this.sessionToken);
                }
                catch (JSONException e) {
                    throw new RuntimeException("could not encode value for key: sessionToken");
                }
            }
            if (this.authData.length() > 0) {
                try {
                    objectJSON.put("auth_data", (Object)this.authData);
                }
                catch (JSONException e) {
                    throw new RuntimeException("could not attach key: auth_data");
                }
            }
            return objectJSON;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void mergeFromObject(ParseObject other) {
        Object object = this.mutex;
        synchronized (object) {
            super.mergeFromObject(other);
            if (other instanceof ParseUser) {
                this.sessionToken = ((ParseUser)other).sessionToken;
                this.isNew = ((ParseUser)other).isNew();
                Iterator key = this.authData.keys();
                while (key.hasNext()) {
                    key.next();
                    key.remove();
                }
                key = ((ParseUser)other).authData.keys();
                while (key.hasNext()) {
                    String k = (String)key.next();
                    try {
                        Object v = ((ParseUser)other).authData.get(k);
                        this.authData.put(k, v);
                    }
                    catch (JSONException e) {
                        throw new RuntimeException("A JSONException occurred where one was not possible.");
                    }
                }
                this.linkedServiceNames.clear();
                this.linkedServiceNames.addAll(((ParseUser)other).linkedServiceNames);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void mergeFromServer(JSONObject object, ParseDecoder decoder, boolean completeData) {
        Object object2 = this.mutex;
        synchronized (object2) {
            super.mergeFromServer(object, decoder, completeData);
            if (object.has("session_token")) {
                try {
                    this.sessionToken = object.getString("session_token");
                }
                catch (JSONException e) {
                    throw new RuntimeException(e.getMessage());
                }
            }
            if (object.has("auth_data")) {
                try {
                    JSONObject newData = object.getJSONObject("auth_data");
                    Iterator i = newData.keys();
                    while (i.hasNext()) {
                        String key = (String)i.next();
                        this.authData.put(key, newData.get(key));
                        if (!newData.isNull(key)) {
                            this.linkedServiceNames.add(key);
                        }
                        this.synchronizeAuthData(key);
                    }
                }
                catch (JSONException e) {
                    throw new RuntimeException(e);
                }
            }
            if (object.has("is_new")) {
                try {
                    this.isNew = object.getBoolean("is_new");
                }
                catch (JSONException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isCurrentUser() {
        Object object = this.mutex;
        synchronized (object) {
            return this.isCurrentUser;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanUpAuthData() {
        Object object = this.mutex;
        synchronized (object) {
            if (!this.isCurrentUser()) {
                return;
            }
            Iterator i = this.authData.keys();
            while (i.hasNext()) {
                String key = (String)i.next();
                if (!this.authData.isNull(key)) continue;
                i.remove();
                this.linkedServiceNames.remove(key);
                if (!authenticationProviders.containsKey(key)) continue;
                authenticationProviders.get(key).restoreAuthentication(null);
            }
        }
    }

    public void setUsername(String username) {
        this.put("username", username);
    }

    public String getUsername() {
        return this.getString("username");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPassword(String password) {
        Object object = this.mutex;
        synchronized (object) {
            this.password = password;
            this.dirty = true;
        }
    }

    public void setEmail(String email) {
        this.put("email", email);
    }

    public String getEmail() {
        return this.getString("email");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(String key, Object value) {
        Object object = this.mutex;
        synchronized (object) {
            if ("username".equals(key)) {
                this.stripAnonymity();
            }
            super.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stripAnonymity() {
        Object object = this.mutex;
        synchronized (object) {
            if (ParseAnonymousUtils.isLinked(this)) {
                this.linkedServiceNames.remove("anonymous");
                try {
                    this.authData.put("anonymous", JSONObject.NULL);
                }
                catch (JSONException e) {
                    throw new RuntimeException(e);
                }
                this.dirty = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreAnonymity(JSONObject anonymousData) {
        Object object = this.mutex;
        synchronized (object) {
            if (anonymousData != null) {
                this.linkedServiceNames.add("anonymous");
                try {
                    this.authData.put("anonymous", (Object)anonymousData);
                }
                catch (JSONException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSessionToken() {
        Object object = this.mutex;
        synchronized (object) {
            return this.sessionToken;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void validateSave() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.getObjectId() == null) {
                throw new IllegalArgumentException("Cannot save a ParseUser until it has been signed up. Call signUp first.");
            }
            if (!this.isAuthenticated() && this.isDirty() && !this.getObjectId().equals(ParseUser.getCurrentUser().getObjectId())) {
                throw new IllegalArgumentException("Cannot save a ParseUser that is not authenticated.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Task<Void> saveAsync(Task<Void> toAwait) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.isLazy()) {
                return this.resolveLazinessAsync(toAwait);
            }
            return super.saveAsync(toAwait).onSuccess(new Continuation<Void, Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void then(Task<Void> task) throws Exception {
                    Object object = ParseUser.this.mutex;
                    synchronized (object) {
                        ParseUser.this.cleanUpAuthData();
                        if (ParseUser.this.isCurrentUser()) {
                            ParseUser.saveCurrentUser(ParseUser.this);
                        }
                        return null;
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void validateDelete() {
        Object object = this.mutex;
        synchronized (object) {
            super.validateDelete();
            if (!this.isAuthenticated() && this.isDirty()) {
                throw new IllegalArgumentException("Cannot delete a ParseUser that is not authenticated.");
            }
        }
    }

    public ParseUser fetch() throws ParseException {
        return (ParseUser)super.fetch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    <T extends ParseObject> Task<T> fetchAsync(Task<Void> toAwait) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.isLazy()) {
                return Task.forResult(this);
            }
            return super.fetchAsync(toAwait).onSuccessTask(new Continuation<T, Task<T>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Task<T> then(Task<T> task) throws Exception {
                    Object object = ParseUser.this.mutex;
                    synchronized (object) {
                        ParseUser.this.cleanUpAuthData();
                        if (ParseUser.this.isCurrentUser()) {
                            ParseUser.saveCurrentUser(ParseUser.this);
                        }
                        return task;
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    ParseCommand constructSaveCommand(Map<String, ParseFieldOperation> operations, ParseObjectEncodingStrategy objectEncoder, String sessionToken) throws ParseException {
        Object object = this.mutex;
        synchronized (object) {
            ParseCommand command;
            block6: {
                command = super.constructSaveCommand(operations, objectEncoder, sessionToken);
                if (command != null) break block6;
                return null;
            }
            if (this.password != null) {
                command.put("user_password", this.password);
            }
            if (this.authData.length() > 0) {
                command.put("auth_data", this.authData);
            }
            return command;
        }
    }

    private ParseCommand constructSignUpCommand(Map<String, ParseFieldOperation> operations, String sessionToken) throws ParseException {
        ParseCommand command = this.constructSaveCommand(operations, PointerEncodingStrategy.get(), sessionToken);
        command.setOp("user_signup");
        return command;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ParseCommand constructSignUpOrLoginCommand(Map<String, ParseFieldOperation> operations) throws ParseException {
        Object object = this.mutex;
        synchronized (object) {
            ParseCommand command = new ParseCommand("user_signup_or_login", null);
            JSONObject params = this.toJSONObjectForSaving(operations, PointerEncodingStrategy.get());
            Iterator keys = params.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                try {
                    Object value = params.get(key);
                    if (value instanceof JSONObject) {
                        command.put(key, (JSONObject)value);
                        continue;
                    }
                    if (value instanceof JSONArray) {
                        command.put(key, (JSONArray)value);
                        continue;
                    }
                    if (value instanceof String) {
                        command.put(key, (String)value);
                        continue;
                    }
                    command.put(key, params.getInt(key));
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
            if (this.password != null) {
                command.put("user_password", this.password);
            }
            return command;
        }
    }

    private static ParseCommand constructPasswordResetCommand(String email, String sessionToken) {
        ParseCommand command = new ParseCommand("user_request_password_reset", sessionToken);
        command.put("email", email);
        return command;
    }

    private Task<Void> signUpAsync() {
        return this.taskQueue.enqueue(new Continuation<Void, Task<Void>>(){

            @Override
            public Task<Void> then(Task<Void> task) throws Exception {
                return ParseUser.this.signUpAsync(task);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Task<Void> signUpAsync(Task<Void> toAwait) {
        Object object = this.mutex;
        synchronized (object) {
            final String sessionToken = ParseUser.getCurrentSessionToken();
            if (this.getUsername() == null || this.getUsername().length() == 0) {
                throw new IllegalArgumentException("Username cannot be missing or blank");
            }
            if (this.password == null) {
                throw new IllegalArgumentException("Password cannot be missing or blank");
            }
            if (this.getObjectId() != null) {
                try {
                    if (this.authData.has("anonymous") && this.authData.get("anonymous") == JSONObject.NULL) {
                        return this.saveAsync(toAwait);
                    }
                }
                catch (JSONException e) {
                    throw new RuntimeException(e);
                }
                throw new IllegalArgumentException("Cannot sign up a user that has already signed up.");
            }
            if (this.operationSetQueue.size() > 1) {
                throw new IllegalArgumentException("Cannot sign up a user that is already signing up.");
            }
            if (ParseUser.getCurrentUser() != null && ParseAnonymousUtils.isLinked(ParseUser.getCurrentUser())) {
                if (this.isCurrentUser()) {
                    throw new IllegalArgumentException("Attempt to merge currentUser with itself.");
                }
                this.checkForChangesToMutableContainers();
                ParseUser.getCurrentUser().checkForChangesToMutableContainers();
                ParseUser.getCurrentUser().copyChangesFrom(this);
                ParseUser.getCurrentUser().dirty = true;
                ParseUser.getCurrentUser().setPassword(this.password);
                ParseUser.getCurrentUser().setUsername(this.getUsername());
                this.revert();
                return ParseUser.getCurrentUser().saveAsync(toAwait).onSuccess(new Continuation<Void, Void>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Void then(Task<Void> task) throws Exception {
                        Object object = ParseUser.this.mutex;
                        synchronized (object) {
                            ParseUser.this.mergeFromObject(ParseUser.getCurrentUser());
                            ParseUser.saveCurrentUser(ParseUser.this);
                            return null;
                        }
                    }
                });
            }
            return Task.call(new Callable<Map<String, ParseFieldOperation>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Map<String, ParseFieldOperation> call() throws Exception {
                    Object object = ParseUser.this.mutex;
                    synchronized (object) {
                        return ParseUser.this.startSave();
                    }
                }
            }).continueWithTask(TaskQueue.waitFor(toAwait)).onSuccessTask(new Continuation<Map<String, ParseFieldOperation>, Task<Void>>(){

                @Override
                public Task<Void> then(Task<Map<String, ParseFieldOperation>> task) throws Exception {
                    final Map<String, ParseFieldOperation> operations = task.getResult();
                    final ParseCommand command = ParseUser.this.constructSignUpCommand(operations, sessionToken);
                    if (command == null) {
                        return Task.forResult(null);
                    }
                    return command.performAsync().continueWithTask(new Continuation<Object, Task<Object>>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public Task<Object> then(Task<Object> task) throws Exception {
                            Object object = (this).ParseUser.this.mutex;
                            synchronized (object) {
                                ParseUser.this.handleSaveResult(command.op, (JSONObject)task.getResult(), operations);
                                if (!task.isCancelled() && !task.isFaulted()) {
                                    ParseUser.saveCurrentUser(ParseUser.this);
                                    ParseUser.this.isNew = true;
                                }
                                return task;
                            }
                        }
                    }).makeVoid();
                }
            });
        }
    }

    public void signUp() throws ParseException {
        Parse.waitForTask(this.signUpAsync());
    }

    public void signUpInBackground(SignUpCallback callback) {
        Parse.callbackOnMainThreadAsync(this.signUpAsync(), callback);
    }

    private static ParseCommand constructLogInCommand(String username, String password) {
        ParseCommand command = new ParseCommand("user_login", null);
        command.put("username", username);
        command.put("user_password", password);
        return command;
    }

    private static Task<ParseUser> logInAsync(String username, String password) {
        if (username == null) {
            throw new IllegalArgumentException("Must specify a username for the user to log in with");
        }
        if (password == null) {
            throw new IllegalArgumentException("Must specify a password for the user to log in with");
        }
        ParseCommand command = ParseUser.constructLogInCommand(username, password);
        return command.performAsync().onSuccess(new Continuation<Object, ParseUser>(){

            @Override
            public ParseUser then(Task<Object> task) throws Exception {
                if (task.getResult() == JSONObject.NULL) {
                    throw new ParseException(101, "invalid login credentials");
                }
                ParseUser user = ParseObject.create(ParseUser.class);
                user.handleFetchResult((JSONObject)task.getResult());
                ParseUser.saveCurrentUser(user);
                return user;
            }
        });
    }

    private static ParseCommand constructBecomeCommand(String sessionToken) {
        ParseCommand command = new ParseCommand("client_me", sessionToken);
        return command;
    }

    private static Task<ParseUser> becomeAsync(String sessionToken) {
        if (sessionToken == null) {
            throw new IllegalArgumentException("Must specify a sessionToken for the user to log in with");
        }
        ParseCommand command = ParseUser.constructBecomeCommand(sessionToken);
        return command.performAsync().onSuccess(new Continuation<Object, ParseUser>(){

            @Override
            public ParseUser then(Task<Object> task) throws Exception {
                if (task.getResult() == JSONObject.NULL) {
                    throw new ParseException(101, "invalid login credentials");
                }
                ParseUser user = ParseObject.create(ParseUser.class);
                user.handleFetchResult((JSONObject)task.getResult());
                ParseUser.saveCurrentUser(user);
                return user;
            }
        });
    }

    public static ParseUser logIn(String username, String password) throws ParseException {
        return Parse.waitForTask(ParseUser.logInAsync(username, password));
    }

    public static void logInInBackground(String username, String password, LogInCallback callback) {
        Parse.callbackOnMainThreadAsync(ParseUser.logInAsync(username, password), callback);
    }

    public static ParseUser become(String sessionToken) throws ParseException {
        return Parse.waitForTask(ParseUser.becomeAsync(sessionToken));
    }

    public static void becomeInBackground(String sessionToken, LogInCallback callback) {
        Parse.callbackOnMainThreadAsync(ParseUser.becomeAsync(sessionToken), callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ParseUser getCurrentUser() {
        Object object = currentUserMutex;
        synchronized (object) {
            ParseUser.checkApplicationContext();
            if (currentUser != null) {
                return currentUser;
            }
            if (currentUserMatchesDisk) {
                if (ParseUser.isAutomaticUserEnabled()) {
                    ParseAnonymousUtils.lazyLogIn();
                }
                return currentUser;
            }
            currentUserMatchesDisk = true;
            ParseObject user = ParseUser.getFromDisk(Parse.applicationContext, CURRENT_USER_FILENAME);
            if (user == null) {
                if (ParseUser.isAutomaticUserEnabled()) {
                    ParseAnonymousUtils.lazyLogIn();
                }
                return currentUser;
            }
            currentUser = (ParseUser)user;
            ParseUser.currentUser.isCurrentUser = true;
            return currentUser;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getCurrentSessionToken() {
        Object object = currentUserMutex;
        synchronized (object) {
            if (ParseUser.getCurrentUser() != null) {
                return ParseUser.getCurrentUser().getSessionToken();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveCurrentUser(ParseUser user) {
        Object object = currentUserMutex;
        synchronized (object) {
            ParseUser.checkApplicationContext();
            if (currentUser != user) {
                ParseUser.logOut();
            }
            Object object2 = user.mutex;
            synchronized (object2) {
                user.isCurrentUser = true;
                user.synchronizeAllAuthData();
                user.saveToDisk(Parse.applicationContext, CURRENT_USER_FILENAME);
            }
            currentUserMatchesDisk = true;
            currentUser = user;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logOut() {
        Object object = currentUserMutex;
        synchronized (object) {
            ParseUser.checkApplicationContext();
            if (currentUser != null) {
                Object object2 = ParseUser.currentUser.mutex;
                synchronized (object2) {
                    for (String authType : currentUser.getLinkedServiceNames()) {
                        currentUser.logOutWith(authType);
                    }
                    ParseUser.currentUser.isCurrentUser = false;
                    ParseUser.currentUser.sessionToken = null;
                }
            }
            currentUserMatchesDisk = true;
            currentUser = null;
            File file = new File(Parse.getParseDir(), CURRENT_USER_FILENAME);
            file.delete();
        }
    }

    private static Task<Void> requestPasswordResetAsync(String email) {
        return ParseUser.constructPasswordResetCommand(email, ParseUser.getCurrentSessionToken()).performAsync().makeVoid();
    }

    public static void requestPasswordReset(String email) throws ParseException {
        Parse.waitForTask(ParseUser.requestPasswordResetAsync(email));
    }

    public static void requestPasswordResetInBackground(String email, RequestPasswordResetCallback callback) {
        Parse.callbackOnMainThreadAsync(ParseUser.requestPasswordResetAsync(email), callback);
    }

    private static void checkApplicationContext() {
        if (Parse.applicationContext == null) {
            throw new RuntimeException("You must call Parse.initialize(context, oauthKey, oauthSecret) before using the Parse library.");
        }
    }

    public ParseUser fetchIfNeeded() throws ParseException {
        return (ParseUser)super.fetchIfNeeded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<String> getLinkedServiceNames() {
        Object object = this.mutex;
        synchronized (object) {
            return this.readOnlyLinkedServiceNames;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void synchronizeAuthData(String authType) {
        Object object = this.mutex;
        synchronized (object) {
            if (!this.isCurrentUser()) {
                return;
            }
            if (!authenticationProviders.containsKey(authType)) {
                return;
            }
            ParseAuthenticationProvider provider = authenticationProviders.get(authType);
            boolean success = provider.restoreAuthentication(this.authData.optJSONObject(provider.getAuthType()));
            if (!success) {
                this.unlinkFromAsync(authType);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void synchronizeAllAuthData() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.authData != null) {
                Iterator authTypes = this.authData.keys();
                while (authTypes.hasNext()) {
                    this.synchronizeAuthData((String)authTypes.next());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Task<Void> unlinkFromAsync(final String authType) {
        Object object = this.mutex;
        synchronized (object) {
            if (authType == null) {
                return Task.forResult(null);
            }
            return Task.forResult(null).continueWithTask(new Continuation<Void, Task<Void>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Task<Void> then(Task<Void> task) throws Exception {
                    Object object = ParseUser.this.mutex;
                    synchronized (object) {
                        if (ParseUser.this.authData.has(authType)) {
                            ParseUser.this.authData.put(authType, JSONObject.NULL);
                            ParseUser.this.dirty = true;
                            return ParseUser.this.saveAsync();
                        }
                        return Task.forResult(null);
                    }
                }
            });
        }
    }

    static void registerAuthenticationProvider(ParseAuthenticationProvider provider) {
        authenticationProviders.put(provider.getAuthType(), provider);
        if (ParseUser.getCurrentUser() != null) {
            ParseUser.getCurrentUser().synchronizeAuthData(provider.getAuthType());
        }
    }

    static Task<ParseUser> logInWithAsync(String authType) {
        if (!authenticationProviders.containsKey(authType)) {
            throw new IllegalArgumentException("No authentication provider could be found for the provided authType");
        }
        return ParseUser.logInWithAsync(authenticationProviders.get(authType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Task<ParseUser> logInWithAsync(final String authType, final JSONObject authData) {
        final Continuation<Void, Task<ParseUser>> logInWithTask = new Continuation<Void, Task<ParseUser>>(){

            @Override
            public Task<ParseUser> then(Task<Void> task) throws Exception {
                final ParseUser user = ParseObject.create(ParseUser.class);
                try {
                    user.authData.put(authType, (Object)authData);
                    user.linkedServiceNames.add(authType);
                }
                catch (JSONException e) {
                    throw new ParseException(e);
                }
                final Map<String, ParseFieldOperation> operations = user.startSave();
                final ParseCommand command = user.constructSignUpOrLoginCommand(operations);
                return command.performAsync().continueWithTask(new Continuation<Object, Task<Object>>(){

                    @Override
                    public Task<Object> then(Task<Object> task) throws Exception {
                        user.handleSaveResult(command.op, (JSONObject)task.getResult(), operations);
                        return null;
                    }
                }).onSuccess(new Continuation<Object, ParseUser>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public ParseUser then(Task<Object> task) throws Exception {
                        Object object = user.mutex;
                        synchronized (object) {
                            user.synchronizeAuthData(authType);
                            ParseUser.saveCurrentUser(user);
                            return user;
                        }
                    }
                });
            }
        };
        final ParseUser user = ParseUser.getCurrentUser();
        if (user != null) {
            Object object = user.mutex;
            synchronized (object) {
                if (ParseAnonymousUtils.isLinked(user)) {
                    if (user.isLazy()) {
                        final JSONObject oldAnonymousData = user.authData.optJSONObject("anonymous");
                        return user.taskQueue.enqueue(new Continuation<Void, Task<ParseUser>>(){

                            @Override
                            public Task<ParseUser> then(Task<Void> task) throws Exception {
                                return Task.forResult(null).continueWithTask(new Continuation<Void, Task<Void>>(){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    @Override
                                    public Task<Void> then(Task<Void> task) throws Exception {
                                        Object object = ParseUser.this.mutex;
                                        synchronized (object) {
                                            ParseUser.this.stripAnonymity();
                                            ParseUser.this.authData.put(authType, (Object)authData);
                                            ParseUser.this.linkedServiceNames.add(authType);
                                            return ParseUser.this.resolveLazinessAsync(task);
                                        }
                                    }
                                }).continueWithTask(new Continuation<Void, Task<ParseUser>>(){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    @Override
                                    public Task<ParseUser> then(Task<Void> task) throws Exception {
                                        Object object = ParseUser.this.mutex;
                                        synchronized (object) {
                                            if (task.isFaulted()) {
                                                ParseUser.this.authData.remove(authType);
                                                ParseUser.this.linkedServiceNames.remove(authType);
                                                ParseUser.this.restoreAnonymity(oldAnonymousData);
                                                return Task.forError(task.getError());
                                            }
                                            if (task.isCancelled()) {
                                                return Task.cancelled();
                                            }
                                            return Task.forResult(ParseUser.this);
                                        }
                                    }
                                });
                            }
                        });
                    }
                    return user.linkWithAsync(authType, authData).continueWithTask(new Continuation<Void, Task<ParseUser>>(){

                        @Override
                        public Task<ParseUser> then(Task<Void> task) throws Exception {
                            if (task.isFaulted() && task.getError() instanceof ParseException && ((ParseException)task.getError()).getCode() == 208) {
                                return Task.forResult(null).continueWithTask(logInWithTask);
                            }
                            if (task.isCancelled()) {
                                return Task.cancelled();
                            }
                            return Task.forResult(user);
                        }
                    });
                }
            }
        }
        return Task.forResult(null).continueWithTask(logInWithTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Task<Void> resolveLazinessAsync(Task<Void> toAwait) {
        Object object = this.mutex;
        synchronized (object) {
            if (!this.isLazy()) {
                return Task.forResult(null);
            }
            if (this.linkedServiceNames.size() == 0) {
                return this.signUpAsync(toAwait).onSuccess(new Continuation<Void, Void>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Void then(Task<Void> task) throws Exception {
                        Object object = ParseUser.this.mutex;
                        synchronized (object) {
                            ParseUser.this.isLazy = false;
                            return null;
                        }
                    }
                });
            }
            final Capture operations = new Capture();
            return Task.call(new Callable<Map<String, ParseFieldOperation>>(){

                @Override
                public Map<String, ParseFieldOperation> call() throws Exception {
                    return ParseUser.this.startSave();
                }
            }).onSuccessTask(TaskQueue.waitFor(toAwait)).onSuccessTask(new Continuation<Map<String, ParseFieldOperation>, Task<Object>>(){

                @Override
                public Task<Object> then(Task<Map<String, ParseFieldOperation>> task) throws Exception {
                    operations.set(task.getResult());
                    ParseCommand command = ParseUser.this.constructSignUpOrLoginCommand((Map)operations.get());
                    return command.performAsync();
                }
            }).onSuccess(new Continuation<Object, Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void then(Task<Object> task) throws Exception {
                    Object object = ParseUser.this.mutex;
                    synchronized (object) {
                        JSONObject commandResult = (JSONObject)task.getResult();
                        ParseUser.this.handleSaveResult("create", commandResult, (Map)operations.get());
                        if (commandResult.optBoolean("is_new")) {
                            ParseUser.this.isLazy = false;
                        } else {
                            ParseUser newUser = ParseObject.create(ParseUser.class);
                            newUser.handleFetchResult(commandResult);
                            ParseUser.saveCurrentUser(newUser);
                        }
                        return null;
                    }
                }
            });
        }
    }

    private static Task<JSONObject> authenticateAsync(ParseAuthenticationProvider authenticator) {
        final Task.TaskCompletionSource tcs = Task.create();
        authenticator.authenticate(new ParseAuthenticationProvider.ParseAuthenticationCallback(){

            @Override
            public void onSuccess(JSONObject authData) {
                tcs.setResult(authData);
            }

            @Override
            public void onCancel() {
                tcs.setCancelled();
            }

            @Override
            public void onError(Throwable error) {
                tcs.setError(new ParseException(error));
            }
        });
        return tcs.getTask();
    }

    private static Task<ParseUser> logInWithAsync(final ParseAuthenticationProvider authenticator) {
        return ParseUser.authenticateAsync(authenticator).onSuccessTask(new Continuation<JSONObject, Task<ParseUser>>(){

            @Override
            public Task<ParseUser> then(Task<JSONObject> task) throws Exception {
                return ParseUser.logInWithAsync(authenticator.getAuthType(), task.getResult());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Task<Void> linkWithAsync(final String authType, final JSONObject authData, final Task<Void> toAwait) {
        final JSONObject oldAnonymousData = authData.optJSONObject("anonymous");
        Object object = this.mutex;
        synchronized (object) {
            return Task.call(new Callable<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void call() throws Exception {
                    Object object = ParseUser.this.mutex;
                    synchronized (object) {
                        ParseUser.this.authData.put(authType, (Object)authData);
                        ParseUser.this.linkedServiceNames.add(authType);
                        ParseUser.this.stripAnonymity();
                        ParseUser.this.dirty = true;
                        return null;
                    }
                }
            }).onSuccessTask(new Continuation<Void, Task<Void>>(){

                @Override
                public Task<Void> then(Task<Void> task) throws Exception {
                    return ParseUser.this.saveAsync(toAwait);
                }
            }).continueWithTask(new Continuation<Void, Task<Void>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Task<Void> then(Task<Void> task) throws Exception {
                    Object object = ParseUser.this.mutex;
                    synchronized (object) {
                        if (task.isFaulted() || task.isCancelled()) {
                            ParseUser.this.restoreAnonymity(oldAnonymousData);
                            return task;
                        }
                        ParseUser.this.synchronizeAuthData(authType);
                        return task;
                    }
                }
            });
        }
    }

    Task<Void> linkWithAsync(final String authType, final JSONObject authData) {
        return this.taskQueue.enqueue(new Continuation<Void, Task<Void>>(){

            @Override
            public Task<Void> then(Task<Void> task) throws Exception {
                return ParseUser.this.linkWithAsync(authType, authData, task);
            }
        });
    }

    Task<Void> linkWithAsync(String authType) {
        if (!authenticationProviders.containsKey(authType)) {
            throw new IllegalArgumentException("No authentication provider could be found for the provided authType");
        }
        return this.linkWithAsync(authenticationProviders.get(authType));
    }

    private Task<Void> linkWithAsync(final ParseAuthenticationProvider authenticator) {
        return ParseUser.authenticateAsync(authenticator).onSuccessTask(new Continuation<JSONObject, Task<Void>>(){

            @Override
            public Task<Void> then(Task<JSONObject> task) throws Exception {
                return ParseUser.this.linkWithAsync(authenticator.getAuthType(), task.getResult());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void logOutWith(String authType) {
        Object object = this.mutex;
        synchronized (object) {
            if (authenticationProviders.containsKey(authType) && this.linkedServiceNames.contains(authType)) {
                this.logOutWith(authenticationProviders.get(authType));
            }
        }
    }

    private void logOutWith(ParseAuthenticationProvider provider) {
        provider.deauthenticate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNew() {
        Object object = this.mutex;
        synchronized (object) {
            return this.isNew;
        }
    }

    static void disableAutomaticUser() {
        autoUserEnabled = false;
    }

    public static void enableAutomaticUser() {
        autoUserEnabled = true;
    }

    static boolean isAutomaticUserEnabled() {
        return autoUserEnabled;
    }

    public static ParseQuery<ParseUser> getQuery() {
        return ParseQuery.getQuery(ParseUser.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearCurrentUserFromMemory() {
        Object object = currentUserMutex;
        synchronized (object) {
            currentUser = null;
            currentUserMatchesDisk = false;
        }
    }

    @Override
    boolean needsDefaultACL() {
        return false;
    }
}

