/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import com.parse.Parse;
import com.parse.ParseDeleteOperation;
import com.parse.ParseFieldOperation;
import com.parse.ParseObject;
import com.parse.ParseObjectEncodingStrategy;
import com.parse.ParseRelation;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class ParseRelationOperation<T extends ParseObject>
implements ParseFieldOperation {
    private String targetClass;
    private Set<ParseObject> relationsToAdd;
    private Set<ParseObject> relationsToRemove;

    ParseRelationOperation(Set<T> newRelationsToAdd, Set<T> newRelationsToRemove) {
        this.targetClass = null;
        this.relationsToAdd = new HashSet<ParseObject>();
        this.relationsToRemove = new HashSet<ParseObject>();
        if (newRelationsToAdd != null) {
            for (ParseObject object : newRelationsToAdd) {
                this.addParseObjectToSet(object, this.relationsToAdd);
                if (this.targetClass == null) {
                    this.targetClass = object.getClassName();
                    continue;
                }
                if (this.targetClass.equals(object.getClassName())) continue;
                throw new IllegalArgumentException("All objects in a relation must be of the same class.");
            }
        }
        if (newRelationsToRemove != null) {
            for (ParseObject object : newRelationsToRemove) {
                this.addParseObjectToSet(object, this.relationsToRemove);
                if (this.targetClass == null) {
                    this.targetClass = object.getClassName();
                    continue;
                }
                if (this.targetClass.equals(object.getClassName())) continue;
                throw new IllegalArgumentException("All objects in a relation must be of the same class.");
            }
        }
        if (this.targetClass == null) {
            throw new IllegalArgumentException("Cannot create a ParseRelationOperation with no objects.");
        }
    }

    private ParseRelationOperation(String newTargetClass, Set<ParseObject> newRelationsToAdd, Set<ParseObject> newRelationsToRemove) {
        this.targetClass = newTargetClass;
        this.relationsToAdd = new HashSet<ParseObject>(newRelationsToAdd);
        this.relationsToRemove = new HashSet<ParseObject>(newRelationsToRemove);
    }

    private void addParseObjectToSet(ParseObject obj, Set<ParseObject> set) {
        if (obj.getObjectId() == null) {
            set.add(obj);
            return;
        }
        for (ParseObject existingObject : set) {
            if (!obj.getObjectId().equals(existingObject.getObjectId())) continue;
            set.remove(existingObject);
        }
        set.add(obj);
    }

    private void addAllParseObjectsToSet(Collection<ParseObject> list, Set<ParseObject> set) {
        for (ParseObject obj : list) {
            this.addParseObjectToSet(obj, set);
        }
    }

    private void removeParseObjectFromSet(ParseObject obj, Set<ParseObject> set) {
        if (obj.getObjectId() == null) {
            set.remove(obj);
            return;
        }
        for (ParseObject existingObject : set) {
            if (!obj.getObjectId().equals(existingObject.getObjectId())) continue;
            set.remove(existingObject);
        }
    }

    private void removeAllParseObjectsFromSet(Collection<ParseObject> list, Set<ParseObject> set) {
        for (ParseObject obj : list) {
            this.removeParseObjectFromSet(obj, set);
        }
    }

    String getTargetClass() {
        return this.targetClass;
    }

    JSONArray convertSetToArray(Set<ParseObject> set, ParseObjectEncodingStrategy objectEncoder) throws JSONException {
        JSONArray array = new JSONArray();
        for (ParseObject obj : set) {
            array.put(Parse.encode(obj, objectEncoder));
        }
        return array;
    }

    public JSONObject encode(ParseObjectEncodingStrategy objectEncoder) throws JSONException {
        JSONObject adds = null;
        JSONObject removes = null;
        if (this.relationsToAdd.size() > 0) {
            adds = new JSONObject();
            adds.put("__op", (Object)"AddRelation");
            adds.put("objects", (Object)this.convertSetToArray(this.relationsToAdd, objectEncoder));
        }
        if (this.relationsToRemove.size() > 0) {
            removes = new JSONObject();
            removes.put("__op", (Object)"RemoveRelation");
            removes.put("objects", (Object)this.convertSetToArray(this.relationsToRemove, objectEncoder));
        }
        if (adds != null && removes != null) {
            JSONObject result = new JSONObject();
            result.put("__op", (Object)"Batch");
            JSONArray ops = new JSONArray();
            ops.put((Object)adds);
            ops.put((Object)removes);
            result.put("ops", (Object)ops);
            return result;
        }
        if (adds != null) {
            return adds;
        }
        if (removes != null) {
            return removes;
        }
        throw new IllegalArgumentException("A ParseRelationOperation was created without any data.");
    }

    @Override
    public ParseFieldOperation mergeWithPrevious(ParseFieldOperation previous) {
        if (previous == null) {
            return this;
        }
        if (previous instanceof ParseDeleteOperation) {
            throw new IllegalArgumentException("You can't modify a relation after deleting it.");
        }
        if (previous instanceof ParseRelationOperation) {
            ParseRelationOperation previousOperation = (ParseRelationOperation)previous;
            if (previousOperation.targetClass != null && !previousOperation.targetClass.equals(this.targetClass)) {
                throw new IllegalArgumentException("Related object object must be of class " + previousOperation.targetClass + ", but " + this.targetClass + " was passed in.");
            }
            HashSet<ParseObject> newRelationsToAdd = new HashSet<ParseObject>(previousOperation.relationsToAdd);
            HashSet<ParseObject> newRelationsToRemove = new HashSet<ParseObject>(previousOperation.relationsToRemove);
            if (this.relationsToAdd != null) {
                this.addAllParseObjectsToSet(this.relationsToAdd, newRelationsToAdd);
                this.removeAllParseObjectsFromSet(this.relationsToAdd, newRelationsToRemove);
            }
            if (this.relationsToRemove != null) {
                this.removeAllParseObjectsFromSet(this.relationsToRemove, newRelationsToAdd);
                this.addAllParseObjectsToSet(this.relationsToRemove, newRelationsToRemove);
            }
            return new ParseRelationOperation<T>(this.targetClass, newRelationsToAdd, newRelationsToRemove);
        }
        throw new IllegalArgumentException("Operation is invalid after previous operation.");
    }

    @Override
    public Object apply(Object oldValue, ParseObject object, String key) {
        ParseRelation relation = null;
        if (oldValue == null) {
            relation = new ParseRelation(object, key);
            relation.setTargetClass(this.targetClass);
        } else if (oldValue instanceof ParseRelation) {
            relation = (ParseRelation)oldValue;
            if (this.targetClass != null && relation.getTargetClass() != null) {
                if (!relation.getTargetClass().equals(this.targetClass)) {
                    throw new IllegalArgumentException("Related object object must be of class " + relation.getTargetClass() + ", but " + this.targetClass + " was passed in.");
                }
                relation.setTargetClass(this.targetClass);
            }
        } else {
            throw new IllegalArgumentException("Operation is invalid after previous operation.");
        }
        return relation;
    }
}

