/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.widget.ImageView;
import com.parse.GetDataCallback;
import com.parse.ParseException;
import com.parse.ParseFile;

public class ParseImageView
extends ImageView {
    private ParseFile file;
    private Drawable placeholder;
    private boolean isLoaded = false;

    public ParseImageView(Context context) {
        super(context);
    }

    public ParseImageView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    public ParseImageView(Context context, AttributeSet attributeSet, int defStyle) {
        super(context, attributeSet, defStyle);
    }

    protected void onDetachedFromWindow() {
        if (this.file != null) {
            this.file.cancel();
        }
    }

    public void setImageBitmap(Bitmap bitmap) {
        super.setImageBitmap(bitmap);
        this.isLoaded = true;
    }

    public void setPlaceholder(Drawable placeholder) {
        this.placeholder = placeholder;
        if (!this.isLoaded) {
            this.setImageDrawable(this.placeholder);
        }
    }

    public void setParseFile(ParseFile file) {
        if (this.file != null) {
            this.file.cancel();
        }
        this.isLoaded = false;
        this.file = file;
        this.setImageDrawable(this.placeholder);
    }

    public void loadInBackground() {
        this.loadInBackground(null);
    }

    public void loadInBackground(final GetDataCallback completionCallback) {
        if (this.file == null) {
            if (completionCallback != null) {
                completionCallback.done(null, null);
            }
            return;
        }
        final ParseFile loadingFile = this.file;
        this.file.getDataInBackground(new GetDataCallback(){

            @Override
            public void done(byte[] data, ParseException e) {
                Bitmap bitmap;
                if (ParseImageView.this.file != loadingFile) {
                    return;
                }
                if (data != null && (bitmap = BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length)) != null) {
                    ParseImageView.this.setImageBitmap(bitmap);
                }
                if (completionCallback != null) {
                    completionCallback.done(data, e);
                }
            }
        });
    }
}

