/*
 * Decompiled with CFR 0.152.
 */
package com.parse.oauth;

import android.app.Dialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;

public class OAuth1FlowDialog
extends Dialog {
    private static final FrameLayout.LayoutParams FILL = new FrameLayout.LayoutParams(-1, -1);
    private final String callbackUrl;
    private final String requestUrl;
    private final String serviceUrlIdentifier;
    private final FlowResultHandler handler;
    private ProgressDialog progressDialog;
    private ImageView closeImage;
    private WebView webView;
    private FrameLayout content;

    public OAuth1FlowDialog(Context context, String requestUrl, String callbackUrl, String serviceUrlIdentifier, FlowResultHandler resultHandler) {
        super(context, 0x1030010);
        this.requestUrl = requestUrl;
        this.callbackUrl = callbackUrl;
        this.serviceUrlIdentifier = serviceUrlIdentifier;
        this.handler = resultHandler;
        this.setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                OAuth1FlowDialog.this.handler.onCancel();
            }
        });
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.progressDialog = new ProgressDialog(this.getContext());
        this.progressDialog.requestWindowFeature(1);
        this.progressDialog.setMessage((CharSequence)"Loading...");
        this.requestWindowFeature(1);
        this.content = new FrameLayout(this.getContext());
        this.createCloseImage();
        int webViewMargin = this.closeImage.getDrawable().getIntrinsicWidth() / 2;
        this.setUpWebView(webViewMargin);
        this.content.addView((View)this.closeImage, new ViewGroup.LayoutParams(-2, -2));
        this.addContentView((View)this.content, new ViewGroup.LayoutParams(-1, -1));
    }

    private void createCloseImage() {
        this.closeImage = new ImageView(this.getContext());
        this.closeImage.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                OAuth1FlowDialog.this.cancel();
            }
        });
        Drawable closeDrawable = this.getContext().getResources().getDrawable(17301527);
        this.closeImage.setImageDrawable(closeDrawable);
        this.closeImage.setVisibility(4);
    }

    private void setUpWebView(int margin) {
        LinearLayout webViewContainer = new LinearLayout(this.getContext());
        this.webView = new WebView(this.getContext());
        this.webView.setVerticalScrollBarEnabled(false);
        this.webView.setHorizontalScrollBarEnabled(false);
        this.webView.setWebViewClient((WebViewClient)new OAuth1WebViewClient());
        this.webView.getSettings().setJavaScriptEnabled(true);
        this.webView.loadUrl(this.requestUrl);
        this.webView.setLayoutParams((ViewGroup.LayoutParams)FILL);
        this.webView.setVisibility(4);
        webViewContainer.setPadding(margin, margin, margin, margin);
        webViewContainer.addView((View)this.webView);
        this.content.addView((View)webViewContainer);
    }

    public static interface FlowResultHandler {
        public void onCancel();

        public void onError(int var1, String var2, String var3);

        public void onComplete(String var1);
    }

    private class OAuth1WebViewClient
    extends WebViewClient {
        private OAuth1WebViewClient() {
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            if (url.startsWith(OAuth1FlowDialog.this.callbackUrl)) {
                OAuth1FlowDialog.this.dismiss();
                OAuth1FlowDialog.this.handler.onComplete(url);
                return true;
            }
            if (url.contains(OAuth1FlowDialog.this.serviceUrlIdentifier)) {
                return false;
            }
            OAuth1FlowDialog.this.getContext().startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)url)));
            return true;
        }

        public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
            super.onReceivedError(view, errorCode, description, failingUrl);
            OAuth1FlowDialog.this.dismiss();
            OAuth1FlowDialog.this.handler.onError(errorCode, description, failingUrl);
        }

        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            super.onPageStarted(view, url, favicon);
            OAuth1FlowDialog.this.progressDialog.show();
        }

        public void onPageFinished(WebView view, String url) {
            super.onPageFinished(view, url);
            try {
                OAuth1FlowDialog.this.progressDialog.dismiss();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            OAuth1FlowDialog.this.content.setBackgroundColor(0);
            OAuth1FlowDialog.this.webView.setVisibility(0);
            OAuth1FlowDialog.this.closeImage.setVisibility(0);
        }
    }
}

