/*
 * Decompiled with CFR 0.152.
 */
package com.parse.codec.binary;

import com.parse.codec.binary.BaseNCodec;
import com.parse.codec.binary.StringUtils;

public class Base32
extends BaseNCodec {
    private static final int BITS_PER_ENCODED_BYTE = 5;
    private static final int BYTES_PER_ENCODED_BLOCK = 8;
    private static final int BYTES_PER_UNENCODED_BLOCK = 5;
    private static final byte[] CHUNK_SEPARATOR = new byte[]{13, 10};
    private static final byte[] DECODE_TABLE;
    private static final byte[] ENCODE_TABLE;
    private static final byte[] HEX_DECODE_TABLE;
    private static final byte[] HEX_ENCODE_TABLE;
    private static final int MASK_5BITS = 31;
    private long bitWorkArea;
    private final int decodeSize;
    private final byte[] decodeTable;
    private final int encodeSize;
    private final byte[] encodeTable;
    private final byte[] lineSeparator;

    static {
        byte[] byArray = new byte[91];
        byArray[0] = -1;
        byArray[1] = -1;
        byArray[2] = -1;
        byArray[3] = -1;
        byArray[4] = -1;
        byArray[5] = -1;
        byArray[6] = -1;
        byArray[7] = -1;
        byArray[8] = -1;
        byArray[9] = -1;
        byArray[10] = -1;
        byArray[11] = -1;
        byArray[12] = -1;
        byArray[13] = -1;
        byArray[14] = -1;
        byArray[15] = -1;
        byArray[16] = -1;
        byArray[17] = -1;
        byArray[18] = -1;
        byArray[19] = -1;
        byArray[20] = -1;
        byArray[21] = -1;
        byArray[22] = -1;
        byArray[23] = -1;
        byArray[24] = -1;
        byArray[25] = -1;
        byArray[26] = -1;
        byArray[27] = -1;
        byArray[28] = -1;
        byArray[29] = -1;
        byArray[30] = -1;
        byArray[31] = -1;
        byArray[32] = -1;
        byArray[33] = -1;
        byArray[34] = -1;
        byArray[35] = -1;
        byArray[36] = -1;
        byArray[37] = -1;
        byArray[38] = -1;
        byArray[39] = -1;
        byArray[40] = -1;
        byArray[41] = -1;
        byArray[42] = -1;
        byArray[43] = -1;
        byArray[44] = -1;
        byArray[45] = -1;
        byArray[46] = -1;
        byArray[47] = 63;
        byArray[48] = -1;
        byArray[49] = -1;
        byArray[50] = 26;
        byArray[51] = 27;
        byArray[52] = 28;
        byArray[53] = 29;
        byArray[54] = 30;
        byArray[55] = 31;
        byArray[56] = -1;
        byArray[57] = -1;
        byArray[58] = -1;
        byArray[59] = -1;
        byArray[60] = -1;
        byArray[61] = -1;
        byArray[62] = -1;
        byArray[63] = -1;
        byArray[64] = -1;
        byArray[66] = 1;
        byArray[67] = 2;
        byArray[68] = 3;
        byArray[69] = 4;
        byArray[70] = 5;
        byArray[71] = 6;
        byArray[72] = 7;
        byArray[73] = 8;
        byArray[74] = 9;
        byArray[75] = 10;
        byArray[76] = 11;
        byArray[77] = 12;
        byArray[78] = 13;
        byArray[79] = 14;
        byArray[80] = 15;
        byArray[81] = 16;
        byArray[82] = 17;
        byArray[83] = 18;
        byArray[84] = 19;
        byArray[85] = 20;
        byArray[86] = 21;
        byArray[87] = 22;
        byArray[88] = 23;
        byArray[89] = 24;
        byArray[90] = 25;
        DECODE_TABLE = byArray;
        ENCODE_TABLE = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 50, 51, 52, 53, 54, 55};
        byte[] byArray2 = new byte[88];
        byArray2[0] = -1;
        byArray2[1] = -1;
        byArray2[2] = -1;
        byArray2[3] = -1;
        byArray2[4] = -1;
        byArray2[5] = -1;
        byArray2[6] = -1;
        byArray2[7] = -1;
        byArray2[8] = -1;
        byArray2[9] = -1;
        byArray2[10] = -1;
        byArray2[11] = -1;
        byArray2[12] = -1;
        byArray2[13] = -1;
        byArray2[14] = -1;
        byArray2[15] = -1;
        byArray2[16] = -1;
        byArray2[17] = -1;
        byArray2[18] = -1;
        byArray2[19] = -1;
        byArray2[20] = -1;
        byArray2[21] = -1;
        byArray2[22] = -1;
        byArray2[23] = -1;
        byArray2[24] = -1;
        byArray2[25] = -1;
        byArray2[26] = -1;
        byArray2[27] = -1;
        byArray2[28] = -1;
        byArray2[29] = -1;
        byArray2[30] = -1;
        byArray2[31] = -1;
        byArray2[32] = -1;
        byArray2[33] = -1;
        byArray2[34] = -1;
        byArray2[35] = -1;
        byArray2[36] = -1;
        byArray2[37] = -1;
        byArray2[38] = -1;
        byArray2[39] = -1;
        byArray2[40] = -1;
        byArray2[41] = -1;
        byArray2[42] = -1;
        byArray2[43] = -1;
        byArray2[44] = -1;
        byArray2[45] = -1;
        byArray2[46] = -1;
        byArray2[47] = 63;
        byArray2[49] = 1;
        byArray2[50] = 2;
        byArray2[51] = 3;
        byArray2[52] = 4;
        byArray2[53] = 5;
        byArray2[54] = 6;
        byArray2[55] = 7;
        byArray2[56] = 8;
        byArray2[57] = 9;
        byArray2[58] = -1;
        byArray2[59] = -1;
        byArray2[60] = -1;
        byArray2[61] = -1;
        byArray2[62] = -1;
        byArray2[63] = -1;
        byArray2[64] = -1;
        byArray2[65] = 10;
        byArray2[66] = 11;
        byArray2[67] = 12;
        byArray2[68] = 13;
        byArray2[69] = 14;
        byArray2[70] = 15;
        byArray2[71] = 16;
        byArray2[72] = 17;
        byArray2[73] = 18;
        byArray2[74] = 19;
        byArray2[75] = 20;
        byArray2[76] = 21;
        byArray2[77] = 22;
        byArray2[78] = 23;
        byArray2[79] = 24;
        byArray2[80] = 25;
        byArray2[81] = 26;
        byArray2[82] = 27;
        byArray2[83] = 28;
        byArray2[84] = 29;
        byArray2[85] = 30;
        byArray2[86] = 31;
        byArray2[87] = 32;
        HEX_DECODE_TABLE = byArray2;
        HEX_ENCODE_TABLE = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86};
    }

    public Base32() {
        this(false);
    }

    public Base32(boolean useHex) {
        this(0, null, useHex);
    }

    public Base32(int lineLength) {
        this(lineLength, CHUNK_SEPARATOR);
    }

    public Base32(int lineLength, byte[] lineSeparator) {
        this(lineLength, lineSeparator, false);
    }

    public Base32(int lineLength, byte[] lineSeparator, boolean useHex) {
        super(5, 8, lineLength, lineSeparator == null ? 0 : lineSeparator.length);
        if (useHex) {
            this.encodeTable = HEX_ENCODE_TABLE;
            this.decodeTable = HEX_DECODE_TABLE;
        } else {
            this.encodeTable = ENCODE_TABLE;
            this.decodeTable = DECODE_TABLE;
        }
        if (lineLength > 0) {
            if (lineSeparator == null) {
                throw new IllegalArgumentException("lineLength " + lineLength + " > 0, but lineSeparator is null");
            }
            if (this.containsAlphabetOrPad(lineSeparator)) {
                String sep = StringUtils.newStringUtf8(lineSeparator);
                throw new IllegalArgumentException("lineSeparator must not contain Base32 characters: [" + sep + "]");
            }
            this.encodeSize = 8 + lineSeparator.length;
            this.lineSeparator = new byte[lineSeparator.length];
            System.arraycopy(lineSeparator, 0, this.lineSeparator, 0, lineSeparator.length);
        } else {
            this.encodeSize = 8;
            this.lineSeparator = null;
        }
        this.decodeSize = this.encodeSize - 1;
    }

    void decode(byte[] in, int inPos, int inAvail) {
        if (this.eof) {
            return;
        }
        if (inAvail < 0) {
            this.eof = true;
        }
        int i = 0;
        while (i < inAvail) {
            byte result;
            byte b;
            if ((b = in[inPos++]) == 61) {
                this.eof = true;
                break;
            }
            this.ensureBufferSize(this.decodeSize);
            if (b >= 0 && b < this.decodeTable.length && (result = this.decodeTable[b]) >= 0) {
                this.modulus = (this.modulus + 1) % 8;
                this.bitWorkArea = (this.bitWorkArea << 5) + (long)result;
                if (this.modulus == 0) {
                    this.buffer[this.pos++] = (byte)(this.bitWorkArea >> 32 & 0xFFL);
                    this.buffer[this.pos++] = (byte)(this.bitWorkArea >> 24 & 0xFFL);
                    this.buffer[this.pos++] = (byte)(this.bitWorkArea >> 16 & 0xFFL);
                    this.buffer[this.pos++] = (byte)(this.bitWorkArea >> 8 & 0xFFL);
                    this.buffer[this.pos++] = (byte)(this.bitWorkArea & 0xFFL);
                }
            }
            ++i;
        }
        if (this.eof && this.modulus >= 2) {
            this.ensureBufferSize(this.decodeSize);
            switch (this.modulus) {
                case 2: {
                    this.buffer[this.pos++] = (byte)(this.bitWorkArea >> 2 & 0xFFL);
                    break;
                }
                case 3: {
                    this.buffer[this.pos++] = (byte)(this.bitWorkArea >> 7 & 0xFFL);
                    break;
                }
                case 4: {
                    this.bitWorkArea >>= 4;
                    this.buffer[this.pos++] = (byte)(this.bitWorkArea >> 8 & 0xFFL);
                    this.buffer[this.pos++] = (byte)(this.bitWorkArea & 0xFFL);
                    break;
                }
                case 5: {
                    this.bitWorkArea >>= 1;
                    this.buffer[this.pos++] = (byte)(this.bitWorkArea >> 16 & 0xFFL);
                    this.buffer[this.pos++] = (byte)(this.bitWorkArea >> 8 & 0xFFL);
                    this.buffer[this.pos++] = (byte)(this.bitWorkArea & 0xFFL);
                    break;
                }
                case 6: {
                    this.bitWorkArea >>= 6;
                    this.buffer[this.pos++] = (byte)(this.bitWorkArea >> 16 & 0xFFL);
                    this.buffer[this.pos++] = (byte)(this.bitWorkArea >> 8 & 0xFFL);
                    this.buffer[this.pos++] = (byte)(this.bitWorkArea & 0xFFL);
                    break;
                }
                case 7: {
                    this.bitWorkArea >>= 3;
                    this.buffer[this.pos++] = (byte)(this.bitWorkArea >> 24 & 0xFFL);
                    this.buffer[this.pos++] = (byte)(this.bitWorkArea >> 16 & 0xFFL);
                    this.buffer[this.pos++] = (byte)(this.bitWorkArea >> 8 & 0xFFL);
                    this.buffer[this.pos++] = (byte)(this.bitWorkArea & 0xFFL);
                }
            }
        }
    }

    void encode(byte[] in, int inPos, int inAvail) {
        if (this.eof) {
            return;
        }
        if (inAvail < 0) {
            this.eof = true;
            if (this.modulus == 0 && this.lineLength == 0) {
                return;
            }
            this.ensureBufferSize(this.encodeSize);
            int savedPos = this.pos;
            switch (this.modulus) {
                case 1: {
                    this.buffer[this.pos++] = this.encodeTable[(int)(this.bitWorkArea >> 3) & 0x1F];
                    this.buffer[this.pos++] = this.encodeTable[(int)(this.bitWorkArea << 2) & 0x1F];
                    this.buffer[this.pos++] = 61;
                    this.buffer[this.pos++] = 61;
                    this.buffer[this.pos++] = 61;
                    this.buffer[this.pos++] = 61;
                    this.buffer[this.pos++] = 61;
                    this.buffer[this.pos++] = 61;
                    break;
                }
                case 2: {
                    this.buffer[this.pos++] = this.encodeTable[(int)(this.bitWorkArea >> 11) & 0x1F];
                    this.buffer[this.pos++] = this.encodeTable[(int)(this.bitWorkArea >> 6) & 0x1F];
                    this.buffer[this.pos++] = this.encodeTable[(int)(this.bitWorkArea >> 1) & 0x1F];
                    this.buffer[this.pos++] = this.encodeTable[(int)(this.bitWorkArea << 4) & 0x1F];
                    this.buffer[this.pos++] = 61;
                    this.buffer[this.pos++] = 61;
                    this.buffer[this.pos++] = 61;
                    this.buffer[this.pos++] = 61;
                    break;
                }
                case 3: {
                    this.buffer[this.pos++] = this.encodeTable[(int)(this.bitWorkArea >> 19) & 0x1F];
                    this.buffer[this.pos++] = this.encodeTable[(int)(this.bitWorkArea >> 14) & 0x1F];
                    this.buffer[this.pos++] = this.encodeTable[(int)(this.bitWorkArea >> 9) & 0x1F];
                    this.buffer[this.pos++] = this.encodeTable[(int)(this.bitWorkArea >> 4) & 0x1F];
                    this.buffer[this.pos++] = this.encodeTable[(int)(this.bitWorkArea << 1) & 0x1F];
                    this.buffer[this.pos++] = 61;
                    this.buffer[this.pos++] = 61;
                    this.buffer[this.pos++] = 61;
                    break;
                }
                case 4: {
                    this.buffer[this.pos++] = this.encodeTable[(int)(this.bitWorkArea >> 27) & 0x1F];
                    this.buffer[this.pos++] = this.encodeTable[(int)(this.bitWorkArea >> 22) & 0x1F];
                    this.buffer[this.pos++] = this.encodeTable[(int)(this.bitWorkArea >> 17) & 0x1F];
                    this.buffer[this.pos++] = this.encodeTable[(int)(this.bitWorkArea >> 12) & 0x1F];
                    this.buffer[this.pos++] = this.encodeTable[(int)(this.bitWorkArea >> 7) & 0x1F];
                    this.buffer[this.pos++] = this.encodeTable[(int)(this.bitWorkArea >> 2) & 0x1F];
                    this.buffer[this.pos++] = this.encodeTable[(int)(this.bitWorkArea << 3) & 0x1F];
                    this.buffer[this.pos++] = 61;
                }
            }
            this.currentLinePos += this.pos - savedPos;
            if (this.lineLength > 0 && this.currentLinePos > 0) {
                System.arraycopy(this.lineSeparator, 0, this.buffer, this.pos, this.lineSeparator.length);
                this.pos += this.lineSeparator.length;
            }
        } else {
            int i = 0;
            while (i < inAvail) {
                this.ensureBufferSize(this.encodeSize);
                this.modulus = (this.modulus + 1) % 5;
                int b = in[inPos++];
                if (b < 0) {
                    b += 256;
                }
                this.bitWorkArea = (this.bitWorkArea << 8) + (long)b;
                if (this.modulus == 0) {
                    this.buffer[this.pos++] = this.encodeTable[(int)(this.bitWorkArea >> 35) & 0x1F];
                    this.buffer[this.pos++] = this.encodeTable[(int)(this.bitWorkArea >> 30) & 0x1F];
                    this.buffer[this.pos++] = this.encodeTable[(int)(this.bitWorkArea >> 25) & 0x1F];
                    this.buffer[this.pos++] = this.encodeTable[(int)(this.bitWorkArea >> 20) & 0x1F];
                    this.buffer[this.pos++] = this.encodeTable[(int)(this.bitWorkArea >> 15) & 0x1F];
                    this.buffer[this.pos++] = this.encodeTable[(int)(this.bitWorkArea >> 10) & 0x1F];
                    this.buffer[this.pos++] = this.encodeTable[(int)(this.bitWorkArea >> 5) & 0x1F];
                    this.buffer[this.pos++] = this.encodeTable[(int)this.bitWorkArea & 0x1F];
                    this.currentLinePos += 8;
                    if (this.lineLength > 0 && this.lineLength <= this.currentLinePos) {
                        System.arraycopy(this.lineSeparator, 0, this.buffer, this.pos, this.lineSeparator.length);
                        this.pos += this.lineSeparator.length;
                        this.currentLinePos = 0;
                    }
                }
                ++i;
            }
        }
    }

    public boolean isInAlphabet(byte octet) {
        return octet >= 0 && octet < this.decodeTable.length && this.decodeTable[octet] != -1;
    }
}

