/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import com.parse.Capture;
import com.parse.Continuation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Task<TResult> {
    private static final ExecutorService defaultExecutor = Executors.newCachedThreadPool();
    private static final Executor immediateExecutor = new Executor(){
        private static final int MAX_DEPTH = 15;
        private ThreadLocal<Integer> executionDepth = new ThreadLocal();

        private int incrementDepth() {
            Integer oldDepth = this.executionDepth.get();
            if (oldDepth == null) {
                oldDepth = 0;
            }
            int newDepth = oldDepth + 1;
            this.executionDepth.set(newDepth);
            return newDepth;
        }

        private int decrementDepth() {
            int newDepth;
            Integer oldDepth = this.executionDepth.get();
            if (oldDepth == null) {
                oldDepth = 0;
            }
            if ((newDepth = oldDepth - 1) == 0) {
                this.executionDepth.remove();
            } else {
                this.executionDepth.set(newDepth);
            }
            return newDepth;
        }

        public void execute(Runnable command) {
            int depth = this.incrementDepth();
            try {
                if (depth <= 15) {
                    command.run();
                } else {
                    defaultExecutor.execute(command);
                }
            }
            finally {
                this.decrementDepth();
            }
        }
    };
    private final Object lock = new Object();
    private boolean complete;
    private boolean cancelled;
    private TResult result;
    private Exception error;
    private List<Continuation<TResult, Void>> continuations = new ArrayList<Continuation<TResult, Void>>();

    private Task() {
    }

    public static <TResult> TaskCompletionSource create() {
        Task<TResult> task;
        Task<TResult> task2 = task = new Task<TResult>();
        task2.getClass();
        return task2.new TaskCompletionSource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCompleted() {
        Object object = this.lock;
        synchronized (object) {
            return this.complete;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCancelled() {
        Object object = this.lock;
        synchronized (object) {
            return this.cancelled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFaulted() {
        Object object = this.lock;
        synchronized (object) {
            return this.error != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TResult getResult() {
        Object object = this.lock;
        synchronized (object) {
            return this.result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Exception getError() {
        Object object = this.lock;
        synchronized (object) {
            return this.error;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForCompletion() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isCompleted()) {
                this.lock.wait();
            }
        }
    }

    public static <TResult> Task<TResult> forResult(TResult value) {
        TaskCompletionSource tcs = Task.create();
        tcs.setResult(value);
        return tcs.getTask();
    }

    public static <TResult> Task<TResult> forError(Exception error) {
        TaskCompletionSource tcs = Task.create();
        tcs.setError(error);
        return tcs.getTask();
    }

    public static <TResult> Task<TResult> cancelled() {
        TaskCompletionSource tcs = Task.create();
        tcs.setCancelled();
        return tcs.getTask();
    }

    public <TOut> Task<TOut> cast() {
        Task task = this;
        return task;
    }

    public Task<Void> makeVoid() {
        return this.continueWithTask(new Continuation<TResult, Task<Void>>(){

            @Override
            public Task<Void> then(Task<TResult> task) throws Exception {
                if (task.isCancelled()) {
                    return Task.cancelled();
                }
                if (task.isFaulted()) {
                    return Task.forError(task.getError());
                }
                return Task.forResult(null);
            }
        });
    }

    public static <TResult> Task<TResult> callInBackground(Callable<TResult> callable) {
        return Task.call(callable, defaultExecutor);
    }

    public static <TResult> Task<TResult> call(final Callable<TResult> callable, Executor executor) {
        final TaskCompletionSource tcs = Task.create();
        executor.execute(new Runnable(){

            public void run() {
                try {
                    tcs.setResult(callable.call());
                }
                catch (Exception e) {
                    tcs.setError(e);
                }
            }
        });
        return tcs.getTask();
    }

    public static <TResult> Task<TResult> call(Callable<TResult> callable) {
        return Task.call(callable, immediateExecutor);
    }

    public static Task<Void> whenAll(Collection<? extends Task<?>> tasks) {
        final TaskCompletionSource tcs = Task.create();
        if (tasks.size() == 0) {
            tcs.setResult(null);
        } else {
            final AtomicInteger count = new AtomicInteger(tasks.size());
            Iterator<Task<?>> iterator = tasks.iterator();
            while (iterator.hasNext()) {
                Task<?> task;
                Task<?> t = task = iterator.next();
                t.continueWith(new Continuation<Object, Void>(){

                    @Override
                    public Void then(Task<Object> task) {
                        if (count.decrementAndGet() == 0) {
                            tcs.setResult(null);
                        }
                        return null;
                    }
                });
            }
        }
        return tcs.getTask();
    }

    public Task<Void> continueWhile(Callable<Boolean> predicate, Continuation<Void, Task<Void>> continuation) {
        return this.continueWhile(predicate, continuation, immediateExecutor);
    }

    public Task<Void> continueWhile(final Callable<Boolean> predicate, final Continuation<Void, Task<Void>> continuation, final Executor executor) {
        final Capture<5> predicateContinuation = new Capture<5>();
        predicateContinuation.set(new Continuation<Void, Task<Void>>(){

            @Override
            public Task<Void> then(Task<Void> task) throws Exception {
                if (((Boolean)predicate.call()).booleanValue()) {
                    return Task.forResult(null).onSuccessTask(continuation, executor).onSuccessTask((Continuation)predicateContinuation.get(), executor);
                }
                return Task.forResult(null);
            }
        });
        return this.makeVoid().continueWithTask((Continuation)predicateContinuation.get(), executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <TContinuationResult> Task<TContinuationResult> continueWith(final Continuation<TResult, TContinuationResult> continuation, final Executor executor) {
        boolean completed = false;
        final TaskCompletionSource tcs = Task.create();
        Object object = this.lock;
        synchronized (object) {
            completed = this.isCompleted();
            if (!completed) {
                this.continuations.add(new Continuation<TResult, Void>(){

                    @Override
                    public Void then(Task<TResult> task) {
                        Task.completeImmediately(tcs, continuation, task, executor);
                        return null;
                    }
                });
            }
        }
        if (completed) {
            Task.completeImmediately(tcs, continuation, this, executor);
        }
        return tcs.getTask();
    }

    public <TContinuationResult> Task<TContinuationResult> continueWith(Continuation<TResult, TContinuationResult> continuation) {
        return this.continueWith(continuation, immediateExecutor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <TContinuationResult> Task<TContinuationResult> continueWithTask(final Continuation<TResult, Task<TContinuationResult>> continuation, final Executor executor) {
        boolean completed = false;
        final TaskCompletionSource tcs = Task.create();
        Object object = this.lock;
        synchronized (object) {
            completed = this.isCompleted();
            if (!completed) {
                this.continuations.add(new Continuation<TResult, Void>(){

                    @Override
                    public Void then(Task<TResult> task) {
                        Task.completeAfterTask(tcs, continuation, task, executor);
                        return null;
                    }
                });
            }
        }
        if (completed) {
            Task.completeAfterTask(tcs, continuation, this, executor);
        }
        return tcs.getTask();
    }

    public <TContinuationResult> Task<TContinuationResult> continueWithTask(Continuation<TResult, Task<TContinuationResult>> continuation) {
        return this.continueWithTask(continuation, immediateExecutor);
    }

    public <TContinuationResult> Task<TContinuationResult> onSuccess(final Continuation<TResult, TContinuationResult> continuation, Executor executor) {
        return this.continueWithTask(new Continuation<TResult, Task<TContinuationResult>>(){

            @Override
            public Task<TContinuationResult> then(Task<TResult> task) {
                if (task.isFaulted()) {
                    return Task.forError(task.getError());
                }
                if (task.isCancelled()) {
                    return Task.cancelled();
                }
                return task.continueWith(continuation);
            }
        }, executor);
    }

    public <TContinuationResult> Task<TContinuationResult> onSuccess(Continuation<TResult, TContinuationResult> continuation) {
        return this.onSuccess(continuation, immediateExecutor);
    }

    public <TContinuationResult> Task<TContinuationResult> onSuccessTask(final Continuation<TResult, Task<TContinuationResult>> continuation, Executor executor) {
        return this.continueWithTask(new Continuation<TResult, Task<TContinuationResult>>(){

            @Override
            public Task<TContinuationResult> then(Task<TResult> task) {
                if (task.isFaulted()) {
                    return Task.forError(task.getError());
                }
                if (task.isCancelled()) {
                    return Task.cancelled();
                }
                return task.continueWithTask(continuation);
            }
        }, executor);
    }

    public <TContinuationResult> Task<TContinuationResult> onSuccessTask(Continuation<TResult, Task<TContinuationResult>> continuation) {
        return this.onSuccessTask(continuation, immediateExecutor);
    }

    private static <TContinuationResult, TResult> void completeImmediately(final TaskCompletionSource tcs, final Continuation<TResult, TContinuationResult> continuation, final Task<TResult> task, Executor executor) {
        executor.execute(new Runnable(){

            public void run() {
                try {
                    Object result = continuation.then(task);
                    tcs.setResult(result);
                }
                catch (Exception e) {
                    tcs.setError(e);
                }
            }
        });
    }

    private static <TContinuationResult, TResult> void completeAfterTask(final TaskCompletionSource tcs, final Continuation<TResult, Task<TContinuationResult>> continuation, final Task<TResult> task, Executor executor) {
        executor.execute(new Runnable(){

            public void run() {
                try {
                    Task result = (Task)continuation.then(task);
                    if (result == null) {
                        tcs.setResult(null);
                    } else {
                        result.continueWith(new Continuation<TContinuationResult, Void>(){

                            @Override
                            public Void then(Task<TContinuationResult> task) {
                                if (task.isCancelled()) {
                                    tcs.setCancelled();
                                } else if (task.isFaulted()) {
                                    tcs.setError(task.getError());
                                } else {
                                    tcs.setResult(task.getResult());
                                }
                                return null;
                            }
                        });
                    }
                }
                catch (Exception e) {
                    tcs.setError(e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runContinuations() {
        Object object = this.lock;
        synchronized (object) {
            for (Continuation<TResult, Void> continuation : this.continuations) {
                try {
                    continuation.then(this);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            this.continuations = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TaskCompletionSource {
        private TaskCompletionSource() {
        }

        public Task<TResult> getTask() {
            return Task.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean trySetCancelled() {
            Object object = Task.this.lock;
            synchronized (object) {
                block4: {
                    if (!Task.this.complete) break block4;
                    return false;
                }
                Task.this.complete = true;
                Task.this.cancelled = true;
                Task.this.lock.notifyAll();
                Task.this.runContinuations();
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean trySetResult(TResult result) {
            Object object = Task.this.lock;
            synchronized (object) {
                block4: {
                    if (!Task.this.complete) break block4;
                    return false;
                }
                Task.this.complete = true;
                Task.this.result = result;
                Task.this.lock.notifyAll();
                Task.this.runContinuations();
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean trySetError(Exception error) {
            Object object = Task.this.lock;
            synchronized (object) {
                block4: {
                    if (!Task.this.complete) break block4;
                    return false;
                }
                Task.this.complete = true;
                Task.this.error = error;
                Task.this.lock.notifyAll();
                Task.this.runContinuations();
                return true;
            }
        }

        public void setCancelled() {
            if (!this.trySetCancelled()) {
                throw new IllegalStateException("Cannot cancel a completed task.");
            }
        }

        public void setResult(TResult result) {
            if (!this.trySetResult(result)) {
                throw new IllegalStateException("Cannot set the result of a completed task.");
            }
        }

        public void setError(Exception error) {
            if (!this.trySetError(error)) {
                throw new IllegalStateException("Cannot set the error on a completed task.");
            }
        }
    }
}

