/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import com.parse.Parse;
import com.parse.ParseDeleteOperation;
import com.parse.ParseFieldOperation;
import com.parse.ParseFieldOperations;
import com.parse.ParseObject;
import com.parse.ParseSetOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ParseAddOperation
implements ParseFieldOperation {
    protected final ArrayList<Object> objects = new ArrayList();

    public ParseAddOperation(Collection<?> coll) {
        this.objects.addAll(coll);
    }

    public ParseAddOperation(Object o) {
        this.objects.add(o);
    }

    public JSONObject encode() throws JSONException {
        JSONObject output = new JSONObject();
        output.put("__op", (Object)"Add");
        output.put("objects", Parse.maybeReferenceAndEncode(this.objects));
        return output;
    }

    @Override
    public ParseFieldOperation mergeWithPrevious(ParseFieldOperation previous) {
        if (previous == null) {
            return this;
        }
        if (previous instanceof ParseDeleteOperation) {
            return new ParseSetOperation(this.objects);
        }
        if (previous instanceof ParseSetOperation) {
            Object value = ((ParseSetOperation)previous).getValue();
            if (value instanceof JSONArray) {
                ArrayList<Object> result = ParseFieldOperations.jsonArrayAsArrayList((JSONArray)value);
                result.addAll(this.objects);
                return new ParseSetOperation(new JSONArray(result));
            }
            if (value instanceof List) {
                ArrayList<Object> result = new ArrayList<Object>((List)value);
                result.addAll(this.objects);
                return new ParseSetOperation(result);
            }
            throw new IllegalArgumentException("You can only add an item to a List or JSONArray.");
        }
        if (previous instanceof ParseAddOperation) {
            ArrayList<Object> result = new ArrayList<Object>(((ParseAddOperation)previous).objects);
            result.addAll(this.objects);
            return new ParseAddOperation(result);
        }
        throw new IllegalArgumentException("Operation is invalid after previous operation.");
    }

    @Override
    public Object apply(Object oldValue, ParseObject object, String key) {
        if (oldValue == null) {
            return this.objects;
        }
        if (oldValue instanceof JSONArray) {
            ArrayList<Object> old = ParseFieldOperations.jsonArrayAsArrayList((JSONArray)oldValue);
            ArrayList newValue = (ArrayList)this.apply(old, object, key);
            return new JSONArray((Collection)newValue);
        }
        if (oldValue instanceof List) {
            ArrayList<Object> result = new ArrayList<Object>((List)oldValue);
            result.addAll(this.objects);
            return result;
        }
        throw new IllegalArgumentException("Operation is invalid after previous operation.");
    }
}

