/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.content.Intent;
import com.parse.Parse;
import com.parse.ParseCommand;
import com.parse.ParseUser;
import java.util.Date;
import org.json.JSONException;
import org.json.JSONObject;

public class ParseAnalytics {
    private static final String TAG = "com.parse.ParseAnalytics";

    public static void trackAppOpened(Intent intent) {
        String parseData = null;
        if (intent != null && intent.getExtras() != null) {
            parseData = intent.getExtras().getString("com.parse.Data");
        }
        ParseAnalytics.trackAppOpened(parseData);
    }

    private static void trackAppOpened(String pushData) {
        ParseCommand command = new ParseCommand("client_app_opened", ParseUser.getCurrentSessionToken());
        command.put("at", Parse.dateToObject(new Date()));
        if (pushData != null) {
            try {
                JSONObject payload = new JSONObject(pushData);
                String pushHash = payload.optString("push_hash");
                if (pushHash.length() > 0) {
                    command.put("push_hash", pushHash);
                }
            }
            catch (JSONException e) {
                Parse.logE(TAG, "Failed to parse push data: " + e.getMessage());
            }
        }
        Parse.getCommandCache().runEventuallyAsync(command, null);
    }
}

