/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.content.Context;
import com.parse.Capture;
import com.parse.Continuation;
import com.parse.DeleteCallback;
import com.parse.FindCallback;
import com.parse.GetCallback;
import com.parse.LocalIdManager;
import com.parse.LockSet;
import com.parse.Parse;
import com.parse.ParseACL;
import com.parse.ParseAddOperation;
import com.parse.ParseAddUniqueOperation;
import com.parse.ParseClassName;
import com.parse.ParseCommand;
import com.parse.ParseCommandCache;
import com.parse.ParseDeleteOperation;
import com.parse.ParseException;
import com.parse.ParseFieldOperation;
import com.parse.ParseFile;
import com.parse.ParseGeoPoint;
import com.parse.ParseIncrementOperation;
import com.parse.ParseInstallation;
import com.parse.ParseJSONCacheItem;
import com.parse.ParseMulticastDelegate;
import com.parse.ParseQuery;
import com.parse.ParseRelation;
import com.parse.ParseRemoveOperation;
import com.parse.ParseRole;
import com.parse.ParseSetOperation;
import com.parse.ParseUser;
import com.parse.RefreshCallback;
import com.parse.SaveCallback;
import com.parse.Task;
import com.parse.TaskQueue;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SimpleTimeZone;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParseObject {
    private static final String TAG = "com.parse.ParseObject";
    static String server = "https://api.parse.com";
    static final String API_VERSION = "2";
    private static final String AUTO_CLASS_NAME = "_Automatic";
    static final String VERSION_NAME = "1.3.1";
    private static final Map<Class<? extends ParseObject>, String> classNames = new ConcurrentHashMap<Class<? extends ParseObject>, String>();
    private static final Map<String, Class<? extends ParseObject>> objectTypes = new ConcurrentHashMap<String, Class<? extends ParseObject>>();
    private static final DateFormat impreciseDateFormat;
    boolean dirty;
    private String objectId;
    private String localId;
    private String className;
    private final ParseMulticastDelegate<ParseObject> saveEvent = new ParseMulticastDelegate();
    private final Map<String, Object> serverData;
    final LinkedList<Map<String, ParseFieldOperation>> operationSetQueue;
    private final Map<String, Object> estimatedData;
    private final Map<String, Boolean> dataAvailability;
    final Object mutex = new Object();
    final TaskQueue taskQueue = new TaskQueue();
    private final Map<Object, ParseJSONCacheItem> hashedObjects;
    private boolean hasBeenFetched;
    private Date updatedAt;
    private Date createdAt;
    private static final ThreadLocal<Boolean> isCreatingPointer;

    protected ParseObject() {
        this(AUTO_CLASS_NAME);
    }

    public ParseObject(String theClassName) {
        boolean isPointer = isCreatingPointer.get();
        isCreatingPointer.set(false);
        if (theClassName == null) {
            throw new IllegalArgumentException("You must specify a Parse class name when creating a new ParseObject.");
        }
        if (AUTO_CLASS_NAME.equals(theClassName)) {
            theClassName = ParseObject.getClassName(this.getClass());
        }
        if (this.getClass().equals(ParseObject.class) && objectTypes.containsKey(theClassName) && !objectTypes.get(theClassName).isInstance(this)) {
            throw new IllegalArgumentException("You must create this type of ParseObject using ParseObject.create() or the proper subclass.");
        }
        if (!this.getClass().equals(ParseObject.class) && !this.getClass().equals(objectTypes.get(theClassName))) {
            throw new IllegalArgumentException("You must register this ParseObject subclass before instantiating it.");
        }
        this.localId = null;
        this.serverData = new HashMap<String, Object>();
        this.operationSetQueue = new LinkedList();
        this.operationSetQueue.add(new HashMap());
        this.estimatedData = new HashMap<String, Object>();
        this.hashedObjects = new IdentityHashMap<Object, ParseJSONCacheItem>();
        this.dataAvailability = new HashMap<String, Boolean>();
        this.className = theClassName;
        if (!isPointer) {
            this.setDefaultValues();
            this.hasBeenFetched = true;
            this.dirty = true;
        } else {
            this.dirty = false;
            this.hasBeenFetched = false;
        }
    }

    public static ParseObject create(String className) {
        if (objectTypes.containsKey(className)) {
            try {
                return objectTypes.get(className).newInstance();
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException("Failed to create instance of subclass.", e);
            }
        }
        return new ParseObject(className);
    }

    public static <T extends ParseObject> T create(Class<T> subclass) {
        return (T)ParseObject.create(ParseObject.getClassName(subclass));
    }

    public static ParseObject createWithoutData(String className, String objectId) {
        try {
            isCreatingPointer.set(true);
            ParseObject result = ParseObject.create(className);
            result.setObjectId(objectId);
            result.dirty = false;
            if (result.isDirty()) {
                throw new IllegalStateException("A ParseObject subclass default constructor must not make changes to the object that cause it to be dirty.");
            }
            ParseObject parseObject = result;
            return parseObject;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException("Failed to create instance of subclass.", e);
        }
        finally {
            isCreatingPointer.set(false);
        }
    }

    public static <T extends ParseObject> T createWithoutData(Class<T> subclass, String objectId) {
        return (T)ParseObject.createWithoutData(ParseObject.getClassName(subclass), objectId);
    }

    private static boolean isAccessible(Member m) {
        return Modifier.isPublic(m.getModifiers()) || m.getDeclaringClass().getPackage().getName().equals("com.parse") && !Modifier.isPrivate(m.getModifiers()) && !Modifier.isProtected(m.getModifiers());
    }

    public static void registerSubclass(Class<? extends ParseObject> subclass) {
        Class<? extends ParseObject> oldValue;
        String className = ParseObject.getClassName(subclass);
        if (className == null) {
            throw new IllegalArgumentException("No ParseClassName annoation provided on " + subclass);
        }
        if (subclass.getDeclaredConstructors().length > 0) {
            try {
                if (!ParseObject.isAccessible(subclass.getDeclaredConstructor(new Class[0]))) {
                    throw new IllegalArgumentException("Default constructor for " + subclass + " is not accessible.");
                }
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("No default constructor provided for " + subclass);
            }
        }
        if ((oldValue = objectTypes.get(className)) != null && subclass.isAssignableFrom(oldValue)) {
            return;
        }
        objectTypes.put(className, subclass);
        if (oldValue != null && !subclass.equals(oldValue)) {
            if (className.equals(ParseObject.getClassName(ParseUser.class))) {
                ParseUser.clearCurrentUserFromMemory();
            } else if (className.equals(ParseObject.getClassName(ParseInstallation.class))) {
                ParseInstallation.clearCurrentInstallationFromMemory();
            }
        }
    }

    static void unregisterSubclass(String className) {
        objectTypes.remove(className);
    }

    static String getApplicationId() {
        Parse.checkInit();
        return Parse.applicationId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> Task<T> enqueueForAll(List<? extends ParseObject> objects, Continuation<Void, Task<T>> taskStart) {
        final Task.TaskCompletionSource readyToStart = Task.create();
        ArrayList<Lock> locks = new ArrayList<Lock>(objects.size());
        for (ParseObject parseObject : objects) {
            locks.add(parseObject.taskQueue.getLock());
        }
        LockSet lock = new LockSet(locks);
        lock.lock();
        try {
            Task<T> task;
            try {
                task = taskStart.then(readyToStart.getTask());
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            final ArrayList childTasks = new ArrayList();
            for (ParseObject parseObject : objects) {
                parseObject.taskQueue.enqueue(new Continuation<Void, Task<T>>(){

                    @Override
                    public Task<T> then(Task<Void> task2) throws Exception {
                        childTasks.add(task2);
                        return task;
                    }
                });
            }
            Task.whenAll(childTasks).continueWith(new Continuation<Void, Void>(){

                @Override
                public Void then(Task<Void> task) throws Exception {
                    readyToStart.setResult(null);
                    return null;
                }
            });
            Task<T> task2 = task;
            return task2;
        }
        finally {
            lock.unlock();
        }
    }

    private static synchronized Date impreciseParseDate(String encoded) {
        try {
            return impreciseDateFormat.parse(encoded);
        }
        catch (java.text.ParseException e) {
            Parse.logE(TAG, "could not parse date: " + encoded, e);
            return null;
        }
    }

    static synchronized JSONObject getDiskObject(Context context, String filename) {
        Parse.setContextIfNeeded(context);
        File file = new File(Parse.getParseDir(), filename);
        return ParseObject.getDiskObject(file);
    }

    static synchronized JSONObject getDiskObject(File file) {
        String fileContent;
        if (!file.exists()) {
            return null;
        }
        try {
            RandomAccessFile f = new RandomAccessFile(file, "r");
            byte[] bytes = new byte[(int)f.length()];
            f.readFully(bytes);
            f.close();
            fileContent = new String(bytes, "UTF-8");
        }
        catch (IOException e) {
            return null;
        }
        JSONTokener tokener = new JSONTokener(fileContent);
        try {
            return new JSONObject(tokener);
        }
        catch (JSONException e) {
            return null;
        }
    }

    static synchronized void saveDiskObject(Context context, String filename, JSONObject object) {
        Parse.setContextIfNeeded(context);
        File file = new File(Parse.getParseDir(), filename);
        ParseObject.saveDiskObject(file, object);
    }

    static synchronized void saveDiskObject(File file, JSONObject object) {
        try {
            FileOutputStream out = new FileOutputStream(file);
            out.write(object.toString().getBytes("UTF-8"));
            out.close();
        }
        catch (UnsupportedEncodingException e) {
            return;
        }
        catch (IOException e) {
            return;
        }
    }

    static synchronized void deleteDiskObject(Context context, String filename) {
        Parse.setContextIfNeeded(context);
        File file = new File(Parse.getParseDir(), filename);
        if (file != null) {
            file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveToDisk(Context context, String filename) {
        Object object = this.mutex;
        synchronized (object) {
            JSONObject object2 = this.toJSONObjectForDataFile();
            ParseObject.saveDiskObject(context, filename, object2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToHashedObjects(Object object) {
        Object object2 = this.mutex;
        synchronized (object2) {
            try {
                this.hashedObjects.put(object, new ParseJSONCacheItem(object));
            }
            catch (JSONException e) {
                throw new IllegalArgumentException("Couldn't serialize container value to JSON.");
            }
        }
    }

    static ParseObject getFromDisk(Context context, String filename) {
        JSONObject object = ParseObject.getDiskObject(context, filename);
        if (object == null) {
            return null;
        }
        try {
            ParseObject parseObject = ParseObject.createWithoutData(object.getString("classname"), null);
            parseObject.mergeFromServer(object, true);
            return parseObject;
        }
        catch (JSONException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getClassName() {
        Object object = this.mutex;
        synchronized (object) {
            return this.className;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> keySet() {
        Object object = this.mutex;
        synchronized (object) {
            return Collections.unmodifiableSet(this.estimatedData.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getUpdatedAt() {
        Object object = this.mutex;
        synchronized (object) {
            return this.updatedAt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getCreatedAt() {
        Object object = this.mutex;
        synchronized (object) {
            return this.createdAt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void copyChangesFrom(ParseObject other) {
        Object object = this.mutex;
        synchronized (object) {
            Map<String, ParseFieldOperation> operations = other.operationSetQueue.getFirst();
            for (String key : operations.keySet()) {
                this.performOperation(key, operations.get(key));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mergeFromObject(ParseObject other) {
        Object object = this.mutex;
        synchronized (object) {
            this.objectId = other.objectId;
            this.createdAt = other.createdAt;
            this.updatedAt = other.updatedAt;
            this.serverData.clear();
            this.serverData.putAll(other.serverData);
            if (this.operationSetQueue.size() != 1) {
                throw new IllegalStateException("Attempt to mergeFromObject during a save.");
            }
            this.operationSetQueue.clear();
            this.operationSetQueue.add(new HashMap());
            this.dirty = false;
            this.rebuildEstimatedData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void revert() {
        Object object = this.mutex;
        synchronized (object) {
            this.currentOperations().clear();
            this.rebuildEstimatedData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mergeAfterFetch(JSONObject result, boolean completeData) {
        Object object = this.mutex;
        synchronized (object) {
            this.mergeFromServer(result, completeData);
            this.rebuildEstimatedData();
            this.checkpointAllMutableContainers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeAfterSave(JSONObject result, boolean justCreated, Map<String, ParseFieldOperation> operationsBeforeSave) {
        Object object = this.mutex;
        synchronized (object) {
            ListIterator<Map<String, ParseFieldOperation>> opIterator = this.operationSetQueue.listIterator(this.operationSetQueue.indexOf(operationsBeforeSave));
            opIterator.next();
            opIterator.remove();
            Map<String, ParseFieldOperation> nextOperation = opIterator.next();
            if (result == null) {
                for (String key : operationsBeforeSave.keySet()) {
                    ParseFieldOperation operation1 = operationsBeforeSave.get(key);
                    ParseFieldOperation operation2 = nextOperation.get(key);
                    operation2 = operation2 != null ? operation2.mergeWithPrevious(operation1) : operation1;
                    this.operationSetQueue.getFirst().put(key, operation2);
                }
            } else {
                this.applyOperations(operationsBeforeSave, this.serverData);
                this.mergeFromServer(result, false);
                this.rebuildEstimatedData();
                this.checkpointAllMutableContainers();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mergeFromServer(JSONObject object, boolean completeData) {
        Object object2 = this.mutex;
        synchronized (object2) {
            this.dirty = false;
            this.hasBeenFetched = this.hasBeenFetched || completeData;
            try {
                String key;
                Iterator keys;
                String updatedAtString;
                String createdAtString;
                if (object.has("id") && this.objectId == null) {
                    this.setObjectIdInternal(object.getString("id"));
                }
                if (object.has("created_at") && (createdAtString = object.getString("created_at")) != null) {
                    this.createdAt = ParseObject.impreciseParseDate(createdAtString);
                }
                if (object.has("updated_at") && (updatedAtString = object.getString("updated_at")) != null) {
                    this.updatedAt = ParseObject.impreciseParseDate(updatedAtString);
                }
                if (object.has("pointers")) {
                    JSONObject newPointers = object.getJSONObject("pointers");
                    keys = newPointers.keys();
                    while (keys.hasNext()) {
                        key = (String)keys.next();
                        JSONArray pointerArray = newPointers.getJSONArray(key);
                        this.serverData.put(key, ParseObject.createWithoutData(pointerArray.optString(0), pointerArray.optString(1)));
                    }
                }
                if (object.has("data")) {
                    JSONObject newData = object.getJSONObject("data");
                    keys = newData.keys();
                    while (keys.hasNext()) {
                        key = (String)keys.next();
                        this.dataAvailability.put(key, true);
                        if (key.equals("objectId")) {
                            this.setObjectIdInternal(newData.getString(key));
                            continue;
                        }
                        if (key.equals("createdAt")) {
                            this.createdAt = Parse.parseDate(newData.getString(key));
                            continue;
                        }
                        if (key.equals("updatedAt")) {
                            this.updatedAt = Parse.parseDate(newData.getString(key));
                            continue;
                        }
                        if (key.equals("ACL")) {
                            ParseACL acl = ParseACL.createACLFromJSONObject(newData.getJSONObject(key));
                            this.serverData.put("ACL", acl);
                            this.addToHashedObjects(acl);
                            continue;
                        }
                        if (key.equals("__type") || key.equals("className")) continue;
                        List<Object> value = newData.get(key);
                        List<Object> decodedObject = Parse.decodeJSONObject(value);
                        if (decodedObject != null) {
                            if (Parse.isContainerObject(decodedObject)) {
                                if (decodedObject instanceof JSONArray) {
                                    decodedObject = Parse.convertArrayToList((JSONArray)decodedObject);
                                }
                                this.addToHashedObjects(decodedObject);
                            }
                            this.serverData.put(key, decodedObject);
                            continue;
                        }
                        if (Parse.isContainerObject(value)) {
                            JSONObject json;
                            if (value instanceof JSONArray) {
                                value = Parse.convertArrayToList((JSONArray)value);
                            }
                            if (value instanceof JSONObject && (json = (JSONObject)value).has("__type") && json.getString("__type").equals("Relation")) {
                                String className = json.getString("className");
                                value = new ParseRelation(this, key);
                                ((ParseRelation)((Object)value)).setTargetClass(className);
                            }
                            this.addToHashedObjects(value);
                        }
                        this.serverData.put(key, value);
                    }
                }
                if (this.updatedAt == null && this.createdAt != null) {
                    this.updatedAt = this.createdAt;
                }
                this.dirty = false;
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
            this.rebuildEstimatedData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasDirtyChildren() {
        Object object = this.mutex;
        synchronized (object) {
            ArrayList<ParseObject> unsavedChildren = new ArrayList<ParseObject>();
            ParseObject.findUnsavedChildren(this.estimatedData, unsavedChildren);
            return unsavedChildren.size() > 0;
        }
    }

    boolean isDirty() {
        return this.isDirty(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDirty(boolean considerChildren) {
        Object object = this.mutex;
        synchronized (object) {
            this.checkForChangesToMutableContainers();
            return this.dirty || this.currentOperations().size() > 0 || considerChildren && this.hasDirtyChildren();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkpointAllMutableContainers() {
        Object object = this.mutex;
        synchronized (object) {
            for (Object o : this.estimatedData.values()) {
                this.checkpointMutableContainer(o);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkpointMutableContainer(Object object) {
        Object object2 = this.mutex;
        synchronized (object2) {
            if (Parse.isContainerObject(object)) {
                ParseJSONCacheItem newCacheItem = null;
                try {
                    newCacheItem = new ParseJSONCacheItem(object);
                }
                catch (JSONException e) {
                    throw new RuntimeException(e);
                }
                this.hashedObjects.put(object, newCacheItem);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForChangesToMutableContainer(String key, Object object) {
        Object object2 = this.mutex;
        synchronized (object2) {
            if (Parse.isContainerObject(object)) {
                ParseJSONCacheItem oldCacheItem = this.hashedObjects.get(object);
                if (oldCacheItem == null) {
                    throw new IllegalArgumentException("ParseObject contains container item that isn't cached.");
                }
                ParseJSONCacheItem newCacheItem = null;
                try {
                    newCacheItem = new ParseJSONCacheItem(object);
                }
                catch (JSONException e) {
                    throw new RuntimeException(e);
                }
                if (!oldCacheItem.equals(newCacheItem)) {
                    this.performOperation(key, new ParseSetOperation(object));
                }
            } else {
                this.hashedObjects.remove(object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkForChangesToMutableContainers() {
        Object object = this.mutex;
        synchronized (object) {
            for (String key : this.estimatedData.keySet()) {
                this.checkForChangesToMutableContainer(key, this.estimatedData.get(key));
            }
            this.hashedObjects.keySet().retainAll(this.estimatedData.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getObjectId() {
        Object object = this.mutex;
        synchronized (object) {
            return this.objectId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized String getOrCreateLocalId() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.localId == null) {
                if (this.objectId != null) {
                    throw new IllegalStateException("Attempted to get a localId for an object with an objectId.");
                }
                this.localId = LocalIdManager.getDefaultInstance().createLocalId();
            }
            return this.localId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObjectId(String newObjectId) {
        Object object = this.mutex;
        synchronized (object) {
            this.dirty = true;
            this.setObjectIdInternal(newObjectId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setObjectIdInternal(String newObjectId) {
        Object object = this.mutex;
        synchronized (object) {
            this.objectId = newObjectId;
            if (this.localId != null) {
                LocalIdManager.getDefaultInstance().setObjectId(this.localId, this.objectId);
                this.localId = null;
            }
        }
    }

    private static void findUnsavedChildren(Object data, List<ParseObject> unsaved) {
        ParseObject object;
        if (data instanceof List) {
            List list = (List)data;
            for (Object elem : list) {
                ParseObject.findUnsavedChildren(elem, unsaved);
            }
        } else if (data instanceof Map) {
            Map map = (Map)data;
            for (Object elem : map.values()) {
                ParseObject.findUnsavedChildren(elem, unsaved);
            }
        } else if (data instanceof ParseObject && (object = (ParseObject)data).isDirty()) {
            unsaved.add(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ParseCommand constructSaveCommand(Map<String, ParseFieldOperation> operations, String sessionToken) throws ParseException {
        Object object = this.mutex;
        synchronized (object) {
            JSONObject objectJSON = this.toJSONObjectForSaving(operations);
            String op = this.objectId == null ? "create" : "update";
            ParseCommand command = new ParseCommand(op, sessionToken);
            command.enableRetrying();
            command.put("classname", this.className);
            try {
                command.put("data", objectJSON.getJSONObject("data"));
            }
            catch (JSONException e) {
                throw new RuntimeException("could not decode data");
            }
            return command;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JSONObject toJSONObjectForDataFile() {
        Object object = this.mutex;
        synchronized (object) {
            this.checkForChangesToMutableContainers();
            JSONObject objectJSON = new JSONObject();
            JSONObject dataJSON = new JSONObject();
            try {
                for (String key : this.serverData.keySet()) {
                    Object object2 = this.serverData.get(key);
                    if (Parse.isContainerObject(object2) && this.hashedObjects.containsKey(object2)) {
                        dataJSON.put(key, this.hashedObjects.get(object2).getJSONObject());
                        continue;
                    }
                    dataJSON.put(key, Parse.maybeEncodeJSONObject(object2, true));
                }
                if (this.createdAt != null) {
                    dataJSON.put("createdAt", (Object)Parse.encodeDate(this.createdAt));
                }
                if (this.updatedAt != null) {
                    dataJSON.put("updatedAt", (Object)Parse.encodeDate(this.updatedAt));
                }
                if (this.objectId != null) {
                    dataJSON.put("objectId", (Object)this.objectId);
                }
                objectJSON.put("data", (Object)dataJSON);
                objectJSON.put("classname", (Object)this.className);
            }
            catch (JSONException e) {
                throw new RuntimeException("could not serialize object to JSON");
            }
            return objectJSON;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JSONObject toJSONObjectForSaving(Map<String, ParseFieldOperation> operations) {
        Object object = this.mutex;
        synchronized (object) {
            JSONObject objectJSON = new JSONObject();
            JSONObject dataJSON = new JSONObject();
            try {
                for (String key : operations.keySet()) {
                    Object object2;
                    ParseFieldOperation operation = operations.get(key);
                    Object encoded = Parse.maybeEncodeJSONObject(operation, true);
                    dataJSON.put(key, encoded);
                    if (!(operation instanceof ParseSetOperation) || !Parse.isContainerObject(object2 = ((ParseSetOperation)operation).getValue()) || !this.hashedObjects.containsKey(object2)) continue;
                    this.hashedObjects.put(object2, new ParseJSONCacheItem(object2));
                }
                if (this.objectId != null) {
                    dataJSON.put("objectId", (Object)this.objectId);
                }
                objectJSON.put("data", (Object)dataJSON);
                objectJSON.put("classname", (Object)this.className);
            }
            catch (JSONException e) {
                throw new RuntimeException("could not serialize object to JSON");
            }
            return objectJSON;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleSaveResult(String op, JSONObject result, Map<String, ParseFieldOperation> operationsBeforeSave) {
        Object object = this.mutex;
        synchronized (object) {
            boolean justCreated = op.equals("create") || op.equals("user_signup");
            this.mergeAfterSave(result, justCreated, operationsBeforeSave);
            this.saveEvent.invoke(this, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, ParseFieldOperation> startSave() {
        Object object = this.mutex;
        synchronized (object) {
            Map<String, ParseFieldOperation> currentOperations = this.currentOperations();
            this.operationSetQueue.addLast(new HashMap());
            return currentOperations;
        }
    }

    void validateSave() {
    }

    public final void save() throws ParseException {
        Parse.waitForTask(this.saveAsync());
    }

    Task<Void> saveAsync(Task<Void> toAwait) {
        final Capture operations = new Capture();
        if (!this.isDirty()) {
            return Task.forResult(null);
        }
        final String sessionToken = ParseUser.getCurrentSessionToken();
        return Task.forResult(null).onSuccessTask(new Continuation<Void, Task<Void>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Task<Void> then(Task<Void> task) throws Exception {
                Object object = ParseObject.this.mutex;
                synchronized (object) {
                    ParseObject.this.validateSave();
                    operations.set(ParseObject.this.startSave());
                    if (ParseObject.this.isDataAvailable("ACL") && ParseObject.this.getACL(false) != null && ParseObject.this.getACL(false).hasUnresolvedUser()) {
                        return ParseUser.getCurrentUser().saveAsync().onSuccess(new Continuation<Void, Void>(){

                            @Override
                            public Void then(Task<Void> task) throws Exception {
                                if (ParseObject.this.getACL(false).hasUnresolvedUser()) {
                                    throw new IllegalStateException("ACL has an unresolved ParseUser. Save or sign up before attempting to serialize the ACL.");
                                }
                                return null;
                            }
                        });
                    }
                    return task;
                }
            }
        }).onSuccessTask(new Continuation<Void, Task<Void>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Task<Void> then(Task<Void> task) throws Exception {
                Object object = ParseObject.this.mutex;
                synchronized (object) {
                    return ParseObject.deepSaveAsync(ParseObject.this.estimatedData, sessionToken);
                }
            }
        }).onSuccessTask(TaskQueue.waitFor(toAwait)).onSuccessTask(new Continuation<Void, Task<Void>>(){

            @Override
            public Task<Void> then(Task<Void> task) throws Exception {
                final ParseCommand command = ParseObject.this.constructSaveCommand((Map)operations.get(), sessionToken);
                return command.performAsync().continueWithTask(new Continuation<Object, Task<Void>>(){

                    @Override
                    public Task<Void> then(Task<Object> task) throws Exception {
                        ParseObject.this.handleSaveResult(command.op, (JSONObject)task.getResult(), (Map)operations.get());
                        return task.makeVoid();
                    }
                });
            }
        });
    }

    final Task<Void> saveAsync() {
        return this.taskQueue.enqueue(new Continuation<Void, Task<Void>>(){

            @Override
            public Task<Void> then(Task<Void> task) throws Exception {
                return ParseObject.this.saveAsync(task);
            }
        });
    }

    public final void saveInBackground(SaveCallback callback) {
        Parse.callbackOnMainThreadAsync(this.saveAsync(), callback);
    }

    public final void saveInBackground() {
        this.saveInBackground(null);
    }

    public final void saveEventually() {
        this.saveEventually(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveEventually(SaveCallback callback) {
        Object object = this.mutex;
        synchronized (object) {
            ArrayList<ParseObject> unsavedChildren = new ArrayList<ParseObject>();
            ParseObject.findUnsavedChildren(this.estimatedData, unsavedChildren);
            String localId = null;
            if (this.getObjectId() == null) {
                localId = this.getOrCreateLocalId();
            }
            final Map<String, ParseFieldOperation> operations = this.startSave();
            final ParseCommandCache cache = Parse.getCommandCache();
            try {
                final ParseCommand command = this.constructSaveCommand(operations, ParseUser.getCurrentSessionToken());
                command.setLocalId(localId);
                command.retainLocalIds();
                for (ParseObject object2 : unsavedChildren) {
                    object2.saveEventually();
                }
                final Capture<Boolean> succeeded = new Capture<Boolean>(false);
                Parse.callbackOnMainThreadAsync(cache.runEventuallyAsync(command, this).continueWith(new Continuation<Object, Void>(){

                    @Override
                    public Void then(Task<Object> task) throws Exception {
                        if (task.getResult() != null) {
                            ParseObject.this.handleSaveResult(command.op, (JSONObject)task.getResult(), operations);
                            succeeded.set(true);
                        }
                        return null;
                    }
                }), callback).continueWithTask(new Continuation<Void, Task<Void>>(){

                    @Override
                    public Task<Void> then(Task<Void> task) throws Exception {
                        if (((Boolean)succeeded.get()).booleanValue()) {
                            cache.getTestHelper().notify(5);
                        }
                        return task;
                    }
                });
                command.releaseLocalIds();
            }
            catch (ParseException exception) {
                throw new IllegalStateException("Unable to saveEventually.", exception);
            }
        }
    }

    public final void deleteEventually() {
        this.deleteEventually(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deleteEventually(DeleteCallback callback) {
        Object object = this.mutex;
        synchronized (object) {
            final ParseCommandCache cache = Parse.getCommandCache();
            try {
                Parse.callbackOnMainThreadAsync(cache.runEventuallyAsync(this.constructDeleteCommand(false, ParseUser.getCurrentSessionToken()), this).makeVoid(), callback).continueWithTask(new Continuation<Void, Task<Void>>(){

                    @Override
                    public Task<Void> then(Task<Void> task) throws Exception {
                        cache.getTestHelper().notify(6);
                        return task;
                    }
                });
                this.dirty = true;
            }
            catch (ParseException e) {
                throw new IllegalStateException("Cannot deleteEventually this object.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleFetchResult(JSONObject result) {
        Object object = this.mutex;
        synchronized (object) {
            this.mergeAfterFetch(result, true);
        }
    }

    public final void refresh() throws ParseException {
        this.fetch();
    }

    public final void refreshInBackground(RefreshCallback callback) {
        Parse.callbackOnMainThreadAsync(this.fetchAsync(), callback);
    }

    public <T extends ParseObject> T fetch() throws ParseException {
        return (T)((ParseObject)Parse.waitForTask(this.fetchAsync()));
    }

    <T extends ParseObject> Task<T> fetchAsync(Task<Void> toAwait) {
        final String sessionToken = ParseUser.getCurrentSessionToken();
        return Task.call(new Callable<ParseCommand>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParseCommand call() throws Exception {
                Object object = ParseObject.this.mutex;
                synchronized (object) {
                    ParseCommand command = new ParseCommand("get", sessionToken);
                    command.enableRetrying();
                    command.put("classname", ParseObject.this.className);
                    JSONObject data = new JSONObject();
                    try {
                        data.put("objectId", (Object)ParseObject.this.objectId);
                    }
                    catch (JSONException e) {
                        throw new RuntimeException(e.getMessage());
                    }
                    command.put("data", data);
                    return command;
                }
            }
        }).onSuccessTask(TaskQueue.waitFor(toAwait)).onSuccessTask(new Continuation<ParseCommand, Task<Object>>(){

            @Override
            public Task<Object> then(Task<ParseCommand> task) throws Exception {
                return task.getResult().performAsync();
            }
        }).onSuccess(new Continuation<Object, T>(){

            @Override
            public T then(Task<Object> task) throws Exception {
                ParseObject.this.handleFetchResult((JSONObject)task.getResult());
                return ParseObject.this;
            }
        });
    }

    final <T extends ParseObject> Task<T> fetchAsync() {
        return this.taskQueue.enqueue(new Continuation<Void, Task<T>>(){

            @Override
            public Task<T> then(Task<Void> task) throws Exception {
                return ParseObject.this.fetchAsync(task);
            }
        });
    }

    public final <T extends ParseObject> void fetchInBackground(GetCallback<T> callback) {
        Parse.callbackOnMainThreadAsync(this.fetchAsync(), callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Task<ParseObject> fetchIfNeededAsync() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.isDataAvailable()) {
                return Task.forResult(this);
            }
            return this.fetchAsync();
        }
    }

    public ParseObject fetchIfNeeded() throws ParseException {
        return Parse.waitForTask(this.fetchIfNeededAsync());
    }

    public final void fetchIfNeededInBackground(GetCallback<ParseObject> callback) {
        Parse.callbackOnMainThreadAsync(this.fetchIfNeededAsync(), callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ParseCommand constructDeleteCommand(boolean requireObjectId, String sessionToken) throws ParseException {
        Object object = this.mutex;
        synchronized (object) {
            ParseCommand command = new ParseCommand("delete", sessionToken);
            command.enableRetrying();
            command.put("classname", this.className);
            JSONObject data = new JSONObject();
            try {
                data.put("objectId", (Object)this.objectId);
            }
            catch (JSONException e) {
                throw new RuntimeException(e.getMessage());
            }
            command.put("data", data);
            return command;
        }
    }

    void validateDelete() {
    }

    private Task<Void> deleteAsync(Task<Void> toAwait) {
        final String sessionToken = ParseUser.getCurrentSessionToken();
        return Task.call(new Callable<ParseCommand>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParseCommand call() throws Exception {
                Object object = ParseObject.this.mutex;
                synchronized (object) {
                    ParseObject.this.validateDelete();
                    if (ParseObject.this.objectId == null) {
                        return null;
                    }
                    return ParseObject.this.constructDeleteCommand(true, sessionToken);
                }
            }
        }).onSuccessTask(TaskQueue.waitFor(toAwait)).onSuccessTask(new Continuation<ParseCommand, Task<Object>>(){

            @Override
            public Task<Object> then(Task<ParseCommand> task) throws Exception {
                return task.getResult().performAsync();
            }
        }).onSuccess(new Continuation<Object, Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void then(Task<Object> task) throws Exception {
                Object object = ParseObject.this.mutex;
                synchronized (object) {
                    ParseObject.this.dirty = true;
                    return null;
                }
            }
        });
    }

    private Task<Void> deleteAsync() {
        return this.taskQueue.enqueue(new Continuation<Void, Task<Void>>(){

            @Override
            public Task<Void> then(Task<Void> task) throws Exception {
                return ParseObject.this.deleteAsync(task);
            }
        });
    }

    public final void delete() throws ParseException {
        Parse.waitForTask(this.deleteAsync());
    }

    public final void deleteInBackground(DeleteCallback callback) {
        Parse.callbackOnMainThreadAsync(this.deleteAsync(), callback);
    }

    public final void deleteInBackground() {
        this.deleteInBackground(null);
    }

    private static void collectDirtyChildren(Object node, List<ParseObject> dirtyChildren, List<ParseFile> dirtyFiles, IdentityHashMap<ParseObject, ParseObject> seen, IdentityHashMap<ParseObject, ParseObject> seenNew) {
        ParseFile file;
        if (node instanceof List) {
            List list = (List)node;
            for (Object item : list) {
                ParseObject.collectDirtyChildren(item, dirtyChildren, dirtyFiles, seen, seenNew);
            }
        } else if (node instanceof Map) {
            Map map = (Map)node;
            for (Object value : map.values()) {
                ParseObject.collectDirtyChildren(value, dirtyChildren, dirtyFiles, seen, seenNew);
            }
        } else if (node instanceof JSONArray) {
            JSONArray array = (JSONArray)node;
            for (int i = 0; i < array.length(); ++i) {
                try {
                    ParseObject.collectDirtyChildren(array.get(i), dirtyChildren, dirtyFiles, seen, seenNew);
                    continue;
                }
                catch (JSONException e) {
                    throw new RuntimeException("Invalid JSONArray on object.", e);
                }
            }
        } else if (node instanceof JSONObject) {
            JSONObject dictionary = (JSONObject)node;
            Iterator keys = dictionary.keys();
            while (keys.hasNext()) {
                try {
                    Object value = dictionary.get((String)keys.next());
                    ParseObject.collectDirtyChildren(value, dirtyChildren, dirtyFiles, seen, seenNew);
                }
                catch (JSONException e) {
                    throw new RuntimeException("Invalid JSONDictionary on object.", e);
                }
            }
        } else if (node instanceof ParseACL) {
            ParseACL acl = (ParseACL)node;
            if (acl.hasUnresolvedUser()) {
                ParseObject.collectDirtyChildren(ParseUser.getCurrentUser(), dirtyChildren, dirtyFiles, seen, seenNew);
            }
        } else if (node instanceof ParseObject) {
            ParseObject object = (ParseObject)node;
            if (object.getObjectId() != null) {
                seenNew = new IdentityHashMap();
            } else {
                if (seenNew.containsKey(object)) {
                    throw new RuntimeException("Found a circular dependency while saving.");
                }
                seenNew = new IdentityHashMap<ParseObject, ParseObject>(seenNew);
                seenNew.put(object, object);
            }
            if (seen.containsKey(object)) {
                return;
            }
            seen = new IdentityHashMap<ParseObject, ParseObject>(seen);
            seen.put(object, object);
            ParseObject.collectDirtyChildren(object.estimatedData, dirtyChildren, dirtyFiles, seen, seenNew);
            if (object.isDirty(false)) {
                dirtyChildren.add(object);
            }
        } else if (node instanceof ParseFile && (file = (ParseFile)node).getUrl() == null) {
            dirtyFiles.add(file);
        }
    }

    private static void collectDirtyChildren(Object node, List<ParseObject> dirtyChildren, List<ParseFile> dirtyFiles) {
        ParseObject.collectDirtyChildren(node, dirtyChildren, dirtyFiles, new IdentityHashMap<ParseObject, ParseObject>(), new IdentityHashMap<ParseObject, ParseObject>());
    }

    private static boolean canBeSerializedAsValue(Object value) {
        ParseACL acl;
        if (value instanceof ParseObject) {
            ParseObject object = (ParseObject)value;
            return object.getObjectId() != null;
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            for (Object item : map.values()) {
                if (ParseObject.canBeSerializedAsValue(item)) continue;
                return false;
            }
        } else if (value instanceof JSONArray) {
            JSONArray array = (JSONArray)value;
            for (int i = 0; i < array.length(); ++i) {
                try {
                    if (ParseObject.canBeSerializedAsValue(array.get(i))) continue;
                    return false;
                }
                catch (JSONException e) {
                    throw new RuntimeException("Unable to find related objects for saving.", e);
                }
            }
        } else if (value instanceof JSONObject) {
            JSONObject dictionary = (JSONObject)value;
            Iterator keys = dictionary.keys();
            while (keys.hasNext()) {
                try {
                    Object v = dictionary.get((String)keys.next());
                    if (ParseObject.canBeSerializedAsValue(v)) continue;
                    return false;
                }
                catch (JSONException e) {
                    throw new RuntimeException("Unable to find related objects for saving.", e);
                }
            }
        } else if (value instanceof ParseACL && (acl = (ParseACL)value).hasUnresolvedUser() && !ParseObject.canBeSerializedAsValue(ParseUser.getCurrentUser())) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canBeSerialized() {
        Object object = this.mutex;
        synchronized (object) {
            if (!ParseObject.canBeSerializedAsValue(this.estimatedData)) {
                return false;
            }
            return !this.isDataAvailable("ACL") || this.getACL(false) == null || !this.getACL(false).hasUnresolvedUser();
            {
            }
        }
    }

    private static Task<Void> deepSaveAsync(Object object, final String sessionToken) {
        final ArrayList<ParseObject> objects = new ArrayList<ParseObject>();
        ArrayList<ParseFile> files = new ArrayList<ParseFile>();
        ParseObject.collectDirtyChildren(object, objects, files);
        ArrayList<Task<Void>> fileSaveTasks = new ArrayList<Task<Void>>();
        for (ParseFile file : files) {
            fileSaveTasks.add(file.saveAsync(null));
        }
        return Task.whenAll(fileSaveTasks).onSuccessTask(new Continuation<Void, Task<Void>>(){

            @Override
            public Task<Void> then(Task<Void> task) throws Exception {
                IdentityHashMap<ParseObject, Boolean> uniqueObjects = new IdentityHashMap<ParseObject, Boolean>();
                for (ParseObject obj : objects) {
                    uniqueObjects.put(obj, true);
                }
                final Capture remaining = new Capture(new ArrayList(uniqueObjects.keySet()));
                return Task.forResult(null).continueWhile(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        return ((List)remaining.get()).size() > 0;
                    }
                }, new Continuation<Void, Task<Void>>(){

                    @Override
                    public Task<Void> then(Task<Void> task) throws Exception {
                        final ArrayList<ParseObject> current = new ArrayList<ParseObject>();
                        ArrayList<ParseObject> nextBatch = new ArrayList<ParseObject>();
                        for (ParseObject obj : (List)remaining.get()) {
                            if (obj.canBeSerialized()) {
                                current.add(obj);
                                continue;
                            }
                            nextBatch.add(obj);
                        }
                        remaining.set(nextBatch);
                        if (current.size() == 0) {
                            throw new RuntimeException("Unable to save a PFObject with a relation to a cycle.");
                        }
                        Task<Object> result = Task.forResult(null);
                        if (ParseUser.getCurrentUser() != null && ParseUser.getCurrentUser().isLazy() && current.contains(ParseUser.getCurrentUser())) {
                            result = result.onSuccessTask(new Continuation<Void, Task<Void>>(){

                                @Override
                                public Task<Void> then(Task<Void> task) throws Exception {
                                    return ParseUser.getCurrentUser().saveAsync();
                                }
                            }).onSuccess(new Continuation<Void, Void>(){

                                @Override
                                public Void then(Task<Void> task) throws Exception {
                                    current.remove(ParseUser.getCurrentUser());
                                    return null;
                                }
                            });
                        }
                        final ArrayList ops = new ArrayList();
                        final ArrayList operations = new ArrayList();
                        result = result.onSuccessTask(new Continuation<Void, Task<Void>>(){

                            @Override
                            public Task<Void> then(Task<Void> task) throws Exception {
                                if (current.size() == 0) {
                                    return Task.forResult(null);
                                }
                                return ParseObject.enqueueForAll(current, new Continuation<Void, Task<Void>>(){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    @Override
                                    public Task<Void> then(Task<Void> toAwait) throws Exception {
                                        for (ParseObject obj : current) {
                                            Object object = obj.mutex;
                                            synchronized (object) {
                                                obj.validateSave();
                                                operations.add(obj.startSave());
                                            }
                                        }
                                        return toAwait.continueWithTask(new Continuation<Void, Task<Void>>(){

                                            @Override
                                            public Task<Void> then(Task<Void> task) throws Exception {
                                                JSONArray commands = new JSONArray();
                                                for (int i = 0; i < current.size(); ++i) {
                                                    ParseCommand command = ((ParseObject)current.get(i)).constructSaveCommand((Map)operations.get(i), sessionToken);
                                                    JSONObject jsonCommand = command.toJSONObject();
                                                    commands.put((Object)jsonCommand);
                                                    ops.add(command.op);
                                                }
                                                ParseCommand multiCommand = new ParseCommand("multi", sessionToken);
                                                multiCommand.put("commands", commands);
                                                return multiCommand.performAsync().cast().onSuccess(new Continuation<JSONArray, Void>(){

                                                    @Override
                                                    public Void then(Task<JSONArray> task) throws Exception {
                                                        for (int i = 0; i < current.size(); ++i) {
                                                            String op = (String)ops.get(i);
                                                            JSONObject result = task.getResult().getJSONObject(i);
                                                            ((ParseObject)current.get(i)).handleSaveResult(op, result, (Map)operations.get(i));
                                                        }
                                                        return null;
                                                    }
                                                });
                                            }
                                        });
                                    }
                                });
                            }
                        });
                        return result;
                    }
                });
            }
        });
    }

    private static Task<Void> saveAllAsync(List<ParseObject> objects) {
        return ParseObject.deepSaveAsync(objects, ParseUser.getCurrentSessionToken());
    }

    public static void saveAll(List<ParseObject> objects) throws ParseException {
        Parse.waitForTask(ParseObject.saveAllAsync(objects));
    }

    private static <T extends ParseObject> Task<List<T>> fetchAllIfNeededAsync(final List<T> objects, Task<Void> toAwait) {
        ArrayList<String> ids = new ArrayList<String>();
        String className = null;
        for (ParseObject object : objects) {
            if (object.isDataAvailable()) continue;
            if (className != null && !className.equals(object.getClassName())) {
                throw new IllegalArgumentException("All objects should have the same class");
            }
            className = object.getClassName();
            String id2 = object.getObjectId();
            if (id2 == null) continue;
            ids.add(id2);
        }
        if (ids.size() == 0) {
            return Task.forResult(objects);
        }
        final ParseQuery query = ParseQuery.getQuery(className);
        query.whereContainedIn("objectId", ids);
        return toAwait.continueWithTask(new Continuation<Void, Task<List<T>>>(){

            @Override
            public Task<List<T>> then(Task<Void> task) throws Exception {
                return query.findAsync();
            }
        }).onSuccess(new Continuation<List<T>, List<T>>(){

            @Override
            public List<T> then(Task<List<T>> task) throws Exception {
                HashMap<String, ParseObject> resultMap = new HashMap<String, ParseObject>();
                for (ParseObject o : task.getResult()) {
                    resultMap.put(o.getObjectId(), o);
                }
                for (int i = 0; i < objects.size(); ++i) {
                    if (((ParseObject)objects.get(i)).isDataAvailable()) continue;
                    ParseObject newObject = (ParseObject)resultMap.get(((ParseObject)objects.get(i)).getObjectId());
                    if (newObject == null) {
                        throw new RuntimeException("Object id " + ((ParseObject)objects.get(i)).getObjectId() + " does not exist");
                    }
                    ((ParseObject)objects.get(i)).mergeFromObject(newObject);
                    ((ParseObject)objects.get(i)).hasBeenFetched = true;
                }
                return objects;
            }
        });
    }

    private static <T extends ParseObject> Task<List<T>> fetchAllIfNeededAsync(final List<T> objects) {
        return ParseObject.enqueueForAll(objects, new Continuation<Void, Task<List<T>>>(){

            @Override
            public Task<List<T>> then(Task<Void> task) throws Exception {
                return ParseObject.fetchAllIfNeededAsync(objects, task);
            }
        });
    }

    public static <T extends ParseObject> List<T> fetchAllIfNeeded(List<T> objects) throws ParseException {
        return Parse.waitForTask(ParseObject.fetchAllIfNeededAsync(objects));
    }

    public static <T extends ParseObject> void fetchAllIfNeededInBackground(List<T> objects, FindCallback<T> callback) {
        Parse.callbackOnMainThreadAsync(ParseObject.fetchAllIfNeededAsync(objects), callback);
    }

    private static <T extends ParseObject> Task<List<T>> fetchAllAsync(final List<T> objects, Task<Void> toAwait) {
        if (objects.size() == 0) {
            return Task.forResult(objects);
        }
        ArrayList<String> ids = new ArrayList<String>();
        String className = ((ParseObject)objects.get(0)).getClassName();
        for (int i = 0; i < objects.size(); ++i) {
            if (!((ParseObject)objects.get(i)).getClassName().equals(className)) {
                throw new IllegalArgumentException("All objects should have the same class");
            }
            String id2 = ((ParseObject)objects.get(i)).getObjectId();
            if (id2 == null) {
                throw new IllegalArgumentException("All objects must exist on the server");
            }
            ids.add(((ParseObject)objects.get(i)).getObjectId());
        }
        final ParseQuery query = ParseQuery.getQuery(className);
        query.whereContainedIn("objectId", ids);
        return toAwait.continueWithTask(new Continuation<Void, Task<List<T>>>(){

            @Override
            public Task<List<T>> then(Task<Void> task) throws Exception {
                return query.findAsync();
            }
        }).onSuccess(new Continuation<List<T>, List<T>>(){

            @Override
            public List<T> then(Task<List<T>> task) throws Exception {
                HashMap<String, ParseObject> resultMap = new HashMap<String, ParseObject>();
                for (ParseObject o : task.getResult()) {
                    resultMap.put(o.getObjectId(), o);
                }
                for (int i = 0; i < objects.size(); ++i) {
                    ParseObject newObject = (ParseObject)resultMap.get(((ParseObject)objects.get(i)).getObjectId());
                    if (newObject == null) {
                        throw new RuntimeException("Object id " + ((ParseObject)objects.get(i)).getObjectId() + " does not exist");
                    }
                    ((ParseObject)objects.get(i)).mergeFromObject(newObject);
                    ((ParseObject)objects.get(i)).hasBeenFetched = true;
                }
                return objects;
            }
        });
    }

    private static <T extends ParseObject> Task<List<T>> fetchAllAsync(final List<T> objects) {
        return ParseObject.enqueueForAll(objects, new Continuation<Void, Task<List<T>>>(){

            @Override
            public Task<List<T>> then(Task<Void> task) throws Exception {
                return ParseObject.fetchAllAsync(objects, task);
            }
        });
    }

    public static List<ParseObject> fetchAll(List<ParseObject> objects) throws ParseException {
        return Parse.waitForTask(ParseObject.fetchAllAsync(objects));
    }

    public static <T extends ParseObject> void fetchAllInBackground(List<T> objects, FindCallback<T> callback) {
        Parse.callbackOnMainThreadAsync(ParseObject.fetchAllAsync(objects), callback);
    }

    public static void saveAllInBackground(List<ParseObject> objects, SaveCallback callback) {
        Parse.callbackOnMainThreadAsync(ParseObject.saveAllAsync(objects), callback);
    }

    public static void saveAllInBackground(List<ParseObject> objects) {
        ParseObject.saveAllInBackground(objects, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String key) {
        Object object = this.mutex;
        synchronized (object) {
            Object object2 = this.get(key);
            if (object2 != null) {
                this.performOperation(key, ParseDeleteOperation.getInstance());
            }
        }
    }

    public boolean has(String key) {
        return this.containsKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, ParseFieldOperation> currentOperations() {
        Object object = this.mutex;
        synchronized (object) {
            return this.operationSetQueue.getLast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyOperations(Map<String, ParseFieldOperation> operations, Map<String, Object> map) {
        Object object = this.mutex;
        synchronized (object) {
            for (String key : operations.keySet()) {
                Object oldValue;
                ParseFieldOperation operation = operations.get(key);
                Object newValue = operation.apply(oldValue = map.get(key), this, key);
                if (newValue != null) {
                    map.put(key, newValue);
                    continue;
                }
                map.remove(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuildEstimatedData() {
        Object object = this.mutex;
        synchronized (object) {
            this.estimatedData.clear();
            this.estimatedData.putAll(this.serverData);
            for (Map map : this.operationSetQueue) {
                this.applyOperations(map, this.estimatedData);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void performOperation(String key, ParseFieldOperation operation) {
        Object object = this.mutex;
        synchronized (object) {
            Object oldValue = this.estimatedData.get(key);
            Object newValue = operation.apply(oldValue, this, key);
            if (newValue != null) {
                this.estimatedData.put(key, newValue);
            } else {
                this.estimatedData.remove(key);
            }
            ParseFieldOperation oldOperation = this.currentOperations().get(key);
            ParseFieldOperation newOperation = operation.mergeWithPrevious(oldOperation);
            this.currentOperations().put(key, newOperation);
            this.checkpointMutableContainer(newValue);
            this.dataAvailability.put(key, Boolean.TRUE);
        }
    }

    public void put(String key, Object value) {
        if (key == null) {
            throw new IllegalArgumentException("key may not be null.");
        }
        if (value == null) {
            throw new IllegalArgumentException("value may not be null.");
        }
        if (!Parse.isValidType(value)) {
            throw new IllegalArgumentException("invalid type for value: " + value.getClass().toString());
        }
        this.performOperation(key, new ParseSetOperation(value));
    }

    public void increment(String key) {
        this.increment(key, 1);
    }

    public void increment(String key, Number amount) {
        ParseIncrementOperation operation = new ParseIncrementOperation(amount);
        this.performOperation(key, operation);
    }

    public void add(String key, Object value) {
        this.addAll(key, Arrays.asList(value));
    }

    public void addAll(String key, Collection<?> values) {
        ParseAddOperation operation = new ParseAddOperation(values);
        this.performOperation(key, operation);
    }

    public void addUnique(String key, Object value) {
        this.addAllUnique(key, Arrays.asList(value));
    }

    public void addAllUnique(String key, Collection<?> values) {
        ParseAddUniqueOperation operation = new ParseAddUniqueOperation(values);
        this.performOperation(key, operation);
    }

    public void removeAll(String key, Collection<?> values) {
        ParseRemoveOperation operation = new ParseRemoveOperation(values);
        this.performOperation(key, operation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(String key) {
        Object object = this.mutex;
        synchronized (object) {
            return this.estimatedData.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(String key) {
        Object object = this.mutex;
        synchronized (object) {
            this.checkGetAccess(key);
            if (!this.estimatedData.containsKey(key)) {
                return null;
            }
            Object value = this.estimatedData.get(key);
            if (!(value instanceof String)) {
                return null;
            }
            return (String)value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes(String key) {
        Object object = this.mutex;
        synchronized (object) {
            this.checkGetAccess(key);
            if (!this.estimatedData.containsKey(key)) {
                return null;
            }
            Object value = this.estimatedData.get(key);
            if (!(value instanceof byte[])) {
                return null;
            }
            return (byte[])value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Number getNumber(String key) {
        Object object = this.mutex;
        synchronized (object) {
            this.checkGetAccess(key);
            if (!this.estimatedData.containsKey(key)) {
                return null;
            }
            Object value = this.estimatedData.get(key);
            if (!(value instanceof Number)) {
                return null;
            }
            return (Number)value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONArray getJSONArray(String key) {
        Object object = this.mutex;
        synchronized (object) {
            this.checkGetAccess(key);
            if (!this.estimatedData.containsKey(key)) {
                return null;
            }
            Object value = this.estimatedData.get(key);
            if (value instanceof List) {
                List l = (List)value;
                value = Parse.encodeAsJSONArray(l, true);
                this.put(key, value);
            }
            if (!(value instanceof JSONArray)) {
                return null;
            }
            return (JSONArray)value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> getList(String key) {
        Object object = this.mutex;
        synchronized (object) {
            if (!this.estimatedData.containsKey(key)) {
                return null;
            }
            List<Object> value = this.estimatedData.get(key);
            if (value instanceof JSONArray) {
                value = Parse.convertArrayToList((JSONArray)value);
                this.put(key, value);
            }
            if (!(value instanceof List)) {
                return null;
            }
            List<Object> returnValue = value;
            return returnValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> Map<String, V> getMap(String key) {
        Object object = this.mutex;
        synchronized (object) {
            if (!this.estimatedData.containsKey(key)) {
                return null;
            }
            Map<String, Object> value = this.estimatedData.get(key);
            if (value instanceof JSONObject) {
                value = Parse.convertJSONObjectToMap((JSONObject)value);
                this.put(key, value);
            }
            if (!(value instanceof Map)) {
                return null;
            }
            Map<String, Object> returnValue = value;
            return returnValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject getJSONObject(String key) {
        Object object = this.mutex;
        synchronized (object) {
            this.checkGetAccess(key);
            if (!this.estimatedData.containsKey(key)) {
                return null;
            }
            Object value = this.estimatedData.get(key);
            if (value instanceof Map) {
                value = Parse.encodeJSONObject(value, true);
                this.put(key, value);
            }
            if (!(value instanceof JSONObject)) {
                return null;
            }
            return (JSONObject)value;
        }
    }

    public int getInt(String key) {
        Number number = this.getNumber(key);
        if (number == null) {
            return 0;
        }
        return number.intValue();
    }

    public double getDouble(String key) {
        Number number = this.getNumber(key);
        if (number == null) {
            return 0.0;
        }
        return number.doubleValue();
    }

    public long getLong(String key) {
        Number number = this.getNumber(key);
        if (number == null) {
            return 0L;
        }
        return number.longValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBoolean(String key) {
        Object object = this.mutex;
        synchronized (object) {
            this.checkGetAccess(key);
            if (!this.estimatedData.containsKey(key)) {
                return false;
            }
            Object value = this.estimatedData.get(key);
            if (!(value instanceof Boolean)) {
                return false;
            }
            return (Boolean)value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getDate(String key) {
        Object object = this.mutex;
        synchronized (object) {
            this.checkGetAccess(key);
            if (!this.estimatedData.containsKey(key)) {
                return null;
            }
            Object value = this.estimatedData.get(key);
            if (!(value instanceof Date)) {
                return null;
            }
            return (Date)value;
        }
    }

    public ParseObject getParseObject(String key) {
        Object value = this.get(key);
        if (!(value instanceof ParseObject)) {
            return null;
        }
        return (ParseObject)value;
    }

    public ParseUser getParseUser(String key) {
        Object value = this.get(key);
        if (!(value instanceof ParseUser)) {
            return null;
        }
        return (ParseUser)value;
    }

    public ParseFile getParseFile(String key) {
        Object value = this.get(key);
        if (!(value instanceof ParseFile)) {
            return null;
        }
        return (ParseFile)value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParseGeoPoint getParseGeoPoint(String key) {
        Object object = this.mutex;
        synchronized (object) {
            this.checkGetAccess(key);
            if (!this.estimatedData.containsKey(key)) {
                return null;
            }
            Object value = this.estimatedData.get(key);
            if (!(value instanceof ParseGeoPoint)) {
                return null;
            }
            return (ParseGeoPoint)value;
        }
    }

    public ParseACL getACL() {
        return this.getACL(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ParseACL getACL(boolean mayCopy) {
        Object object = this.mutex;
        synchronized (object) {
            this.checkGetAccess("ACL");
            Object acl = this.estimatedData.get("ACL");
            if (acl == null) {
                return null;
            }
            if (!(acl instanceof ParseACL)) {
                throw new RuntimeException("only ACLs can be stored in the ACL key");
            }
            if (mayCopy && ((ParseACL)acl).isShared()) {
                ParseACL copy = ((ParseACL)acl).copy();
                this.estimatedData.put("ACL", copy);
                this.addToHashedObjects(copy);
                return copy;
            }
            return (ParseACL)acl;
        }
    }

    public void setACL(ParseACL acl) {
        this.put("ACL", acl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDataAvailable() {
        Object object = this.mutex;
        synchronized (object) {
            return this.hasBeenFetched;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDataAvailable(String key) {
        Object object = this.mutex;
        synchronized (object) {
            return this.isDataAvailable() || this.dataAvailability.containsKey(key) && this.dataAvailability.get(key) != false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends ParseObject> ParseRelation<T> getRelation(String key) {
        Object object = this.mutex;
        synchronized (object) {
            ParseRelation relation = new ParseRelation(this, key);
            Object value = this.estimatedData.get(key);
            if (value instanceof ParseRelation) {
                relation.setTargetClass(((ParseRelation)value).getTargetClass());
            }
            return relation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String key) {
        Object object = this.mutex;
        synchronized (object) {
            ParseACL acl;
            this.checkGetAccess(key);
            if (!this.estimatedData.containsKey(key)) {
                return null;
            }
            Object value = this.estimatedData.get(key);
            if (value instanceof ParseACL && key.equals("ACL") && (acl = (ParseACL)value).isShared()) {
                ParseACL copy = acl.copy();
                this.estimatedData.put("ACL", copy);
                this.addToHashedObjects(copy);
                return this.getACL();
            }
            if (value instanceof ParseRelation) {
                ((ParseRelation)value).ensureParentAndKey(this, key);
            }
            return value;
        }
    }

    private void checkGetAccess(String key) {
        if (!this.isDataAvailable(key)) {
            throw new IllegalStateException("ParseObject has no data for this key.  Call fetchIfNeeded() to get the data.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSameId(ParseObject other) {
        Object object = this.mutex;
        synchronized (object) {
            return this.getClassName() != null && this.getObjectId() != null && this.getClassName().equals(other.getClassName()) && this.getObjectId().equals(other.getObjectId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerSaveListener(GetCallback<ParseObject> callback) {
        Object object = this.mutex;
        synchronized (object) {
            this.saveEvent.subscribe(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterSaveListener(GetCallback<ParseObject> callback) {
        Object object = this.mutex;
        synchronized (object) {
            this.saveEvent.unsubscribe(callback);
        }
    }

    static String getClassName(Class<? extends ParseObject> clazz) {
        String name = classNames.get(clazz);
        if (name == null) {
            ParseClassName info = clazz.getAnnotation(ParseClassName.class);
            if (info == null) {
                return null;
            }
            name = info.value();
            classNames.put(clazz, name);
        }
        return name;
    }

    void setDefaultValues() {
        if (this.needsDefaultACL() && ParseACL.getDefaultACL() != null) {
            this.setACL(ParseACL.getDefaultACL());
        }
    }

    boolean needsDefaultACL() {
        return true;
    }

    static {
        ParseObject.registerSubclass(ParseUser.class);
        ParseObject.registerSubclass(ParseRole.class);
        ParseObject.registerSubclass(ParseInstallation.class);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
        format.setTimeZone(new SimpleTimeZone(0, "GMT"));
        impreciseDateFormat = format;
        isCreatingPointer = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return false;
            }
        };
    }
}

