/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Looper;
import com.parse.Parse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;

class PushConnection {
    static final String TAG = "com.parse.push.connection";
    private Object socketLock = new Object();
    private Socket socket;
    private BufferedReader reader = null;
    private OutputStreamWriter writer = null;
    private Thread readerThread = null;
    private String server;
    private int port;
    static long generalTimeout = 1800000L;
    static int connectTimeout = 40000;
    static final ConnectivityReceiver connectivityReceiver = new ConnectivityReceiver();
    boolean hasRegisteredReceiver = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PushConnection(Context context) {
        ConnectivityReceiver connectivityReceiver = PushConnection.connectivityReceiver;
        synchronized (connectivityReceiver) {
            if (!this.hasRegisteredReceiver) {
                context.registerReceiver((BroadcastReceiver)PushConnection.connectivityReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
                this.hasRegisteredReceiver = true;
            }
        }
        PushConnection.connectivityReceiver.delegate = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(String pushServer, int pushPort, boolean forceReconnect) {
        boolean shouldCreateSocket = forceReconnect;
        Socket cachedSocket = null;
        if (!shouldCreateSocket) {
            Object object = this.socketLock;
            synchronized (object) {
                shouldCreateSocket = this.socket == null || this.socket.isClosed() || this.server != pushServer || this.port != pushPort;
                cachedSocket = this.socket;
            }
        }
        if (shouldCreateSocket) {
            Socket newSocket = null;
            try {
                Parse.logV(TAG, "connecting to push server at " + pushServer + ":" + pushPort);
                InetSocketAddress address = new InetSocketAddress(pushServer, pushPort);
                newSocket = new Socket();
                newSocket.setKeepAlive(true);
                newSocket.connect(address, connectTimeout);
                assert (!newSocket.isClosed());
            }
            catch (UnknownHostException e) {
                Parse.logV(TAG, "unknown host " + e.toString());
                this.close();
                return;
            }
            catch (IOException e) {
                Parse.logV(TAG, "could not connect to push server " + e.toString());
                this.close();
                return;
            }
            Object object = this.socketLock;
            synchronized (object) {
                if (this.socket != cachedSocket) {
                    return;
                }
                this.close();
                this.socket = newSocket;
                this.server = pushServer;
                this.port = pushPort;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        block18: {
            Socket cachedSocket;
            OutputStreamWriter cachedWriter;
            BufferedReader cachedReader;
            Object object = this.socketLock;
            synchronized (object) {
                cachedReader = this.reader;
                cachedWriter = this.writer;
                cachedSocket = this.socket;
                if (this.readerThread != null) {
                    Parse.logV(TAG, "Trying to interrupt long poll in another thread");
                    this.readerThread.interrupt();
                }
                this.reader = null;
                this.writer = null;
                this.socket = null;
            }
            if (Looper.myLooper() == Looper.getMainLooper()) {
                return;
            }
            try {
                if (cachedReader != null) {
                    object = cachedReader;
                    synchronized (object) {
                        cachedReader.close();
                    }
                }
                if (cachedWriter != null) {
                    object = cachedWriter;
                    synchronized (object) {
                        cachedWriter.close();
                    }
                }
                if (cachedSocket == null) break block18;
                object = cachedSocket;
                synchronized (object) {
                    cachedSocket.close();
                }
            }
            catch (IOException e) {
                Parse.logV(TAG, "error closing socket", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readLine() throws IOException {
        BufferedReader cachedReader = null;
        Object object = this.socketLock;
        synchronized (object) {
            block24: {
                if (this.socket != null && !this.socket.isClosed()) break block24;
                return null;
            }
            if (this.reader == null) {
                Parse.logV(TAG, "Creating a new reader");
                this.reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            }
            cachedReader = this.reader;
            assert (this.readerThread == null);
            this.readerThread = Thread.currentThread();
        }
        object = cachedReader;
        synchronized (object) {
            Object object2;
            String string2;
            try {
                string2 = cachedReader.readLine();
                object2 = this.socketLock;
            }
            catch (IOException e) {
                Object object3;
                try {
                    Parse.logV(TAG, "IOException in blocking read: " + e.toString());
                    object3 = this.socketLock;
                }
                catch (Throwable throwable) {
                    Object object4 = this.socketLock;
                    synchronized (object4) {
                        this.readerThread = null;
                    }
                    throw throwable;
                }
                synchronized (object3) {
                    this.readerThread = null;
                }
                return null;
            }
            synchronized (object2) {
                this.readerThread = null;
            }
            return string2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean trySend(String message) {
        OutputStreamWriter cachedWriter = null;
        Object object = this.socketLock;
        synchronized (object) {
            if (this.socket == null) return false;
            if (this.socket.isClosed()) {
                return false;
            }
            if (this.writer == null) {
                try {
                    this.writer = new OutputStreamWriter(this.socket.getOutputStream(), "UTF-8");
                }
                catch (IOException e) {
                    Parse.logE(TAG, "Failed to open write socket", e);
                    return false;
                }
            }
            cachedWriter = this.writer;
        }
        object = cachedWriter;
        synchronized (object) {
            try {
                Parse.logV(TAG, "Sending message " + message);
                cachedWriter.write(String.valueOf(message) + "\n");
                cachedWriter.flush();
            }
            catch (UnsupportedEncodingException e) {
                Parse.logE(TAG, "unsupported encoding", e);
                return false;
            }
            catch (IOException e) {
                Parse.logE(TAG, "could not construct writer", e);
                return false;
            }
            return true;
        }
    }

    private static class ConnectivityReceiver
    extends BroadcastReceiver {
        PushConnection delegate;

        private ConnectivityReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if (this.delegate != null) {
                this.delegate.close();
            }
        }
    }
}

