/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.webkit.MimeTypeMap;
import com.parse.Continuation;
import com.parse.CountingMultipartEntity;
import com.parse.GetDataCallback;
import com.parse.Parse;
import com.parse.ParseCommand;
import com.parse.ParseException;
import com.parse.ParseRequestRetryer;
import com.parse.ParseUser;
import com.parse.ProgressCallback;
import com.parse.SaveCallback;
import com.parse.Task;
import com.parse.TaskQueue;
import com.parse.entity.mime.HttpMultipartMode;
import com.parse.entity.mime.content.ByteArrayBody;
import com.parse.entity.mime.content.StringBody;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParseFile {
    private boolean dirty = false;
    private String name = null;
    private String url = null;
    private byte[] data;
    private HttpPost fileUploadPost = null;
    final TaskQueue taskQueue = new TaskQueue();
    private Set<Task.TaskCompletionSource> currentTasks = Collections.synchronizedSet(new HashSet());

    public ParseFile(byte[] data) {
        if (data.length > Parse.maxParseFileSize) {
            throw new IllegalArgumentException(String.format("ParseFile must be less than %i bytes", Parse.maxParseFileSize));
        }
        this.dirty = true;
        this.data = data;
    }

    public ParseFile(String name, byte[] data) {
        if (data.length > Parse.maxParseFileSize) {
            throw new IllegalArgumentException(String.format("ParseFile must be less than %i bytes", Parse.maxParseFileSize));
        }
        this.name = name;
        this.data = data;
        this.dirty = true;
    }

    ParseFile(String name, String url) {
        this.name = name;
        this.url = url;
    }

    public String getName() {
        return this.name;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isDataAvailable() {
        return this.data != null;
    }

    public String getUrl() {
        return this.url;
    }

    private ParseCommand constructFileUploadCommand(String sessionToken) {
        ParseCommand currentCommand = new ParseCommand("upload_file", sessionToken);
        currentCommand.enableRetrying();
        if (this.name != null) {
            currentCommand.put("name", this.name);
        }
        return currentCommand;
    }

    private void prepareFileUploadPost(JSONObject result, ProgressCallback progressCallback) {
        JSONObject postParams = null;
        try {
            this.name = result.getString("name");
            this.url = result.getString("url");
            postParams = result.getJSONObject("post_params");
        }
        catch (JSONException e) {
            throw new RuntimeException(e.getMessage());
        }
        String mimeType = null;
        CountingMultipartEntity entity = new CountingMultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE, progressCallback);
        if (this.name.lastIndexOf(".") != -1) {
            String extension = this.name.substring(this.name.lastIndexOf(".") + 1);
            mimeType = MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension);
        }
        if (mimeType == null) {
            mimeType = "application/octet-stream";
        }
        try {
            entity.addPart("Content-Type", new StringBody(mimeType));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage());
        }
        Iterator keys = postParams.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            try {
                entity.addPart(key, new StringBody(postParams.getString(key)));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e.getMessage());
            }
            catch (JSONException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        entity.addPart("file", new ByteArrayBody(this.data, mimeType, "file"));
        try {
            this.fileUploadPost = new HttpPost(result.getString("post_url"));
        }
        catch (JSONException e) {
            throw new RuntimeException(e.getMessage());
        }
        this.fileUploadPost.setEntity((HttpEntity)entity);
    }

    private Task<Void> handleFileUploadResultAsync(JSONObject result, ProgressCallback progressCallback) {
        if (this.fileUploadPost == null) {
            this.prepareFileUploadPost(result, progressCallback);
        }
        ParseRequestRetryer retryer = new ParseRequestRetryer((HttpUriRequest)this.fileUploadPost, 1000L, 5);
        return retryer.goAsync(null).makeVoid();
    }

    public void save() throws ParseException {
        this.save(null);
    }

    private void save(ProgressCallback progressCallback) throws ParseException {
        Parse.waitForTask(this.saveAsync(progressCallback));
    }

    Task<Void> saveAsync(final ProgressCallback progressCallback, Task<Void> toAwait) {
        if (!this.isDirty()) {
            return Task.forResult(null);
        }
        final Task.TaskCompletionSource tcs = Task.create();
        this.currentTasks.add(tcs);
        toAwait.continueWith(new Continuation<Void, Void>(){

            @Override
            public Void then(Task<Void> task) throws Exception {
                if (!ParseFile.this.isDirty()) {
                    tcs.trySetResult(null);
                    return null;
                }
                final String sessionToken = ParseUser.getCurrentSessionToken();
                Task.call(new Callable<ParseCommand>(){

                    @Override
                    public ParseCommand call() throws Exception {
                        final ParseCommand command = ParseFile.this.constructFileUploadCommand(sessionToken);
                        tcs.getTask().continueWith(new Continuation<Void, Void>(){

                            @Override
                            public Void then(Task<Void> task) throws Exception {
                                if (task.isCancelled()) {
                                    command.cancel();
                                }
                                return null;
                            }
                        });
                        return command;
                    }
                }).onSuccessTask(new Continuation<ParseCommand, Task<Object>>(){

                    @Override
                    public Task<Object> then(Task<ParseCommand> task) throws Exception {
                        return task.getResult().performAsync();
                    }
                }).onSuccessTask(new Continuation<Object, Task<Void>>(){

                    @Override
                    public Task<Void> then(Task<Object> task) throws Exception {
                        return ParseFile.this.handleFileUploadResultAsync((JSONObject)task.getResult(), progressCallback);
                    }
                }).continueWithTask(new Continuation<Void, Task<Void>>(){

                    @Override
                    public Task<Void> then(Task<Void> task) throws Exception {
                        if (!task.isFaulted()) {
                            ParseFile.this.dirty = false;
                        }
                        return task;
                    }
                }).continueWith(new Continuation<Void, Void>(){

                    @Override
                    public Void then(Task<Void> task) throws Exception {
                        ParseFile.this.currentTasks.remove(tcs);
                        if (task.isCancelled()) {
                            tcs.trySetCancelled();
                        } else if (task.isFaulted()) {
                            tcs.trySetError(task.getError());
                        } else {
                            tcs.trySetResult(task.getResult());
                        }
                        return null;
                    }
                });
                return null;
            }
        });
        return tcs.getTask();
    }

    Task<Void> saveAsync(final ProgressCallback progressCallback) {
        return this.taskQueue.enqueue(new Continuation<Void, Task<Void>>(){

            @Override
            public Task<Void> then(Task<Void> task) throws Exception {
                return ParseFile.this.saveAsync(progressCallback, task);
            }
        });
    }

    public synchronized void saveInBackground(SaveCallback saveCallback, ProgressCallback progressCallback) {
        Parse.callbackOnMainThreadAsync(this.saveAsync(progressCallback), saveCallback);
    }

    public void saveInBackground(SaveCallback callback) {
        this.saveInBackground(callback, null);
    }

    public void saveInBackground() {
        this.saveInBackground(null);
    }

    public byte[] getData() throws ParseException {
        return Parse.waitForTask(this.getDataAsync(null));
    }

    private Task<byte[]> getDataAsync(final ProgressCallback progressCallback, Task<Void> toAwait) {
        if (this.isDataAvailable()) {
            return Task.forResult(this.data);
        }
        final Task.TaskCompletionSource tcs = Task.create();
        this.currentTasks.add(tcs);
        toAwait.continueWith(new Continuation<Void, Void>(){

            @Override
            public Void then(Task<Void> task) throws Exception {
                ParseRequestRetryer retryer = new ParseRequestRetryer((HttpUriRequest)new HttpGet(ParseFile.this.url), 1000L, 5);
                retryer.goAsync(progressCallback).continueWithTask(new Continuation<byte[], Task<byte[]>>(){

                    @Override
                    public Task<byte[]> then(Task<byte[]> task) throws Exception {
                        if (task.isFaulted() && task.getError() instanceof IllegalStateException) {
                            return Task.forError(new ParseException(100, task.getError().getMessage()));
                        }
                        if (tcs.getTask().isCancelled()) {
                            return tcs.getTask();
                        }
                        ParseFile.access$502(ParseFile.this, task.getResult());
                        return task;
                    }
                }).continueWith(new Continuation<byte[], Void>(){

                    @Override
                    public Void then(Task<byte[]> task) throws Exception {
                        ParseFile.this.currentTasks.remove(tcs);
                        if (task.isCancelled()) {
                            tcs.trySetCancelled();
                        } else if (task.isFaulted()) {
                            tcs.trySetError(task.getError());
                        } else {
                            tcs.trySetResult(task.getResult());
                        }
                        return null;
                    }
                });
                return null;
            }
        });
        return tcs.getTask();
    }

    Task<byte[]> getDataAsync(final ProgressCallback progressCallback) {
        return this.taskQueue.enqueue(new Continuation<Void, Task<byte[]>>(){

            @Override
            public Task<byte[]> then(Task<Void> task) throws Exception {
                return ParseFile.this.getDataAsync(progressCallback, task);
            }
        });
    }

    public void getDataInBackground(GetDataCallback dataCallback, ProgressCallback progressCallback) {
        Parse.callbackOnMainThreadAsync(this.getDataAsync(progressCallback), dataCallback);
    }

    public void getDataInBackground(GetDataCallback dataCallback) {
        this.getDataInBackground(dataCallback, null);
    }

    public void cancel() {
        HashSet<Task.TaskCompletionSource> tasks = new HashSet<Task.TaskCompletionSource>(this.currentTasks);
        for (Task.TaskCompletionSource tcs : tasks) {
            tcs.trySetCancelled();
        }
        this.currentTasks.removeAll(tasks);
    }

    static /* synthetic */ byte[] access$502(ParseFile x0, byte[] x1) {
        x0.data = x1;
        return x1;
    }
}

