/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import com.parse.Continuation;
import com.parse.ParseACL;
import com.parse.ParseCallback;
import com.parse.ParseCommandCache;
import com.parse.ParseException;
import com.parse.ParseFieldOperation;
import com.parse.ParseFieldOperations;
import com.parse.ParseFile;
import com.parse.ParseGeoPoint;
import com.parse.ParseObject;
import com.parse.ParseRelation;
import com.parse.Task;
import com.parse.codec.binary.Base64;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SimpleTimeZone;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parse {
    private static final String TAG = "com.parse.Parse";
    static Context applicationContext;
    static String applicationId;
    static String clientKey;
    public static final int LOG_LEVEL_VERBOSE = 2;
    public static final int LOG_LEVEL_DEBUG = 3;
    public static final int LOG_LEVEL_INFO = 4;
    public static final int LOG_LEVEL_WARNING = 5;
    public static final int LOG_LEVEL_ERROR = 6;
    public static final int LOG_LEVEL_NONE = Integer.MAX_VALUE;
    private static int logLevel;
    static int maxParseFileSize;
    static int maxKeyValueCacheBytes;
    static int maxKeyValueCacheFiles;
    static ParseCommandCache commandCache;
    private static final DateFormat dateFormat;
    static Executor uiThreadExecutor;

    private Parse() {
        throw new AssertionError();
    }

    public static void initialize(Context context, String applicationId, String clientKey) {
        Parse.applicationId = applicationId;
        Parse.clientKey = clientKey;
        if (context != null) {
            applicationContext = context.getApplicationContext();
            Parse.checkCacheApplicationId();
            new Thread("Parse.initialize Starting Command Cache"){

                public void run() {
                    Parse.getCommandCache();
                }
            }.start();
        }
    }

    public static void setLogLevel(int logLevel) {
        Parse.logLevel = logLevel;
    }

    public static int getLogLevel() {
        return logLevel;
    }

    private static void log(int messageLogLevel, String tag, String message, Throwable tr) {
        if (messageLogLevel >= logLevel) {
            if (tr == null) {
                Log.println((int)logLevel, (String)tag, (String)message);
            } else {
                Log.println((int)logLevel, (String)tag, (String)(message + '\n' + Log.getStackTraceString((Throwable)tr)));
            }
        }
    }

    static void logV(String tag, String message, Throwable tr) {
        Parse.log(2, tag, message, tr);
    }

    static void logV(String tag, String message) {
        Parse.logV(tag, message, null);
    }

    static void logD(String tag, String message, Throwable tr) {
        Parse.log(3, tag, message, tr);
    }

    static void logD(String tag, String message) {
        Parse.logD(tag, message, null);
    }

    static void logI(String tag, String message, Throwable tr) {
        Parse.log(4, tag, message, tr);
    }

    static void logI(String tag, String message) {
        Parse.logI(tag, message, null);
    }

    static void logW(String tag, String message, Throwable tr) {
        Parse.log(5, tag, message, tr);
    }

    static void logW(String tag, String message) {
        Parse.logW(tag, message, null);
    }

    static void logE(String tag, String message, Throwable tr) {
        Parse.log(6, tag, message, tr);
    }

    static void logE(String tag, String message) {
        Parse.logE(tag, message, null);
    }

    static void setContextIfNeeded(Context context) {
        if (applicationContext == null) {
            applicationContext = context;
        }
    }

    static synchronized File getParseDir() {
        Parse.checkContext();
        return applicationContext.getDir("Parse", 0);
    }

    static synchronized void recursiveDelete(File file) {
        if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                Parse.recursiveDelete(f);
            }
        }
        file.delete();
    }

    static synchronized void checkCacheApplicationId() {
        if (applicationId != null) {
            File applicationIdFile = new File(Parse.getParseDir(), "applicationId");
            if (applicationIdFile.exists()) {
                boolean matches = false;
                try {
                    RandomAccessFile f = new RandomAccessFile(applicationIdFile, "r");
                    byte[] bytes = new byte[(int)f.length()];
                    f.readFully(bytes);
                    f.close();
                    String diskApplicationId = new String(bytes, "UTF-8");
                    matches = diskApplicationId.equals(applicationId);
                }
                catch (FileNotFoundException e) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (!matches) {
                    Parse.recursiveDelete(Parse.getParseDir());
                }
            }
            applicationIdFile = new File(Parse.getParseDir(), "applicationId");
            try {
                FileOutputStream out = new FileOutputStream(applicationIdFile);
                out.write(applicationId.getBytes("UTF-8"));
                out.close();
            }
            catch (FileNotFoundException e) {
            }
            catch (UnsupportedEncodingException e) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static synchronized File getKeyValueCacheDir() {
        Parse.checkContext();
        File appCacheDir = applicationContext.getCacheDir();
        File parseCacheDir = new File(appCacheDir, "ParseKeyValueCache");
        if (parseCacheDir.isDirectory() || parseCacheDir.mkdir()) {
            return parseCacheDir;
        }
        throw new RuntimeException("could not create Parse cache directory");
    }

    static File getKeyValueCacheFile(String key) {
        final String suffix = '.' + key;
        File[] matches = Parse.getKeyValueCacheDir().listFiles(new FilenameFilter(){

            public boolean accept(File dir, String filename) {
                return filename.endsWith(suffix);
            }
        });
        return matches.length == 0 ? null : matches[0];
    }

    static long getKeyValueCacheAge(File cacheFile) {
        String name = cacheFile.getName();
        try {
            return Long.parseLong(name.substring(0, name.indexOf(46)));
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    static File createKeyValueCacheFile(String key) {
        String filename = String.valueOf(new Date().getTime()) + '.' + key;
        return new File(Parse.getKeyValueCacheDir(), filename);
    }

    static void clearCacheDir() {
        File dir = Parse.getKeyValueCacheDir();
        File[] entries = dir.listFiles();
        if (entries == null) {
            return;
        }
        for (int i = 0; i < entries.length; ++i) {
            entries[i].delete();
        }
    }

    static void saveToKeyValueCache(String key, String value) {
        File prior = Parse.getKeyValueCacheFile(key);
        if (prior != null) {
            prior.delete();
        }
        File f = Parse.createKeyValueCacheFile(key);
        try {
            FileOutputStream out = new FileOutputStream(f);
            out.write(value.getBytes("UTF-8"));
            out.close();
        }
        catch (UnsupportedEncodingException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        File[] files = Parse.getKeyValueCacheDir().listFiles();
        int numFiles = files.length;
        int numBytes = 0;
        for (File file : files) {
            numBytes = (int)((long)numBytes + file.length());
        }
        if (numFiles > maxKeyValueCacheFiles || numBytes > maxKeyValueCacheBytes) {
            Arrays.sort(files, new Comparator<File>(){

                @Override
                public int compare(File f1, File f2) {
                    int dateCompare = Long.valueOf(f1.lastModified()).compareTo(f2.lastModified());
                    if (dateCompare != 0) {
                        return dateCompare;
                    }
                    return f1.getName().compareTo(f2.getName());
                }
            });
            for (File file : files) {
                numBytes = (int)((long)numBytes - file.length());
                file.delete();
                if (--numFiles <= maxKeyValueCacheFiles && numBytes <= maxKeyValueCacheBytes) break;
            }
        }
    }

    static void clearFromKeyValueCache(String key) {
        File file = Parse.getKeyValueCacheFile(key);
        if (file != null) {
            file.delete();
        }
    }

    static String loadFromKeyValueCache(String key, long maxAgeMilliseconds) {
        File file = Parse.getKeyValueCacheFile(key);
        if (file == null) {
            return null;
        }
        Date now = new Date();
        long oldestAcceptableAge = Math.max(0L, now.getTime() - maxAgeMilliseconds);
        if (Parse.getKeyValueCacheAge(file) < oldestAcceptableAge) {
            return null;
        }
        file.setLastModified(now.getTime());
        try {
            RandomAccessFile f = new RandomAccessFile(file, "r");
            byte[] bytes = new byte[(int)f.length()];
            f.readFully(bytes);
            f.close();
            return new String(bytes, "UTF-8");
        }
        catch (IOException e) {
            Parse.logE(TAG, "error reading from cache", e);
            return null;
        }
    }

    static Object jsonFromKeyValueCache(String key, long maxAgeMilliseconds) {
        String raw = Parse.loadFromKeyValueCache(key, maxAgeMilliseconds);
        if (raw == null) {
            return null;
        }
        JSONTokener tokener = new JSONTokener(raw);
        try {
            Object o = tokener.nextValue();
            return o;
        }
        catch (JSONException e) {
            Parse.logE(TAG, "corrupted cache for " + key, e);
            Parse.clearFromKeyValueCache(key);
            return null;
        }
    }

    static synchronized ParseCommandCache getCommandCache() {
        if (commandCache == null) {
            Parse.checkContext();
            commandCache = new ParseCommandCache(applicationContext);
        }
        return commandCache;
    }

    static void checkInit() {
        if (applicationId == null) {
            throw new RuntimeException("applicationId is null. You must call Parse.initialize(context, applicationId, clientKey) before using the Parse library.");
        }
        if (clientKey == null) {
            throw new RuntimeException("clientKey is null. You must call Parse.initialize(context, applicationId, clientKey) before using the Parse library.");
        }
    }

    static void checkContext() {
        if (applicationContext == null) {
            throw new RuntimeException("applicationContext is null. You must call Parse.initialize(context, applicationId, clientKey) before using the Parse library.");
        }
    }

    static boolean hasPermission(String permission) {
        Parse.checkContext();
        return applicationContext.checkCallingOrSelfPermission(permission) == 0;
    }

    static void requirePermission(String permission) {
        if (!Parse.hasPermission(permission)) {
            throw new IllegalStateException("To use this functionality, add this to your AndroidManifest.xml:\n<uses-permission android:name=\"" + permission + "\" />");
        }
    }

    static List<Object> convertArrayToList(JSONArray array) {
        ArrayList<Object> new_array = new ArrayList<Object>();
        for (int i = 0; i < array.length(); ++i) {
            Object oldValue = array.opt(i);
            Object newValue = Parse.decodeJSONObject(oldValue);
            if (newValue != null) {
                new_array.add(newValue);
                continue;
            }
            new_array.add(oldValue);
        }
        return new_array;
    }

    static Map<String, Object> convertJSONObjectToMap(JSONObject object) {
        HashMap<String, Object> outputMap = new HashMap<String, Object>();
        Iterator it = object.keys();
        while (it.hasNext()) {
            String key = (String)it.next();
            Object value = object.opt(key);
            Object decodedObject = Parse.decodeJSONObject(value);
            if (decodedObject != null) {
                outputMap.put(key, decodedObject);
                continue;
            }
            if (value instanceof JSONArray) {
                outputMap.put(key, Parse.convertArrayToList((JSONArray)value));
                continue;
            }
            outputMap.put(key, value);
        }
        return outputMap;
    }

    static Object decodeJSONObject(Object object) {
        if (!(object instanceof JSONObject)) {
            return null;
        }
        JSONObject jsonObject = (JSONObject)object;
        String opString = jsonObject.optString("__op", null);
        if (opString != null) {
            try {
                return ParseFieldOperations.decode(jsonObject);
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        }
        String typeString = jsonObject.optString("__type", null);
        if (typeString == null) {
            return Parse.convertJSONObjectToMap(jsonObject);
        }
        if (typeString.equals("Date")) {
            String iso = jsonObject.optString("iso");
            return Parse.parseDate(iso);
        }
        if (typeString.equals("Bytes")) {
            String base64 = jsonObject.optString("base64");
            return Base64.decodeBase64(base64);
        }
        if (typeString.equals("Pointer")) {
            return ParseObject.createWithoutData(jsonObject.optString("className"), jsonObject.optString("objectId"));
        }
        if (typeString.equals("File")) {
            return new ParseFile(jsonObject.optString("name"), jsonObject.optString("url"));
        }
        if (typeString.equals("GeoPoint")) {
            double longitude;
            double latitude;
            try {
                latitude = jsonObject.getDouble("latitude");
                longitude = jsonObject.getDouble("longitude");
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
            return new ParseGeoPoint(latitude, longitude);
        }
        if (typeString.equals("Object")) {
            JSONObject nested = new JSONObject();
            try {
                nested.put("data", (Object)jsonObject);
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
            ParseObject output = ParseObject.createWithoutData(jsonObject.optString("className"), null);
            output.mergeAfterFetch(nested);
            return output;
        }
        if (typeString.equals("Relation")) {
            return new ParseRelation(jsonObject.optString("className", null));
        }
        return null;
    }

    static JSONObject encodeJSONObject(Object object, boolean allowParseObjects) {
        try {
            if (object instanceof Date) {
                return Parse.dateToObject((Date)object);
            }
            if (object instanceof byte[]) {
                JSONObject json = new JSONObject();
                json.put("__type", (Object)"Bytes");
                json.put("base64", (Object)Base64.encodeBase64String((byte[])object));
                return json;
            }
            if (object instanceof ParseObject) {
                if (!allowParseObjects) {
                    throw new IllegalArgumentException("ParseObjects not allowed here");
                }
                return Parse.parseObjectToJSONPointer((ParseObject)object);
            }
            if (object instanceof ParseFile) {
                ParseFile file = (ParseFile)object;
                JSONObject json = new JSONObject();
                json.put("__type", (Object)"File");
                json.put("url", (Object)file.getUrl());
                json.put("name", (Object)file.getName());
                return json;
            }
            if (object instanceof ParseGeoPoint) {
                ParseGeoPoint point = (ParseGeoPoint)object;
                JSONObject json = new JSONObject();
                json.put("__type", (Object)"GeoPoint");
                json.put("latitude", point.getLatitude());
                json.put("longitude", point.getLongitude());
                return json;
            }
            if (object instanceof ParseACL) {
                ParseACL acl = (ParseACL)object;
                return acl.toJSONObject();
            }
            if (object instanceof Map) {
                Map map = (Map)object;
                JSONObject json = new JSONObject();
                for (Map.Entry pair : map.entrySet()) {
                    json.put((String)pair.getKey(), Parse.maybeEncodeJSONObject(pair.getValue(), allowParseObjects));
                }
                return json;
            }
            if (object instanceof ParseRelation) {
                ParseRelation relation = (ParseRelation)object;
                return relation.encodeToJSON();
            }
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    static boolean isValidType(Object value) {
        return value instanceof JSONObject || value instanceof JSONArray || value instanceof String || value instanceof Number || value instanceof Boolean || value == JSONObject.NULL || value instanceof ParseObject || value instanceof ParseACL || value instanceof ParseFile || value instanceof ParseGeoPoint || value instanceof Date || value instanceof byte[] || value instanceof List || value instanceof Map || value instanceof ParseRelation;
    }

    static JSONArray encodeAsJSONArray(List<Object> list, boolean allowParseObjects) {
        JSONArray new_array = new JSONArray();
        for (Object o : list) {
            if (!Parse.isValidType(o)) {
                throw new IllegalArgumentException("invalid type for value in array: " + o.getClass().toString());
            }
            new_array.put(Parse.maybeEncodeJSONObject(o, allowParseObjects));
        }
        return new_array;
    }

    static Object maybeEncodeJSONObject(Object value, boolean allowParseObjects) {
        if (value instanceof List) {
            List input = (List)value;
            return Parse.encodeAsJSONArray(input, allowParseObjects);
        }
        if (value instanceof ParseFieldOperation) {
            try {
                return ((ParseFieldOperation)value).encode();
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        }
        JSONObject json = Parse.encodeJSONObject(value, allowParseObjects);
        if (null == json) {
            return value;
        }
        return json;
    }

    static Object maybeReferenceAndEncode(Object value) {
        if (value instanceof ParseObject && ((ParseObject)value).getObjectId() == null) {
            throw new IllegalStateException("unable to encode an association with an unsaved ParseObject");
        }
        return Parse.maybeEncodeJSONObject(value, true);
    }

    static JSONObject parseObjectToJSONPointer(ParseObject pointedTo) {
        JSONObject json = new JSONObject();
        try {
            if (pointedTo.getObjectId() != null) {
                json.put("__type", (Object)"Pointer");
                json.put("className", (Object)pointedTo.getClassName());
                json.put("objectId", (Object)pointedTo.getObjectId());
            } else {
                json.put("__type", (Object)"Pointer");
                json.put("className", (Object)pointedTo.getClassName());
                json.put("localId", (Object)pointedTo.getOrCreateLocalId());
            }
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        return json;
    }

    static synchronized Date parseDate(String dateString) {
        try {
            return dateFormat.parse(dateString);
        }
        catch (java.text.ParseException e) {
            Parse.logE(TAG, "could not parse date: " + dateString, e);
            return null;
        }
    }

    static synchronized String encodeDate(Date date) {
        return dateFormat.format(date);
    }

    static JSONObject dateToObject(Date date) {
        JSONObject object = new JSONObject();
        String iso = Parse.encodeDate(date);
        try {
            object.put("__type", (Object)"Date");
            object.put("iso", (Object)iso);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        return object;
    }

    static Iterable<String> keys(JSONObject object) {
        final JSONObject finalObject = object;
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                Iterator answer = finalObject.keys();
                return answer;
            }
        };
    }

    static boolean isContainerObject(Object object) {
        return object instanceof JSONObject || object instanceof JSONArray || object instanceof ParseACL || object instanceof ParseGeoPoint || object instanceof List || object instanceof Map;
    }

    static Number addNumbers(Number first, Number second) {
        if (first instanceof Double) {
            return first.doubleValue() + second.doubleValue();
        }
        if (first instanceof Long) {
            return first.longValue() + second.longValue();
        }
        if (first instanceof Float) {
            return Float.valueOf(first.floatValue() + second.floatValue());
        }
        if (first instanceof Short) {
            return first.shortValue() + second.shortValue();
        }
        if (first instanceof Byte) {
            return first.byteValue() + second.byteValue();
        }
        return first.intValue() + second.intValue();
    }

    static String join(Collection<String> items, String delimiter) {
        StringBuffer buffer = new StringBuffer();
        Iterator<String> iter = items.iterator();
        if (iter.hasNext()) {
            buffer.append(iter.next());
            while (iter.hasNext()) {
                buffer.append(delimiter);
                buffer.append(iter.next());
            }
        }
        return buffer.toString();
    }

    static <T> T waitForTask(Task<T> task) throws ParseException {
        try {
            task.waitForCompletion();
            if (task.isFaulted()) {
                Exception error = task.getError();
                if (error instanceof ParseException) {
                    throw (ParseException)error;
                }
                if (error instanceof RuntimeException) {
                    throw (RuntimeException)error;
                }
                throw new RuntimeException(error);
            }
            if (task.isCancelled()) {
                throw new RuntimeException(new CancellationException());
            }
            return task.getResult();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    static <T> Task<T> callbackOnMainThreadAsync(Task<T> task, ParseCallback<T> callback) {
        return Parse.callbackOnMainThreadAsync(task, callback, false);
    }

    static <T> Task<T> callbackOnMainThreadAsync(Task<T> task, final ParseCallback<T> callback, final boolean reportCancellation) {
        if (callback == null) {
            return task;
        }
        final Task.TaskCompletionSource tcs = Task.create();
        task.continueWith(new Continuation<T, Void>(){

            @Override
            public Void then(final Task<T> task) throws Exception {
                if (task.isCancelled() && !reportCancellation) {
                    tcs.setCancelled();
                    return null;
                }
                uiThreadExecutor.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            Exception error = task.getError();
                            if (error != null && !(task.getError() instanceof ParseException)) {
                                if (error instanceof RuntimeException) {
                                    throw (RuntimeException)error;
                                }
                                throw new RuntimeException(error);
                            }
                            callback.internalDone(task.getResult(), (ParseException)error);
                        }
                        finally {
                            if (task.isCancelled()) {
                                tcs.setCancelled();
                            } else if (task.isFaulted()) {
                                tcs.setError(task.getError());
                            } else {
                                tcs.setResult(task.getResult());
                            }
                        }
                    }
                });
                return null;
            }
        });
        return tcs.getTask();
    }

    static {
        logLevel = 6;
        maxParseFileSize = 0xA00000;
        maxKeyValueCacheBytes = 0x200000;
        maxKeyValueCacheFiles = 1000;
        commandCache = null;
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.US);
        format.setTimeZone(new SimpleTimeZone(0, "GMT"));
        dateFormat = format;
        uiThreadExecutor = new Executor(){

            public void execute(Runnable command) {
                new Handler(Looper.getMainLooper()).post(command);
            }
        };
    }
}

