/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import com.parse.Continuation;
import com.parse.CountCallback;
import com.parse.FindCallback;
import com.parse.GetCallback;
import com.parse.Parse;
import com.parse.ParseCommand;
import com.parse.ParseException;
import com.parse.ParseGeoPoint;
import com.parse.ParseObject;
import com.parse.ParseUser;
import com.parse.Task;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParseQuery {
    private static final String TAG = "com.parse.ParseQuery";
    private String className;
    private HashMap<String, Object> where;
    private ArrayList<String> include;
    private int limit;
    private boolean trace;
    private int skip;
    private String order;
    private long queryStart;
    private long querySent;
    private long queryReceived;
    private long objectsParsed;
    private ParseCommand currentCommand = null;
    private Boolean isRunning = false;
    private HashMap<String, Object> extraOptions = null;
    private CachePolicy cachePolicy;
    private long maxCacheAge;

    public static ParseQuery or(List<ParseQuery> queries) {
        ArrayList<ParseQuery> localList = new ArrayList<ParseQuery>();
        String className = null;
        for (int i = 0; i < queries.size(); ++i) {
            if (className != null && !queries.get((int)i).className.equals(className)) {
                throw new IllegalArgumentException("All of the queries in an or query must be on the same class ");
            }
            className = queries.get((int)i).className;
            localList.add(queries.get(i));
        }
        if (localList.size() == 0) {
            throw new IllegalArgumentException("Can't take an or of an empty list of queries");
        }
        ParseQuery value = new ParseQuery(className);
        return value.whereSatifiesAnyOf(localList);
    }

    public ParseQuery(String theClassName) {
        this.className = theClassName;
        this.limit = -1;
        this.skip = 0;
        this.where = new HashMap();
        this.include = new ArrayList();
        this.cachePolicy = CachePolicy.IGNORE_CACHE;
        this.maxCacheAge = Long.MAX_VALUE;
        this.trace = false;
        this.extraOptions = new HashMap();
    }

    @Deprecated
    public static ParseQuery getUserQuery() {
        return ParseUser.getQuery();
    }

    private void checkIfRunning() {
        this.checkIfRunning(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkIfRunning(boolean grabLock) {
        Boolean bl = this.isRunning;
        synchronized (bl) {
            if (this.isRunning.booleanValue()) {
                throw new RuntimeException("This query has an outstanding network connection. You have to wait until it's done.");
            }
            if (grabLock) {
                this.isRunning = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishedRunning() {
        Boolean bl = this.isRunning;
        synchronized (bl) {
            this.isRunning = false;
            this.currentCommand = null;
        }
    }

    private <T> Task<T> finishRunning(Task<T> task) {
        return task.continueWithTask(new Continuation<T, Task<T>>(){

            @Override
            public Task<T> then(Task<T> task) throws Exception {
                ParseQuery.this.finishedRunning();
                return task;
            }
        });
    }

    private Object maybeEncodeSubQueries(Object value) throws JSONException {
        if (!(value instanceof JSONObject)) {
            return value;
        }
        JSONObject json = (JSONObject)value;
        Iterator keys = json.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Object object = json.opt(key);
            if (object instanceof ParseQuery) {
                ParseQuery query = (ParseQuery)object;
                JSONObject realData = query.getFindParams();
                if (!realData.isNull("data")) {
                    realData.put("where", realData.get("data"));
                    realData.remove("data");
                }
                realData.put("className", realData.remove("classname"));
                json.put(key, (Object)realData);
                continue;
            }
            if (!(object instanceof JSONObject)) continue;
            json.put(key, this.maybeEncodeSubQueries(object));
        }
        return json;
    }

    JSONObject getFindParams() {
        JSONObject params = new JSONObject();
        try {
            params.put("classname", (Object)this.className);
            JSONObject whereData = new JSONObject();
            for (String key : this.where.keySet()) {
                if (key.equals("$or")) {
                    List queries = (List)this.where.get(key);
                    JSONArray array = new JSONArray();
                    for (ParseQuery query : queries) {
                        if (query.limit >= 0) {
                            throw new IllegalArgumentException("Cannot have limits in sub queries of an 'OR' query");
                        }
                        if (query.skip > 0) {
                            throw new IllegalArgumentException("Cannot have skips in sub queries of an 'OR' query");
                        }
                        if (query.order != null) {
                            throw new IllegalArgumentException("Cannot have an order in sub queries of an 'OR' query");
                        }
                        if (!query.include.isEmpty()) {
                            throw new IllegalArgumentException("Cannot have an include in sub queries of an 'OR' query");
                        }
                        JSONObject object = query.getFindParams();
                        if (!object.isNull("data")) {
                            array.put(object.get("data"));
                            continue;
                        }
                        array.put((Object)new JSONObject());
                    }
                    whereData.put(key, (Object)array);
                    continue;
                }
                Object value = this.maybeEncodeSubQueries(this.where.get(key));
                whereData.put(key, Parse.maybeReferenceAndEncode(value));
            }
            params.put("data", (Object)whereData);
            if (this.limit >= 0) {
                params.put("limit", this.limit);
            }
            if (this.skip > 0) {
                params.put("skip", this.skip);
            }
            if (this.order != null) {
                params.put("order", (Object)this.order);
            }
            if (!this.include.isEmpty()) {
                params.put("include", (Object)Parse.join(this.include, ","));
            }
            if (this.trace) {
                params.put("trace", (Object)"1");
            }
            for (String key : this.extraOptions.keySet()) {
                params.put(key, Parse.maybeReferenceAndEncode(this.extraOptions.get(key)));
            }
        }
        catch (JSONException e) {
            throw new RuntimeException(e.getMessage());
        }
        return params;
    }

    private ParseCommand makeFindCommand(String sessionToken) {
        ParseCommand command = new ParseCommand("find", sessionToken);
        JSONObject params = this.getFindParams();
        Iterator keys = params.keys();
        try {
            while (keys.hasNext()) {
                String key = (String)keys.next();
                command.put(key, params.get(key).toString());
            }
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        return command;
    }

    private List<ParseObject> convertFindResponse(JSONObject response) throws JSONException {
        ArrayList<ParseObject> answer = new ArrayList<ParseObject>();
        JSONArray results = response.getJSONArray("results");
        if (results == null) {
            Parse.logD(TAG, "null results in find response");
        } else {
            String resultClassName = response.optString("className");
            if (resultClassName == "") {
                resultClassName = this.className;
            }
            for (int i = 0; i < results.length(); ++i) {
                ParseObject object = ParseObject.createWithoutData(resultClassName, null);
                object.mergeAfterFetch(results.getJSONObject(i));
                answer.add(object);
            }
        }
        this.objectsParsed = System.nanoTime();
        if (response.has("trace")) {
            Object serverTrace = response.get("trace");
            String fullTrace = "Query pre-processing took " + (this.querySent - this.queryStart) + " milliseconds\n";
            fullTrace = fullTrace + serverTrace + "\n";
            fullTrace = fullTrace + "Client side parsing took " + (this.objectsParsed - this.queryReceived) + " millisecond\n";
            Parse.logD("ParseQuery", fullTrace);
        }
        return answer;
    }

    private <T> Task<T> runCommandWithPolicyAsync(final CommandDelegate<T> c, CachePolicy policy) {
        switch (policy) {
            case IGNORE_CACHE: 
            case NETWORK_ONLY: {
                return c.runOnNetworkAsync(true);
            }
            case CACHE_ONLY: {
                return c.runFromCacheAsync();
            }
            case CACHE_ELSE_NETWORK: {
                return c.runFromCacheAsync().continueWithTask(new Continuation<T, Task<T>>(){

                    @Override
                    public Task<T> then(Task<T> task) throws Exception {
                        if (task.isFaulted() && task.getError() instanceof ParseException) {
                            return c.runOnNetworkAsync(true);
                        }
                        return task;
                    }
                });
            }
            case NETWORK_ELSE_CACHE: {
                return c.runOnNetworkAsync(false).continueWithTask(new Continuation<T, Task<T>>(){

                    @Override
                    public Task<T> then(Task<T> task) throws Exception {
                        if (task.isFaulted() && task.getError() instanceof ParseException && ((ParseException)task.getError()).getCode() == 100) {
                            return c.runFromCacheAsync();
                        }
                        return task;
                    }
                });
            }
            case CACHE_THEN_NETWORK: {
                throw new RuntimeException("You cannot use the cache policy CACHE_THEN_NETWORK with find()");
            }
        }
        throw new RuntimeException("Unknown cache policy: " + (Object)((Object)this.cachePolicy));
    }

    private Task<Integer> countWithCachePolicyAsync(CachePolicy policy) {
        CommandDelegate<Integer> callbacks = new CommandDelegate<Integer>(){

            @Override
            public Task<Integer> runOnNetworkAsync(boolean retry) {
                return ParseQuery.this.countFromNetworkAsync();
            }

            @Override
            public Task<Integer> runFromCacheAsync() {
                return Task.call(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        return ParseQuery.this.countFromCache();
                    }
                }, ParseCommand.networkThreadPool);
            }
        };
        return this.runCommandWithPolicyAsync(callbacks, policy);
    }

    Task<List<ParseObject>> findAsync() {
        this.checkIfRunning(true);
        return this.finishRunning(this.findWithCachePolicyAsync(this.cachePolicy));
    }

    private Task<List<ParseObject>> findWithCachePolicyAsync(CachePolicy policy) {
        CommandDelegate<List<ParseObject>> callbacks = new CommandDelegate<List<ParseObject>>(){

            @Override
            public Task<List<ParseObject>> runOnNetworkAsync(boolean retry) {
                return ParseQuery.this.findFromNetworkAsync(retry);
            }

            @Override
            public Task<List<ParseObject>> runFromCacheAsync() {
                return Task.call(new Callable<List<ParseObject>>(){

                    @Override
                    public List<ParseObject> call() throws Exception {
                        return ParseQuery.this.findFromCache();
                    }
                }, ParseCommand.networkThreadPool);
            }
        };
        return this.runCommandWithPolicyAsync(callbacks, policy);
    }

    public void cancel() {
        if (this.currentCommand != null) {
            this.currentCommand.cancel();
            this.currentCommand = null;
        }
        this.isRunning = false;
    }

    public List<ParseObject> find() throws ParseException {
        return Parse.waitForTask(this.findAsync());
    }

    public ParseObject getFirst() throws ParseException {
        return Parse.waitForTask(this.getFirstAsync());
    }

    private Task<List<ParseObject>> findFromNetworkAsync(final boolean shouldRetry) {
        this.currentCommand = this.makeFindCommand(ParseUser.getCurrentSessionToken());
        return Task.call(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                if (shouldRetry) {
                    ParseQuery.this.currentCommand.enableRetrying();
                }
                return null;
            }
        }).onSuccessTask(new Continuation<Void, Task<List<ParseObject>>>(){

            @Override
            public Task<List<ParseObject>> then(Task<Void> task) throws Exception {
                ArrayList answer = new ArrayList();
                if (ParseQuery.this.currentCommand == null) {
                    return Task.forResult(answer);
                }
                boolean caching = ParseQuery.this.cachePolicy != CachePolicy.IGNORE_CACHE;
                ParseQuery.this.querySent = System.nanoTime();
                return ParseQuery.this.currentCommand.performAsync(caching).onSuccess(new Continuation<Object, List<ParseObject>>(){

                    @Override
                    public List<ParseObject> then(Task<Object> task) throws Exception {
                        ParseQuery.this.queryReceived = System.nanoTime();
                        return ParseQuery.this.convertFindResponse((JSONObject)task.getResult());
                    }
                });
            }
        });
    }

    public void setCachePolicy(CachePolicy newCachePolicy) {
        this.checkIfRunning();
        this.cachePolicy = newCachePolicy;
    }

    public CachePolicy getCachePolicy() {
        return this.cachePolicy;
    }

    public void setMaxCacheAge(long maxAgeInMilliseconds) {
        this.maxCacheAge = maxAgeInMilliseconds;
    }

    public long getMaxCacheAge() {
        return this.maxCacheAge;
    }

    private List<ParseObject> findFromCache() throws ParseException {
        String cacheKey = this.makeFindCommand(ParseUser.getCurrentSessionToken()).getCacheKey();
        Object cached = Parse.jsonFromKeyValueCache(cacheKey, this.maxCacheAge);
        if (cached == null) {
            throw new ParseException(120, "results not cached");
        }
        if (!(cached instanceof JSONObject)) {
            throw new ParseException(120, "the cache contains the wrong datatype");
        }
        JSONObject object = (JSONObject)cached;
        try {
            return this.convertFindResponse(object);
        }
        catch (JSONException e) {
            throw new ParseException(120, "the cache contains corrupted json");
        }
    }

    private Integer countFromCache() throws ParseException {
        String cacheKey = this.makeCountCommand(ParseUser.getCurrentSessionToken()).getCacheKey();
        Object cached = Parse.jsonFromKeyValueCache(cacheKey, this.maxCacheAge);
        if (cached == null) {
            throw new ParseException(120, "results not cached");
        }
        if (!(cached instanceof JSONObject)) {
            throw new ParseException(120, "the cache contains the wrong datatype");
        }
        JSONObject object = (JSONObject)cached;
        try {
            return object.getInt("count");
        }
        catch (JSONException e) {
            throw new ParseException(120, "the cache contains corrupted json");
        }
    }

    public void findInBackground(FindCallback callback) {
        Task<List<ParseObject>> findTask;
        this.checkIfRunning(true);
        this.queryStart = System.nanoTime();
        if (this.cachePolicy == CachePolicy.CACHE_THEN_NETWORK) {
            findTask = this.findWithCachePolicyAsync(CachePolicy.CACHE_ONLY);
            findTask = Parse.callbackOnMainThreadAsync(findTask, callback);
            findTask = findTask.continueWithTask(new Continuation<List<ParseObject>, Task<List<ParseObject>>>(){

                @Override
                public Task<List<ParseObject>> then(Task<List<ParseObject>> task) throws Exception {
                    if (task.isCancelled()) {
                        return task;
                    }
                    return ParseQuery.this.findWithCachePolicyAsync(CachePolicy.NETWORK_ONLY);
                }
            });
        } else {
            findTask = this.findWithCachePolicyAsync(this.cachePolicy);
        }
        Parse.callbackOnMainThreadAsync(this.finishRunning(findTask), callback);
    }

    private Task<ParseObject> getFirstAsync() {
        this.setLimit(1);
        return this.findAsync().onSuccess(new Continuation<List<ParseObject>, ParseObject>(){

            @Override
            public ParseObject then(Task<List<ParseObject>> task) throws Exception {
                if (task.getResult() != null && task.getResult().size() > 0) {
                    return task.getResult().get(0);
                }
                throw new ParseException(101, "no results found for query");
            }
        });
    }

    public void getFirstInBackground(GetCallback callback) {
        Parse.callbackOnMainThreadAsync(this.getFirstAsync(), callback);
    }

    private ParseCommand makeCountCommand(String sessionToken) {
        ParseCommand command = this.makeFindCommand(sessionToken);
        command.put("limit", 0);
        command.put("count", 1);
        return command;
    }

    public int count() throws ParseException {
        return this.count(true);
    }

    protected int count(boolean needsLock) throws ParseException {
        if (needsLock) {
            this.checkIfRunning(true);
        }
        return Parse.waitForTask(this.finishRunning(this.countWithCachePolicyAsync(this.cachePolicy)));
    }

    private Task<Integer> countFromNetworkAsync() {
        boolean caching = this.cachePolicy != CachePolicy.IGNORE_CACHE;
        this.currentCommand = this.makeCountCommand(ParseUser.getCurrentSessionToken());
        return this.currentCommand.performAsync(caching).continueWith(new Continuation<Object, Integer>(){

            @Override
            public Integer then(Task<Object> task) throws Exception {
                return ((JSONObject)task.getResult()).optInt("count");
            }
        });
    }

    public void countInBackground(CountCallback callback) {
        this.checkIfRunning(true);
        Parse.callbackOnMainThreadAsync(this.finishRunning(this.countWithCachePolicyAsync(this.cachePolicy)), callback);
    }

    private Task<ParseObject> getAsync(String theObjectId) {
        this.skip = -1;
        this.where = new HashMap();
        this.where.put("objectId", theObjectId);
        return this.getFirstAsync();
    }

    public ParseObject get(String theObjectId) throws ParseException {
        return Parse.waitForTask(this.getAsync(theObjectId));
    }

    public boolean hasCachedResult() {
        String raw = Parse.loadFromKeyValueCache(this.makeFindCommand(ParseUser.getCurrentSessionToken()).getCacheKey(), this.maxCacheAge);
        return raw != null;
    }

    public void clearCachedResult() {
        Parse.clearFromKeyValueCache(this.makeFindCommand(ParseUser.getCurrentSessionToken()).getCacheKey());
    }

    public static void clearAllCachedResults() {
        Parse.clearCacheDir();
    }

    public void getInBackground(String objectId, GetCallback callback) {
        Parse.callbackOnMainThreadAsync(this.getAsync(objectId), callback);
    }

    public ParseQuery whereEqualTo(String key, Object value) {
        this.checkIfRunning();
        if (value instanceof Date) {
            value = Parse.dateToObject((Date)value);
        }
        this.where.put(key, value);
        return this;
    }

    private void addCondition(String key, String condition, Object value) {
        Object existingValue;
        this.checkIfRunning();
        JSONObject whereValue = null;
        value = Parse.maybeReferenceAndEncode(value);
        if (this.where.containsKey(key) && (existingValue = this.where.get(key)) instanceof JSONObject) {
            whereValue = (JSONObject)existingValue;
        }
        if (whereValue == null) {
            whereValue = new JSONObject();
        }
        try {
            whereValue.put(condition, value);
        }
        catch (JSONException e) {
            throw new RuntimeException(e.getMessage());
        }
        this.where.put(key, whereValue);
    }

    public ParseQuery whereLessThan(String key, Object value) {
        this.addCondition(key, "$lt", value);
        return this;
    }

    public ParseQuery whereNotEqualTo(String key, Object value) {
        this.addCondition(key, "$ne", value);
        return this;
    }

    public ParseQuery whereGreaterThan(String key, Object value) {
        this.addCondition(key, "$gt", value);
        return this;
    }

    public ParseQuery whereLessThanOrEqualTo(String key, Object value) {
        this.addCondition(key, "$lte", value);
        return this;
    }

    public ParseQuery whereGreaterThanOrEqualTo(String key, Object value) {
        this.addCondition(key, "$gte", value);
        return this;
    }

    public ParseQuery whereContainedIn(String key, Collection<? extends Object> values) {
        JSONArray array = new JSONArray();
        for (Object object : values) {
            array.put(Parse.maybeReferenceAndEncode(object));
        }
        this.addCondition(key, "$in", array);
        return this;
    }

    public ParseQuery whereContainsAll(String key, Collection<?> values) {
        JSONArray array = new JSONArray();
        for (Object val : values) {
            array.put(Parse.maybeReferenceAndEncode(val));
        }
        this.addCondition(key, "$all", array);
        return this;
    }

    public ParseQuery whereMatchesQuery(String key, ParseQuery query) {
        this.addCondition(key, "$inQuery", query);
        return this;
    }

    public ParseQuery whereDoesNotMatchQuery(String key, ParseQuery query) {
        this.addCondition(key, "$notInQuery", query);
        return this;
    }

    public ParseQuery whereMatchesKeyInQuery(String key, String keyInQuery, ParseQuery query) {
        JSONObject condition = new JSONObject();
        try {
            condition.put("key", (Object)keyInQuery);
            condition.put("query", (Object)query);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        this.addCondition(key, "$select", condition);
        return this;
    }

    public ParseQuery whereDoesNotMatchKeyInQuery(String key, String keyInQuery, ParseQuery query) {
        JSONObject condition = new JSONObject();
        try {
            condition.put("key", (Object)keyInQuery);
            condition.put("query", (Object)query);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        this.addCondition(key, "$dontSelect", condition);
        return this;
    }

    private ParseQuery whereSatifiesAnyOf(List<ParseQuery> queries) {
        this.where.put("$or", queries);
        return this;
    }

    public ParseQuery whereNotContainedIn(String key, Collection<? extends Object> values) {
        JSONArray array = new JSONArray();
        for (Object object : values) {
            array.put(Parse.maybeReferenceAndEncode(object));
        }
        this.addCondition(key, "$nin", array);
        return this;
    }

    public ParseQuery whereNear(String key, ParseGeoPoint point) {
        this.addCondition(key, "$nearSphere", point);
        return this;
    }

    public ParseQuery whereWithinMiles(String key, ParseGeoPoint point, double maxDistance) {
        this.whereWithinRadians(key, point, maxDistance / ParseGeoPoint.EARTH_MEAN_RADIUS_MILE);
        return this;
    }

    public ParseQuery whereWithinKilometers(String key, ParseGeoPoint point, double maxDistance) {
        this.whereWithinRadians(key, point, maxDistance / ParseGeoPoint.EARTH_MEAN_RADIUS_KM);
        return this;
    }

    public ParseQuery whereWithinRadians(String key, ParseGeoPoint point, double maxDistance) {
        this.addCondition(key, "$nearSphere", point);
        this.addCondition(key, "$maxDistance", maxDistance);
        return this;
    }

    public ParseQuery whereWithinGeoBox(String key, ParseGeoPoint southwest, ParseGeoPoint northeast) {
        ArrayList<Object> array = new ArrayList<Object>();
        array.add(Parse.maybeReferenceAndEncode(southwest));
        array.add(Parse.maybeReferenceAndEncode(northeast));
        HashMap<String, ArrayList<Object>> dictionary = new HashMap<String, ArrayList<Object>>();
        dictionary.put("$box", array);
        this.addCondition(key, "$within", dictionary);
        return this;
    }

    public ParseQuery whereMatches(String key, String regex) {
        this.addCondition(key, "$regex", regex);
        return this;
    }

    public ParseQuery whereMatches(String key, String regex, String modifiers) {
        this.addCondition(key, "$regex", regex);
        if (modifiers.length() != 0) {
            this.addCondition(key, "$options", modifiers);
        }
        return this;
    }

    public ParseQuery whereContains(String key, String substring) {
        String regex = Pattern.quote(substring);
        this.whereMatches(key, regex);
        return this;
    }

    public ParseQuery whereStartsWith(String key, String prefix) {
        String regex = "^" + Pattern.quote(prefix);
        this.whereMatches(key, regex);
        return this;
    }

    public ParseQuery whereEndsWith(String key, String suffix) {
        String regex = Pattern.quote(suffix) + "$";
        this.whereMatches(key, regex);
        return this;
    }

    public void include(String key) {
        this.checkIfRunning();
        this.include.add(key);
    }

    public ParseQuery whereExists(String key) {
        this.addCondition(key, "$exists", true);
        return this;
    }

    public ParseQuery whereDoesNotExist(String key) {
        this.addCondition(key, "$exists", false);
        return this;
    }

    ParseQuery whereRelatedTo(ParseObject parent, String key) {
        this.addCondition("$relatedTo", "object", Parse.maybeReferenceAndEncode(parent));
        this.addCondition("$relatedTo", "key", key);
        return this;
    }

    ParseQuery redirectClassNameForKey(String key) {
        this.extraOptions.put("redirectClassNameForKey", key);
        return this;
    }

    public ParseQuery orderByAscending(String key) {
        this.checkIfRunning();
        this.order = key;
        return this;
    }

    public ParseQuery addAscendingOrder(String key) {
        this.checkIfRunning();
        this.order = this.order == null ? key : this.order + "," + key;
        return this;
    }

    public ParseQuery orderByDescending(String key) {
        this.checkIfRunning();
        this.order = "-" + key;
        return this;
    }

    public ParseQuery addDescendingOrder(String key) {
        this.checkIfRunning();
        this.order = this.order == null ? "-" + key : this.order + ",-" + key;
        return this;
    }

    public void setLimit(int newLimit) {
        this.checkIfRunning();
        this.limit = newLimit;
    }

    public void setTrace(boolean shouldTrace) {
        this.trace = shouldTrace;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setSkip(int newSkip) {
        this.checkIfRunning();
        this.skip = newSkip;
    }

    public int getSkip() {
        return this.skip;
    }

    public String getClassName() {
        return this.className;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface CommandDelegate<T> {
        public Task<T> runOnNetworkAsync(boolean var1);

        public Task<T> runFromCacheAsync();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CachePolicy {
        IGNORE_CACHE,
        CACHE_ONLY,
        NETWORK_ONLY,
        CACHE_ELSE_NETWORK,
        NETWORK_ELSE_CACHE,
        CACHE_THEN_NETWORK;

    }
}

