/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.parse.Parse;
import com.parse.ParseCommand;
import com.parse.ParseObject;
import com.parse.Task;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ParseCommandCache {
    private static final String TAG = "com.parse.ParseCommandCache";
    private File cachePath;
    private int timeoutMaxRetries = 5;
    private double timeoutRetryWaitSeconds = 600.0;
    private int maxCacheSizeBytes = 0xA00000;
    private static int filenameCounter = 0;
    private boolean shouldStop = false;
    private boolean connected = false;
    private HashMap<File, Task.TaskCompletionSource> pendingTasks = new HashMap();
    private static Object lock = new Object();
    private boolean running = false;
    private Object runningLock;
    private Logger log;
    private TestHelper testHelper = null;

    public ParseCommandCache(Context context) {
        lock = new Object();
        this.runningLock = new Object();
        this.log = Logger.getLogger(TAG);
        File parseDir = Parse.getParseDir();
        this.cachePath = new File(parseDir, "CommandCache");
        this.cachePath.mkdirs();
        if (!Parse.hasPermission("android.permission.ACCESS_NETWORK_STATE")) {
            return;
        }
        final ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectivityManager != null) {
            NetworkInfo network = connectivityManager.getActiveNetworkInfo();
            this.setConnected(network != null && network.isConnected());
            context.registerReceiver(new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    boolean connectionLost = intent.getBooleanExtra("noConnectivity", false);
                    if (connectionLost) {
                        ParseCommandCache.this.setConnected(false);
                    } else {
                        NetworkInfo network = connectivityManager.getActiveNetworkInfo();
                        ParseCommandCache.this.setConnected(network != null && network.isConnected());
                    }
                }
            }, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        }
        this.resume();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimeoutMaxRetries(int tries) {
        Object object = lock;
        synchronized (object) {
            this.timeoutMaxRetries = tries;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimeoutRetryWaitSeconds(double seconds) {
        Object object = lock;
        synchronized (object) {
            this.timeoutRetryWaitSeconds = seconds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxCacheSizeBytes(int bytes) {
        Object object = lock;
        synchronized (object) {
            this.maxCacheSizeBytes = bytes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        Object object = this.runningLock;
        synchronized (object) {
            if (!this.running) {
                new Thread("ParseCommandCache.runLoop()"){

                    public void run() {
                        ParseCommandCache.this.runLoop();
                    }
                }.start();
                try {
                    this.runningLock.wait();
                }
                catch (InterruptedException e) {
                    Object object2 = lock;
                    synchronized (object2) {
                        this.shouldStop = true;
                        lock.notify();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void pause() {
        var1_1 = this.runningLock;
        synchronized (var1_1) {
            if (!this.running) ** GOTO lbl20
            var2_2 = ParseCommandCache.lock;
            synchronized (var2_2) {
                this.shouldStop = true;
                ParseCommandCache.lock.notify();
                // MONITOREXIT @DISABLED, blocks:[0, 1, 3, 4] lbl10 : MonitorExitStatement: MONITOREXIT : var2_2
                if (true) ** GOTO lbl20
            }
            do {
                try {
                    this.runningLock.wait();
                }
                catch (InterruptedException var2_3) {
                    // empty catch block
                }
lbl20:
                // 4 sources

            } while (this.running);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFile(File file) {
        Object object = lock;
        synchronized (object) {
            block18: {
                this.pendingTasks.remove(file);
                JSONObject json = null;
                InputStream input = null;
                try {
                    try {
                        int read;
                        input = new BufferedInputStream(new FileInputStream(file));
                        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                        byte[] temp = new byte[1024];
                        while ((read = input.read(temp)) > 0) {
                            buffer.write(temp, 0, read);
                        }
                        json = new JSONObject(buffer.toString("UTF-8"));
                        ParseCommand command = new ParseCommand(json);
                        command.releaseLocalIds();
                    }
                    catch (Exception exception) {
                        if (input != null) {
                            try {
                                input.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block18;
                    }
                }
                catch (Throwable throwable) {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void simulateReboot() {
        Object object = lock;
        synchronized (object) {
            this.pendingTasks.clear();
        }
    }

    public Task<Object> runEventuallyAsync(ParseCommand command, ParseObject object) {
        Parse.requirePermission("android.permission.ACCESS_NETWORK_STATE");
        return this.runEventuallyInternalAsync(command, false, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Task<Object> runEventuallyInternalAsync(ParseCommand command, boolean preferOldest, ParseObject object) {
        tcs = Task.create();
        try {
            if (object != null && object.getObjectId() == null) {
                command.setLocalId(object.getOrCreateLocalId());
            }
            jsonObject = command.toJSONObject();
            json = jsonObject.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            if (5 >= Parse.getLogLevel()) {
                this.log.log(Level.WARNING, "UTF-8 isn't supported.  This shouldn't happen.", e);
            }
            if (this.testHelper == null) return Task.forResult(null);
            this.testHelper.notify(4);
            return Task.forResult(null);
        }
        if (json.length > this.maxCacheSizeBytes) {
            if (5 >= Parse.getLogLevel()) {
                this.log.warning("Unable to save command for later because it's too big.");
            }
            if (this.testHelper == null) return Task.forResult(null);
            this.testHelper.notify(4);
            return Task.forResult(null);
        }
        var6_5 = ParseCommandCache.lock;
        synchronized (var6_5) {
            block23: {
                block24: {
                    try {
                        fileNames = this.cachePath.list();
                        if (fileNames == null) ** GOTO lbl65
                        Arrays.sort(fileNames);
                        size = 0;
                        var12_12 = fileNames;
                        var11_13 = fileNames.length;
                        var10_15 = 0;
                        while (true) {
                            block25: {
                                if (var10_15 < var11_13) break block25;
                                if ((size += json.length) <= this.maxCacheSizeBytes) ** GOTO lbl65
                                if (preferOldest) {
                                    if (5 >= Parse.getLogLevel()) {
                                        this.log.warning("Unable to save command for later because storage is full.");
                                    }
                                    var15_22 = Task.forResult(null);
                                    ParseCommandCache.lock.notify();
                                    break;
                                }
                                ** GOTO lbl-1000
                            }
                            fileName = var12_12[var10_15];
                            file = new File(this.cachePath, (String)fileName);
                            size += (int)file.length();
                            ++var10_15;
                        }
                    }
                    catch (IOException e) {
                        if (5 >= Parse.getLogLevel()) {
                            this.log.log(Level.WARNING, "Unable to save command for later.", e);
                        }
                        ParseCommandCache.lock.notify();
                        break block23;
                    }
                    catch (Throwable var14_23) {
                        ParseCommandCache.lock.notify();
                        throw var14_23;
                    }
                    return var15_22;
lbl-1000:
                    // 1 sources

                    {
                        if (5 >= Parse.getLogLevel()) {
                            this.log.warning("Deleting old commands to make room in command cache.");
                        }
                        indexToDelete = 0;
                        while (size > this.maxCacheSizeBytes && indexToDelete < fileNames.length) {
                            file = new File(this.cachePath, (String)fileNames[indexToDelete++]);
                            size -= (int)file.length();
                            this.removeFile(file);
                        }
lbl65:
                        // 3 sources

                        if ((prefix1 = Long.toHexString(System.currentTimeMillis())).length() < 16) {
                            zeroes = new char[16 - prefix1.length()];
                            Arrays.fill(zeroes, '0');
                            prefix1 = String.valueOf(new String(zeroes)) + prefix1;
                        }
                        if ((prefix2 = Integer.toHexString(ParseCommandCache.filenameCounter++)).length() < 8) {
                            zeroes = new char[8 - prefix2.length()];
                            Arrays.fill(zeroes, '0');
                            prefix2 = String.valueOf(new String(zeroes)) + prefix2;
                        }
                        prefix = "CachedCommand_" + prefix1 + "_" + prefix2 + "_";
                        path = File.createTempFile(prefix, "", this.cachePath);
                        this.pendingTasks.put(path, tcs);
                        command.retainLocalIds();
                        output = new BufferedOutputStream(new FileOutputStream(path));
                        output.write(json);
                        output.close();
                        if (this.testHelper == null) break block24;
                        this.testHelper.notify(3);
                    }
                }
                ParseCommandCache.lock.notify();
            }
            return tcs.getTask();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int pendingCount() {
        Object object = lock;
        synchronized (object) {
            String[] files = this.cachePath.list();
            return files == null ? 0 : files.length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = lock;
        synchronized (object) {
            File[] files = this.cachePath.listFiles();
            if (files == null) {
                return;
            }
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                this.removeFile(file);
                ++n2;
            }
            this.pendingTasks.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnected(boolean connected) {
        Object object = lock;
        synchronized (object) {
            if (this.connected != connected) {
                this.connected = connected;
                if (connected) {
                    lock.notify();
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    private void maybeRunAllCommandsNow(int retriesRemaining) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [18[CATCHBLOCK]], but top level block is 16[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void runLoop() {
        if (4 >= Parse.getLogLevel()) {
            this.log.info("Parse command cache has started processing queued commands.");
        }
        var1_1 = this.runningLock;
        synchronized (var1_1) {
            if (this.running) {
                return;
            }
            this.running = true;
            this.runningLock.notifyAll();
        }
        shouldRun = false;
        var2_3 = ParseCommandCache.lock;
        synchronized (var2_3) {
            shouldRun = this.shouldStop == false && Thread.interrupted() == false;
            // MONITOREXIT @DISABLED, blocks:[1, 8] lbl21 : MonitorExitStatement: MONITOREXIT : var2_3
            if (true) ** GOTO lbl50
        }
        do {
            var2_3 = ParseCommandCache.lock;
            synchronized (var2_3) {
                block25: {
                    try {
                        try {
                            this.maybeRunAllCommandsNow(this.timeoutMaxRetries);
                            if (!this.shouldStop) {
                                try {
                                    ParseCommandCache.lock.wait();
                                }
                                catch (InterruptedException e) {
                                    this.shouldStop = true;
                                }
                            }
                        }
                        catch (Exception e) {
                            if (6 >= Parse.getLogLevel()) {
                                this.log.log(Level.SEVERE, "saveEventually thread had an error.", e);
                            }
                            shouldRun = this.shouldStop == false;
                            break block25;
                        }
                    }
                    catch (Throwable var4_7) {
                        shouldRun = this.shouldStop == false;
                        throw var4_7;
                    }
                    shouldRun = this.shouldStop == false;
                }
            }
lbl50:
            // 2 sources

        } while (shouldRun);
        var2_3 = this.runningLock;
        synchronized (var2_3) {
            this.running = false;
            this.runningLock.notifyAll();
        }
        if (4 >= Parse.getLogLevel()) {
            this.log.info("saveEventually thread has stopped processing commands.");
        }
    }

    public TestHelper getTestHelper() {
        if (this.testHelper == null) {
            this.testHelper = new TestHelper();
        }
        return this.testHelper;
    }

    public class TestHelper {
        private static final int MAX_EVENTS = 1000;
        public static final int COMMAND_SUCCESSFUL = 1;
        public static final int COMMAND_FAILED = 2;
        public static final int COMMAND_ENQUEUED = 3;
        public static final int COMMAND_NOT_ENQUEUED = 4;
        public static final int OBJECT_UPDATED = 5;
        public static final int OBJECT_REMOVED = 6;
        @SuppressLint(value={"UseSparseArrays"})
        private HashMap<Integer, Semaphore> events = new HashMap();

        private TestHelper() {
            this.clear();
        }

        public void clear() {
            this.events.clear();
            this.events.put(1, new Semaphore(1000));
            this.events.put(2, new Semaphore(1000));
            this.events.put(3, new Semaphore(1000));
            this.events.put(4, new Semaphore(1000));
            this.events.put(5, new Semaphore(1000));
            this.events.put(6, new Semaphore(1000));
            for (int event : this.events.keySet()) {
                this.events.get(event).acquireUninterruptibly(1000);
            }
        }

        public int unexpectedEvents() {
            int sum = 0;
            for (int event : this.events.keySet()) {
                sum += this.events.get(event).availablePermits();
            }
            return sum;
        }

        public void notify(int event) {
            this.events.get(event).release();
        }

        public boolean waitFor(int event) {
            try {
                return this.events.get(event).tryAcquire(5000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return false;
            }
        }
    }
}

