/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.content.Context;
import com.parse.Parse;
import com.parse.ParseCommand;
import com.parse.ParseCommandCache;
import com.parse.ParseException;
import com.parse.ParseInstallation;
import com.parse.ParseObject;
import com.parse.ParsePushRouter;
import com.parse.ParseUser;
import com.parse.PushCallback;
import com.parse.PushConnection;
import com.parse.PushService;
import com.parse.StandardPushCallback;
import com.parse.Synchronizer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.ServerSocket;
import java.util.Set;
import java.util.concurrent.Semaphore;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParseTestUtils {
    private static final String TAG = "com.parse.ParseTestUtils";
    private static int serverPort = 9000;
    private static Synchronizer synchronizer;

    public static String useServer(String theServer) {
        String oldServer = ParseObject.server;
        ParseObject.server = theServer;
        return oldServer;
    }

    public static String useInvalidServer() {
        return ParseTestUtils.useServer("http://invalid.server:3000");
    }

    public static String useBadServerPort() {
        return ParseTestUtils.useServer("http://10.0.2.2:6666");
    }

    public static void clearApp() {
        ParseCommand command = new ParseCommand("clear_app");
        try {
            command.perform();
        }
        catch (ParseException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static void mockV8Client() {
        ParseCommand command = new ParseCommand("mock_v8_client");
        try {
            command.perform();
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static void unmockV8Client() {
        ParseCommand command = new ParseCommand("unmock_v8_client");
        try {
            command.perform();
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static void beginFakeSleep() {
        PushService.sleepSemaphore = new Semaphore(0);
    }

    public static void endFakeSleep() {
        PushService.sleepSemaphore.release(1000000);
    }

    public static void allowSleep(int millis) {
        PushService.sleepSemaphore.release(millis);
    }

    public static void assertSlept() {
        while (PushService.sleepSemaphore.availablePermits() != 0) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        return;
    }

    public static void useDevPushServer() {
        PushService.useServer("10.0.2.2");
    }

    public static int consecutiveFailures() {
        return PushService.consecutiveFailures;
    }

    public static void saveObjectToDisk(ParseObject object, Context context, String filename) {
        object.saveToDisk(context, filename);
    }

    public static ParseObject getObjectFromDisk(Context context, String filename) {
        return ParseObject.getFromDisk(context, filename);
    }

    public static ParseUser getUserObjectFromDisk(Context context, String filename) {
        return (ParseUser)ParseObject.getFromDisk(context, filename);
    }

    public static void saveStringToDisk(String string2, Context context, String filename) {
        File file = new File(ParseTestUtils.getParseDir(context), filename);
        try {
            FileOutputStream out = new FileOutputStream(file);
            out.write(string2.getBytes("UTF-8"));
            out.close();
        }
        catch (UnsupportedEncodingException e) {
            return;
        }
        catch (IOException e) {
            return;
        }
    }

    static File getParseDir(Context context) {
        return context.getDir("Parse", 0);
    }

    public static void initSynchronizer() {
        synchronizer = new Synchronizer();
    }

    public static Set<String> keySet(ParseObject object) {
        return object.keySet();
    }

    public static void start(int count) {
        synchronizer.start(count);
    }

    public static void assertFinishes() {
        synchronizer.assertFinishes();
    }

    public static void finish() {
        synchronizer.finish();
    }

    public static void setCommandInitialDelay(double seconds) {
        ParseCommand.setInitialDelay(seconds);
    }

    public static void recursiveDelete(File file) {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            File[] children;
            File[] fileArray = children = file.listFiles();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                ParseTestUtils.recursiveDelete(child);
                ++n2;
            }
        }
        file.delete();
    }

    public static void clearFiles() {
        ParseTestUtils.recursiveDelete(Parse.getParseDir());
        ParseTestUtils.recursiveDelete(Parse.getKeyValueCacheDir());
        if (Parse.commandCache != null) {
            Parse.commandCache.pause();
            Parse.commandCache = null;
        }
    }

    public static void clearPushRouterStateFromMemory() {
        ParsePushRouter.clearStateFromMemory();
    }

    public static void clearCurrentInstallationFromMemory() {
        ParseInstallation.currentInstallation = null;
    }

    public static Set<String> pushRoutes(Context context) {
        ParsePushRouter.ensureStateIsLoaded(context);
        return ParsePushRouter.channelRoutes.keySet();
    }

    public static void onPush(Context context, String channel, PushCallback callback) {
        ParsePushRouter.addSingletonRoute(context, channel, callback);
        PushService.startServiceIfRequired(context);
    }

    public static int totalNotifications() {
        return StandardPushCallback.totalNotifications;
    }

    public static int setPushHistoryLength(int length) {
        int old = ParsePushRouter.maxHistory;
        ParsePushRouter.maxHistory = length;
        return old;
    }

    public static String getInstallationId(Context context) {
        return ParseInstallation.getCurrentInstallation().getInstallationId();
    }

    public static String getLastTime() {
        return ParsePushRouter.lastTime;
    }

    public static String getIgnoreAfterTime() {
        return ParsePushRouter.ignoreAfter;
    }

    public static JSONObject getPushRequestJSON(Context context) {
        return ParsePushRouter.getPushRequestJSON(context);
    }

    public static void tearDownPushTest(Context context) {
        ParseTestUtils.clearFiles();
        ParseInstallation.clearCurrentInstallationFromDisk(context);
        ParsePushRouter.clearStateFromDisk(context);
        if (PushService.connection != null) {
            PushService.connection.close();
        }
    }

    public static void setUpPushTest(Context context) {
        StandardPushCallback.disableNotifications = true;
        StandardPushCallback.totalNotifications = 0;
        PushService.sleepSemaphore = null;
        PushService.useServer("localhost");
        ParseTestUtils.useServer("http://10.0.2.2:3000");
        ParsePushRouter.clearStateFromDisk(context);
        ParseInstallation.clearCurrentInstallationFromDisk(context);
        ParseTestUtils.initSynchronizer();
        PushConnection.generalTimeout = 60000L;
        PushConnection.connectTimeout = 60000;
    }

    public static void startServiceIfRequired(Context context) {
        PushService.startServiceIfRequired(context);
    }

    public static String toDeterministicString(Object o) {
        try {
            return ParseCommand.toDeterministicString(o);
        }
        catch (JSONException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static ServerSocket mockPushServer() {
        PushService.usePort(++serverPort);
        Parse.logI(TAG, "running mockPushServer on port " + serverPort);
        try {
            return new ServerSocket(serverPort);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static int numKeyValueCacheFiles() {
        return Parse.getKeyValueCacheDir().listFiles().length;
    }

    public static void setMaxKeyValueCacheFiles(int max) {
        Parse.maxKeyValueCacheFiles = max;
    }

    public static void setMaxKeyValueCacheBytes(int max) {
        Parse.maxKeyValueCacheBytes = max;
    }

    public static void resetCommandCache() {
        ParseCommandCache cache = Parse.getCommandCache();
        ParseCommandCache.TestHelper helper = cache.getTestHelper();
        cache.clear();
        helper.clear();
    }

    public static void disconnectCommandCache() {
        Parse.getCommandCache().setConnected(false);
    }

    public static void reconnectCommandCache() {
        Parse.getCommandCache().setConnected(true);
    }

    public static boolean waitForCommandCacheEnqueue() {
        return Parse.getCommandCache().getTestHelper().waitFor(3);
    }

    public static boolean waitForCommandCacheSuccess() {
        return Parse.getCommandCache().getTestHelper().waitFor(1);
    }

    public static boolean waitForCommandCacheFailure() {
        return Parse.getCommandCache().getTestHelper().waitFor(2);
    }

    public static int commandCacheUnexpectedEvents() {
        return Parse.getCommandCache().getTestHelper().unexpectedEvents();
    }
}

