/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import com.parse.BackgroundTask;
import com.parse.CountCallback;
import com.parse.FindCallback;
import com.parse.GetCallback;
import com.parse.Parse;
import com.parse.ParseCallback;
import com.parse.ParseCommand;
import com.parse.ParseException;
import com.parse.ParseGeoPoint;
import com.parse.ParseObject;
import com.parse.ParseUser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParseQuery {
    private static final String TAG = "com.parse.ParseQuery";
    private String className;
    private HashMap<String, Object> where;
    private ArrayList<String> include;
    private int limit;
    private boolean trace;
    private int skip;
    private String order;
    private long queryStart;
    private long querySent;
    private long queryReceived;
    private long objectsParsed;
    private BackgroundTask<?> currentTask = null;
    private ParseCommand currentCommand = null;
    private Boolean isRunning = false;
    private HashMap<String, Object> extraOptions = null;
    private CachePolicy cachePolicy;
    private long maxCacheAge;

    public static ParseQuery or(List<ParseQuery> queries) {
        ArrayList<ParseQuery> localList = new ArrayList<ParseQuery>();
        String className = null;
        int i = 0;
        while (i < queries.size()) {
            if (className != null && !queries.get((int)i).className.equals(className)) {
                throw new IllegalArgumentException("All of the queries in an or query must be on the same class ");
            }
            className = queries.get((int)i).className;
            localList.add(queries.get(i));
            ++i;
        }
        if (localList.size() == 0) {
            throw new IllegalArgumentException("Can't take an or of an empty list of queries");
        }
        ParseQuery value = new ParseQuery(className);
        return value.whereSatifiesAnyOf(localList);
    }

    public ParseQuery(String theClassName) {
        this.className = theClassName;
        this.limit = -1;
        this.skip = 0;
        this.where = new HashMap();
        this.include = new ArrayList();
        this.cachePolicy = CachePolicy.IGNORE_CACHE;
        this.maxCacheAge = Long.MAX_VALUE;
        this.trace = false;
        this.extraOptions = new HashMap();
    }

    @Deprecated
    public static ParseQuery getUserQuery() {
        return ParseUser.getQuery();
    }

    private void checkIfRunning() {
        this.checkIfRunning(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkIfRunning(boolean grabLock) {
        Boolean bl = this.isRunning;
        synchronized (bl) {
            if (this.isRunning.booleanValue()) {
                throw new RuntimeException("This query has an outstanding network connection. You have to wait until it's done.");
            }
            if (grabLock) {
                this.isRunning = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishedRunning() {
        Boolean bl = this.isRunning;
        synchronized (bl) {
            this.isRunning = false;
            this.currentTask = null;
            this.currentCommand = null;
        }
    }

    private Object maybeEncodeSubQueries(Object value) throws JSONException {
        if (!(value instanceof JSONObject)) {
            return value;
        }
        JSONObject json = (JSONObject)value;
        Iterator keys = json.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Object object = json.opt(key);
            if (object instanceof ParseQuery) {
                ParseQuery query = (ParseQuery)object;
                JSONObject realData = query.getFindParams();
                if (!realData.isNull("data")) {
                    realData.put("where", realData.get("data"));
                    realData.remove("data");
                }
                realData.put("className", realData.remove("classname"));
                json.put(key, (Object)realData);
                continue;
            }
            if (!(object instanceof JSONObject)) continue;
            json.put(key, this.maybeEncodeSubQueries(object));
        }
        return json;
    }

    JSONObject getFindParams() {
        JSONObject params = new JSONObject();
        try {
            params.put("classname", (Object)this.className);
            JSONObject whereData = new JSONObject();
            for (String key : this.where.keySet()) {
                if (key.equals("$or")) {
                    List queries = (List)this.where.get(key);
                    JSONArray array = new JSONArray();
                    for (ParseQuery query : queries) {
                        if (query.limit >= 0) {
                            throw new IllegalArgumentException("Cannot have limits in sub queries of an 'OR' query");
                        }
                        if (query.skip > 0) {
                            throw new IllegalArgumentException("Cannot have skips in sub queries of an 'OR' query");
                        }
                        if (query.order != null) {
                            throw new IllegalArgumentException("Cannot have an order in sub queries of an 'OR' query");
                        }
                        if (!query.include.isEmpty()) {
                            throw new IllegalArgumentException("Cannot have an include in sub queries of an 'OR' query");
                        }
                        JSONObject object = query.getFindParams();
                        if (!object.isNull("data")) {
                            array.put(object.get("data"));
                            continue;
                        }
                        array.put((Object)new JSONObject());
                    }
                    whereData.put(key, (Object)array);
                    continue;
                }
                Object value = this.maybeEncodeSubQueries(this.where.get(key));
                whereData.put(key, Parse.maybeReferenceAndEncode(value));
            }
            params.put("data", (Object)whereData);
            if (this.limit >= 0) {
                params.put("limit", this.limit);
            }
            if (this.skip > 0) {
                params.put("skip", this.skip);
            }
            if (this.order != null) {
                params.put("order", (Object)this.order);
            }
            if (!this.include.isEmpty()) {
                params.put("include", (Object)Parse.join(this.include, ","));
            }
            if (this.trace) {
                params.put("trace", (Object)"1");
            }
            for (String key : this.extraOptions.keySet()) {
                params.put(key, Parse.maybeReferenceAndEncode(this.extraOptions.get(key)));
            }
        }
        catch (JSONException e) {
            throw new RuntimeException(e.getMessage());
        }
        return params;
    }

    private ParseCommand makeFindCommand() {
        ParseCommand command = new ParseCommand("find");
        JSONObject params = this.getFindParams();
        Iterator keys = params.keys();
        try {
            while (keys.hasNext()) {
                String key = (String)keys.next();
                command.put(key, params.get(key).toString());
            }
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        return command;
    }

    private List<ParseObject> convertFindResponse(JSONObject response) throws JSONException {
        ArrayList<ParseObject> answer = new ArrayList<ParseObject>();
        JSONArray results = response.getJSONArray("results");
        if (results == null) {
            Parse.logD(TAG, "null results in find response");
        } else {
            String resultClassName = response.optString("className");
            if (resultClassName == "") {
                resultClassName = this.className;
            }
            int i = 0;
            while (i < results.length()) {
                ParseObject object = ParseObject.createWithoutData(resultClassName, null);
                object.mergeAfterFetch(results.getJSONObject(i));
                answer.add(object);
                ++i;
            }
        }
        this.objectsParsed = System.nanoTime();
        if (response.has("trace")) {
            Object serverTrace = response.get("trace");
            String fullTrace = "Query pre-processing took " + (this.querySent - this.queryStart) + " milliseconds\n";
            fullTrace = String.valueOf(fullTrace) + serverTrace + "\n";
            fullTrace = String.valueOf(fullTrace) + "Client side parsing took " + (this.objectsParsed - this.queryReceived) + " millisecond\n";
            Parse.logD("ParseQuery", fullTrace);
        }
        return answer;
    }

    private <T> T runCommandWithPolicy(CommandDelegate<T> c, CachePolicy policy) throws ParseException {
        switch (policy) {
            case IGNORE_CACHE: 
            case NETWORK_ONLY: {
                return c.runOnNetwork(true);
            }
            case CACHE_ONLY: {
                return c.runFromCache();
            }
            case CACHE_ELSE_NETWORK: {
                try {
                    return c.runFromCache();
                }
                catch (ParseException e) {
                    return c.runOnNetwork(true);
                }
            }
            case NETWORK_ELSE_CACHE: {
                try {
                    return c.runOnNetwork(false);
                }
                catch (ParseException e) {
                    if (e.getCode() != 100) {
                        throw new ParseException(e);
                    }
                    return c.runFromCache();
                }
            }
            case CACHE_THEN_NETWORK: {
                throw new RuntimeException("You cannot use the cache policy CACHE_THEN_NETWORK with find()");
            }
        }
        throw new RuntimeException("Unknown cache policy: " + (Object)((Object)this.cachePolicy));
    }

    private int countWithCachePolicy(CachePolicy policy) throws ParseException {
        CommandDelegate<Integer> callbacks = new CommandDelegate<Integer>(){

            @Override
            public Integer runOnNetwork(boolean retry) throws ParseException {
                return ParseQuery.this.countFromNetwork();
            }

            @Override
            public Integer runFromCache() throws ParseException {
                return ParseQuery.this.countFromCache();
            }
        };
        return this.runCommandWithPolicy(callbacks, policy);
    }

    private List<ParseObject> findWithCachePolicy(CachePolicy policy) throws ParseException {
        CommandDelegate<List<ParseObject>> callbacks = new CommandDelegate<List<ParseObject>>(){

            @Override
            public List<ParseObject> runOnNetwork(boolean retry) throws ParseException {
                return ParseQuery.this.findFromNetwork(retry);
            }

            @Override
            public List<ParseObject> runFromCache() throws ParseException {
                return ParseQuery.this.findFromCache();
            }
        };
        return this.runCommandWithPolicy(callbacks, policy);
    }

    public void cancel() {
        if (this.currentTask != null) {
            this.currentTask.cancel(true);
            this.currentTask = null;
        }
        if (this.currentCommand != null) {
            this.currentCommand.cancel();
            this.currentCommand = null;
        }
        this.isRunning = false;
    }

    public List<ParseObject> find() throws ParseException {
        return this.find(true);
    }

    public List<ParseObject> find(boolean needsLock) throws ParseException {
        List<ParseObject> result;
        if (needsLock) {
            this.checkIfRunning(true);
        }
        this.queryStart = System.nanoTime();
        try {
            result = this.findWithCachePolicy(this.cachePolicy);
        }
        finally {
            this.finishedRunning();
        }
        return result;
    }

    public ParseObject getFirst() throws ParseException {
        return this.getFirst(true);
    }

    protected ParseObject getFirst(boolean needsLock) throws ParseException {
        if (needsLock) {
            this.checkIfRunning(true);
        }
        this.limit = 1;
        List<ParseObject> results = this.find(false);
        if (results != null && results.size() > 0) {
            return results.get(0);
        }
        throw new ParseException(101, "no results matched the query");
    }

    private List<ParseObject> findFromNetwork(boolean shouldRetry) throws ParseException {
        this.currentCommand = this.makeFindCommand();
        if (shouldRetry) {
            this.currentCommand.enableRetrying();
        }
        ArrayList<ParseObject> answer = new ArrayList<ParseObject>();
        if (this.currentCommand == null) {
            return answer;
        }
        boolean caching = this.cachePolicy != CachePolicy.IGNORE_CACHE;
        this.querySent = System.nanoTime();
        JSONObject result = (JSONObject)this.currentCommand.perform(caching);
        this.queryReceived = System.nanoTime();
        try {
            return this.convertFindResponse(result);
        }
        catch (JSONException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public void setCachePolicy(CachePolicy newCachePolicy) {
        this.checkIfRunning();
        this.cachePolicy = newCachePolicy;
    }

    public CachePolicy getCachePolicy() {
        return this.cachePolicy;
    }

    public void setMaxCacheAge(long maxAgeInMilliseconds) {
        this.maxCacheAge = maxAgeInMilliseconds;
    }

    public long getMaxCacheAge() {
        return this.maxCacheAge;
    }

    private List<ParseObject> findFromCache() throws ParseException {
        String cacheKey = this.makeFindCommand().getCacheKey();
        Object cached = Parse.jsonFromKeyValueCache(cacheKey, this.maxCacheAge);
        if (cached == null) {
            throw new ParseException(120, "results not cached");
        }
        if (!(cached instanceof JSONObject)) {
            throw new ParseException(120, "the cache contains the wrong datatype");
        }
        JSONObject object = (JSONObject)cached;
        try {
            return this.convertFindResponse(object);
        }
        catch (JSONException e) {
            throw new ParseException(120, "the cache contains corrupted json");
        }
    }

    private Integer countFromCache() throws ParseException {
        String cacheKey = this.makeCountCommand().getCacheKey();
        Object cached = Parse.jsonFromKeyValueCache(cacheKey, this.maxCacheAge);
        if (cached == null) {
            throw new ParseException(120, "results not cached");
        }
        if (!(cached instanceof JSONObject)) {
            throw new ParseException(120, "the cache contains the wrong datatype");
        }
        JSONObject object = (JSONObject)cached;
        try {
            return object.getInt("count");
        }
        catch (JSONException e) {
            throw new ParseException(120, "the cache contains corrupted json");
        }
    }

    public void findInBackground(FindCallback callback) {
        BackgroundTask<List<ParseObject>> findTask;
        CachePolicy callbackCachePolicy;
        this.checkIfRunning(true);
        this.queryStart = System.nanoTime();
        if (this.cachePolicy == CachePolicy.CACHE_THEN_NETWORK) {
            try {
                List<ParseObject> cacheResults = this.findWithCachePolicy(CachePolicy.CACHE_ONLY);
                callback.done(cacheResults, null);
            }
            catch (ParseException e) {
                callback.done(null, e);
            }
            callbackCachePolicy = CachePolicy.NETWORK_ONLY;
        } else {
            callbackCachePolicy = this.cachePolicy;
        }
        this.currentTask = findTask = new BackgroundTask<List<ParseObject>>((ParseCallback)callback){

            @Override
            public List<ParseObject> run() throws ParseException {
                List result = ParseQuery.this.findWithCachePolicy(callbackCachePolicy);
                ParseQuery.this.currentCommand = null;
                return result;
            }
        };
        BackgroundTask.executeTask(findTask);
    }

    public void getFirstInBackground(final GetCallback callback) {
        this.setLimit(1);
        this.findInBackground(new FindCallback(){

            @Override
            public void done(List<ParseObject> objects, ParseException e) {
                if (objects != null && objects.size() > 0) {
                    callback.internalDone(objects.get(0), e);
                } else if (e != null) {
                    callback.internalDone(null, e);
                } else {
                    callback.internalDone(null, new ParseException(101, "no results found for query"));
                }
            }
        });
    }

    private ParseCommand makeCountCommand() {
        ParseCommand command = this.makeFindCommand();
        command.put("limit", 0);
        command.put("count", 1);
        return command;
    }

    public int count() throws ParseException {
        return this.count(true);
    }

    protected int count(boolean needsLock) throws ParseException {
        if (needsLock) {
            this.checkIfRunning(true);
        }
        int result = 0;
        try {
            result = this.countWithCachePolicy(this.cachePolicy);
        }
        finally {
            this.finishedRunning();
        }
        return result;
    }

    private int countFromNetwork() throws ParseException {
        boolean caching = this.cachePolicy != CachePolicy.IGNORE_CACHE;
        this.currentCommand = this.makeCountCommand();
        JSONObject result = (JSONObject)this.currentCommand.perform(caching);
        return result.optInt("count");
    }

    public void countInBackground(CountCallback callback) {
        BackgroundTask<Integer> countTask;
        this.checkIfRunning(true);
        this.currentTask = countTask = new BackgroundTask<Integer>((ParseCallback)callback){

            @Override
            public Integer run() throws ParseException {
                Integer result = ParseQuery.this.count(false);
                ParseQuery.this.currentCommand = null;
                return result;
            }
        };
        BackgroundTask.executeTask(countTask);
    }

    public ParseObject get(String theObjectId) throws ParseException {
        return this.get(theObjectId, true);
    }

    protected ParseObject get(String theObjectId, boolean needsLock) throws ParseException {
        this.skip = -1;
        this.where = new HashMap();
        this.where.put("objectId", theObjectId);
        return this.getFirst(needsLock);
    }

    public boolean hasCachedResult() {
        String raw = Parse.loadFromKeyValueCache(this.makeFindCommand().getCacheKey(), this.maxCacheAge);
        return raw != null;
    }

    public void clearCachedResult() {
        Parse.clearFromKeyValueCache(this.makeFindCommand().getCacheKey());
    }

    public static void clearAllCachedResults() {
        Parse.clearCacheDir();
    }

    public void getInBackground(String objectId, GetCallback callback) {
        BackgroundTask<ParseObject> getTask;
        this.checkIfRunning(true);
        final String finalObjectId = objectId;
        this.currentTask = getTask = new BackgroundTask<ParseObject>((ParseCallback)callback){

            @Override
            public ParseObject run() throws ParseException {
                ParseObject result = ParseQuery.this.get(finalObjectId, false);
                ParseQuery.this.currentCommand = null;
                return result;
            }
        };
        BackgroundTask.executeTask(getTask);
    }

    public ParseQuery whereEqualTo(String key, Object value) {
        this.checkIfRunning();
        if (value instanceof Date) {
            value = Parse.dateToObject((Date)value);
        }
        this.where.put(key, value);
        return this;
    }

    private void addCondition(String key, String condition, Object value) {
        Object existingValue;
        this.checkIfRunning();
        JSONObject whereValue = null;
        value = Parse.maybeReferenceAndEncode(value);
        if (this.where.containsKey(key) && (existingValue = this.where.get(key)) instanceof JSONObject) {
            whereValue = (JSONObject)existingValue;
        }
        if (whereValue == null) {
            whereValue = new JSONObject();
        }
        try {
            whereValue.put(condition, value);
        }
        catch (JSONException e) {
            throw new RuntimeException(e.getMessage());
        }
        this.where.put(key, whereValue);
    }

    public ParseQuery whereLessThan(String key, Object value) {
        this.addCondition(key, "$lt", value);
        return this;
    }

    public ParseQuery whereNotEqualTo(String key, Object value) {
        this.addCondition(key, "$ne", value);
        return this;
    }

    public ParseQuery whereGreaterThan(String key, Object value) {
        this.addCondition(key, "$gt", value);
        return this;
    }

    public ParseQuery whereLessThanOrEqualTo(String key, Object value) {
        this.addCondition(key, "$lte", value);
        return this;
    }

    public ParseQuery whereGreaterThanOrEqualTo(String key, Object value) {
        this.addCondition(key, "$gte", value);
        return this;
    }

    public ParseQuery whereContainedIn(String key, Collection<? extends Object> values) {
        JSONArray array = new JSONArray();
        for (Object object : values) {
            array.put(Parse.maybeReferenceAndEncode(object));
        }
        this.addCondition(key, "$in", array);
        return this;
    }

    public ParseQuery whereContainsAll(String key, Collection<?> values) {
        JSONArray array = new JSONArray();
        for (Object val : values) {
            array.put(Parse.maybeReferenceAndEncode(val));
        }
        this.addCondition(key, "$all", array);
        return this;
    }

    public ParseQuery whereMatchesQuery(String key, ParseQuery query) {
        this.addCondition(key, "$inQuery", query);
        return this;
    }

    public ParseQuery whereDoesNotMatchQuery(String key, ParseQuery query) {
        this.addCondition(key, "$notInQuery", query);
        return this;
    }

    public ParseQuery whereMatchesKeyInQuery(String key, String keyInQuery, ParseQuery query) {
        JSONObject condition = new JSONObject();
        try {
            condition.put("key", (Object)keyInQuery);
            condition.put("query", (Object)query);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        this.addCondition(key, "$select", condition);
        return this;
    }

    public ParseQuery whereDoesNotMatchKeyInQuery(String key, String keyInQuery, ParseQuery query) {
        JSONObject condition = new JSONObject();
        try {
            condition.put("key", (Object)keyInQuery);
            condition.put("query", (Object)query);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        this.addCondition(key, "$dontSelect", condition);
        return this;
    }

    private ParseQuery whereSatifiesAnyOf(List<ParseQuery> queries) {
        this.where.put("$or", queries);
        return this;
    }

    public ParseQuery whereNotContainedIn(String key, Collection<? extends Object> values) {
        JSONArray array = new JSONArray();
        for (Object object : values) {
            array.put(Parse.maybeReferenceAndEncode(object));
        }
        this.addCondition(key, "$nin", array);
        return this;
    }

    public ParseQuery whereNear(String key, ParseGeoPoint point) {
        this.addCondition(key, "$nearSphere", point);
        return this;
    }

    public ParseQuery whereWithinMiles(String key, ParseGeoPoint point, double maxDistance) {
        this.whereWithinRadians(key, point, maxDistance / ParseGeoPoint.EARTH_MEAN_RADIUS_MILE);
        return this;
    }

    public ParseQuery whereWithinKilometers(String key, ParseGeoPoint point, double maxDistance) {
        this.whereWithinRadians(key, point, maxDistance / ParseGeoPoint.EARTH_MEAN_RADIUS_KM);
        return this;
    }

    public ParseQuery whereWithinRadians(String key, ParseGeoPoint point, double maxDistance) {
        this.addCondition(key, "$nearSphere", point);
        this.addCondition(key, "$maxDistance", maxDistance);
        return this;
    }

    public ParseQuery whereWithinGeoBox(String key, ParseGeoPoint southwest, ParseGeoPoint northeast) {
        ArrayList<Object> array = new ArrayList<Object>();
        array.add(Parse.maybeReferenceAndEncode(southwest));
        array.add(Parse.maybeReferenceAndEncode(northeast));
        HashMap<String, ArrayList<Object>> dictionary = new HashMap<String, ArrayList<Object>>();
        dictionary.put("$box", array);
        this.addCondition(key, "$within", dictionary);
        return this;
    }

    public ParseQuery whereMatches(String key, String regex) {
        this.addCondition(key, "$regex", regex);
        return this;
    }

    public ParseQuery whereMatches(String key, String regex, String modifiers) {
        this.addCondition(key, "$regex", regex);
        if (modifiers.length() != 0) {
            this.addCondition(key, "$options", modifiers);
        }
        return this;
    }

    public ParseQuery whereContains(String key, String substring) {
        String regex = Pattern.quote(substring);
        this.whereMatches(key, regex);
        return this;
    }

    public ParseQuery whereStartsWith(String key, String prefix) {
        String regex = "^" + Pattern.quote(prefix);
        this.whereMatches(key, regex);
        return this;
    }

    public ParseQuery whereEndsWith(String key, String suffix) {
        String regex = String.valueOf(Pattern.quote(suffix)) + "$";
        this.whereMatches(key, regex);
        return this;
    }

    public void include(String key) {
        this.checkIfRunning();
        this.include.add(key);
    }

    public ParseQuery whereExists(String key) {
        this.addCondition(key, "$exists", true);
        return this;
    }

    public ParseQuery whereDoesNotExist(String key) {
        this.addCondition(key, "$exists", false);
        return this;
    }

    ParseQuery whereRelatedTo(ParseObject parent, String key) {
        this.addCondition("$relatedTo", "object", Parse.maybeReferenceAndEncode(parent));
        this.addCondition("$relatedTo", "key", key);
        return this;
    }

    ParseQuery redirectClassNameForKey(String key) {
        this.extraOptions.put("redirectClassNameForKey", key);
        return this;
    }

    public ParseQuery orderByAscending(String key) {
        this.checkIfRunning();
        this.order = key;
        return this;
    }

    public ParseQuery addAscendingOrder(String key) {
        this.checkIfRunning();
        this.order = this.order == null ? key : String.valueOf(this.order) + "," + key;
        return this;
    }

    public ParseQuery orderByDescending(String key) {
        this.checkIfRunning();
        this.order = "-" + key;
        return this;
    }

    public ParseQuery addDescendingOrder(String key) {
        this.checkIfRunning();
        this.order = this.order == null ? "-" + key : String.valueOf(this.order) + ",-" + key;
        return this;
    }

    public void setLimit(int newLimit) {
        this.checkIfRunning();
        this.limit = newLimit;
    }

    public void setTrace(boolean shouldTrace) {
        this.trace = shouldTrace;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setSkip(int newSkip) {
        this.checkIfRunning();
        this.skip = newSkip;
    }

    public int getSkip() {
        return this.skip;
    }

    public String getClassName() {
        return this.className;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CachePolicy {
        IGNORE_CACHE,
        CACHE_ONLY,
        NETWORK_ONLY,
        CACHE_ELSE_NETWORK,
        NETWORK_ELSE_CACHE,
        CACHE_THEN_NETWORK;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface CommandDelegate<T> {
        public T runOnNetwork(boolean var1) throws ParseException;

        public T runFromCache() throws ParseException;
    }
}

