/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import com.parse.Parse;
import com.parse.ParseObject;
import java.io.File;
import java.io.IOException;
import java.util.Random;
import org.json.JSONException;
import org.json.JSONObject;

class LocalIdManager {
    private static LocalIdManager defaultInstance;
    private File diskPath;
    private Random random;

    public static synchronized LocalIdManager getDefaultInstance() {
        if (defaultInstance == null) {
            defaultInstance = new LocalIdManager();
        }
        return defaultInstance;
    }

    private LocalIdManager() {
        File parseDir = Parse.getParseDir();
        this.diskPath = new File(parseDir, "LocalId");
        this.diskPath.mkdirs();
        this.random = new Random();
    }

    private boolean isLocalId(String localId) {
        if (!localId.startsWith("local_")) {
            return false;
        }
        int i = 6;
        while (i < localId.length()) {
            char c = localId.charAt(i);
            if (!(c >= '0' && c <= '9' || c >= 'a' && c <= 'f')) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private synchronized MapEntry getMapEntry(String localId) {
        if (!this.isLocalId(localId)) {
            throw new IllegalStateException("Tried to get invalid local id: \"" + localId + "\".");
        }
        File file = new File(this.diskPath, localId);
        if (!file.exists()) {
            return new MapEntry();
        }
        JSONObject json = ParseObject.getDiskObject(file);
        MapEntry entry = new MapEntry();
        entry.retainCount = json.optInt("retainCount", 0);
        entry.objectId = json.optString("objectId", null);
        return entry;
    }

    private synchronized void putMapEntry(String localId, MapEntry entry) {
        if (!this.isLocalId(localId)) {
            throw new IllegalStateException("Tried to get invalid local id: \"" + localId + "\".");
        }
        JSONObject json = new JSONObject();
        try {
            json.put("retainCount", entry.retainCount);
            if (entry.objectId != null) {
                json.put("objectId", (Object)entry.objectId);
            }
        }
        catch (JSONException je) {
            throw new IllegalStateException("Error creating local id map entry.", je);
        }
        File file = new File(this.diskPath, localId);
        if (!this.diskPath.exists()) {
            this.diskPath.mkdirs();
        }
        ParseObject.saveDiskObject(file, json);
    }

    private synchronized void removeMapEntry(String localId) {
        if (!this.isLocalId(localId)) {
            throw new IllegalStateException("Tried to get invalid local id: \"" + localId + "\".");
        }
        File file = new File(this.diskPath, localId);
        file.delete();
    }

    synchronized String createLocalId() {
        long localIdNumber = this.random.nextLong();
        String localId = "local_" + Long.toHexString(localIdNumber);
        if (!this.isLocalId(localId)) {
            throw new IllegalStateException("Generated an invalid local id: \"" + localId + "\". " + "This should never happen. Please email feedback@parse.com");
        }
        return localId;
    }

    synchronized void retainLocalIdOnDisk(String localId) {
        MapEntry entry = this.getMapEntry(localId);
        ++entry.retainCount;
        this.putMapEntry(localId, entry);
    }

    synchronized void releaseLocalIdOnDisk(String localId) {
        MapEntry entry = this.getMapEntry(localId);
        --entry.retainCount;
        if (entry.retainCount > 0) {
            this.putMapEntry(localId, entry);
        } else {
            this.removeMapEntry(localId);
        }
    }

    synchronized String getObjectId(String localId) {
        MapEntry entry = this.getMapEntry(localId);
        return entry.objectId;
    }

    synchronized void setObjectId(String localId, String objectId) {
        MapEntry entry = this.getMapEntry(localId);
        if (entry.retainCount > 0) {
            if (entry.objectId != null) {
                throw new IllegalStateException("Tried to set an objectId for a localId that already has one.");
            }
            entry.objectId = objectId;
            this.putMapEntry(localId, entry);
        }
    }

    synchronized boolean clear() throws IOException {
        String[] files = this.diskPath.list();
        if (files == null) {
            return false;
        }
        if (files.length == 0) {
            return false;
        }
        String[] stringArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            File file = new File(this.diskPath, fileName);
            if (!file.delete()) {
                throw new IOException("Unable to delete file " + fileName + " in localId cache.");
            }
            ++n2;
        }
        return true;
    }

    private class MapEntry {
        String objectId;
        int retainCount;

        private MapEntry() {
        }
    }
}

