/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.os.SystemClock;
import java.util.LinkedList;
import java.util.Queue;

class SimpleTraceLogger {
    public static final String TAG = "SimpleTraceLogger";
    public static int NO_LIMIT = 0;
    protected final int mTraceCountLimit;
    private Queue<TraceLogLine> mTrace;

    public SimpleTraceLogger(int traceCountLimit) {
        this.mTraceCountLimit = traceCountLimit;
        this.clear();
    }

    public void append(String str, Object ... args) {
        this.append(String.format(str, args));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(String str) {
        SimpleTraceLogger simpleTraceLogger = this;
        synchronized (simpleTraceLogger) {
            if (this.mTraceCountLimit > NO_LIMIT && this.mTrace.size() == this.mTraceCountLimit) {
                this.mTrace.remove();
            }
            this.mTrace.offer(new TraceLogLine(str, SystemClock.elapsedRealtime()));
        }
    }

    public synchronized String toString() {
        return this.toString(NO_LIMIT);
    }

    public synchronized String toString(int limit) {
        StringBuilder retval = new StringBuilder();
        int startFrom = limit <= NO_LIMIT ? 0 : Math.max(this.mTrace.size() - limit, 0);
        int index = 0;
        for (TraceLogLine line : this.mTrace) {
            if (index >= startFrom) {
                retval.append(line.toString()).append('\n');
            }
            ++index;
        }
        return retval.toString();
    }

    public synchronized void clear() {
        this.mTrace = new LinkedList<TraceLogLine>();
    }

    protected static class TraceLogLine {
        public final String trace;
        public final long time;

        TraceLogLine(String trace, long time) {
            this.trace = trace;
            this.time = time;
        }

        public String toString() {
            return String.format("[%d] %s", this.time, this.trace);
        }
    }
}

