/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.os.Process;
import android.util.Log;
import java.io.File;
import java.util.Scanner;

class ProcFileReader {
    private static final Class<?> TAG = ProcFileReader.class;
    public static final int CANNOT_DETERMINE_OPEN_FDS = -1;
    public static final int SECURITY_EXCEPTION = -2;

    ProcFileReader() {
    }

    public static int getOpenFDCount() {
        try {
            String[] FD_DIRS = new String[]{String.format("/proc/%s/fd", Process.myPid()), "/proc/self/fd", String.format("/proc/%s/fd", Process.myTid())};
            for (int i = 0; i < FD_DIRS.length; ++i) {
                String[] fdFiles = new File(FD_DIRS[i]).list();
                if (fdFiles == null) continue;
                return fdFiles.length;
            }
            return -1;
        }
        catch (SecurityException e) {
            Log.e((String)TAG.toString(), (String)e.getMessage());
            return -2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OpenFDLimits getOpenFDLimits() {
        try (Scanner s = null;){
            s = new Scanner(new File("/proc/self/limits"));
            if (s.findWithinHorizon("Max open files", 5000) == null) {
                OpenFDLimits openFDLimits = null;
                return openFDLimits;
            }
            OpenFDLimits openFDLimits = new OpenFDLimits(s.next(), s.next());
            return openFDLimits;
        }
    }

    public static class OpenFDLimits {
        public final String softLimit;
        public final String hardLimit;

        public OpenFDLimits(String softLimit, String hardLimit) {
            this.softLimit = softLimit;
            this.hardLimit = hardLimit;
        }
    }
}

